unit Main;

interface

uses
  {$IFDEF Win32} Windows, {$ELSE} WinTypes, WinProcs, {$ENDIF}
  Classes, Controls, Forms, StdCtrls, ShellAPI, ExtCtrls,
  Buttons, BlindGuardian;

type
  TMainForm = class(TForm)
    Label2: TLabel;
    Label1: TLabel;
    RegisterBtn: TBitBtn;
    BlindGuardian: TBlindGuardian;
    procedure Label2Click(Sender: TObject);
    procedure RegisterBtnClick(Sender: TObject);
    procedure BlindGuardianRegistration(Sender: TObject; TrialPeriod,
      DaysPassed: Integer);
    procedure FormShow(Sender: TObject);
    procedure BlindGuardianCracked(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}
                     
uses RegDlg;

procedure TMainForm.Label2Click(Sender: TObject);
begin
  ShellExecute(GetDesktopWindow, 'open', 'http://www.utilmind.com', nil, nil, 0);
end;

procedure TMainForm.RegisterBtnClick(Sender: TObject);
begin
  with BlindGuardian do
   BlindGuardianRegistration(Sender, TrialPeriod, DaysPassed);
end;

procedure TMainForm.BlindGuardianRegistration(Sender: TObject;
  TrialPeriod, DaysPassed: Integer);
begin
  RegistrationDlg.TrialPeriod := TrialPeriod;
  RegistrationDlg.DaysPassed := DaysPassed;
  if RegistrationDlg.ShowModal <> id_Ok then Application.Terminate;
  RegisterBtn.Visible := not BlindGuardian.Registered;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  if not BlindGuardian.Registered then
   Caption := Caption + ' - EVALUATED'
  else
   Caption := Caption + ' - REGISTERED !'
end;

procedure TMainForm.BlindGuardianCracked(Sender: TObject);
begin
  Application.MessageBox('This app. is cracked. :-(', 'Cracked', mb_Ok or mb_IconStop);
  Application.Terminate;
end;

end.
