{--------------------------------------------------------------------------
Sprache    : Delphi 1.0
Aufgaben   : Funktionen und Prozeduren fuer Pascal-Strings
Hinweise   : Programme, die diese Unit benutzen, muessen mit der
             Anweisung $X+ compiliert werden
Fehler     : Fehler bitte melden an: scheffczyk@verwaltung.uni-mainz.de
Inhalt     : Siehe Deklaration.
---------------------------------------------------------------------------}
unit _4string;

{$X+}

{==========================================================================}
interface

type
    TSetOfChar = Set of Char;
const
      DOSFilenameChars    : TSetOfChar = ['A'..'Z','a'..'z','0'..'9','-','_'];
      AlphaCharsAndDigits : TSetOfChar = ['A'..'Z','a'..'z','','','','','','','','0'..'9'];
      AlphaChars          : TSetOfChar = ['A'..'Z','a'..'z','','','','','','',''];
      UpperChars          : TSetOfChar = ['A'..'Z','','',''];
      LowerChars          : TSetOfChar = ['a'..'z','','','',''];
      NumBlockChars       : TSetOfChar = ['a'..'i','`'];
      Digits              : TSetOfChar = ['0'..'9'];
      DigitsPlus          : TSetOfChar = ['0'..'9','.',',','-','+'];
      Ascii7Bit           : TSetOfChar = [#32..#127];
      Ascii8Bit           : TSetOfChar = [#32..#255];


      K_RETURN                =  13;
      K_ESC                   =  27;
      K_SPACE                 =  32;
      K_TAB                   =  9;
      K_INSERT                =  82;
      K_BACKSPACE             =  8;
      K_DELETE                =  83;
      K_LEFT                  =  75;
      K_RIGHT                 =  77;
      K_HOME                  =  71;
      K_END                   =  79;
      K_UP                    =  72;
      K_DOWN                  =  80;
      K_PGUP                  =  73;
      K_PGDN                  =  81;

      MinShortInt             = -128;
      MaxShortInt             =  127;
      MinInteger              = -32768;
      MaxInteger              =  32767;
      MinLongInt              = -2147483647-1;
      MaxLongInt              =  2147483647;
      MinByte                 =  0;
      MaxByte                 =  255;
      MinWord                 =  0;
      MaxWord                 =  65535;

{==========================================================================}
implementation
end.
