{--------------------------------------------------------------------------
Sprache    : Delphi 1.0
Aufgaben   : Funktionen und Prozeduren fuer null-terminierte Strings
Hinweise   : Programme, die diese Unit benutzen, muessen mit der
             Anweisung $X+ compiliert werden
Fehler     : Fehler bitte melden an: scheffczyk@verwaltung.uni-mainz.de
Inhalt     : StrLTrim         = Entfernen von Leerzeichen vom Anfang
                                null-terminierter Strings
             StrRTrim         = Entfernen von Leerzeichen vom Ende
                                null-terminierter Strings
             StrAllTrim       = Entfernen von Leerzeichen vom Anfang und vom Ende
                                null-terminierter Strings
             StrLeft          = Rueckgabe eines Teils eines null-term. Strings,
                                Ausgangspunkt ist der Anfang des Strings (von Links)
             StrRight         = Rueckgabe eines Teils eines null-term. Strings
                                Ausgangspunkt ist das Ende des Strings (von Rechts)
             StrSubStr        = Rueckgabe eines Teils eines null-term. Strings
                                Ausgangspunkt ist eine beliebige Stelle des Strings
             StrLFill         = Auffuellen eines null-term. Strings durch Voran-
                                stellung von n Zeichen auf eine bestimmte Laenge
             StrRFill         = Auffuellen eines null-terminierten Strings durch
                                Anhaengung von n Zeichen auf eine bestimmte Laenge
             StrReplicate     = Erstellen eines null-term. Strings, der aus einer
                                bestimmten Anzahl gleicher Zeichen besteht
             StrReduce        = Loescht aus einem String direkt aufeinander
                                folgende gleiche Zeichen
             StrReplace       = Ersetzt Zeichen in einem null-term. String durch
                                andere Zeichen (ein Zeichen gegen ein anderes)
             StrMixedCase     = Schreibt das erste Zeichen jedes Wortes in einem
                                null-term. String gross und alle anderen Zeichen klein
             StrReplaceSubStr = Ersetzt Teile eines null-term. Strings durch
                                andere Teile
             StrDeleteSubStr  = Loescht Teile eines null-term. Strings, die
                                durch eine Anfangs- und eine EndSequenz def. sind
             StrCharScan      = Ueberprueft ob ein Zeichen in einem null-term.
                                String vorhanden ist
---------------------------------------------------------------------------}
unit _4pchar;

{$X+}

{==========================================================================}
interface

uses
    sysutils;

{--------------------------------------------------------------------------
Name      : StrLTrim
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 12.07.1995
Autor     : Scheffczyk
Aufgabe   : Entfernt alle Leerzeichen vom Anfang eines Strings
Parameter : SourceStr : PChar = Zeiger auf den zu bearbeitenen String
Rueckgabe :             PChar = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : Wenn keine fuehrenden Leerzeichen vorhanden sind, wird der
            Originalstring zurueckgegeben
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrLTrim( SourceStr : PChar): PChar;

{--------------------------------------------------------------------------
Name      : StrLTrim
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 12.07.1995
Autor     : Scheffczyk
Aufgabe   : Entfernt alle Leerzeichen vom Ende eines Strings
Parameter : SourceStr : PChar = Zeiger auf den zu bearbeitenen String
Rueckgabe :             PChar = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : Wenn keine abschliessenden Leerzeichen vorhanden sind, wird der
            Originalstring zurueckgegeben
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrRTrim( SourceStr : PChar): PChar;

{--------------------------------------------------------------------------
Name      : StrAllTrim
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 12.07.1995
Autor     : Scheffczyk
Aufgabe   : Entfernt alle Leerzeichen vom Anfang und vom Ende eines Strings
Parameter : SourceStr : PChar = Zeiger auf den zu bearbeitenen String
Rueckgabe :             PChar = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : Wenn keine fuehrenden oder abschlissenden Leerzeichen vorhanden
            sind, wird der Originalstring zurueckgegeben
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrAllTrim( SourceStr : PChar): PChar;

{--------------------------------------------------------------------------
Name      : StrLeft
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 03.08.1995
Autor     : Scheffczyk
Aufgabe   : Liefert einen Teilstring des Originalstrings zurueck, wobei der
            Anfang des Teilstring mit dem Anfang des Originalstings ueber-
            einstimmt
Parameter : SourceStr : PChar = Zeiger auf den zu bearbeitenen String
            CharNum   : Word  = Die Laenge des gewuenschten Teilstrings
Rueckgabe :             PChar = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : Wenn die gewuenschte Laenge des Teilstrings groesser als die
            Laenge des Originalstrings ist, wird der Originalstring
            zurueckgegeben
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrLeft( SourceStr : PChar;
                  CharNum   : Word): PChar;

{--------------------------------------------------------------------------
Name      : StrRight
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 03.08.1995
Autor     : Scheffczyk
Aufgabe   : Liefert einen Teilstring des Originalstrings zurueck, wobei das
            Ende des Teilstring mit dem Ende des Originalstings ueber-
            einstimmt
Parameter : SourceStr : PChar = Zeiger auf den zu bearbeitenen String
            CharNum   : Byte  = Die Laenge des gewuenschten Teilstrings
Rueckgabe :             PChar = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : Wenn die gewuenschte Laenge des Teilstrings groesser als die
            Laenge des Originalstrings ist, wird der Originalstring
            zurueckgegeben
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrRight( SourceStr : PChar;
                   CharNum   : Word): PChar;

{--------------------------------------------------------------------------
Name      : StrSubStr
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 12.07.1995
Autor     : Scheffczyk
Aufgabe   : Liefert einen Teilstring des Originalstrings zurueck, wobei der
            Anfang und das Ende des Teilstring frei bestimmt werden koennen
Parameter : SourceStr : PChar  = Der zu bearbeitene String
            StartPos  : Word   = Die Position des ersten Zeichens des
                                 gewuenschten Teilstrings
            CharNum   : Word   = Die Laenge des gewuenschten Teilstrings
Rueckgabe :             PChar  = Der bearbeitete String
Fehler    : -
Hinweise  : Wenn die gewuenschte Laenge des Teilstrings groesser als die
            Laenge des Originalstrings ist, wird der Originalstring
            zurueckgegeben
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrSubStr( SourceStr : PChar;
                    StartPos  : Word;
                    CharNum   : Word): PChar;

{--------------------------------------------------------------------------
Name      : StrLFill
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 03.08.1995
Autor     : Scheffczyk
Aufgabe   : Fuellt einen String durch Voranstellung von Zeichen auf eine
            gewuenschte Laenge auf
Parameter : SourceStr : PChar  = Zeiger auf den zu bearbeitenen String
            NewLen    : Word   = Die gewuenschte neue Laenge
            FillChar  : Char   = Das zum Fuellen zu benutzende Zeichen
Rueckgabe :             PChar  = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : Wenn die gewuenschte neue Laenge des Strings groesser als die
            uerspruengliche Laenge, wird der Originalstring zurueckgegeben
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrLFill( SourceStr : PChar;
                   NewLen    : Word;
                   FillChar  : Char): PChar;

{--------------------------------------------------------------------------
Name      : StrRFill
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 03.08.1995
Autor     : Scheffczyk
Aufgabe   : Fuellt einen String durch Anhaengung von Zeichen auf eine
            gewuenschte Laenge auf
Parameter : SourceStr : PChar  = Zeiger auf den zu bearbeitenen String
            NewLen    : Word   = Die gewuenschte neue Laenge
            FillChar  : Char   = Das zum Fuellen zu benutzende Zeichen
Rueckgabe :             PChar  = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : Wenn die gewuenschte neue Laenge des Strings groesser als die
            uerspruengliche Laenge, wird der Originalstring zurueckgegeben
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrRFill( SourceStr : PChar;
                   NewLen    : Word;
                   FillChar  : Char): PChar;

{--------------------------------------------------------------------------
Name      : StrReplicate
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 05.08.1995
Autor     : Scheffczyk
Aufgabe   : Erstellt einen String aus einer bestimmten Anzahl gleicher Zeichen
Parameter : SourceStr : PChar  = Zeiger auf den zu bearbeitenen String
            Len       : Word   = Die gewuenschte Laenge
            FillChar  : Char   = Das zum Fuellen zu benutzende Zeichen
Rueckgabe :             PChar  = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : TargetStr wird uebergeben, damit die Verantwortung sowohl fuer
            die Erstellung, als auch fuer die Freigabe des Heapbereiches bei
            dem aufrufenden Programm liegt
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrReplicate( SourceStr : PChar;
                       Len       : Word;
                       FillChar  : Char): PChar;

{--------------------------------------------------------------------------
Name      : StrReduce
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 05.08.1995
Autor     : Scheffczyk
Aufgabe   : Loescht in einem String direkt aufeinander folgende gleiche
            Zeichen
Parameter : SourceStr : PChar = Zeiger auf den zu veraendernden String
            RedChars  : PChar = Zeiger auf einen String mit den
                                zu reduzierenden Zeichen
Rueckgabe :             PChar = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : SourceStr wird uebergeben, damit die Verantwortung sowohl fuer
            die Erstellung, als auch fuer die Freigabe des Heapbereiches bei
            dem aufrufenden Programm liegt
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrReduce( SourceStr,
                    ReduceChars : PChar): PChar;

{--------------------------------------------------------------------------
Name      : StrReplace
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 02.04.1996
Autor     : Scheffczyk
Aufgabe   : Ersetzt Zeichen in einem null-term. String durch andere Zeichen.
            Hierbei wird das erste Zeichen des Parameters 'OldChars' gegen das
            erste Zeichen des Parameters 'newChars' ausgetauscht, das zweite
            gegen das zweite, usw.
Parameter : SourceStr : PChar = Zeiger auf den zu veraendernden String
            OldChars  : PChar = Zeiger auf einen String mit den
                                auszutauschenden Zeichen
            newChars  : PChar = Zeiger auf einen String mit den
                                Ersatz-Zeichen
Rueckgabe :             PChar = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : SourceStr wird uebergeben, damit die Verantwortung sowohl fuer
            die Erstellung, als auch fuer die Freigabe des Heapbereiches bei
            dem aufrufenden Programm liegt
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrReplace( SourceStr,OldChars,newChars : PChar): PChar;

{--------------------------------------------------------------------------
Name      : StrMixedCase
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 26.02.1996
Autor     : Scheffczyk
Aufgabe   : Schreibt das erste Zeichen jedes Wortes im String gross und alle
            anderen Zeichen klein
Parameter : SourceStr : PChar : Zeiger auf den umzuwandelnden String
Rueckgabe :             PChar : Zeiger auf den umgewandelten String
Fehler    :
Hinweise  : SourceStr wird uebergeben, damit die Verantwortung sowohl fuer
            die Erstellung, als auch fuer die Freigabe des Heapbereiches bei
            dem aufrufenden Programm liegt
            ACHTUNG! Der Originalstring wird verndert!
---------------------------------------------------------------------------}
function StrMixedCase( SourceStr: PChar): PChar;

{--------------------------------------------------------------------------
Name      : StrAddCrLf
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 12.08.1996
Autor     : Scheffczyk
Aufgabe   : Fuegt in einen #0 term. String Zeilenumbrueche ein, wobei der
            Umbruch nach dem ersten Zeichen nach der gewuenschten Zeilenlaenge
            erfolgt, das in einer Menge von Trennzeichen vorhanden ist.
Parameter : SourceStr   : PChar : Zeiger auf den umzuwandelnden String
            WhiteSpaces : PChar : Zeiger auf einen String mit Trennzeichen
            LineWidth   : Byte  : Laenge der gewuenschten Zeile.
Rueckgabe :               PChar : Zeiger auf den umgewandelten String
Fehler    :
Hinweise  : SourceStr wird uebergeben, damit die Verantwortung sowohl fuer
            die Erstellung, als auch fuer die Freigabe des Heapbereiches bei
            dem aufrufenden Programm liegt
            ACHTUNG! Der Originalstring wird verndert!
            Der Umbruch erfolgt erst nach dem Ende des Wortes, dass die
            gewuenschte Zeilenlaenge ueberschreitet und nicht nach exakt
            der angegebenen Zeilenlaenge.
---------------------------------------------------------------------------}
function StrAddCrLf( SourceStr   : PChar;
                     WhiteSpaces : PChar;
                     LineWidth   : Byte): PChar;

{--------------------------------------------------------------------------
Name      : StrReplaceSubStr
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 12.08.1996
Autor     : Scheffczyk
Aufgabe   : Ersetzt Zeichen in einem null-term. String durch andere Zeichen
Parameter : SourceStr : PChar = Zeiger auf den zu veraendernden String
            OldChars  : PChar = Zeiger auf einen String mit den
                                auszutauschenden Zeichen
            newChars  : PChar = Zeiger auf einen String mit den
                                Ersatz-Zeichen
Rueckgabe :             PChar = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : SourceStr wird uebergeben, damit die Verantwortung sowohl fuer
            die Erstellung, als auch fuer die Freigabe des Heapbereiches bei
            dem aufrufenden Programm liegt
            ACHTUNG! Der Originalstring wird verndert!
            ACHTUNG!!! Im Unterschied zur Funktion 'StrReplace' tauscht diese
            Funktion den alten String als Ganzes gegen den neuen String aus.
---------------------------------------------------------------------------}
function StrReplaceSubStr( SourceStr,OldChars,newChars : PChar): PChar;

{--------------------------------------------------------------------------
Name      : StrDeleteSubStr
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 14.09.1996
Autor     : Scheffczyk
Aufgabe   : Loescht Teile eines null-term. Strings
Parameter : SourceStr : PChar = Zeiger auf den zu veraendernden String
            BeginChars: PChar = Zeiger auf einen String mit der Anfangssequenz
                                des zu loeschenden Teilstrings
            EndChars  : PChar = Zeiger auf einen String mit der Endsequenz
                                des zu loeschenden Teilstrings
Rueckgabe :             PChar = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : SourceStr wird uebergeben, damit die Verantwortung sowohl fuer
            die Erstellung, als auch fuer die Freigabe des Heapbereiches bei
            dem aufrufenden Programm liegt
            ACHTUNG! Der Originalstring wird verndert!
            ACHTUNG!!! Es werden ALLE passenden Teilstrings geloescht.
---------------------------------------------------------------------------}
function StrDeleteSubStr( SourceStr,BeginChars,EndChars : PChar): PChar;

{--------------------------------------------------------------------------
Name      : StrCharScan
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.1
Datum     : 1.0: 12.08.1996 1.1: 15.09.1996 
Autor     : Scheffczyk
Aufgabe   : Ueberprueft das Vorhandensein eines Zeichens in einem null-term.
            String
Parameter : aPChar : PChar   = Zeiger auf einen null-term. String
            aChar  : Char    = Das Zeichen, dessen Vorhandensein ueberprueft
                               werden soll
Rueckgabe :          Boolean = True, wenn das Zichen vorhanden ist, ansonsten
                               false
Fehler    : -
Hinweise  : -
---------------------------------------------------------------------------}
function StrCharScan(aPChar: PChar; aChar : Char): Boolean;

{==========================================================================}
implementation


{--------------------------------------------------------------------------}
function StrCharScan(aPChar: PChar; aChar : Char): Boolean;
var
   aRChar  : PChar;
begin
     aRChar  := aPChar;
     while ((aRChar^ <> aChar) and (aRChar^ <> #0)) do
     begin
          inc(aRChar);
     end;
     if aRChar^ = #0 then
     begin
          Result := false;
     end
     else
     begin
          Result := true;
     end;
end;

{--------------------------------------------------------------------------}
function StrLTrim( SourceStr : PChar): PChar;
begin
     while ((SourceStr^ = ' ') and (SourceStr^ <> #0)) do
     begin
          Inc(SourceStr);
     end;
     Result := SourceStr;
end;
{--------------------------------------------------------------------------}
function StrRTrim( SourceStr : PChar): PChar;
var
   EndStr : PChar;
begin
     EndStr := StrEnd(SourceStr);
     Dec(EndStr);
     while ((EndStr^ = ' ') and (EndStr <> SourceStr)) do
     begin
          Dec(EndStr);
     end;
     Inc(EndStr);
     EndStr^  := #0;
     Result := SourceStr;
end;
{--------------------------------------------------------------------------}
function StrAllTrim( SourceStr : PChar): PChar;
begin
     Result := StrLTrim(StrRTrim(SourceStr));
end;
{--------------------------------------------------------------------------}
function StrLeft( SourceStr : PChar;
                  CharNum   : Word): PChar;
var
   EndNewStr : PChar;
begin
     if ((CharNum < StrLen (SourceStr)) and (SourceStr <> nil)) then
     begin
          EndNewStr  := SourceStr;
          Inc(EndNewStr,CharNum);
          EndNewStr^ := #0;
     end;
     Result := SourceStr;
end;
{--------------------------------------------------------------------------}
function StrRight( SourceStr : PChar;
                   CharNum   : Word): PChar;
var
   newStrBegin : PChar;
begin
     NewStrBegin := SourceStr;
     if CharNum < StrLen(SourceStr) then
     begin
          Inc(newStrBegin,StrLen(SourceStr)-CharNum);
     end;
     Result := newStrBegin;
end;
{--------------------------------------------------------------------------}
function StrSubStr( SourceStr : PChar;
                    StartPos  : Word;
                    CharNum   : Word): PChar;
var
   newStrBegin : PChar;
begin
     if StrLen(SourceStr) >= StartPos then
     begin
          NewStrBegin := StrRight(SourceStr,StrLen(SourceStr)-StartPos+1);
          Result      := StrLeft(NewStrBegin,CharNum);
     end
     else
     begin
          NewStrBegin  := SourceStr;
          NewStrBegin^ := #0;
          Result       := NewStrBegin;
     end;
end;
{--------------------------------------------------------------------------}
function StrLFill( SourceStr : PChar;
                   NewLen    : Word;
                   FillChar  : Char): PChar;
var
   tempStr : PChar;
   startStr: PChar;
   fillLen : Word;
   oldSize : Word;
   maxSize : Word;
   i       : Word;
begin
     maxSize := StrBufSize(SourceStr);
     oldSize := StrLen(SourceStr);
     if NewLen > oldSize then
     begin
          if NewLen > maxSize then
          begin
               fillLen := maxSize - oldSize;
          end
          else
          begin
               fillLen := NewLen - oldSize;
          end;
          tempStr := StrAlloc(maxSize);
          StrCopy(tempStr,SourceStr);
          startStr := SourceStr;
          for i := 1 to fillLen do
          begin
               StartStr^ := FillChar;
               inc(startStr);
          end;
          StartStr^ := #0;
          StrCat(SourceStr,tempStr);
          StrDispose(TempStr);
     end;
     Result := SourceStr;


end;
{--------------------------------------------------------------------------}
function StrRFill( SourceStr : PChar;
                   NewLen    : Word;
                   FillChar  : Char): PChar;
var
   EndStr  : PChar;
   fillLen : Word;
   oldSize : Word;
   maxSize : Word;
   i       : Word;
begin
     maxSize := StrBufSize(SourceStr);
     oldSize := StrLen(SourceStr);
     if NewLen > oldSize then
     begin
          if NewLen > maxSize then
          begin
               fillLen := maxSize - oldSize;
          end
          else
          begin
               fillLen := NewLen - oldSize;
          end;
          EndStr := StrEnd(SourceStr);
          for i := 1 to fillLen do
          begin
               EndStr^ := FillChar;
               inc(EndStr);
          end;
          EndStr^ := #0;
    end;
     Result := SourceStr;
end;
{--------------------------------------------------------------------------}
function StrReplicate( SourceStr : PChar;
                       Len       : Word;
                       FillChar  : Char): PChar;
var
   i       : Word;
   maxSize : Word;
   fillSize: Word;
   fillStr : PChar;
begin
     maxSize := StrBufSize(SourceStr);
     if Len > maxSize then
     begin
          fillSize := maxSize
     end
     else
     begin
          fillSize := Len
     end;
     SourceStr^ := #0;
     fillStr := SourceStr;
     for i := 1 to fillSize do
     begin
          fillStr^:= FillChar;
          inc(FillStr);
     end;
     fillStr^:= #0;
     Result := SourceStr;
end;

{--------------------------------------------------------------------------}
function StrReduce( SourceStr,
                    ReduceChars : PChar): PChar;
var
   i                 : Word;
   CharNum           : Word;
   TargetStr         : PChar;
   SourceChar        : PChar;
   TargetCurrentChar : PChar;
   TargetLastChar    : PChar;

begin
     if StrLen(SourceStr) > 1 then
     begin
          TargetStr         := StrAlloc(StrBufSize(SourceStr));
          TargetStr^        := #0;
          SourceChar        := SourceStr;
          TargetCurrentChar := TargetStr;
          TargetLastChar    := TargetStr;
          for i := 1 to StrLen(SourceStr) do
          begin
               if ((TargetLastChar^ <> SourceChar^) OR
                   (not StrCharScan(ReduceChars,SourceChar^))) then
               begin
                    TargetCurrentChar^ := SourceChar^;
                    inc(SourceChar);
                    TargetLastChar := TargetCurrentChar;
                    inc(TargetCurrentChar);
               end
               else
               begin
                    inc(SourceChar);
               end;
          end;
          TargetCurrentChar^ := #0;
          StrCopy(SourceStr,TargetStr);
          StrDispose(TargetStr);
     end;
     Result := SourceStr;
end;
{--------------------------------------------------------------------------}
function StrReplace( SourceStr,OldChars,newChars : PChar): PChar;
var
   i,j,k       : Word;
   CharNum     : Word;
   SourcePos   : PChar;
   OldCharPos  : PChar;
   newCharPos  : PChar;
   aChar       : Char;
   x           : Word;

begin
     if StrLen(SourceStr) > 1 then
     begin
          newCharPos := StrEnd(newChars);
          Dec(NewCharPos);
          aChar := newCharPos^;
          Inc(NewCharPos);
          for i := StrLen(newChars) to StrLen(oldChars)-1 do
          begin
               NewCharPos^ := aChar;
               Inc(NewCharPos);
          end;
          NewCharPos^ := #0;
          SourcePos  := SourceStr;
          x := StrLen(SourceStr);
          for i := 1 to StrLen(SourceStr) do
          begin
               oldCharPos := OldChars;
               for j := 1 to StrLen(OldChars) do
               begin
                    if SourcePos^ = oldCharPos^ then
                    begin
                         newCharPos := newChars;
                         Inc(newCharPos,j-1);
                         SourcePos^ := newCharPos^;
                    end;
                    inc(oldCharPos);
               end;
               inc(SourcePos);
          end;
     end;
     Result := SourceStr;
end;
{--------------------------------------------------------------------------}
function StrMixedCase( SourceStr : PChar): PChar;
var
   i           : Word;
   CharNum     : Word;
   SourcePos   : PChar;
   CharStr     : String[1];
   NextBig     : Boolean;

begin
     if StrLen(SourceStr) > 1 then
     begin
          SourcePos  := SourceStr;
          NextBig    := true;
          for i := 1 to StrLen(SourceStr) do
          begin
               CharStr[1] := SourcePos^;
               if NextBig
                  then CharStr := UpperCase(CharStr)
                  else CharStr := LowerCase(CharStr);
               SourcePos^ := CharStr[1];
               if (SourcePos^ in [' ','.','!','?','-',';',',',#13])
                  then NextBig := true
                  else NextBig := false;
               inc(SourcePos);
          end;
     end;
     Result := SourceStr;
end;
{--------------------------------------------------------------------------}
function StrAddCrLf( SourceStr   : PChar;
                     WhiteSpaces : PChar;
                     LineWidth   : Byte): PChar;
var
   i                 : Word;
   LinePos           : Byte;
   TargetStr         : PChar;
   SourcePos         : PChar;
   TargetCurrentChar : PChar;

begin
     if StrLen(SourceStr) > 1 then
     begin
          LinePos           := 0;
          TargetStr         := StrAlloc(32768);
          TargetStr^        := #0;
          SourcePos         := SourceStr;
          TargetCurrentChar := TargetStr;
          for i := 1 to StrLen(SourceStr) do
          begin
               inc(LinePos);
               if ((LinePos > LineWidth) and
                   (StrCharScan(WhiteSpaces,SourcePos^) = true)) then
               begin
                    LinePos := 0;
                    TargetCurrentChar^ := #13;
                    inc(TargetCurrentChar);
                    TargetCurrentChar^ := #10;
                    inc(TargetCurrentChar);
               end;
               TargetCurrentChar^ := SourcePos^;
               inc(SourcePos);
               inc(TargetCurrentChar);
          end;
          TargetCurrentChar^ := #0;
          StrCopy(SourceStr,TargetStr);
          StrDispose(TargetStr);
     end;
     Result := SourceStr;
end;
{--------------------------------------------------------------------------}
function StrReplaceSubStr( SourceStr,OldChars,newChars : PChar): PChar;
var
   i                 : Word;
   TargetStr         : PChar;
   SourcePos         : PChar;
   TargetCurrentChar : PChar;
   Position          : PChar;
   newCharPos        : PChar;
   Replaced          : Boolean;

begin
     if StrLen(SourceStr) > 1 then
     begin
          TargetStr         := StrAlloc(32768);
          TargetStr^        := #0;
          SourcePos         := SourceStr;
          TargetCurrentChar := TargetStr;
          while SourcePos^ <> #0 do
          begin
               Replaced := false;
               if SourcePos^ = OldChars^ then
               begin
                    if StrPos(SourcePos,OldChars) = SourcePos then
                    begin
                         Inc(SourcePos,StrLen(OldChars));
                         newCharPos := newChars;
                         while newCharPos^ <> #0 do
                         begin
                              TargetCurrentChar^ := newCharPos^;
                              inc(newCharPos);
                              inc(TargetCurrentChar);
                         end;
                         Replaced := true;
                    end;
               end;
               TargetCurrentChar^ := SourcePos^;
               if not Replaced then
               begin
                    inc(SourcePos);
                    inc(TargetCurrentChar);
               end;
          end;
          TargetCurrentChar^ := #0;
          StrLCopy(SourceStr,TargetStr,StrLen(SourceStr));
          StrDispose(TargetStr);
     end;
     Result := SourceStr;
end;

{--------------------------------------------------------------------------}
function StrDeleteSubStr( SourceStr,BeginChars,EndChars : PChar): PChar;
var
   i                 : Word;
   TargetStr         : PChar;
   SourcePos         : PChar;
   TargetCurrentChar : PChar;
   Position          : PChar;
   newCharPos        : PChar;
   Replaced          : Boolean;

begin
     if StrLen(SourceStr) > 1 then
     begin
          TargetStr         := StrAlloc(32768);
          TargetStr^        := #0;
          SourcePos         := SourceStr;
          TargetCurrentChar := TargetStr;
          while SourcePos^ <> #0 do
          begin
               if SourcePos^ = BeginChars^ then
               begin
                    if StrPos(SourcePos,BeginChars) = SourcePos then
                    begin
                         while ((StrPos(SourcePos,EndChars) <> SourcePos) and
                                (SourcePos^ <> #0)) do
                         begin
                              Inc(SourcePos);
                         end;
                         if StrPos(SourcePos,EndChars) = SourcePos then
                         begin
                              Inc(SourcePos);
                         end;
                    end;
               end;
               TargetCurrentChar^ := SourcePos^;
               inc(SourcePos);
               inc(TargetCurrentChar);
          end;
          TargetCurrentChar^ := #0;
          StrCopy(SourceStr,TargetStr);
          StrDispose(TargetStr);
     end;
     Result := SourceStr;
end;

end.
