{--------------------------------------------------------------------------
Sprache    : Delphi 1.0
Aufgaben   : Funktionen und Prozeduren fuer Pascal-Strings
Hinweise   : Programme, die diese Unit benutzen, muessen mit der
             Anweisung $X+ compiliert werden
Fehler     : Fehler bitte melden an: scheffczyk@verwaltung.uni-mainz.de
             LTrim         = Entfernen Leerzeichen vom Anfang von
                             Pascal-Strings
             RTrim         = Entfernen von Leerzeichen vom Ende von
                             Pascal-Strings
             AllTrim       = Entfernen von Leerzeichen vom Ende und vom Anfang
                             von Pascal-Strings
             LeftStr       = Rueckgabe eines Teils eines Pascal-Strings,
                             Ausgangspunkt ist der Anfang des Strings (von Links)
             RightStr      = Rueckgabe eines Teils eines Pascal-Strings
                             Ausgangspunkt ist das Ende des Strings (von Rechts)
             SubStr        = Rueckgabe eines Teils eines Pascal-Strings
                             Ausgangspunkt ist eine beliebige Stelle des Strings
             LFill         = Auffuellen eines Pascal-Strings durch Voranstellung
                             von n Zeichen auf eine bestimmte Laenge
             RFill         = Auffuellen eines Pascal-Strings durch
                             Anhaengung von n Zeichen auf eine bestimmte Laenge
             Replicate     = Erstellen eines Pascal-Strings, der aus einer
                             bestimmten Anzahl gleicher Zeichen besteht
             Reduce        = Loescht aus einem String direkt aufeinander
                             folgende gleiche Zeichen
             ReplaceStr    = Ersetzt Zeichen in einem String durch andere
                             Zeichen
             MixedCase     = Schreibt das erste Zeichen jedes Wortes in einem
                             Pascal-String gross und alle anderen Zeichen klein
             ReplaceSubStr = Ersetzt Teile eines Pascal-Strings durch
                             andere Teile
             DeleteSubStr  = Loescht Teile eines Pascal-Strings, die
                             durch eine Anfangs- und eine EndSequenz def. sind
             CharScan      = Ueberprueft ob ein Zeichen in einem Pascal-String
                             vorhanden ist
             ccsAnsi2Ascii = Setzt einen String vom Standard (ANSI) Windows-
                             Zeichensatz auf den DOS (OEM) Zeichensatz um, der
                             in der Systemsteuerung als Tastaturtreiber
                             angegeben ist
             ccsAscii2Ansi = Setzt einen String von dem in der Systemsteuerung
                             als Tastaturtreiber angegebenen DOS (OEM)
                             Zeichensatz auf den Standard (ANSI) Windows
                             Zeichensatz um
---------------------------------------------------------------------------}
unit _4passtr;

{$X+}

{==========================================================================}
interface

{--------------------------------------------------------------------------
Name      : LTrim
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 03.08.1995
Autor     : Scheffczyk
Aufgabe   : Entfernt alle Leerzeichen vom Anfang eines Strings
Parameter : SourceStr : String = Der zu bearbeitene String
Rueckgabe :             String = Der bearbeitete String
Fehler    : -
Hinweise  : Wenn keine fuehrenden Leerzeichen vorhanden sind, wird der
            Originalstring zurueckgegeben
---------------------------------------------------------------------------}
function LTrim( SourceStr : String): String;

{--------------------------------------------------------------------------
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 12.07.1995
Autor     : Scheffczyk
Aufgabe   : Entfernt alle Leerzeichen vom Ende eines Strings
Parameter : SourceStr : String = Der zu bearbeitene String
Rueckgabe :             String = Der bearbeitete String
Fehler    : -
Hinweise  : Wenn keine abschliessenden Leerzeichen vorhanden sind, wird der
            Originalstring zurueckgegeben
---------------------------------------------------------------------------}
function RTrim( SourceStr : String): String;

{--------------------------------------------------------------------------
Name      : AllTrim
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 12.07.1995
Autor     : Scheffczyk
Aufgabe   : Entfernt alle Leerzeichen vom Anfang und vom Ende eines Strings
Parameter : SourceStr : String = Der zu bearbeitene String
Rueckgabe :             String = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : Wenn keine fuehrenden oder abschlissenden Leerzeichen vorhanden
            sind, wird der Originalstring zurueckgegeben
---------------------------------------------------------------------------}
function AllTrim( SourceStr : String): String;

{--------------------------------------------------------------------------
Name      : LeftStr
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 03.08.1995
Autor     : Scheffczyk
Aufgabe   : Liefert einen Teilstring des Originalstrings zurueck, wobei der
            Anfang des Teilstring mit dem Anfang des Originalstings ueber-
            einstimmt
Parameter : SourceStr : String = Der zu bearbeitene String
            CharNum   : Byte   = Die Laenge des gewuenschten Teilstrings
Rueckgabe :             String = Zeiger auf den bearbeiteten String
Fehler    : -
Hinweise  : Wenn die gewuenschte Laenge des Teilstrings groesser als die
            Laenge des Originalstrings ist, wird der Originalstring
            zurueckgegeben
---------------------------------------------------------------------------}
function LeftStr( SourceStr : String;
                  CharNum   : Byte): String;

{--------------------------------------------------------------------------
Name      : RightStr
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 12.07.1995
Autor     : Scheffczyk
Aufgabe   : Liefert einen Teilstring des Originalstrings zurueck, wobei das
            Ende des Teilstring mit dem Ende des Originalstings ueber-
            einstimmt
Parameter : SourceStr : String = Der zu bearbeitene String
            CharNum   : Byte   = Die Laenge des gewuenschten Teilstrings
Rueckgabe :             String = Der bearbeitete String
Fehler    : -
Hinweise  : Wenn die gewuenschte Laenge des Teilstrings groesser als die
            Laenge des Originalstrings ist, wird der Originalstring
            zurueckgegeben
---------------------------------------------------------------------------}
function RightStr( SourceStr : String;
                   CharNum   : Byte): String;

{--------------------------------------------------------------------------
Name      : SubStr
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 12.07.1995
Autor     : Scheffczyk
Aufgabe   : Liefert einen Teilstring des Originalstrings zurueck, wobei der
            Anfang und das Ende des Teilstring frei bestimmt werden koennen
Parameter : SourceStr : String = Der zu bearbeitene String
            StartPos  : Byte   = Die Position des ersten Zeichens des
                                 gewuenschten Teilstrings
            CharNum   : Byte   = Die Laenge des gewuenschten Teilstrings
Rueckgabe :             String = Der bearbeitete String
Fehler    : -
Hinweise  : Wenn die gewuenschte Laenge des Teilstrings groesser als die
            Laenge des Originalstrings ist, wird der Originalstring
            zurueckgegeben
---------------------------------------------------------------------------}
function SubStr( SourceStr : String;
                 StartPos  : Byte;
                 CharNum   : Byte): String;

{--------------------------------------------------------------------------
Name      : LFill
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 03.08.1995
Autor     : Scheffczyk
Aufgabe   : Fuellt einen String durch Voranstellung von Zeichen auf eine
            gewuenschte Laenge auf
Parameter : SourceStr : String = Der zu bearbeitene String
            NewLen    : Byte   = Die gewuenschte neue Laenge
            FillChar  : Char   = Das zum Fuellen zu benutzende Zeichen
Rueckgabe :             String = Der bearbeitete String
Fehler    : -
Hinweise  : Wenn die gewuenschte neue Laenge des Strings groesser als die
            uerspruengliche Laenge, wird der Originalstring zurueckgegeben
---------------------------------------------------------------------------}
function LFill( SourceStr : String;
                NewLen    : Byte;
                FillChar  : Char): String;

{--------------------------------------------------------------------------
Name      : RFill
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 03.08.1995
Autor     : Scheffczyk
Aufgabe   : Fuellt einen String durch Anhaengung von Zeichen auf eine
            gewuenschte Laenge auf
Parameter : SourceStr : String = Der zu bearbeitene String
            NewLen    : Byte   = Die gewuenschte neue Laenge
            FillChar  : Char   = Das zum Fuellen zu benutzende Zeichen
Rueckgabe :             String = Der bearbeitete String
Fehler    : -
Hinweise  : Wenn die gewuenschte neue Laenge des Strings groesser als die
            uerspruengliche Laenge, wird der Originalstring zurueckgegeben
---------------------------------------------------------------------------}
function RFill( SourceStr : String;
                NewLen    : Byte;
                FillChar  : Char): String;

{--------------------------------------------------------------------------
Name      : Replicate
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 05.08.1995
Autor     : Scheffczyk
Aufgabe   : Erstellt einen String aus einer bestimmten Anzahl gleicher Zeichen
Parameter : Len       : Word   = Die gewuenschte Laenge
            FillChar  : Char   = Das zum Fuellen zu benutzende Zeichen
Rueckgabe :             String = Der bearbeitete String
Fehler    : -
Hinweise  : -
---------------------------------------------------------------------------}
function Replicate( Len       : Byte;
                    FillChar  : Char): String;

{--------------------------------------------------------------------------
Name      : Reduce
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 05.08.1995
Autor     : Scheffczyk
Aufgabe   : Loescht in einem String direkt aufeinander folgende gleiche
            Zeichen
Parameter : SourceStr : String = Der zu veraendernde String
            RedChars  : String = Die zu reduzierenden Zeichen
Rueckgabe :             String = Der bearbeitete String
Fehler    : -
Hinweise  : -
---------------------------------------------------------------------------}
function Reduce( SourceStr,
                 RedChars : String): String;

{--------------------------------------------------------------------------
Name      : ReplaceStr
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 02.04.1996
Autor     : Scheffczyk
Aufgabe   : Ersetzt ein Zeichen in einem String durch ein anderes Zeichen
Parameter : SourceStr : String = Der zu veraendernde String
            OrgChars  : String = Das zu ersetzende Zeichen
            NewChars  : String = Das anstelle des zu ersetzenden Zeichens
                                 einzufuegende Zeichen
Rueckgabe :             String = Der bearbeitete String
Fehler    : -
Hinweise  : -
---------------------------------------------------------------------------}
function ReplaceStr( SourceStr,OrgChars,newChars : String): String;

{--------------------------------------------------------------------------
Name      : MixedCase
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 26.02.1996
Autor     : Scheffczyk
Aufgabe   : Schreibt das erste Zeichen jedes Wortes im String gross und alle
            anderen Zeichen klein
Parameter : SourceStr : String : Der umzuwandelnde String
Rueckgabe :             String : Der umgewandelte String
Fehler    :
Hinweise  : Wenn SourceStr ein Leerstring ist wird ein Leerstring als
            Ergebnis zurueckgegeben
---------------------------------------------------------------------------}
function MixedCase( SourceStr: String): String;

{--------------------------------------------------------------------------
Name      : AddCrLf
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 15.09.1996
Autor     : Scheffczyk
Aufgabe   : Fuegt in einen pascal-String Zeilenumbrueche ein, wobei der
            Umbruch nach dem ersten Zeichen nach der gewuenschten Zeilenlaenge
            erfolgt, das in einer Menge von Trennzeichen vorhanden ist.
Parameter : SourceStr   : String : der umzuwandelnde String
            WhiteSpaces : String : ein String mit Trennzeichen
            LineWidth   : Byte   : Laenge der gewuenschten Zeile.
Rueckgabe :               String : der umgewandelte String
Fehler    :
Hinweise  : Der Umbruch erfolgt erst nach dem Ende des Wortes, dass die
            gewuenschte Zeilenlaenge ueberschreitet und nicht nach exakt
            der angegebenen Zeilenlaenge.
---------------------------------------------------------------------------}
function AddCrLf( SourceStr   : String;
                  WhiteSpaces : String;
                  LineWidth   : Byte): String;

{--------------------------------------------------------------------------
Name      : StrReplaceSubStr
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 15.09.1996
Autor     : Scheffczyk
Aufgabe   : Ersetzt Zeichen in einem pascal-String durch andere Zeichen
Parameter : SourceStr : String = der zu veraendernde String
            OldChars  : String = String mit den auszutauschenden Zeichen
            newChars  : String = String mit den Ersatz-Zeichen
Rueckgabe :             String = der bearbeitete String
Fehler    : -
Hinweise  : ACHTUNG!!! Im Unterschied zur Funktion 'StrReplace' tauscht diese
            Funktion den alten String als Ganzes gegen den neuen String aus.
---------------------------------------------------------------------------}
function ReplaceSubStr( SourceStr,OldChars,newChars : String): String;

{--------------------------------------------------------------------------
Name      : StrDeleteSubStr
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 14.09.1996
Autor     : Scheffczyk
Aufgabe   : Loescht Teile eines pascal-Strings
Parameter : SourceStr : String = der zu veraendernde String
            BeginChars: String = String mit der Anfangssequenz des zu
                                 loeschenden Teilstrings
            EndChars  : String = String mit der Endsequenz des zu loeschenden
                                 Teilstrings
Rueckgabe :             String = der bearbeitete String
Fehler    : -
Hinweise  : ACHTUNG!!! Es werden ALLE passenden Teilstrings geloescht.
---------------------------------------------------------------------------}
function DeleteSubStr( SourceStr,BeginChars,EndChars : String): String;

{--------------------------------------------------------------------------
Name      : CharScan
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 15.09.1996
Autor     : Scheffczyk
Aufgabe   : Ueberprueft das Vorhandensein eines Zeichens in einem pascal-String
Parameter : aString : String  = Zeiger auf einen null-term. String
            aChar   : Char    = Das Zeichen, dessen Vorhandensein ueberprueft
                                werden soll
Rueckgabe :           Boolean = True, wenn das Zichen vorhanden ist, ansonsten
                                false
Fehler    : -
Hinweise  : -
---------------------------------------------------------------------------}
function CharScan(aString: String; aChar : Char): Boolean;

{--------------------------------------------------------------------------
Name      : ccsAnsi2Ascii
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 29.10.1996
Autor     : Scheffczyk
Aufgabe   : Setzt einen String vom Standard (ANSI) Windows-Zeichensatz auf den
            DOS (OEM) Zeichensatz um, der in der Systemsteuerung als Tastatur-
            treiber angegeben ist
Parameter : aString : String  = der umzuwandelnde String
Rueckgabe :           String  = der umgewandelte String
Fehler    : -
Hinweise  : Diese Funktion ruft direkt die KernelFunktion 'AnsiToOem' auf
---------------------------------------------------------------------------}
function ccsAnsi2Ascii(aString: String): String;

{--------------------------------------------------------------------------
Name      : ccsAscii2Ansi
Typ       : Funktion
Sprache   : Delphi 1.0
Version   : 1.0
Datum     : 29.10.1996
Autor     : Scheffczyk
Aufgabe   : Setzt einen String von dem in der Systemsteuerung als Tastatur-
            treiber angegebenen DOS (OEM) Zeichensatz auf den Standard (ANSI)
            Windows Zeichensatz um
Parameter : aString : String  = der umzuwandelnde String
Rueckgabe :           String  = der umgewandelte String
Fehler    : -
Hinweise  : Diese Funktion ruft direkt die KernelFunktion 'OemToAnsi' auf
---------------------------------------------------------------------------}
function ccsAscii2Ansi(aString: String): String;

{==========================================================================}
implementation

uses
    _4pchar,
    winprocs,
    sysutils;

{--------------------------------------------------------------------------}
function LTrim( SourceStr : String): String;
var
   aPChar   : PChar;
   newPChar : PChar;
begin
      aPChar := StrAlloc(Length(SourceStr)+1);
      StrPCopy(aPChar,SourceStr);
      newPChar := StrLTrim(aPChar);
      Result   := StrPas(newPChar);
      StrDispose(aPChar);
end;

{--------------------------------------------------------------------------}
function RTrim( SourceStr : String): String;
var
   aPChar   : PChar;
   newPChar : PChar;
begin
      aPChar := StrAlloc(Length(SourceStr)+1);
      StrPCopy(aPChar,SourceStr);
      newPChar := StrRTrim(aPChar);
      Result   := StrPas(newPChar);
      StrDispose(aPChar);
end;

{--------------------------------------------------------------------------}
function AllTrim( SourceStr : String): String;
begin
      Result   := LTrim(RTrim(SourceStr));
end;

{--------------------------------------------------------------------------}
function LeftStr( SourceStr : String;
                  CharNum   : Byte): String;
var
   aPChar   : PChar;
   newPChar : PChar;
begin
      aPChar := StrAlloc(Length(SourceStr)+1);
      StrPCopy(aPChar,SourceStr);
      newPChar := StrLeft(aPChar,CharNum);
      Result   := StrPas(newPChar);
      StrDispose(aPChar);
end;

{--------------------------------------------------------------------------}
function RightStr( SourceStr : String;
                   CharNum   : Byte): String;
var
   aPChar   : PChar;
   newPChar : PChar;
begin
     if Length(SourceStr) > 0 then
     begin
          aPChar   := StrAlloc(Length(SourceStr)+1);
          StrPCopy(aPChar,SourceStr);
          newPChar := StrRight(aPChar,CharNum);
          Result   := StrPas(newPChar);
          StrDispose(aPChar);
     end
     else
     begin
          Result := '';
     end;
end;

{--------------------------------------------------------------------------}
function SubStr( SourceStr : String;
                 StartPos  : Byte;
                 CharNum   : Byte): String;
var
   aPChar   : PChar;
   newPChar : PChar;
begin
      aPChar := StrAlloc(Length(SourceStr)+1);
      StrPCopy(aPChar,SourceStr);
      newPChar := StrSubStr(aPChar,StartPos,CharNum);
      Result   := StrPas(newPChar);
      StrDispose(aPChar);
end;

{--------------------------------------------------------------------------}
function LFill( SourceStr : String;
                NewLen    : Byte;
                FillChar  : Char): String;
var
   aPChar   : PChar;
   newPChar : PChar;
begin
     if NewLen > Length(SourceStr) then
     begin
          aPChar := StrAlloc(NewLen+1);
          StrPCopy(aPChar,SourceStr);
          newPChar := StrLFill(aPChar,NewLen,FillChar);
          Result   := StrPas(newPChar);
          StrDispose(aPChar);
     end
     else
     begin
          Result := SourceStr;
     end;
end;

{--------------------------------------------------------------------------}
function RFill( SourceStr : String;
                NewLen    : Byte;
                FillChar  : Char): String;
var
   aPChar   : PChar;
   newPChar : PChar;
begin
     if NewLen > Length(SourceStr) then
     begin
          aPChar := StrAlloc(NewLen+1);
          StrPCopy(aPChar,SourceStr);
          newPChar := StrRFill(aPChar,NewLen,FillChar);
          Result   := StrPas(newPChar);
          StrDispose(aPChar);
     end
     else
     begin
          Result := SourceStr;
     end;
end;

{--------------------------------------------------------------------------}
function Replicate( Len       : Byte;
                    FillChar  : Char): String;
var
   aPChar   : PChar;
   newPChar : PChar;
   tempStr  : String;
begin
     if FillChar <> #0 then
     begin
          aPChar   := StrAlloc(Len+1);
          newPChar := StrReplicate(aPChar,Len,FillChar);
          Result   := StrPas(newPChar);
          StrDispose(aPChar);
     end
     else
     begin
          Result := '';
     end;
end;

{--------------------------------------------------------------------------}
function Reduce( SourceStr : String;
                 RedChars  : String): String;
var
   aPChar1  : PChar;
   aPChar2  : PChar;
   newPChar : PChar;
begin
     aPChar1 := StrAlloc(Length(SourceStr)+1);
     aPChar2 := StrAlloc(Length(RedChars)+1);
     StrPCopy(aPChar1,SourceStr);
     StrPCopy(aPChar2,RedChars);
     newPChar := StrReduce(aPChar1,aPChar2);
     Result   := StrPas(newPChar);
     StrDispose(aPChar1);
     StrDispose(aPChar2);
end;

{--------------------------------------------------------------------------}
function ReplaceStr( SourceStr,OrgChars,newChars : String): String;
var
   aPChar1  : PChar;
   aPChar2  : PChar;
   aPChar3  : PChar;
   newPChar : PChar;
begin
     aPChar1 := StrAlloc(Length(SourceStr)+1);
     aPChar2 := StrAlloc(Length(OrgChars)+1);
     aPChar3 := StrAlloc(Length(newChars)+1);
     StrPCopy(aPChar1,SourceStr);
     StrPCopy(aPChar2,OrgChars);
     StrPCopy(aPChar3,newChars);
     newPChar := StrReplace(aPChar1,aPChar2,aPChar3);
     Result   := StrPas(newPChar);
     StrDispose(aPChar1);
     StrDispose(aPChar2);
     StrDispose(aPChar3);
end;

{--------------------------------------------------------------------------}
function MixedCase( SourceStr : String): String;
var
   aPChar1  : PChar;
   newPChar : PChar;
begin
     aPChar1 := StrAlloc(Length(SourceStr)+1);
     StrPCopy(aPChar1,SourceStr);
     newPChar := StrMixedCase(aPChar1);
     Result   := StrPas(newPChar);
     StrDispose(aPChar1);
end;

{--------------------------------------------------------------------------}
function AddCrLf( SourceStr   : String;
                  WhiteSpaces : String;
                  LineWidth   : Byte): String;
var
   aPChar1  : PChar;
   aPChar2  : PChar;
   newPChar : PChar;
begin
     aPChar1 := StrAlloc(Length(SourceStr)+1);
     aPChar2 := StrAlloc(Length(WhiteSpaces)+1);
     StrPCopy(aPChar1,SourceStr);
     StrPCopy(aPChar2,WhiteSpaces);
     newPChar := StrAddCrLf(aPChar1,aPChar2,LineWidth);
     Result   := StrPas(newPChar);
     StrDispose(aPChar1);
     StrDispose(aPChar2);
end;

{--------------------------------------------------------------------------}
function ReplaceSubStr( SourceStr,OldChars,newChars : String): String;
var
   aPChar1  : PChar;
   aPChar2  : PChar;
   aPChar3  : PChar;
   newPChar : PChar;
begin
     aPChar1 := StrAlloc(Length(SourceStr)+1);
     aPChar2 := StrAlloc(Length(OldChars)+1);
     aPChar3 := StrAlloc(Length(newChars)+1);
     StrPCopy(aPChar1,SourceStr);
     StrPCopy(aPChar2,OldChars);
     StrPCopy(aPChar3,newChars);
     newPChar := StrReplaceSubStr(aPChar1,aPChar2,aPChar3);
     Result   := StrPas(newPChar);
     StrDispose(aPChar1);
     StrDispose(aPChar2);
     StrDispose(aPChar3);
end;

{--------------------------------------------------------------------------}
function DeleteSubStr( SourceStr,BeginChars,EndChars : String): String;
var
   aPChar1  : PChar;
   aPChar2  : PChar;
   aPChar3  : PChar;
   newPChar : PChar;
begin
     aPChar1 := StrAlloc(Length(SourceStr)+1);
     aPChar2 := StrAlloc(Length(BeginChars)+1);
     aPChar3 := StrAlloc(Length(EndChars)+1);
     StrPCopy(aPChar1,SourceStr);
     StrPCopy(aPChar2,BeginChars);
     StrPCopy(aPChar3,EndChars);
     newPChar := StrDeleteSubStr(aPChar1,aPChar2,aPChar3);
     Result   := StrPas(newPChar);
     StrDispose(aPChar1);
     StrDispose(aPChar2);
     StrDispose(aPChar3);
end;

{--------------------------------------------------------------------------}
function CharScan(aString: String; aChar : Char): Boolean;
var
   aPChar1  : PChar;
begin
     aPChar1 := StrAlloc(Length(aString)+1);
     StrPCopy(aPChar1,aString);
     Result  := StrCharScan(aPChar1,aChar);
     StrDispose(aPChar1);
end;

{--------------------------------------------------------------------------}
function ccsAnsi2Ascii(aString: String): String;
var
   aPChar1  : PChar;
begin
     aPChar1 := StrAlloc(Length(aString)+1);
     StrPCopy(aPChar1,aString);
     AnsiToOem(aPChar1,aPChar1);
     Result   := StrPas(aPChar1);
     StrDispose(aPChar1);
end;
{--------------------------------------------------------------------------}
function ccsAscii2Ansi(aString: String): String;
var
   aPChar1  : PChar;
begin
     aPChar1 := StrAlloc(Length(aString)+1);
     StrPCopy(aPChar1,aString);
     OemToAnsi(aPChar1,aPChar1);
     Result   := StrPas(aPChar1);
     StrDispose(aPChar1);
end;



end.
