// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Keyboard.pas' rev: 6.00

#ifndef KeyboardHPP
#define KeyboardHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Forms.hpp>	// Pascal unit
#include <Buttons.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Keyboard
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TKeyLevel { klNormal, klShift, klAltGr };
#pragma option pop

#pragma option push -b-
enum TKeyType { ktNormal, ktShift, ktCapsLock, ktEscape, ktAltGr, ktEnter, KtTab, ktBackspace, ktInsert, ktDelete, ktHome, ktEnd, ktPageUp, ktPageDown, ktLeft, ktRight, ktUp, ktDown, ktFunction };
#pragma option pop

typedef AnsiString TKeyValue;

typedef Shortint TKeyWidth;

typedef Shortint TKeyHeight;

typedef AnsiString TKeyLevelCaption[3];

typedef AnsiString TKeyLevelValue[3];

class DELPHICLASS TKey;
class DELPHICLASS TKeyControl;
class PASCALIMPLEMENTATION TKeyControl : public Buttons::TSpeedButton 
{
	typedef Buttons::TSpeedButton inherited;
	
public:
	TKey* Key;
public:
	#pragma option push -w-inl
	/* TSpeedButton.Create */ inline __fastcall virtual TKeyControl(Classes::TComponent* AOwner) : Buttons::TSpeedButton(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TSpeedButton.Destroy */ inline __fastcall virtual ~TKeyControl(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TKey : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	AnsiString FKeyCaption[3];
	TKeyType FKeyType;
	AnsiString FKeyValue[3];
	TKeyControl* FControl;
	int FTop;
	int FLeft;
	TKeyWidth FWidth;
	TKeyHeight FHeight;
	bool FVisible;
	bool FEnabled;
	Graphics::TFont* FFont;
	void __fastcall SetLeft(const int Value);
	void __fastcall SetTop(const int Value);
	void __fastcall SetWidth(const TKeyWidth Value);
	void __fastcall SetHeight(const TKeyHeight Value);
	AnsiString __fastcall GetKeyCaption(TKeyLevel Level);
	void __fastcall SetKeyCaption(TKeyLevel Level, AnsiString KeyCaption);
	AnsiString __fastcall GetKeyValue(TKeyLevel Level);
	void __fastcall SetKeyValue(TKeyLevel Level, AnsiString KeyValue);
	void __fastcall SetKeyType(const TKeyType Value);
	void __fastcall SetEnabled(const bool Value);
	void __fastcall SetVisible(const bool Value);
	void __fastcall SetFont(const Graphics::TFont* Value);
	
public:
	__fastcall TKey(TKeyType KeyType);
	__fastcall virtual ~TKey(void);
	__property AnsiString KeyCaption[TKeyLevel Level] = {read=GetKeyCaption, write=SetKeyCaption};
	__property TKeyType KeyType = {read=FKeyType, write=SetKeyType, nodefault};
	__property AnsiString KeyValue[TKeyLevel Level] = {read=GetKeyValue, write=SetKeyValue};
	__property int Top = {read=FTop, write=SetTop, nodefault};
	__property int Left = {read=FLeft, write=SetLeft, nodefault};
	__property TKeyWidth Width = {read=FWidth, write=SetWidth, nodefault};
	__property TKeyHeight Height = {read=FHeight, write=SetHeight, nodefault};
	__property bool Enabled = {read=FEnabled, write=SetEnabled, nodefault};
	__property bool Visible = {read=FVisible, write=SetVisible, nodefault};
	__property TKeyControl* Control = {read=FControl, write=FControl};
	__property Graphics::TFont* Font = {read=FFont, write=SetFont};
	void __fastcall AssignControl(TKeyControl* Ctrl);
	void __fastcall UpdateControl(void);
};


class DELPHICLASS TKeyCollection;
class PASCALIMPLEMENTATION TKeyCollection : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
public:
	TKey* operator[](int n) { return Items[n]; }
	
private:
	TKey* __fastcall GetItem(int n);
	int __fastcall GetCount(void);
	
protected:
	Classes::TList* FItems;
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall LoadKeys(Classes::TReader* Reader);
	void __fastcall WriteKeys(Classes::TWriter* Writer);
	
public:
	__property TKey* Items[int n] = {read=GetItem/*, default*/};
	__property int Count = {read=GetCount, nodefault};
	__fastcall TKeyCollection(void);
	__fastcall virtual ~TKeyCollection(void);
	void __fastcall SaveToFile(AnsiString FileName);
	void __fastcall LoadFromFile(AnsiString FileName);
	void __fastcall AddKey(TKey* Key);
	void __fastcall DeleteKey(TKey* Key)/* overload */;
	void __fastcall DeleteKey(int i)/* overload */;
	void __fastcall DeleteAndFreeKey(TKey* Key)/* overload */;
	void __fastcall DeleteAndFreeKey(int i)/* overload */;
	void __fastcall DeleteAllKeys(void);
};


typedef void __fastcall (__closure *TKeyEvent)(System::TObject* Sender, TKey* Key, TKeyLevel KeyLevel, AnsiString KeyValue);

typedef void __fastcall (__closure *TShiftStateChange)(System::TObject* Sender, bool ShiftOn);

typedef void __fastcall (__closure *TCapsStateChange)(System::TObject* Sender, bool CapsOn);

typedef void __fastcall (__closure *TAltGrStateChange)(System::TObject* Sender, bool AltGrOn);

class DELPHICLASS TKeyboard;
class PASCALIMPLEMENTATION TKeyboard : public Extctrls::TCustomPanel 
{
	typedef Extctrls::TCustomPanel inherited;
	
private:
	bool m_bShiftState;
	bool m_bCapsState;
	bool m_bAltGrState;
	TKeyCollection* FKeys;
	Stdctrls::TEditCharCase FCharCase;
	bool FBeep;
	Controls::TWinControl* FLinkedControl;
	Graphics::TColor FHighlightColor;
	TCapsStateChange FOnCapsStateChange;
	TShiftStateChange FOnShiftStateChange;
	TAltGrStateChange FOnAltGrStateChange;
	TKeyEvent FOnKey;
	void __fastcall SetKeys(const TKeyCollection* Value);
	TKeyCollection* __fastcall GetKeys(void);
	void __fastcall SetLinkedControl(const Controls::TWinControl* Value);
	TKeyLevel __fastcall GetKeyLevel(void);
	
protected:
	virtual void __fastcall Loaded(void);
	DYNAMIC void __fastcall Resize(void);
	void __fastcall CreateControls(void);
	void __fastcall ReCreateControls(void);
	void __fastcall FreeAllControls(void);
	void __fastcall KeyClick(System::TObject* Sender);
	void __fastcall SetShiftState(void);
	void __fastcall ClearShiftState(void);
	void __fastcall ToggleCapsState(void);
	void __fastcall ToggleAltGrState(void);
	void __fastcall DoLinkedControlAction(TKey* Key);
	
public:
	__fastcall virtual TKeyboard(Classes::TComponent* AOwner);
	__fastcall virtual ~TKeyboard(void);
	void __fastcall ReCreateKeys(void);
	void __fastcall ResizeKeyboard(void);
	void __fastcall LoadKeyLayout(AnsiString FileName);
	void __fastcall SaveKeyLayout(AnsiString FileName);
	TKey* __fastcall SearchKey(AnsiString KeyCaption, TKeyLevel KeyLevel)/* overload */;
	TKey* __fastcall SearchKey(TKeyLevel KeyLevel, AnsiString KeyValue)/* overload */;
	TKey* __fastcall SearchKey(TKeyType KeyType, AnsiString KeyCaption, TKeyLevel KeyLevel)/* overload */;
	
__published:
	__property BevelOuter  = {default=2};
	__property BevelInner  = {default=0};
	__property BevelWidth  = {default=1};
	__property BorderStyle  = {default=0};
	__property BorderWidth  = {default=0};
	__property Color  = {default=-2147483633};
	__property Enabled  = {default=1};
	__property Stdctrls::TEditCharCase CharCase = {read=FCharCase, write=FCharCase, default=0};
	__property bool BeepOnKeyPressed = {read=FBeep, write=FBeep, default=0};
	__property Controls::TWinControl* LinkedControl = {read=FLinkedControl, write=SetLinkedControl};
	__property Graphics::TColor HighlightColor = {read=FHighlightColor, write=FHighlightColor, nodefault};
	__property bool ShiftState = {read=m_bShiftState, nodefault};
	__property bool CapsState = {read=m_bCapsState, nodefault};
	__property bool AltGrState = {read=m_bAltGrState, nodefault};
	__property TKeyLevel KeyLevel = {read=GetKeyLevel, nodefault};
	__property TKeyCollection* Keys = {read=GetKeys, write=SetKeys};
	__property TKeyEvent OnKey = {read=FOnKey, write=FOnKey};
	__property TShiftStateChange OnShiftStateChange = {read=FOnShiftStateChange, write=FOnShiftStateChange};
	__property TCapsStateChange OnCapsStateChange = {read=FOnCapsStateChange, write=FOnCapsStateChange};
	__property TAltGrStateChange OnAltGrStateChange = {read=FOnAltGrStateChange, write=FOnAltGrStateChange};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TKeyboard(HWND ParentWindow) : Extctrls::TCustomPanel(ParentWindow) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint HORZ_BASE_UNIT = 0x4;
static const Shortint VERT_BASE_UNIT = 0x4;
static const Shortint DEFAULT_KEY_WIDTH = 0x8;
static const Shortint DEFAULT_KEY_HEIGHT = 0x8;
static const Byte WINGDINGS_PAGEUP = 0xf1;
static const Byte WINGDINGS_PAGEDOWN = 0xf2;
static const Byte WINGDINGS_LEFT = 0xdf;
static const Byte WINGDINGS_RIGHT = 0xe0;
static const Byte WINGDINGS_UP = 0xe1;
static const Byte WINGDINGS_DOWN = 0xe2;
static const Byte WINGDINGS_ENTER = 0xc3;
#define WINGDINGS "Wingdings"
extern PACKAGE bool __fastcall IsDelphiRunning(void);

}	/* namespace Keyboard */
using namespace Keyboard;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Keyboard
