// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'O2Plan.pas' rev: 5.00

#ifndef O2PlanHPP
#define O2PlanHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Menus.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <ShellAPI.hpp>	// Pascal unit
#include <Printers.hpp>	// Pascal unit
#include <PlanObjects.hpp>	// Pascal unit
#include <jpeg.hpp>	// Pascal unit
#include <PlanUtils.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <StrF.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace O2plan
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EOxygenPlanException;
class PASCALIMPLEMENTATION EOxygenPlanException : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EOxygenPlanException(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EOxygenPlanException(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EOxygenPlanException(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EOxygenPlanException(int Ident, const System::TVarRec 
		* Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EOxygenPlanException(const AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EOxygenPlanException(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EOxygenPlanException(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EOxygenPlanException(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EOxygenPlanException(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanStandardPicture;
class PASCALIMPLEMENTATION TPlanStandardPicture : public Graphics::TPicture 
{
	typedef Graphics::TPicture inherited;
	
public:
	AnsiString Name;
	AnsiString __fastcall GetDescrString(void);
public:
	#pragma option push -w-inl
	/* TPicture.Create */ inline __fastcall TPlanStandardPicture(void) : Graphics::TPicture() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TPicture.Destroy */ inline __fastcall virtual ~TPlanStandardPicture(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TPlanOption { poAutoAnimate, poSavePictures, poSaveStandardPictures, poSaveBackgroundPicture, poChildrenClipping 
	};
#pragma option pop

typedef Set<TPlanOption, poAutoAnimate, poChildrenClipping>  TPlanOptions;

struct TPrintMargins
{
	int pmLeft;
	int pmTop;
	int pmRight;
	int pmBottom;
} ;

class DELPHICLASS TOxygenPlan;
typedef void __fastcall (__closure *TObjectClickEvent)(TOxygenPlan* Plan, Planobjects::TPlanObject* 
	PlanObject, Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);

typedef void __fastcall (__closure *TPlanNotifyEvent)(TOxygenPlan* Plan, Planobjects::TPlanObject* PlanObject
	);

typedef void __fastcall (__closure *TParseProgressEvent)(TOxygenPlan* Plan, const int PercentsCompleted
	);

typedef bool __fastcall (__closure *TNeedStdPictureEvent)(TOxygenPlan* Plan, const AnsiString PictureName
	);

typedef void __fastcall (__closure *TNeedPictureEvent)(TOxygenPlan* Plan, Planobjects::TPlanPicture* 
	PlanPicture);

class DELPHICLASS TSelectedObjectList;
class PASCALIMPLEMENTATION TSelectedObjectList : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TList* FList;
	Planobjects::TPlanObject* __fastcall Get(int Index);
	void __fastcall Put(int Index, Planobjects::TPlanObject* Item);
	int __fastcall GetCount(void);
	
public:
	__property int Count = {read=GetCount, nodefault};
	__property Planobjects::TPlanObject* Items[int Index] = {read=Get, write=Put/*, default*/};
	__fastcall TSelectedObjectList(void);
	HIDESBASE void __fastcall Free(void);
	int __fastcall Add(Planobjects::TPlanObject* Item);
	int __fastcall IndexOf(Planobjects::TPlanObject* Item);
	void __fastcall Delete(int Index);
	void __fastcall DeleteObject(Planobjects::TPlanObject* Item);
	void __fastcall EditMove(const Windows::TPoint &APoint);
	void __fastcall Clear(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TSelectedObjectList(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TOxygenPlan : public Extctrls::TCustomPanel 
{
	typedef Extctrls::TCustomPanel inherited;
	
private:
	int FScaleX;
	int FScaleY;
	int FCurX;
	int FCurY;
	Windows::TPoint FStartCoord;
	Planobjects::TPlanObject* FActiveObject;
	Planobjects::TMarginType FActiveMarginType;
	Graphics::TPicture* FBackgroundPicture;
	bool FReadOnly;
	Classes::TStrings* FPlanStrings;
	int FNewClickNum;
	Graphics::TColor FSelectColor;
	Planobjects::TPlanLayer* FCurLayer;
	Planobjects::TPlanObject* FCurDrawingObject;
	int FCurDrawingPointNum;
	Graphics::TPen* FPen;
	Graphics::TBrush* FBrush;
	Planobjects::TPlanObject* NewObjUM;
	Planobjects::TPlanObject* OldObjUM;
	int FDisableRepaintCount;
	bool FReadyToMoving;
	bool FTransparent;
	Classes::TList* FStandardPicturesList;
	TPlanOptions FOptions;
	bool FPrinting;
	TPrintMargins FPrintMargins;
	TSelectedObjectList* FSelectedObjects;
	bool FWasMove;
	TObjectClickEvent FObjectClick;
	TPlanNotifyEvent FObjectDblClick;
	TPlanNotifyEvent FObjectMouseMove;
	TPlanNotifyEvent FObjectMouseEnter;
	TPlanNotifyEvent FObjectMouseLeave;
	TPlanNotifyEvent FAfterDrawNewObject;
	TParseProgressEvent FParseProgress;
	Classes::TNotifyEvent FAfterPaint;
	TNeedStdPictureEvent FNeedStdPicture;
	TNeedPictureEvent FNeedPicture;
	TPlanNotifyEvent FObjectBlink;
	Classes::TStrings* __fastcall GetPlanStrings(void);
	void __fastcall SetPlanStrings(Classes::TStrings* Value);
	void __fastcall SetBackgroundPicture(Graphics::TPicture* Value);
	void __fastcall SetScaleX(int Value);
	void __fastcall SetScaleY(int Value);
	void __fastcall SetReadOnly(bool Value);
	AnsiString __fastcall GetBackgroundPictureType(void);
	void __fastcall SetCurLayer(Planobjects::TPlanLayer* Value);
	TPlanStandardPicture* __fastcall GetPicture(int Index);
	void __fastcall ClearPictures(void);
	int __fastcall GetPictureCount(void);
	void __fastcall SetActiveObject(Planobjects::TPlanObject* PlanObject);
	void __fastcall ReadStringData(Classes::TReader* Reader);
	void __fastcall StdPictureChange(System::TObject* Sender);
	void __fastcall SetOptions(TPlanOptions Value);
	int __fastcall GetObjectCount(void);
	void __fastcall SetBrush(Graphics::TBrush* Value);
	void __fastcall SetPen(Graphics::TPen* Value);
	void __fastcall SetTransparent(const bool Value);
	
protected:
	virtual void __fastcall DoObjectClick(Planobjects::TPlanObject* PlanObject, Controls::TMouseButton 
		Button, Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall DoObjectDblClick(Planobjects::TPlanObject* PlanObject);
	virtual void __fastcall DoObjectMouseMove(Planobjects::TPlanObject* PlanObject);
	virtual void __fastcall DoObjectMouseEnter(Planobjects::TPlanObject* PlanObject);
	virtual void __fastcall DoObjectMouseLeave(Planobjects::TPlanObject* PlanObject);
	virtual void __fastcall DoAfterDrawNewObject(Planobjects::TPlanObject* PlanObject);
	virtual void __fastcall DoParseProgress(const int PercentsCompleted);
	virtual void __fastcall DoAfterPaint(void);
	virtual bool __fastcall DoNeedStdPicture(const AnsiString PictureName);
	virtual void __fastcall DoNeedPicture(Planobjects::TPlanPicture* PlanPicture);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	virtual void __fastcall Loaded(void);
	DYNAMIC void __fastcall Resize(void);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, 
		int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	DYNAMIC void __fastcall DblClick(void);
	virtual void __fastcall Paint(void);
	
public:
	Planobjects::TPlanLayers* Layers;
	__property Planobjects::TMarginType ActiveMarginType = {read=FActiveMarginType, nodefault};
	__property Planobjects::TPlanObject* ActiveObject = {read=FActiveObject, write=SetActiveObject};
	__property AnsiString BackgroundPictureType = {read=GetBackgroundPictureType};
	__property Canvas ;
	__property int CurDrawingPointNum = {read=FCurDrawingPointNum, nodefault};
	__property Planobjects::TPlanLayer* CurrentLayer = {read=FCurLayer, write=SetCurLayer, stored=false
		};
	__property int DisableRepaintCount = {read=FDisableRepaintCount, nodefault};
	__property bool Printing = {read=FPrinting, write=FPrinting, nodefault};
	__property int ObjectCount = {read=GetObjectCount, nodefault};
	__property TPlanStandardPicture* Pictures[int Index] = {read=GetPicture};
	__property int PictureCount = {read=GetPictureCount, nodefault};
	__property TSelectedObjectList* SelectedObjects = {read=FSelectedObjects};
	__property Windows::TPoint StartCoord = {read=FStartCoord};
	int __fastcall AddPicture(const AnsiString PictureName, Graphics::TPicture* Picture);
	void __fastcall DeletePicture(int Index);
	void __fastcall LoadStdPicture(const AnsiString PictureName, Planobjects::TPlanPicture* PlanPicture
		);
	void __fastcall LoadPicture(Planobjects::TPlanPicture* PlanPicture);
	int __fastcall PictureIndex(const AnsiString PictureName);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__fastcall virtual TOxygenPlan(Classes::TComponent* AOwner);
	void __fastcall CancelDrawNewObject(void);
	void __fastcall Clear(void);
	void __fastcall EnableRepaint(void);
	void __fastcall DisableRepaint(void);
	virtual void __fastcall DoObjectBlink(Planobjects::TPlanObject* PlanObject);
	void __fastcall ExportToMetafile(const AnsiString FileName);
	void __fastcall ExportToBitmap(const AnsiString FileName);
	void __fastcall ExportToJpeg(const AnsiString FileName);
	void __fastcall DrawNewObject(TMetaClass* PlanObjectClass);
	Planobjects::TPlanObject* __fastcall FindObject(TMetaClass* ObjectClass, const AnsiString ObjectName
		, const int ObjectID);
	Graphics::TBitmap* __fastcall GetBitmap(void);
	Graphics::TMetafile* __fastcall GetMetafile(void);
	virtual void __fastcall Initialize(void);
	void __fastcall LoadFromFile(AnsiString FileName);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	Planobjects::TPlanObject* __fastcall ObjectByID(TMetaClass* ObjectClass, const int ObjectID);
	Planobjects::TPlanObject* __fastcall ObjectByName(TMetaClass* ObjectClass, const AnsiString ObjectName
		);
	Planobjects::TPlanObject* __fastcall ObjectUnderMouse(Planobjects::TMarginType &MarginType);
	void __fastcall PaintToCanvas(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	void __fastcall PaintToDesktop(void);
	void __fastcall Parse(Classes::TStrings* PlanData);
	void __fastcall Print(Printers::TPrinter* APrinter);
	/*         class method */ static void __fastcall RegisterPlanObjectClass(TMetaClass* vmt, const AnsiString 
		ACmdString, TMetaClass* PlanObjectClass);
	void __fastcall SaveTo(Classes::TStrings* PlanData);
	void __fastcall SaveToFile(AnsiString FileName);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	__fastcall virtual ~TOxygenPlan(void);
	
__published:
	__property Align ;
	__property Graphics::TPicture* BackgroundPicture = {read=FBackgroundPicture, write=SetBackgroundPicture
		};
	__property BevelInner ;
	__property BevelOuter ;
	__property BevelWidth ;
	__property BorderWidth ;
	__property BorderStyle ;
	__property Graphics::TBrush* Brush = {read=FBrush, write=SetBrush};
	__property Constraints ;
	__property DragCursor ;
	__property DragMode ;
	__property DragKind ;
	__property DockSite ;
	__property DoubleBuffered ;
	__property Enabled ;
	__property Color ;
	__property Ctl3D ;
	__property Font ;
	__property Locked ;
	__property TPlanOptions Options = {read=FOptions, write=SetOptions, nodefault};
	__property ParentColor ;
	__property ParentCtl3D ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property Graphics::TPen* Pen = {read=FPen, write=SetPen};
	__property Classes::TStrings* PlanStrings = {read=GetPlanStrings, write=SetPlanStrings};
	__property PopupMenu ;
//	__property TPrintMargins PrintMargins = {read=FPrintMargins, write=FPrintMargins};
	__property bool ReadOnly = {read=FReadOnly, write=SetReadOnly, nodefault};
	__property Graphics::TColor SelectColor = {read=FSelectColor, write=FSelectColor, nodefault};
	__property int ScaleX = {read=FScaleX, write=SetScaleX, nodefault};
	__property int ScaleY = {read=FScaleY, write=SetScaleY, nodefault};
	__property ShowHint ;
	__property TabOrder ;
	__property TabStop ;
	__property bool Transparent = {read=FTransparent, write=SetTransparent, nodefault};
	__property Visible ;
	__property UseDockManager ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnCanResize ;
	__property OnConstrainedResize ;
	__property OnDockDrop ;
	__property OnDockOver ;
	__property OnStartDock ;
	__property OnEndDock ;
	__property OnUnDock ;
	__property OnGetSiteInfo ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnMouseWheel ;
	__property OnMouseWheelDown ;
	__property OnMouseWheelUp ;
	__property OnResize ;
	__property OnStartDrag ;
	__property Classes::TNotifyEvent OnAfterPaint = {read=FAfterPaint, write=FAfterPaint};
	__property TPlanNotifyEvent OnAfterDrawNewObject = {read=FAfterDrawNewObject, write=FAfterDrawNewObject
		};
	__property TNeedStdPictureEvent OnNeedStdPicture = {read=FNeedStdPicture, write=FNeedStdPicture};
	__property TNeedPictureEvent OnNeedPicture = {read=FNeedPicture, write=FNeedPicture};
	__property TPlanNotifyEvent OnObjectBlink = {read=FObjectBlink, write=FObjectBlink};
	__property TObjectClickEvent OnObjectClick = {read=FObjectClick, write=FObjectClick};
	__property TPlanNotifyEvent OnObjectDblClick = {read=FObjectDblClick, write=FObjectDblClick};
	__property TPlanNotifyEvent OnObjectMouseMove = {read=FObjectMouseMove, write=FObjectMouseMove};
	__property TPlanNotifyEvent OnObjectMouseEnter = {read=FObjectMouseEnter, write=FObjectMouseEnter};
		
	__property TPlanNotifyEvent OnObjectMouseLeave = {read=FObjectMouseLeave, write=FObjectMouseLeave};
		
	__property TParseProgressEvent OnParseProgress = {read=FParseProgress, write=FParseProgress};
public:
		
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TOxygenPlan(HWND ParentWindow) : Extctrls::TCustomPanel(
		ParentWindow) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE System::ResourceString _cmScale;
#define O2plan_cmScale System::LoadResourceString(&O2plan::_cmScale)
extern PACKAGE System::ResourceString _cmSetPenColor;
#define O2plan_cmSetPenColor System::LoadResourceString(&O2plan::_cmSetPenColor)
extern PACKAGE System::ResourceString _cmSetBrushColor;
#define O2plan_cmSetBrushColor System::LoadResourceString(&O2plan::_cmSetBrushColor)
extern PACKAGE System::ResourceString _cmSetLineWidth;
#define O2plan_cmSetLineWidth System::LoadResourceString(&O2plan::_cmSetLineWidth)
extern PACKAGE System::ResourceString _cmSetFont;
#define O2plan_cmSetFont System::LoadResourceString(&O2plan::_cmSetFont)
extern PACKAGE System::ResourceString _cmStandardPicture;
#define O2plan_cmStandardPicture System::LoadResourceString(&O2plan::_cmStandardPicture)
extern PACKAGE System::ResourceString _cmStandardAniGif;
#define O2plan_cmStandardAniGif System::LoadResourceString(&O2plan::_cmStandardAniGif)
extern PACKAGE System::ResourceString _cmBackgroundPicture;
#define O2plan_cmBackgroundPicture System::LoadResourceString(&O2plan::_cmBackgroundPicture)
extern PACKAGE System::ResourceString _cmLayer;
#define O2plan_cmLayer System::LoadResourceString(&O2plan::_cmLayer)
extern PACKAGE System::ResourceString _sDefaultLayer;
#define O2plan_sDefaultLayer System::LoadResourceString(&O2plan::_sDefaultLayer)
extern PACKAGE System::ResourceString _sFileNotFound;
#define O2plan_sFileNotFound System::LoadResourceString(&O2plan::_sFileNotFound)
extern PACKAGE System::ResourceString _sInvalidOwner;
#define O2plan_sInvalidOwner System::LoadResourceString(&O2plan::_sInvalidOwner)
extern PACKAGE System::ResourceString _sUnknownPlanObject;
#define O2plan_sUnknownPlanObject System::LoadResourceString(&O2plan::_sUnknownPlanObject)
extern PACKAGE void __fastcall RenameStdPicture(TOxygenPlan* Plan, const AnsiString OldName, const AnsiString 
	NewName);
extern PACKAGE int __fastcall StandardPictureReferenceCount(TOxygenPlan* Plan, const AnsiString StdPictureName
	);
extern PACKAGE void __fastcall Register(void);

}	/* namespace O2plan */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace O2plan;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// O2Plan
