//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "ImageEnIO"
#pragma link "ImageEnView"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// copy twain parameters to the controls
void TForm1::FillBack()
{
	static AnsiString COLORS[3]={"Black&White","GrayScale","RGB"};
   Edit1->Text=FloatToStr( ImageEnIO1->TWainParams->YResolution->CurrentValue );
	Edit2->Text=FloatToStr( ImageEnIO1->TWainParams->XResolution->CurrentValue );
   // Fill Colors (0=B/W 1=GrayScale 2=RGB) combobox
   ComboBox2->Clear();
	for(int i=0; i<ImageEnIO1->TWainParams->PixelType->Count;i++)
   	ComboBox2->Items->Add( COLORS[ ImageEnIO1->TWainParams->PixelType->Items[i] ] );
   ComboBox2->ItemIndex=ImageEnIO1->TWainParams->PixelType->IndexOf(ImageEnIO1->TWainParams->PixelType->CurrentValue);
}
//---------------------------------------------------------------------------
// copy controls to twain parameters
void TForm1::FillIn()
{
	ImageEnIO1->TWainParams->VisibleDialog=CheckBox1->Checked;
   ImageEnIO1->TWainParams->ProgressIndicators=CheckBox2->Checked;
   ImageEnIO1->TWainParams->PixelType->CurrentValue=ComboBox2->ItemIndex;
   ImageEnIO1->TWainParams->YResolution->CurrentValue=StrToInt( Edit1->Text);
	ImageEnIO1->TWainParams->XResolution->CurrentValue=StrToInt( Edit2->Text);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
	// fills TWain sources
	for(int i=0; i<ImageEnIO1->TWainParams->SourceCount; i++)
   	ComboBox1->Items->Add( ImageEnIO1->TWainParams->SourceName[i] );
   // Select first scanner
   ComboBox1->ItemIndex=0;
   ImageEnIO1->TWainParams->SelectedSource=ComboBox1->ItemIndex;
   FillBack();
}
//---------------------------------------------------------------------------
// Select scanner
void __fastcall TForm1::ComboBox1Change(TObject *Sender)
{
	ImageEnIO1->TWainParams->SelectedSource=ComboBox1->ItemIndex;
   FillBack();
}
//---------------------------------------------------------------------------
// negotiate parameters (verify that scanner supports Frame rectangle, Dpi...)
void __fastcall TForm1::Button2Click(TObject *Sender)
{
	FillIn();
   ImageEnIO1->TWainParams->Update();	// verify here...
   FillBack();
}
//---------------------------------------------------------------------------
// Acquire
void __fastcall TForm1::Button1Click(TObject *Sender)
{
	FillIn();
   ImageEnIO1->Acquire();
   ProgressBar1->Position=0;
}
//---------------------------------------------------------------------------
// progress
void __fastcall TForm1::ImageEnIO1Progress(TObject *Sender, int per)
{
	ProgressBar1->Position=per;
   if(CheckBox3->Checked) {
	   ImageEnView1->Update();
	   Application->ProcessMessages();
   }
}
//---------------------------------------------------------------------------

