// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ImageEnProc.pas' rev: 5.00

#ifndef ImageEnProcHPP
#define ImageEnProcHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <iefft.hpp>	// Pascal unit
#include <hyiedefs.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <ImageEnView.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Imageenproc
{
//-- type declarations -------------------------------------------------------
struct TGraphFilter
{
	int Values[3][3];
	int Divisor;
} ;

class DELPHICLASS EFilterInvalid;
class PASCALIMPLEMENTATION EFilterInvalid : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EFilterInvalid(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EFilterInvalid(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EFilterInvalid(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EFilterInvalid(int Ident, const System::TVarRec * Args
		, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EFilterInvalid(const AnsiString Msg, int AHelpContext)
		 : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EFilterInvalid(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EFilterInvalid(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EFilterInvalid(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EFilterInvalid(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TFlipDir { fdHorizontal, fdVertical };
#pragma option pop

struct THistogramItem
{
	unsigned R;
	unsigned G;
	unsigned B;
	unsigned Gray;
} ;

typedef THistogramItem THistogram[256];

typedef THistogramItem *PHistogram;

#pragma option push -b-
enum ImageEnProc__2 { peAll, peContrast, peHSV, peHSL, peRGB, peUserFilt, peEqualize, peBumpMap, peLens, 
	peWave, peMorph, peRotate, peFFT };
#pragma option pop

typedef Set<ImageEnProc__2, peAll, peFFT>  TPreviewEffects;

#pragma option push -b-
enum TPRPreviewsParamsItems { prppDefaultLockPreview };
#pragma option pop

typedef Set<TPRPreviewsParamsItems, prppDefaultLockPreview, prppDefaultLockPreview>  TPRPreviewsParams
	;

#pragma option push -b-
enum TIEFilterPresets { fpNone, fpBlur, fpEdge, fpEmboss, fpHighPass1, fpHighPass2, fpHighPass3, LowPass1, 
	LowPass2 };
#pragma option pop

typedef void __fastcall (__closure *TIEPreviewEvent)(System::TObject* Sender, Forms::TForm* PreviewForm
	);

class DELPHICLASS TImageEnProc;
class PASCALIMPLEMENTATION TImageEnProc : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	bool fAutoUndo;
	Imageenview::TIEView* fImageEnView;
	int fSelx1;
	int fSely1;
	int fSelx2;
	int fSely2;
	Graphics::TColor fBackground;
	Hyiedefs::TMsgLanguage fMsgLanguage;
	TPRPreviewsParams fPreviewsParams;
	Graphics::TFont* fPreviewFont;
	TIEPreviewEvent fOnPreview;
	Extctrls::TImage* fTImage;
	void __fastcall SetAttachedBitmap(Graphics::TBitmap* atBitmap);
	void __fastcall SetAttachedImageEn(Imageenview::TIEView* atImageEn);
	Graphics::TColor __fastcall GetReBackground(void);
	void __fastcall SetReBackground(Graphics::TColor v);
	void __fastcall SetPreviewFont(Graphics::TFont* f);
	void __fastcall SetTImage(Extctrls::TImage* v);
	int __fastcall GetSelX1(void);
	int __fastcall GetSelY1(void);
	int __fastcall GetSelX2(void);
	int __fastcall GetSelY2(void);
	void __fastcall SetPRPreviewParams(TPRPreviewsParams v);
	TPRPreviewsParams __fastcall GetPRPreviewParams(void);
	bool __fastcall GetCanUndo(void);
	
protected:
	Graphics::TBitmap* fUndoBitmap;
	Graphics::TBitmap* fBitmap;
	Hyiedefs::TIEProgressEvent fOnProgress;
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	void __fastcall OnBitmapChange(System::TObject* Sender, bool destroying);
	
public:
	__fastcall virtual TImageEnProc(Classes::TComponent* Owner);
	__fastcall virtual ~TImageEnProc(void);
	__property Graphics::TBitmap* AttachedBitmap = {read=fBitmap, write=SetAttachedBitmap};
	void __fastcall Update(void);
	void __fastcall Negative(void);
	void __fastcall HSLvar(int oHue, int oSat, int oLum);
	void __fastcall HSVvar(int oHue, int oSat, int oVal);
	void __fastcall IntensityRGBall(int r, int g, int b);
	void __fastcall Contrast(int vv);
	void __fastcall ApplyFilter(const TGraphFilter &filter);
	void __fastcall ApplyFilterPreset(TIEFilterPresets filter);
	void __fastcall ConvertToGray(void);
	void __fastcall CastColorRange(Hyiedefs::TRGB BeginColor, Hyiedefs::TRGB EndColor, Hyiedefs::TRGB CastColor
		);
	void __fastcall Rotate(int fangle, bool antialias);
	void __fastcall Flip(TFlipDir dir);
	void __fastcall ImageResize(int newWidth, int newHeight);
	void __fastcall Resample(int NewWidth, int NewHeight, Hyiedefs::TResampleFilter FilterType);
	bool __fastcall DoPreviews(TPreviewEffects pe);
	void __fastcall Clear(void);
	void __fastcall ClearSel(void);
	void __fastcall Merge(Graphics::TBitmap* DBitmap, int pcf);
	void __fastcall Threshold(Hyiedefs::TRGB DownLimit, Hyiedefs::TRGB UpLimit, Hyiedefs::TRGB DownVal, 
		Hyiedefs::TRGB UpVal);
	void __fastcall HistEqualize(Hyiedefs::TRGB LoThresh, Hyiedefs::TRGB HiThresh);
	void __fastcall HistAutoEqualize(void);
	void __fastcall CropSel(void);
	void __fastcall BumpMapping(int LightX, int LightY, int LampX, int LampY, int pcf, Hyiedefs::TRGB Color
		);
	void __fastcall Lens(int cx, int cy, int Width, int Height, double Refraction);
	void __fastcall Wave(int amplitude, int wavelength, int phase, bool reflective);
	void __fastcall ConvertToBWOrdered(void);
	void __fastcall ConvertToBWThreshold(int Threshold);
	void __fastcall ConvertTo24Bit(void);
	void __fastcall ConvertToPalette(int NumColors, Hyiedefs::pRGBROW Palette);
	void __fastcall ConvertTo(int NumColors);
	int __fastcall WriteHiddenText(AnsiString text);
	int __fastcall WriteHiddenData(char * data, int count);
	void __fastcall Maximum(int WindowSize);
	void __fastcall Minimum(int WindowSize);
	void __fastcall Opening(int WindowSize);
	void __fastcall Closing(int WindowSize);
	void __fastcall GetHistogram(THistogramItem * Hist);
	void __fastcall CalcImagePalette(Hyiedefs::TRGB * Palette, const int Palette_Size, int MaxCol);
	int __fastcall CalcImageNumColors(void);
	Graphics::TBitmap* __fastcall GetHSVChannel(int ch);
	void __fastcall GetHSVChannelAll(Graphics::TBitmap* BitmapH, Graphics::TBitmap* BitmapS, Graphics::TBitmap* 
		BitmapV);
	Graphics::TBitmap* __fastcall GetRGBChannel(int ch);
	void __fastcall GetRGBChannelAll(Graphics::TBitmap* BitmapR, Graphics::TBitmap* BitmapG, Graphics::TBitmap* 
		BitmapB);
	AnsiString __fastcall ReadHiddenText(void);
	int __fastcall ReadHiddenData(char * data, int maxlen);
	int __fastcall GetHiddenDataSpace(void);
	Iefft::TIEFtImage* __fastcall FTCreateImage(Iefft::TIEFtImageType ImageType, int NewWidth, int NewHeight
		);
	void __fastcall FTConvertFrom(Iefft::TIEFtImage* ft);
	void __fastcall FTDisplayFrom(Iefft::TIEFtImage* ft);
	virtual void __fastcall SaveUndo(void);
	void __fastcall ClearUndo(void);
	virtual void __fastcall Undo(void);
	__property bool CanUndo = {read=GetCanUndo, nodefault};
	void __fastcall SelCopyToClip(void);
	void __fastcall CopyToClipboard(void);
	void __fastcall SelPasteFromClipStretch(void);
	void __fastcall PasteFromClipboard(void);
	void __fastcall PointPasteFromClip(int x1, int y1);
	void __fastcall SelCutToClip(void);
	__property int SelX1 = {read=GetSelX1, nodefault};
	__property int SelY1 = {read=GetSelY1, nodefault};
	__property int SelX2 = {read=GetSelX2, nodefault};
	__property int SelY2 = {read=GetSelY2, nodefault};
	void __fastcall Select(int x1, int y1, int x2, int y2, Imageenview::TIESelOp Op);
	void __fastcall SelectAll(void);
	bool __fastcall GetReSel(int &fsX1, int &fsY1, int &fsX2, int &fsY2, Hyiedefs::PPointArray &PolySel
		, int &PolySelCount);
	
__published:
	__property Imageenview::TIEView* AttachedImageEn = {read=fImageEnView, write=SetAttachedImageEn};
	__property bool AutoUndo = {read=fAutoUndo, write=fAutoUndo, default=1};
	__property Graphics::TColor Background = {read=GetReBackground, write=SetReBackground, default=0};
	__property Hyiedefs::TIEProgressEvent OnProgress = {read=fOnProgress, write=fOnProgress};
	__property Hyiedefs::TMsgLanguage MsgLanguage = {read=fMsgLanguage, write=fMsgLanguage, default=0};
		
	__property TPRPreviewsParams PreviewsParams = {read=GetPRPreviewParams, write=SetPRPreviewParams, default=0
		};
	__property Graphics::TFont* PreviewFont = {read=fPreviewFont, write=SetPreviewFont};
	__property Extctrls::TImage* AttachedTImage = {read=fTImage, write=SetTImage};
	__property TIEPreviewEvent OnPreview = {read=fOnPreview, write=fOnPreview};
};


//-- var, const, procedure ---------------------------------------------------
#define ppeColorAdjust (System::Set<ImageEnProc__2, peAll, peFFT> () )
#define ppeEffects (System::Set<ImageEnProc__2, peAll, peFFT> () )
extern PACKAGE TGraphFilter IEFiltPres[9];
extern PACKAGE Hyiedefs::TRGB C1TO24[256][8];
extern PACKAGE Hyiedefs::TRGB __fastcall CreateRGB(Byte r, Byte g, Byte b);
extern PACKAGE int __fastcall _RGBToGray(const Hyiedefs::TRGB rgb);
extern PACKAGE Graphics::TColor __fastcall TRGB2TColor(Hyiedefs::TRGB rgb);
extern PACKAGE Graphics::TColor __fastcall RGB2TColor(int r, int g, int b);
extern PACKAGE Hyiedefs::TRGB __fastcall TColor2TRGB(Graphics::TColor cl);
extern PACKAGE double __fastcall dmin(double v1, double v2);
extern PACKAGE double __fastcall dmax(double v1, double v2);
extern PACKAGE int __fastcall imax(int v1, int v2);
extern PACKAGE int __fastcall imin(int v1, int v2);
extern PACKAGE int __fastcall ilimit(int vv, int min, int max);
extern PACKAGE int __fastcall blimit(int vv);
extern PACKAGE void __fastcall iswap(int &B1, int &B2);
extern PACKAGE bool __fastcall EqualRGB(Hyiedefs::TRGB rgb1, Hyiedefs::TRGB rgb2);
extern PACKAGE void __fastcall bswap(Byte &B1, Byte &B2);
extern PACKAGE void __fastcall OrdCor(int &x1, int &y1, int &x2, int &y2);
extern PACKAGE void __fastcall _ApplyFilter(Graphics::TBitmap* bitmap, const TGraphFilter &filter, int 
	fSelx1, int fSely1, int fSelx2, int fSely2, Hyiedefs::TProgressRec &Progress);
extern PACKAGE int __fastcall _GetMediaContrast(Graphics::TBitmap* bitmap);
extern PACKAGE void __fastcall _HSLvar(Graphics::TBitmap* bitmap, int oHue, int oSat, int oLum, int 
	fSelx1, int fSely1, int fSelx2, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* 
	Sender);
extern PACKAGE void __fastcall _HSVvar(Graphics::TBitmap* bitmap, int oHue, int oSat, int oVal, int 
	fSelx1, int fSely1, int fSelx2, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* 
	Sender);
extern PACKAGE void __fastcall _Rot90o(Graphics::TBitmap* bakbmp, Graphics::TBitmap* newbitmap);
extern PACKAGE void __fastcall _Rot90(Graphics::TBitmap* bakbmp, Graphics::TBitmap* newbitmap);
extern PACKAGE void __fastcall RGB2HSL(Hyiedefs::TRGB px, double &Hue, double &Sat, double &Lum);
extern PACKAGE void __fastcall HSL2RGB(Hyiedefs::TRGB &px, double iHue, double iSat, double iLum);
extern PACKAGE void __fastcall HSV2RGB(Hyiedefs::TRGB &px, int H, int S, int V);
extern PACKAGE void __fastcall RGB2HSV(Hyiedefs::TRGB RGB, int &h, int &s, int &v);
extern PACKAGE TGraphFilter __fastcall LoadFilterFromFile(const AnsiString nf);
extern PACKAGE void __fastcall SaveFilterToFile(const AnsiString nf, const TGraphFilter &filt);
extern PACKAGE void __fastcall _ContrastRGB(Graphics::TBitmap* bitmap, int vv, int mR, int mG, int mB
	, int fSelx1, int fSely1, int fSelx2, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* 
	Sender);
extern PACKAGE void __fastcall _Merge(Graphics::TBitmap* bitmap, Graphics::TBitmap* DBitmap, int pcf
	, int fSelx1, int fSely1, int fSelx2, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* 
	Sender);
extern PACKAGE void __fastcall _CastColorRange(Graphics::TBitmap* bitmap, Hyiedefs::TRGB BeginColor, 
	Hyiedefs::TRGB EndColor, Hyiedefs::TRGB CastColor, int fSelx1, int fSely1, int fSelx2, int fSely2, 
	Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* Sender);
extern PACKAGE void __fastcall _Threshold(Graphics::TBitmap* bitmap, Hyiedefs::TRGB DownLimit, Hyiedefs::TRGB 
	UpLimit, Hyiedefs::TRGB DownVal, Hyiedefs::TRGB UpVal, int fSelx1, int fSely1, int fSelx2, int fSely2
	, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* Sender);
extern PACKAGE void __fastcall _HistAutoEqualize(Graphics::TBitmap* bitmap, int fSelx1, int fSely1, 
	int fSelx2, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* Sender);
extern PACKAGE void __fastcall _HistEqualize(Graphics::TBitmap* bitmap, Hyiedefs::TRGB LoThresh, Hyiedefs::TRGB 
	HiThresh, int fSelx1, int fSely1, int fSelx2, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* 
	Sender);
extern PACKAGE void __fastcall _GetMediaContrastRGB(Graphics::TBitmap* bitmap, int &mR, int &mG, int 
	&mB);
extern PACKAGE void __fastcall _GetHistogram(Graphics::TBitmap* Bitmap, THistogramItem * Hist, int fSelx1
	, int fSely1, int fSelx2, int fSely2);
extern PACKAGE int __fastcall _GetImageNumColors(Graphics::TBitmap* bitmap, int fSelx1, int fSely1, 
	int fSelx2, int fSely2);
extern PACKAGE void __fastcall _Contrast(Graphics::TBitmap* bitmap, int vv, int mm, int fSelx1, int 
	fSely1, int fSelx2, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* Sender);
extern PACKAGE Graphics::TBitmap* __fastcall _ConvertTo1bit(Graphics::TBitmap* Bitmap, Hyiedefs::TRGB 
	&BackCol, Hyiedefs::TRGB &ForeCol);
extern PACKAGE void __fastcall _IntensityRGBall(Graphics::TBitmap* bitmap, int r, int g, int b, int 
	fSelx1, int fSely1, int fSelx2, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* 
	Sender);
extern PACKAGE Graphics::TBitmap* __fastcall _GetHSVChannel(Graphics::TBitmap* bitmap, int ch, Hyiedefs::TIEProgressEvent 
	fOnProgress, System::TObject* Sender);
extern PACKAGE Graphics::TBitmap* __fastcall _GetRGBChannel(Graphics::TBitmap* bitmap, int ch, Hyiedefs::TIEProgressEvent 
	fOnProgress, System::TObject* Sender);
extern PACKAGE void __fastcall _GetHSVChannelAll(Graphics::TBitmap* bitmap, Graphics::TBitmap* BitmapH
	, Graphics::TBitmap* BitmapS, Graphics::TBitmap* BitmapV, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* 
	Sender);
extern PACKAGE void __fastcall _GetRGBChannelAll(Graphics::TBitmap* bitmap, Graphics::TBitmap* BitmapR
	, Graphics::TBitmap* BitmapG, Graphics::TBitmap* BitmapB, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* 
	Sender);
extern PACKAGE int __fastcall _GetSimilColor(const Hyiedefs::TRGB * ColorMap, const int ColorMap_Size
	, int nc, Hyiedefs::TRGB Col);
extern PACKAGE void __fastcall _RGB2BGR(Hyiedefs::TRGB * ColorMap, const int ColorMap_Size, int nc);
	
extern PACKAGE Graphics::TBitmap* __fastcall IECloneBitmap(Graphics::TBitmap* Source);
extern PACKAGE void __fastcall IECopyBitmap(Graphics::TBitmap* Source, Graphics::TBitmap* Dest);
extern PACKAGE unsigned __fastcall _CopyBitmaptoDIB(Graphics::TBitmap* fBitmap, int x1, int y1, int 
	x2, int y2);
extern PACKAGE void __fastcall _CopyBits(Windows::PByte Dest, Windows::PByte Source, int DestStart, 
	int SourceStart, int Len);
extern PACKAGE void __fastcall _CopyBitmapRect(Graphics::TBitmap* Source, Graphics::TBitmap* Dest, int 
	x1, int y1, int x2, int y2);
extern PACKAGE void __fastcall _Negative1Bit(Graphics::TBitmap* Bitmap);
extern PACKAGE void __fastcall _Negative(Graphics::TBitmap* bitmap, int fSelx1, int fSely1, int fSelx2
	, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* Sender);
extern PACKAGE bool __fastcall _BitmapCompareX(Graphics::TBitmap* Bitmap1, Graphics::TBitmap* Bitmap2
	);
extern PACKAGE void __fastcall _ClearSel(Graphics::TBitmap* fBitmap, Hyiedefs::PPointArray SelPoly, 
	int SelPolyCount, Graphics::TColor Background);
extern PACKAGE void __fastcall _CopyBitmapPoly(Graphics::TBitmap* Source, Graphics::TBitmap* Dest, int 
	sx1, int sy1, int sx2, int sy2, Hyiedefs::PPointArray SelPoly, int SelPolyCount);
extern PACKAGE void __fastcall _ConvertTo(Graphics::TBitmap* Bitmap, int NumColors, Hyiedefs::pRGBROW 
	OutPalette, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* Sender);
extern PACKAGE void __fastcall _ConvertToBWOrdered(Graphics::TBitmap* bitmap, Hyiedefs::TProgressRec 
	&Progress);
extern PACKAGE void __fastcall _ConvertToBWThreshold(Graphics::TBitmap* bitmap, int Threshold, Hyiedefs::TProgressRec 
	&Progress);
extern PACKAGE void __fastcall _QuickResample(Graphics::TBitmap* Src, Graphics::TBitmap* Dst, Hyiedefs::TResampleFilter 
	FilterType, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* Sender);
extern PACKAGE void __fastcall _Resample(Graphics::TBitmap* Src, Graphics::TBitmap* Dst, Hyiedefs::TResampleFilter 
	FilterType, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* Sender);
extern PACKAGE void __fastcall _Conv1to24(Graphics::TBitmap* &SrcBitmap, Graphics::TBitmap* &DstBitmap
	, Hyiedefs::TProgressRec &Progress);
extern PACKAGE void __fastcall _ConvertToGray(Graphics::TBitmap* bitmap, int fSelx1, int fSely1, int 
	fSelx2, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* Sender);
extern PACKAGE void __fastcall _BumpMapping(Graphics::TBitmap* Bitmap, int LightX, int LightY, int LAmpX
	, int LAmpY, int pcf, Hyiedefs::TRGB Color, int fselx1, int fsely1, int fselx2, int fsely2, Hyiedefs::TProgressRec 
	&Progress);
extern PACKAGE void __fastcall _lens(Graphics::TBitmap* Bitmap, int xx, int yy, int width, int height
	, double refraction, Hyiedefs::TProgressRec &Progress);
extern PACKAGE int __fastcall _GetPixelbw(Windows::PByte row, int pix);
extern PACKAGE void __fastcall _SetPixelbw(Windows::PByte row, int pix, int vv);
extern PACKAGE void __fastcall _rotate1bit(Graphics::TBitmap* fBitmap, double angle, int background, 
	Hyiedefs::TProgressRec &Progress);
extern PACKAGE void __fastcall _wave(Graphics::TBitmap* Bitmap, int amplitude, int wavelength, int phase
	, bool reflective, Hyiedefs::TProgressRec &Progress);
extern PACKAGE HPALETTE __fastcall _CreateWinPalette(Hyiedefs::TRGB * ColorMap, const int ColorMap_Size
	, int NCol);
extern PACKAGE void __fastcall YUV2RGB(int y, int u, int v, Hyiedefs::TRGB &RGB);
extern PACKAGE void __fastcall _CopyIYU1ToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE void __fastcall _CopyIYU2ToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE void __fastcall _CopyUYVYToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE void __fastcall _CopyYUY2ToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE void __fastcall _CopyYVYUToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE void __fastcall _CopyY41PToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE void __fastcall _CopyY211ToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE void __fastcall _CopyCLJRToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE void __fastcall _CopyYVU9ToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE void __fastcall _CopyYV12ToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE void __fastcall _CopyI420ToBitmap(Windows::PByte xbits, Graphics::TBitmap* fBitmap, bool 
	dirc);
extern PACKAGE int __fastcall _CopyDIB2Bitmap(unsigned hbi, Graphics::TBitmap* fBitmap, Windows::PByte 
	xbits, bool unlck);
extern PACKAGE void __fastcall _CopyPolygonToPoint(Graphics::TBitmap* Source, Hyiedefs::PPointArray 
	Polygon, int PolygonLen, Graphics::TBitmap* Dest, const Windows::TPoint &Position);
extern PACKAGE void __fastcall _CopyPointToPolygon(Graphics::TBitmap* Source, Hyiedefs::PPointArray 
	Polygon, int PolygonLen, Graphics::TBitmap* Dest, const Windows::TPoint &Position);
extern PACKAGE void __fastcall _CopyBGR_RGB(Hyiedefs::pRGB dst, Hyiedefs::pRGB src, int width);
extern PACKAGE void __fastcall _MorphFilter(Graphics::TBitmap* bitmap, int WindowSize, int op, int fSelx1
	, int fSely1, int fSelx2, int fSely2, Hyiedefs::TIEProgressEvent fOnProgress, System::TObject* Sender
	);
extern PACKAGE Hyiedefs::PPointArray __fastcall _MakeMagicWandPoints(Graphics::TBitmap* fBitmap, int 
	x, int y, bool maxfilter, int tolerance, int &pcount);
extern PACKAGE void __fastcall _IEBmpStretch(Graphics::TBitmap* origBmp, Graphics::TBitmap* destBmp)
	;
extern PACKAGE int __fastcall _ConvertXBitsToYBits(Byte * Input, Byte * Output, Word Xbits, Word Ybits
	, Word Width, const Hyiedefs::TRGB * Palette, const int Palette_Size, System::TObject* Quantizer);
extern PACKAGE void __fastcall _SubResample1bitFiltered(Graphics::TBitmap* src, int sx1, int sy1, int 
	sx2, int sy2, Graphics::TBitmap* dst);
extern PACKAGE Windows::PByte __fastcall _SubResample1bitFilteredDIB(Windows::PByte src, int sxx, int 
	syy, int sx1, int sy1, int sx2, int sy2, int dxx, int dyy);
extern PACKAGE void __fastcall _CopyPolygonBitmap(Graphics::TBitmap* Dest, Graphics::TBitmap* Source
	, int x1, int y1, Hyiedefs::PPointArray SelPoly, int SelPolyCount);

}	/* namespace Imageenproc */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Imageenproc;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ImageEnProc
