{$I dbpOptions.Inc}
unit DbpAdoSet;

interface

uses
  {SysUtils,} Classes, DbpSet, Db;

type
  TDPAdoFindIndex=class(TDPFindIndex)
  protected
    function InternalGetOptions:TIndexOptions; override;
    function GetIndexDefs:TIndexDefs; override;
    function  GetIndexName:String; override;
    function FindKey(const KeyValues:Variant):Boolean; override;
    procedure FindNearest(const KeyValues:Variant); override;
  end;

  TDPAdoFindPanel=class(TDBFindPanel)
  protected
    function CreateFindIndex:TDPFindIndex; override;
  end;

  TDPAdoFindDialog=class(TDBFindDialog)
  protected
    function CreatePanelFieldsSet:TPanelFieldsSet; override;
    function GetFieldsSetClass:TFieldsSetClass; override;
  end;

  procedure Register;

implementation

uses ADODB;

type
  TCustomADODataSetCrack=class(TCustomADODataSet)
  end;

  TAdoFindComponent=class(TDBFindComponent)
  protected
    function CreateFindIndex:TDPFindIndex; override;
  end;

procedure Register;
begin
  {$IFDEF V5_MORE}
     RegisterComponents('DP Addition', [TDPAdoFindPanel]);
     RegisterComponents('DP Addition', [TDPAdoFindDialog]);
  {$ENDIF}
end;

{ TDPAdoFindIndex }

function TDPAdoFindIndex.InternalGetOptions:TIndexOptions;
begin
  if IndexDef {GetIndexDefs}=nil then result:=[ixCaseInsensitive]
  else result:=inherited InternalGetOptions;
{  result:=[ixCaseInsensitive];}
end;


function TDPAdoFindIndex.GetIndexDefs:TIndexDefs;
begin
  if (DataSet is TCustomADODataSet) then
  begin
    if DataSet.Active and TCustomADODataSet(DataSet).Supports([coIndex]) then
       result:=TCustomADODataSetCrack(DataSet).IndexDefs
    else result:=nil;
  end
  else result:= inherited GetIndexDefs;
end;

function  TDPAdoFindIndex.GetIndexName:String;
begin
  if (DataSet is TCustomADODataSet) then
  begin
    if DataSet.Active and TCustomADODataSet(DataSet).Supports([coIndex]) then
       result:=TCustomADODataSetCrack(DataSet).IndexName
    else result:='';
  end
  else result:= inherited GetIndexName;
end;

function TDPAdoFindIndex.FindKey(const KeyValues:Variant):Boolean;
begin
  if DataSet is TCustomADODataSet then
  begin
    if {DataSet.Active and} TCustomADODataSet(DataSet).Supports([coSeek]) and
      ((GetIndexName<>'') or (GetIndexFieldNames<>'')) then
      result:=TCustomADODataSet(DataSet).Seek(KeyValues,soFirstEQ)
    else result:=inherited FindKey(KeyValues);
  end
  else result:=inherited FindKey(KeyValues);
end;

procedure TDPAdoFindIndex.FindNearest(const KeyValues:Variant);
begin
  if DataSet is TCustomADODataSet then
  begin
    if TCustomADODataSet(DataSet).Supports([coSeek]) and
      ((GetIndexName<>'') or (GetIndexFieldNames<>'')) then
      TCustomADODataSet(DataSet).Seek(KeyValues,soAfterEQ)
    else inherited FindNearest(KeyValues);
  end
  else inherited FindNearest(KeyValues);
end;

{ TDPAdoFindPanel }

function TDPAdoFindPanel.CreateFindIndex:TDPFindIndex;
begin
  result:=TDPAdoFindIndex.Create(Self);
end;

{ TAdoFindComponent }

function TAdoFindComponent.CreateFindIndex:TDPFindIndex;
begin
  result:=TDPAdoFindIndex.Create(Self);
end;

{ TDPAdoFindDialog }

function TDPAdoFindDialog.CreatePanelFieldsSet:TPanelFieldsSet;
begin
  result:=TAdoFindComponent.Create(Self);
end;

function TDPAdoFindDialog.GetFieldsSetClass:TFieldsSetClass;
begin
  result:=TDPAdoFindDialog;
end;

end.
