unit DemoMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TbPrint, ComCtrls, Tabnotbk, StdCtrls, Db, DBTables,
  TbPrintColumnarReport;

type
  TMain = class(TForm)
    TbPrinter: TTbPrinter;
    TbReport: TTbReport;
    Paginas: TTabbedNotebook;
    TbExcel: TTbExcel;
    ExcelExample: TTabbedNotebook;
    ConnectToExcel: TButton;
    DisconnectFromExcel: TButton;
    LState: TLabel;
    State: TLabel;
    SendPanel: TGroupBox;
    LExcelY: TLabel;
    LExcelX: TLabel;
    LTextToSend: TLabel;
    ExcelX: TEdit;
    ExcelY: TEdit;
    TextToSend: TEdit;
    SendToExcel: TButton;
    StartAutoExcel: TButton;
    Friends: TTable;
    StartReport: TButton;
    FriendsNAME: TStringField;
    FriendsADDRESS: TStringField;
    FriendsZIP: TStringField;
    FriendsCITY: TStringField;
    FriendsAGE: TSmallintField;
    FriendsBORNDATE: TDateField;
    TbReportNAME: TTbReportColumn;
    TbReportADDRESS: TTbReportColumn;
    TbReportCITY: TTbReportColumn;
    TbReportZIP: TTbReportColumn;
    TbReportBORNDATE: TTbReportColumn;
    TbReportAGE: TTbReportColumn;
    ReportPrintingMode: TComboBox;
    lReportPrintingMode: TLabel;
    lReportShowPreview: TLabel;
    ReportShowPreview: TComboBox;
    lPrinterPrintingMode: TLabel;
    PrintingMode: TComboBox;
    lPrinterShowPreview: TLabel;
    ShowPreview: TComboBox;
    FastMode: TGroupBox;
    lPrinterPrinterModel: TLabel;
    lPrinterPrinterPort: TLabel;
    Model: TComboBox;
    Port: TEdit;
    TbCustomReport: TTbCustomReport;
    lCustomPrintingMode: TLabel;
    CustomPrintingMode: TComboBox;
    lCustomShowPreview: TLabel;
    CustomShowPreview: TComboBox;
    StartCustomReport: TButton;
    lQueryPrintingMode: TLabel;
    lQueryShowPreview: TLabel;
    QueryStart: TButton;
    QueryPrintMode: TComboBox;
    QueryPrintPreview: TComboBox;
    Query: TQuery;
    TbQueryReport: TTbQueryReport;
    TbQueryCITY: TTbReportColumn;
    TbQueryNAME: TTbReportColumn;
    TbQueryAGE: TTbReportColumn;
    TbQueryBORNDATE: TTbReportColumn;
    TbQueryZIP: TTbReportColumn;
    TbQueryADDRESS: TTbReportColumn;
    QueryNAME: TStringField;
    QueryADDRESS: TStringField;
    QueryZIP: TStringField;
    QueryCITY: TStringField;
    QueryAGE: TSmallintField;
    QueryBORNDATE: TDateField;
    LWindowsFont: TLabel;
    Font: TComboBox;
    lColumnarPrintingMode: TLabel;
    lColumnarShowPreview: TLabel;
    StartColumnarReport: TButton;
    ColumnarPrintingMode: TComboBox;
    ColumnarShowPreview: TComboBox;
    TbColumnarReport: TTbColumnarReport;
    procedure ConnectToExcelClick(Sender: TObject);
    procedure ExcelXExit(Sender: TObject);
    procedure ExcelYExit(Sender: TObject);
    procedure SendToExcelClick(Sender: TObject);
    procedure DisconnectFromExcelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PaginasChange(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure ExcelExampleChange(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure StartAutoExcelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure StartReportClick(Sender: TObject);
    procedure ReportPrintingModeChange(Sender: TObject);
    procedure ReportShowPreviewChange(Sender: TObject);
    procedure PrintingModeChange(Sender: TObject);
    procedure ShowPreviewChange(Sender: TObject);
    procedure PortChange(Sender: TObject);
    procedure ModelChange(Sender: TObject);
    procedure CustomPrintingModeChange(Sender: TObject);
    procedure CustomShowPreviewChange(Sender: TObject);
    procedure StartCustomReportClick(Sender: TObject);
    procedure TbCustomReportGenerate;
    procedure QueryStartClick(Sender: TObject);
    procedure QueryPrintModeChange(Sender: TObject);
    procedure QueryPrintPreviewChange(Sender: TObject);
    procedure ColumnarPrintingModeChange(Sender: TObject);
    procedure ColumnarShowPreviewChange(Sender: TObject);
    procedure StartColumnarReportClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

{$R *.DFM}

procedure TMain.ConnectToExcelClick(Sender: TObject);
begin
  With TbExcel do
    begin
      if Connect then
        begin
          ConnectToExcel.Enabled := False;
          DisconnectFromExcel.Enabled := True;
          State.Caption := 'Connected';
          SendPanel.Enabled := True;
          StartExport;
        end;
    end;
end;

procedure TMain.DisconnectFromExcelClick(Sender: TObject);
begin
  With TbExcel do
    begin
      EndExport;
      Disconnect;
      ConnectToExcel.Enabled := True;
      DisconnectFromExcel.Enabled := False;
      State.Caption := 'Disconnected';
      SendPanel.Enabled := False;
    end;
end;

procedure TMain.ExcelXExit(Sender: TObject);
begin
  try
    StrToInt(ExcelX.Text);
  except
    MessageDlg('You must put a number here.',mtError,[mbOk],0);
    ExcelX.SetFocus;
  end;
end;

procedure TMain.ExcelYExit(Sender: TObject);
begin
  try
    StrToInt(ExcelY.Text);
  except
    MessageDlg('You must put a number here.',mtError,[mbOk],0);
    ExcelY.SetFocus;
  end;
end;

procedure TMain.SendToExcelClick(Sender: TObject);
begin
  TbExcel.SetStr(StrToInt(ExcelY.Text),StrToInt(ExcelX.Text),TextToSend.Text);
end;

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if State.Caption = 'Connected' then
    begin
      TbExcel.EndExport;
      TbExcel.Disconnect;
    end;
end;

procedure TMain.PaginasChange(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  if Paginas.ActivePage = 'TbExcel' then
    begin
      if State.Caption = 'Connected' then
        DisconnectFromExcelClick(self);
    end;
end;

procedure TMain.ExcelExampleChange(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  if (ExcelExample.ActivePage = 'Manual') and
     (State.Caption = 'Connected') then
    DisconnectFromExcelClick(self);
end;

procedure TMain.StartAutoExcelClick(Sender: TObject);
begin
  with TbExcel do
    begin
      if Connect then
        begin
          StartExport;
          SetStr(1,1,'First name');
          SetStr(2,1,'Last name');
          SetStr(3,1,'Tel/Fax');
          SetStr(1,2,'Horacio');
          SetStr(2,2,'Jamilis');
          SetStr(3,2,'+54+1+482-xxxx');
          EndExport;
          Disconnect;
        end;
    end;
end;

procedure TMain.FormCreate(Sender: TObject);
var
  DC : HDC;

  function EnumFontFamProc(var LogFont    : TLogFont;
                           var TextMetric : TTextMetric;
                               FontType   : Integer;
                               Data       : Pointer): Integer; StdCall;
  begin
    TMain(Data).Font.Items.Add(LogFont.lfFaceName);
    result := 1;
  end;

begin
  Friends.TableName := ExtractFilePath(ParamStr(0))+'FRIENDS.DBF';
  Query.SQL.Text := 'SELECT * FROM "'+ExtractFilePath(ParamStr(0))+'FRIENDS.DBF'+'"';
  ReportPrintingMode.ItemIndex := 0;
  ReportShowPreview.ItemIndex := 0;
  PrintingMode.ItemIndex := 0;
  ShowPreview.ItemIndex := 0;
  CustomPrintingMode.ItemIndex := 0;
  CustomShowPreview.ItemIndex := 0;
  QueryPrintMode.ItemIndex := 0;
  QueryPrintPreview.ItemIndex := 0;
  ColumnarPrintingMode.ItemIndex := 0;
  ColumnarShowPreview.ItemIndex := 0;
  TbPrinter.GetModels(Model.Items);
  Model.ItemIndex := 2;
 try
  Friends.Open;
 except
  MessageDlg('You could not use the TbReport because the table file is missing.',mtError,[mbOk],0);
 end;
  Font.Items.Clear;
  DC := GetDC(0);
  EnumFontFamilies(DC, nil, @EnumFontFamProc, LongInt(Pointer(self)));
  ReleaseDC(0, DC);
  Font.Text := TbPrinter.WinFont;
end;

procedure TMain.StartReportClick(Sender: TObject);
begin
  TbReport.Execute;
end;

procedure TMain.ReportPrintingModeChange(Sender: TObject);
begin
  case ReportPrintingMode.ItemIndex of
    1 : TbReport.ModoImpresion := rmFast;
    2 : TbReport.ModoImpresion := rmWindows;
    else
        TbReport.ModoImpresion := rmDefault;
  end;
end;

procedure TMain.ReportShowPreviewChange(Sender: TObject);
begin
  case ReportShowPreview.ItemIndex of
    1: TbReport.Preview := pYes;
    2: TbReport.Preview := pGrid;
    3: TbReport.Preview := pNo;
  else
       TbReport.Preview := pDefault;
  end;
end;


procedure TMain.PrintingModeChange(Sender: TObject);
begin
  case PrintingMode.ItemIndex of
    1 : TbPrinter.Mode := pmWindows;
    else
        TbPrinter.Mode := pmFast;
  end;
end;

procedure TMain.ShowPreviewChange(Sender: TObject);
begin
  case ShowPreview.ItemIndex of
    1 : TbPrinter.Preview := ppGrid;
    2 : TbPrinter.Preview := ppNo;
    else
        TbPrinter.Preview := ppYes;
  end;
end;

procedure TMain.PortChange(Sender: TObject);
begin
  TbPrinter.FastPort := Port.Text;
end;

procedure TMain.ModelChange(Sender: TObject);
begin
  TbPrinter.SetModelName(Model.Items[Model.ItemIndex]);
end;

procedure TMain.CustomPrintingModeChange(Sender: TObject);
begin
  case CustomPrintingMode.ItemIndex of
    1 : TbCustomReport.ModoImpresion := rmFast;
    2 : TbCustomReport.ModoImpresion := rmWindows;
    else
        TbCustomReport.ModoImpresion := rmDefault;
  end;
end;

procedure TMain.CustomShowPreviewChange(Sender: TObject);
begin
  case CustomShowPreview.ItemIndex of
    1: TbCustomReport.Preview := pYes;
    2: TbCustomReport.Preview := pNo;
  else
       TbCustomReport.Preview := pDefault;
  end;
end;

procedure TMain.StartCustomReportClick(Sender: TObject);
begin
  TbCustomReport.Execute;
end;

procedure TMain.TbCustomReportGenerate;
begin
  with TbCustomReport.Printer do
    begin
      StartDoc;
      Lines := 16;
      WriteStd(1,1,'Custom Printing Demostration.');
      WriteStd(1,2,'In this example I don''t assign a procedure to export to Excel');
      WriteStd(1,3,'so in the print preview form does not appear the Export to excel button.');
      Write(5,5,'You could change the font in the report!',[Bold]);
      Write(5,6,'Or you could write subscript.',[Underline]);
      Write(5,7,'Or may be italic???',[Italic]);
      Write(5,8,'Or a combination of this...',[Bold,Underline,Italic]);
      Write(10,10,'ANYWHERE',[Bold]);
      Write(12,11,'DOUBLE',[DobleWide,Bold,Italic]);
      Write(15,12,'COMPRESSED FONT TOO... AND THIS IS ALL!',[Compress]);
      WriteStd(5,14,'Accented characters: ');
    end;
end;



procedure TMain.QueryStartClick(Sender: TObject);
begin
  TbQueryReport.Execute;
end;

procedure TMain.QueryPrintModeChange(Sender: TObject);
begin
  case QueryPrintMode.ItemIndex of
    1 : TbQueryReport.PrintMode := rmFast;
    2 : TbQueryReport.PrintMode := rmWindows;
    else
        TbQueryReport.PrintMode := rmDefault;
  end;
end;

procedure TMain.QueryPrintPreviewChange(Sender: TObject);
begin
  case QueryPrintPreview.ItemIndex of
    1: TbQueryReport.Preview := pYes;
    2: TbQueryReport.Preview := pGrid;
    3: TbQueryReport.Preview := pNo;
  else
       TbQueryReport.Preview := pDefault;
  end;
end;


procedure TMain.ColumnarPrintingModeChange(Sender: TObject);
begin
  case ColumnarPrintingMode.ItemIndex of
    1 : TbColumnarReport.PrintMode := rmFast;
    2 : TbColumnarReport.PrintMode := rmWindows;
    else
        TbColumnarReport.PrintMode := rmDefault;
  end;
end;

procedure TMain.ColumnarShowPreviewChange(Sender: TObject);
begin
  case ColumnarShowPreview.ItemIndex of
    1: TbColumnarReport.Preview := pYes;
    2: TbColumnarReport.Preview := pGrid;
    3: TbColumnarReport.Preview := pNo;
  else
       TbColumnarReport.Preview := pDefault;
  end;
end;

procedure TMain.StartColumnarReportClick(Sender: TObject);
begin
  TbColumnarReport.Execute;
end;

end.
