// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'TbPrint.pas' rev: 4.00

#ifndef TbPrintHPP
#define TbPrintHPP

#pragma delphiheader begin
#pragma option push -w-
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Menus.hpp>	// Pascal unit
#include <Buttons.hpp>	// Pascal unit
#include <ComCtrls.hpp>	// Pascal unit
#include <Registry.hpp>	// Pascal unit
#include <DsgnIntf.hpp>	// Pascal unit
#include <Printers.hpp>	// Pascal unit
#include <ShellAPI.hpp>	// Pascal unit
#include <Consts.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <DdeMan.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <DBTables.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <CommDlg.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Tbprint
{
//-- type declarations -------------------------------------------------------
typedef TTable ReportTableType;
;

typedef TField ReportFieldType;
;

#pragma option push -b-
enum TStatus { OnLine, OffLine, PaperOut, TurnedOff, Unknown };
#pragma option pop

#pragma option push -b-
enum TPrinterModel { Cannon_F60, Cannon_Laser, Epson_FX, Epson_Stylus, HP_Deskjet, HP_Laserjet, HP_Thinkjet, 
	IBM_Color_Jet, IBM_PC_Graphics, IBM_Proprinter, NEC_3500, NEC_Pinwriter, Mp20Mi };
#pragma option pop

#pragma option push -b-
enum TPrinterMode { pmFast, pmWindows };
#pragma option pop

#pragma option push -b-
enum TLineType { ltSingle, ltDouble };
#pragma option pop

#pragma option push -b-
enum TFontType { Bold, Italic, Underline, Compress, DobleWide };
#pragma option pop

typedef Set<TFontType, Bold, DobleWide>  TFastFont;

#pragma option push -b-
enum TTbAlign { alLeft, alCenter, alRight };
#pragma option pop

struct TPage;
typedef TPage *PPage;

#pragma pack(push, 4)
struct TPage
{
	Classes::TList* Writed;
	Classes::TList* VerticalLines;
	Classes::TList* HorizLines;
	Byte PrintedLines;
	Classes::TList* Graphics;
} ;
#pragma pack(pop)

struct TGraphic;
typedef TGraphic *PGraphic;

#pragma pack(push, 4)
struct TGraphic
{
	float X;
	float Y;
	Graphics::TPicture* Picture;
} ;
#pragma pack(pop)

struct TWrite;
typedef TWrite *PWrite;

#pragma pack(push, 4)
struct TWrite
{
	Byte X;
	Byte Y;
	TFastFont FastFont;
	AnsiString Text;
} ;
#pragma pack(pop)

struct THorizLine;
typedef THorizLine *PHorizLine;

#pragma pack(push, 1)
struct THorizLine
{
	Byte X1;
	Byte X2;
	Byte Y;
	TLineType Kind;
} ;
#pragma pack(pop)

struct TVertLine;
typedef TVertLine *PVertLine;

#pragma pack(push, 1)
struct TVertLine
{
	Byte X;
	Byte Y1;
	Byte Y2;
	TLineType Kind;
} ;
#pragma pack(pop)

class DELPHICLASS EPrinterError;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION EPrinterError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EPrinterError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EPrinterError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EPrinterError(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EPrinterError(int Ident, const System::TVarRec * Args
		, const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EPrinterError(const AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EPrinterError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EPrinterError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EPrinterError(int Ident, const System::TVarRec * 
		Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EPrinterError(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS EReportError;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION EReportError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EReportError(const AnsiString Msg) : Sysutils::Exception(Msg
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EReportError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EReportError(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EReportError(int Ident, const System::TVarRec * Args
		, const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EReportError(const AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EReportError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EReportError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EReportError(int Ident, const System::TVarRec * 
		Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EReportError(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TTbAboutBoxProperty;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbAboutBoxProperty : public Dsgnintf::TPropertyEditor 
{
	typedef Dsgnintf::TPropertyEditor inherited;
	
public:
	virtual void __fastcall Edit(void);
	virtual Dsgnintf::TPropertyAttributes __fastcall GetAttributes(void);
	virtual AnsiString __fastcall GetValue();
protected:
	#pragma option push -w-inl
	/* TPropertyEditor.Create */ inline __fastcall TTbAboutBoxProperty(const Dsgnintf::_di_IFormDesigner 
		ADesigner, int APropCount) : Dsgnintf::TPropertyEditor(ADesigner, APropCount) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TPropertyEditor.Destroy */ inline __fastcall virtual ~TTbAboutBoxProperty(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TInitialZoom { zReal, zWidth, zHeight };
#pragma option pop

#pragma option push -b-
enum TPageSize { pzDefault, pzContinuous, pzLetter, pzLegal, pzA4, pzLetterSmall, pzTabloid, pzLedger, 
	pzStatement, pzExecutive, pzA3, pzA4small, pzA5, pzB4, pzB5, pzFolio, pzQuarto, pz10x14, pz11x17, pzNote, 
	pzEnv9, pzEnv10, pzEnv11, pzEnv12, pzEnv14, pzEnvDl, pzEnvC5, pzEnvC3, pzEnvC4, pzEnvC6, pzEnvC65, 
	pzEnvB4, pzEnvB5, pzEnvB6, pzEnvItaly, pzEnvMonarch, pzEnvPersonal, pzFanfoldUS, pzFanfoldStd, pzFanfoldLgl 
	};
#pragma option pop

struct TTbPrn;
typedef TTbPrn *PTbPrn;

#pragma pack(push, 4)
struct TTbPrn
{
	AnsiString Name;
	AnsiString FastModel;
	AnsiString WinModel;
	AnsiString FastPort;
	int WinTopMargin;
	int WinBottomMargin;
	TPrinterMode DefaultMode;
} ;
#pragma pack(pop)

#pragma option push -b-
enum TTbSaveMode { smNoSave, smFile, smRegistry };
#pragma option pop

class DELPHICLASS TTbPrintersComponentEditor;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbPrintersComponentEditor : public Dsgnintf::TComponentEditor 
{
	typedef Dsgnintf::TComponentEditor inherited;
	
public:
	virtual void __fastcall Edit(void);
public:
	#pragma option push -w-inl
	/* TComponentEditor.Create */ inline __fastcall virtual TTbPrintersComponentEditor(Classes::TComponent* 
		AComponent, Dsgnintf::_di_IFormDesigner ADesigner) : Dsgnintf::TComponentEditor(AComponent, ADesigner
		) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TTbPrintersComponentEditor(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TTbPrinters;
class DELPHICLASS TTbPrinter;
#pragma option push -b-
enum TTbPrinterPreview { ppGrid, ppYes, ppNo };
#pragma option pop

class DELPHICLASS TTbPrintTray;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbPrintTray : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TTbPrinter* TbPrinter;
	Menus::TPopupMenu* FPopupMenuL;
	Graphics::TIcon* FIcon;
	AnsiString FTip;
	HWND FWnd;
	void __fastcall DoPopup(int i);
	void __fastcall TBChange(void);
	void __fastcall SetTip(AnsiString s);
	void __fastcall PauseClick(System::TObject* Sender);
	void __fastcall CancelClick(System::TObject* Sender);
	void __fastcall CancelAllClick(System::TObject* Sender);
	
protected:
	void __fastcall WndProc(Messages::TMessage &Msg);
	virtual void __fastcall DoOnLeftClick(void);
	
public:
	__fastcall virtual TTbPrintTray(Classes::TComponent* AOwner);
	__fastcall virtual ~TTbPrintTray(void);
	
__published:
	__property AnsiString Tip = {read=FTip, write=SetTip};
};

#pragma pack(pop)

class DELPHICLASS TPrintThread;
struct TPrintJob;
typedef TPrintJob *PPrintJob;

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPrintThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
private:
	TPrintJob *Job;
	int Answer;
	AnsiString Text;
	void __fastcall SetJobName(void);
	void __fastcall Ask(void);
	
protected:
	virtual void __fastcall Execute(void);
	bool __fastcall PrintFast(int Number);
	
public:
	TTbPrinter* TbPrinter;
	Classes::TThreadList* Jobs;
public:
	#pragma option push -w-inl
	/* TThread.Create */ inline __fastcall TPrintThread(bool CreateSuspended) : Classes::TThread(CreateSuspended
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TThread.Destroy */ inline __fastcall virtual ~TPrintThread(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TTbPrintGrid;
typedef void __fastcall (__closure *TTbBuildGridProcedure)(TTbPrintGrid* Grid);

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbPrinter : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Forms::TForm* FOwner;
	Classes::TNotifyEvent fOnPrinterError;
	AnsiString FDatosEmpresa;
	TPrinterModel FModelo;
	AnsiString FFastPuerto;
	Byte FLineas;
	Byte FColumnas;
	TFastFont FFuente;
	TPrinterMode FModo;
	Classes::TList* LasPaginas;
	int FCopias;
	int FWinSupMargin;
	int FWinBotMargin;
	AnsiString PRNNormal;
	AnsiString PRNBold;
	AnsiString PRNWide;
	AnsiString PRNItalics;
	AnsiString PRNULineON;
	AnsiString PRNULineOFF;
	AnsiString PRNCompON;
	AnsiString PRNCompOFF;
	AnsiString PRNSetup;
	AnsiString PRNReset;
	AnsiString PRNSelLength;
	TTbPrinterPreview FPreview;
	TInitialZoom FZoom;
	AnsiString FTitulo;
	Forms::TForm* PreviewForm;
	AnsiString FWinPrinter;
	AnsiString FWinPort;
	bool FTransliterate;
	TTbAboutBoxProperty* FAbout;
	AnsiString FWinFont;
	TTbPrinters* FPrinters;
	int FPrinterActive;
	void __fastcall (__closure *OldCloseQuery)(System::TObject* Sender, bool &CanClose);
	TTbPrintTray* TrayIcon;
	TPrintThread* PrintThread;
	TPageSize FPageSize;
	Byte FPageLength;
	Byte FContinuousJump;
	bool Cancelado;
	void __fastcall FormCloseQuery(System::TObject* Sender, bool &CanClose);
	AnsiString __fastcall GetModelRealName(TPrinterModel Model);
	void __fastcall SetModel(TPrinterModel Name);
	void __fastcall SetFastPuerto(AnsiString Puerto);
	Byte __fastcall GetPaginas(void);
	void __fastcall Clear(void);
	void __fastcall SetPrinters(TTbPrinters* P);
	void __fastcall SetPrinterActive(AnsiString PA);
	AnsiString __fastcall GetPrinterActive();
	void __fastcall SetPrinterIndex(int PI);
	void __fastcall PrintThreadTerminate(System::TObject* Sender);
	void __fastcall BtnCancelarClick(System::TObject* Sender);
	
protected:
	virtual void __fastcall Loaded(void);
	
public:
	Forms::TForm* GridFrm;
	Classes::TStringList* Fonts;
	Byte PaginaActual;
	int PageWidth;
	int PageHeight;
	double PageWidthP;
	double PageHeightP;
	Printers::TPrinterOrientation PageOrientation;
	void __fastcall (__closure *ReGenerate)(void);
	void __fastcall (__closure *SendToExcel)(void);
	TTbBuildGridProcedure BuildGrid;
	bool CurrentlyPrinting;
	void __fastcall PreviewGrid(void);
	void __fastcall PreviewReal(void);
	void __fastcall CancelAllPrinting(void);
	void __fastcall PausePrinting(void);
	void __fastcall RestorePrinting(void);
	void __fastcall CancelPrinting(void);
	__fastcall virtual TTbPrinter(Classes::TComponent* AOwner);
	__fastcall virtual ~TTbPrinter(void);
	void __fastcall StartDoc(void);
	void __fastcall EndDoc(void);
	void __fastcall WriteStd(Byte X, Byte Y, AnsiString Text);
	void __fastcall Write(Byte X, Byte Y, AnsiString Text, TFastFont Font);
	void __fastcall DrawMetafile(float X, float Y, Graphics::TMetafile* Picture);
	void __fastcall Box(Byte X1, Byte Y1, Byte X2, Byte Y2, TLineType Kind);
	void __fastcall HorizLine(Byte X1, Byte X2, Byte Y, TLineType Kind);
	void __fastcall VerticalLine(Byte X, Byte Y1, Byte Y2, TLineType Kind);
	void __fastcall Print(void);
	void __fastcall NewPage(void);
	void __fastcall SetModelName(AnsiString Name);
	void __fastcall GetModels(Classes::TStrings* Models);
	AnsiString __fastcall GetModelName();
	void __fastcall BuildPage(int Number, Graphics::TMetafile* Page, bool ToPrint, TPrinterMode Mode, bool 
		ShowDialog);
	__property Byte Lines = {read=FLineas, write=FLineas, default=66};
	bool __fastcall PrintPage(int Number);
	void __fastcall PrintAll(void);
	int __fastcall GetPrintingWidth(void);
	int __fastcall GetPrintingHeight(void);
	__property AnsiString WinPrinter = {read=FWinPrinter, write=FWinPrinter};
	__property AnsiString WinPort = {read=FWinPort, write=FWinPort};
	__property int PrinterIndex = {read=FPrinterActive, write=SetPrinterIndex, nodefault};
	
__published:
	__property Byte PageContinuousJump = {read=FContinuousJump, write=FContinuousJump, default=5};
	__property TPageSize PageSize = {read=FPageSize, write=FPageSize, nodefault};
	__property Byte PageLength = {read=FPageLength, write=FPageLength, nodefault};
	__property AnsiString PrinterActive = {read=GetPrinterActive, write=SetPrinterActive};
	__property TTbPrinters* Printers = {read=FPrinters, write=SetPrinters};
	__property TPrinterModel FastPrinter = {read=FModelo, write=SetModel, nodefault};
	__property TFastFont FastFont = {read=FFuente, write=FFuente, nodefault};
	__property AnsiString FastPort = {read=FFastPuerto, write=SetFastPuerto};
	__property TPrinterMode Mode = {read=FModo, write=FModo, default=0};
	__property Byte Columnas = {read=FColumnas, default=80};
	__property Byte Paginas = {read=GetPaginas, default=0};
	__property AnsiString CompanyData = {read=FDatosEmpresa, write=FDatosEmpresa};
	__property TInitialZoom Zoom = {read=FZoom, write=FZoom, default=1};
	__property TTbPrinterPreview Preview = {read=FPreview, write=FPreview, nodefault};
	__property AnsiString Title = {read=FTitulo, write=FTitulo};
	__property int Copies = {read=FCopias, write=FCopias, default=1};
	__property Classes::TNotifyEvent OnPrinterError = {read=fOnPrinterError, write=fOnPrinterError};
	__property int PrintingWidth = {read=GetPrintingWidth, nodefault};
	__property int PrintingHeight = {read=GetPrintingHeight, nodefault};
	__property bool Transliterate = {read=FTransliterate, write=FTransliterate, default=1};
	__property int WinMarginTop = {read=FWinSupMargin, write=FWinSupMargin, default=0};
	__property int WinMarginBottom = {read=FWinBotMargin, write=FWinBotMargin, default=0};
	__property AnsiString WinFont = {read=FWinFont, write=FWinFont};
	__property TTbAboutBoxProperty* About = {read=FAbout, write=FAbout};
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbPrinters : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Classes::TList* FPrinterList;
	TTbSaveMode FSaveMode;
	AnsiString FSaveTo;
	TTbAboutBoxProperty* FAbout;
	Stdctrls::TListBox* List;
	void __fastcall Save(void);
	void __fastcall Load(void);
	void __fastcall Clear(void);
	void __fastcall AddClick(System::TObject* Sender);
	void __fastcall EditClick(System::TObject* Sender);
	void __fastcall DelClick(System::TObject* Sender);
	int __fastcall GetPrinterCount(void);
	
public:
	TTbPrinter* TbPrinter;
	__fastcall virtual TTbPrinters(Classes::TComponent* AOwner);
	__fastcall virtual ~TTbPrinters(void);
	virtual void __fastcall Loaded(void);
	void __fastcall Config(void);
	void __fastcall ConfigPrinter(int Number);
	void __fastcall AddPrinter(PTbPrn Prn);
	PTbPrn __fastcall PrinterByName(AnsiString Name);
	void __fastcall DelPrinter(int Num);
	PTbPrn __fastcall GetPrinter(int Num);
	__property Classes::TList* Printers = {read=FPrinterList};
	__property int Count = {read=GetPrinterCount, nodefault};
	
__published:
	__property TTbSaveMode SaveMode = {read=FSaveMode, write=FSaveMode, nodefault};
	__property AnsiString SaveTo = {read=FSaveTo, write=FSaveTo};
	__property TTbAboutBoxProperty* About = {read=FAbout, write=FAbout};
};

#pragma pack(pop)

#pragma pack(push, 4)
struct TPrintJob
{
	AnsiString Name;
	TPageSize PageSize;
	Byte PageLength;
	Classes::TList* LasPaginas;
	int FCopias;
	TFastFont FFuente;
	AnsiString FPort;
	int FLineas;
	bool FTransliterate;
	AnsiString PRNNormal;
	AnsiString PRNBold;
	AnsiString PRNWide;
	AnsiString PRNItalics;
	AnsiString PRNULineON;
	AnsiString PRNULineOFF;
	AnsiString PRNCompON;
	AnsiString PRNCompOFF;
	AnsiString PRNSetup;
	AnsiString PRNReset;
	AnsiString PRNSelLength;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbPrintGrid : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Forms::TForm* FGridForm;
	AnsiString __fastcall GetCells(int ACol, int ARow);
	void __fastcall SetCells(int ACol, int ARow, const AnsiString Value);
	int __fastcall GetFixedCols(void);
	void __fastcall SetFixedCols(int Cols);
	int __fastcall GetFixedRows(void);
	void __fastcall SetFixedRows(int Rows);
	int __fastcall GetColCount(void);
	void __fastcall SetColCount(int Count);
	int __fastcall GetRowCount(void);
	void __fastcall SetRowCount(int Count);
	int __fastcall GetColWidths(int Index);
	void __fastcall SetColWidths(int Index, int Width);
	Graphics::TColor __fastcall GetRowColor(int Index);
	void __fastcall SetRowColor(int Index, Graphics::TColor Color);
	bool __fastcall GetEnabled(void);
	void __fastcall SetEnabled(bool Enabled);
	AnsiString __fastcall GetTitle();
	void __fastcall SetTitle(AnsiString Title);
	Forms::TForm* __fastcall GetGridForm(void);
	void __fastcall SetGridForm(Forms::TForm* GridForm);
	
public:
	__property AnsiString Cells[int Col][int Row] = {read=GetCells, write=SetCells};
	__property int FixedCols = {read=GetFixedCols, write=SetFixedCols, default=1};
	__property int FixedRows = {read=GetFixedRows, write=SetFixedRows, default=1};
	__property int ColCount = {read=GetColCount, write=SetColCount, default=5};
	__property int RowCount = {read=GetRowCount, write=SetRowCount, default=5};
	__property int ColWidths[int Index] = {read=GetColWidths, write=SetColWidths};
	__property Graphics::TColor RowColor[int Index] = {read=GetRowColor, write=SetRowColor};
	__property bool Enabled = {read=GetEnabled, write=SetEnabled, nodefault};
	__property AnsiString Title = {read=GetTitle, write=SetTitle};
	__property Forms::TForm* GridForm = {read=GetGridForm, write=SetGridForm};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TTbPrintGrid(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TTbPrintGrid(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

typedef void __fastcall (__closure *TTbEndQueryEvent)(bool &EndReport);

#pragma option push -b-
enum TTbPreviewType { pGrid, pYes, pNo, pDefault };
#pragma option pop

#pragma option push -b-
enum TTbPrinterMode { rmFast, rmWindows, rmDefault };
#pragma option pop

typedef void __fastcall (__closure *TTbProcedure)(void);

class DELPHICLASS TTbCustomReport;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbCustomReport : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TTbPrinter* FPrinter;
	TTbPrinterMode FModo;
	TTbPreviewType FPreview;
	TTbProcedure FOnGenerate;
	TTbBuildGridProcedure FOnBuildGrid;
	TTbProcedure FOnSendToExcel;
	TTbAboutBoxProperty* FAbout;
	AnsiString FTitle;
	TPageSize FPageSize;
	Byte FPageLength;
	void __fastcall BtnCancelarClick(System::TObject* Sender);
	
public:
	bool Cancelado;
	__fastcall virtual TTbCustomReport(Classes::TComponent* AOwner);
	void __fastcall Execute(void);
	
__published:
	__property TPageSize PageSize = {read=FPageSize, write=FPageSize, nodefault};
	__property Byte PageLength = {read=FPageLength, write=FPageLength, default=0};
	__property AnsiString Title = {read=FTitle, write=FTitle};
	__property TTbPrinter* Printer = {read=FPrinter, write=FPrinter};
	__property TTbPrinterMode ModoImpresion = {read=FModo, write=FModo, default=2};
	__property TTbPreviewType Preview = {read=FPreview, write=FPreview, default=3};
	__property TTbProcedure OnGenerate = {read=FOnGenerate, write=FOnGenerate};
	__property TTbBuildGridProcedure OnBuildGrid = {read=FOnBuildGrid, write=FOnBuildGrid};
	__property TTbProcedure OnSendToExcel = {read=FOnSendToExcel, write=FOnSendToExcel};
	__property TTbAboutBoxProperty* About = {read=FAbout, write=FAbout};
public:
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TTbCustomReport(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TTbBaseReport;
class DELPHICLASS TTbReportColumn;
class DELPHICLASS TTbReportGroup;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbBaseReport : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Byte FPageLength;
	TPageSize FPageSize;
	virtual void __fastcall Clear(void);
	virtual int __fastcall ColumnAdd(TTbReportColumn* Columna);
	virtual void __fastcall ColumnChangeIndex(int Ind1, int Ind2);
	virtual void __fastcall ColumnDel(TTbReportColumn* Columna);
	virtual int __fastcall GroupAdd(TTbReportGroup* Grupo);
	virtual void __fastcall GroupChangeIndex(int Ind1, int Ind2);
	virtual void __fastcall GroupDel(TTbReportGroup* Grupo);
	virtual void __fastcall Execute(void);
	virtual void __fastcall ExportToExcel(void);
	virtual void __fastcall Generate(void);
	virtual void __fastcall BuildGrid(TTbPrintGrid* Grid);
	
__published:
	__property TPageSize PageSize = {read=FPageSize, write=FPageSize, nodefault};
	__property Byte PageLength = {read=FPageLength, write=FPageLength, nodefault};
public:
	#pragma option push -w-inl
	/* TComponent.Create */ inline __fastcall virtual TTbBaseReport(Classes::TComponent* AOwner) : Classes::TComponent(
		AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TTbBaseReport(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TTbQueryReport;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbQueryReport : public TTbBaseReport 
{
	typedef TTbBaseReport inherited;
	
private:
	TTbPrinter* FPrinter;
	Db::TDataSet* FQuery;
	TTbPrinterMode FModo;
	bool NumeraPaginas;
	bool FechaYHora;
	Byte SeparacionColumnas;
	TFastFont FFuente;
	AnsiString FTitulo;
	AnsiString FSubTitulo;
	AnsiString PiePagina;
	Byte LineaTitulo;
	Byte LineaSubTitulo;
	Byte LineaPiePagina;
	Byte FLineas;
	Byte IMargen;
	Byte DMargen;
	Classes::TList* Columnas;
	Byte ColumnaTitulo;
	Byte ColumnaSubTitulo;
	Byte ColumnaPiePagina;
	TTbPreviewType FPreview;
	TTbAboutBoxProperty* FAbout;
	bool Cancelado;
	Stdctrls::TButton* BtnCancelar;
	void __fastcall BtnCancelarClick(System::TObject* Sender);
	
public:
	__fastcall virtual TTbQueryReport(Classes::TComponent* AOwner);
	__fastcall virtual ~TTbQueryReport(void);
	virtual void __fastcall Clear(void);
	virtual int __fastcall ColumnAdd(TTbReportColumn* Columna);
	virtual void __fastcall ColumnChangeIndex(int Ind1, int Ind2);
	virtual void __fastcall ColumnDel(TTbReportColumn* Columna);
	virtual void __fastcall Execute(void);
	virtual void __fastcall ExportToExcel(void);
	virtual void __fastcall Generate(void);
	virtual void __fastcall BuildGrid(TTbPrintGrid* Grid);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
__published:
	__property TTbPrinter* Printer = {read=FPrinter, write=FPrinter};
	__property Db::TDataSet* Query = {read=FQuery, write=FQuery};
	__property bool PrintPgNumber = {read=NumeraPaginas, write=NumeraPaginas, default=1};
	__property bool PrintDateTime = {read=FechaYHora, write=FechaYHora, default=1};
	__property Byte ColumnSeparation = {read=SeparacionColumnas, write=SeparacionColumnas, default=1};
	__property AnsiString Title = {read=FTitulo, write=FTitulo};
	__property Byte TitleLine = {read=LineaTitulo, write=LineaTitulo, default=4};
	__property AnsiString SubTitle = {read=FSubTitulo, write=FSubTitulo};
	__property Byte SubTitleLine = {read=LineaSubTitulo, write=LineaSubTitulo, default=6};
	__property AnsiString FutPage = {read=PiePagina, write=PiePagina};
	__property Byte FutPageLine = {read=LineaPiePagina, write=LineaPiePagina, default=66};
	__property TFastFont FastFont = {read=FFuente, write=FFuente, nodefault};
	__property TTbPreviewType Preview = {read=FPreview, write=FPreview, default=3};
	__property TTbPrinterMode PrintMode = {read=FModo, write=FModo, default=2};
	__property TTbAboutBoxProperty* About = {read=FAbout, write=FAbout};
};

#pragma pack(pop)

class DELPHICLASS TTbReport;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbReport : public TTbBaseReport 
{
	typedef TTbBaseReport inherited;
	
private:
	TTbPrinter* FPrinter;
	Dbtables::TTable* FTabla;
	Byte FLineas;
	TTbPrinterMode FModo;
	Byte IMargen;
	Byte DMargen;
	Classes::TList* Columnas;
	Classes::TList* Grupos;
	bool NumeraPaginas;
	bool FechaYHora;
	Byte SeparacionColumnas;
	TFastFont FFuente;
	AnsiString FTitulo;
	AnsiString FSubTitulo;
	AnsiString PiePagina;
	Byte LineaTitulo;
	Byte LineaSubTitulo;
	Byte LineaPiePagina;
	Byte ColumnaTitulo;
	Byte ColumnaSubTitulo;
	Byte ColumnaPiePagina;
	AnsiString FFiltro;
	AnsiString FIndice;
	TTbPreviewType FPreview;
	bool FAutoFirst;
	TTbEndQueryEvent FOnEndQuery;
	TTbAboutBoxProperty* FAbout;
	bool Cancelado;
	Stdctrls::TButton* BtnCancelar;
	void __fastcall BtnCancelarClick(System::TObject* Sender);
	TTbEndQueryEvent __fastcall GetEndQueryEvent();
	void __fastcall SetEndQueryEvent(TTbEndQueryEvent AEndQueryEvent);
	
public:
	__fastcall virtual TTbReport(Classes::TComponent* AOwner);
	__fastcall virtual ~TTbReport(void);
	virtual void __fastcall Clear(void);
	virtual int __fastcall ColumnAdd(TTbReportColumn* Columna);
	virtual void __fastcall ColumnChangeIndex(int Ind1, int Ind2);
	virtual void __fastcall ColumnDel(TTbReportColumn* Columna);
	virtual int __fastcall GroupAdd(TTbReportGroup* Grupo);
	virtual void __fastcall GroupChangeIndex(int Ind1, int Ind2);
	virtual void __fastcall GroupDel(TTbReportGroup* Grupo);
	virtual void __fastcall Execute(void);
	virtual void __fastcall ExportToExcel(void);
	virtual void __fastcall Generate(void);
	virtual void __fastcall BuildGrid(TTbPrintGrid* Grid);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
__published:
	__property TTbPrinter* Printer = {read=FPrinter, write=FPrinter};
	__property Dbtables::TTable* Tabla = {read=FTabla, write=FTabla};
	__property AnsiString TablaFiltro = {read=FFiltro, write=FFiltro};
	__property AnsiString TablaIndice = {read=FIndice, write=FIndice};
	__property Byte Lineas = {read=FLineas, write=FLineas, default=66};
	__property Byte MargenDerecho = {read=DMargen, write=DMargen, default=80};
	__property Byte MargenIzquierdo = {read=IMargen, write=IMargen, default=1};
	__property bool NumerarPaginas = {read=NumeraPaginas, write=NumeraPaginas, default=1};
	__property bool EscribirFechaHora = {read=FechaYHora, write=FechaYHora, default=1};
	__property Byte SeparacionDeColumnas = {read=SeparacionColumnas, write=SeparacionColumnas, default=1
		};
	__property AnsiString Titulo = {read=FTitulo, write=FTitulo};
	__property Byte LineaDeTitulo = {read=LineaTitulo, write=LineaTitulo, default=4};
	__property AnsiString SubTitulo = {read=FSubTitulo, write=FSubTitulo};
	__property Byte LineaDeSubTitulo = {read=LineaSubTitulo, write=LineaSubTitulo, default=6};
	__property Byte LineaDePieDePagina = {read=LineaPiePagina, write=LineaPiePagina, default=66};
	__property Byte ColumnaDeTitulo = {read=ColumnaTitulo, write=ColumnaTitulo, default=0};
	__property Byte ColumnaDeSubTitulo = {read=ColumnaSubTitulo, write=ColumnaSubTitulo, default=0};
	__property Byte ColumnaDePieDePagina = {read=ColumnaPiePagina, write=ColumnaPiePagina, default=0};
	__property AnsiString PieDePagina = {read=PiePagina, write=PiePagina};
	__property TFastFont Fuente = {read=FFuente, write=FFuente, nodefault};
	__property TTbPreviewType Preview = {read=FPreview, write=FPreview, default=3};
	__property bool TablaAutoFirst = {read=FAutoFirst, write=FAutoFirst, default=1};
	__property TTbPrinterMode ModoImpresion = {read=FModo, write=FModo, default=2};
	__property TTbEndQueryEvent OnEndQuery = {read=GetEndQueryEvent, write=SetEndQueryEvent};
	__property TTbAboutBoxProperty* About = {read=FAbout, write=FAbout};
};

#pragma pack(pop)

typedef void __fastcall (__closure *TTbGetTextEvent)(AnsiString &Text);

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbReportColumn : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	int FIndice;
	TTbAlign FAlineacion;
	TTbBaseReport* FReporte;
	AnsiString FTitulo;
	Byte FAncho;
	double AcumuladorColumna;
	bool FSumaColumna;
	Db::TField* FField;
	TTbGetTextEvent FOnGetText;
	Byte PosicionIzquierda;
	AnsiString FFormato;
	TTbAboutBoxProperty* FAbout;
	bool HayDecimales;
	void __fastcall SetReporte(TTbBaseReport* Rep);
	void __fastcall SetIndice(int Ind);
	int __fastcall GetIndice(void);
	void __fastcall SetField(Db::TField* F);
	TTbGetTextEvent __fastcall GetTextEvent();
	void __fastcall SetTextEvent(TTbGetTextEvent AGetTextEvent);
	
public:
	__fastcall virtual TTbReportColumn(Classes::TComponent* AOwner);
	__fastcall virtual ~TTbReportColumn(void);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
__published:
	__property int Indice = {read=GetIndice, write=SetIndice, nodefault};
	__property TTbBaseReport* Reporte = {read=FReporte, write=SetReporte};
	__property AnsiString Titulo = {read=FTitulo, write=FTitulo};
	__property Byte Ancho = {read=FAncho, write=FAncho, nodefault};
	__property bool SumaColumna = {read=FSumaColumna, write=FSumaColumna, default=0};
	__property Db::TField* DataField = {read=FField, write=SetField};
	__property AnsiString Formato = {read=FFormato, write=FFormato};
	__property TTbGetTextEvent OnGetText = {read=GetTextEvent, write=SetTextEvent};
	__property TTbAboutBoxProperty* About = {read=FAbout, write=FAbout};
	__property TTbAlign Alignment = {read=FAlineacion, write=FAlineacion, default=0};
};

#pragma pack(pop)

typedef void __fastcall (__closure *TTbEndGroupEvent)(bool &EndGroup);

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbReportGroup : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	int FIndice;
	TTbReport* FReporte;
	double AcumuladorGrupo;
	Db::TField* ClaveAgrupacion;
	AnsiString Encabezado;
	double TotalGrupo;
	bool FTotalizaGrupo;
	AnsiString FTotalFormato;
	bool SaltaHoja;
	Variant ClaveAnterior;
	Variant ClaveActual;
	TTbEndGroupEvent FOnEndGroup;
	AnsiString FTitulo;
	TTbAboutBoxProperty* FAbout;
	void __fastcall SetReporte(TTbReport* Rep);
	void __fastcall SetIndice(int Ind);
	TTbEndGroupEvent __fastcall GetEndGroupEvent();
	void __fastcall SetEndGroupEvent(TTbEndGroupEvent AEndGroupEvent);
	
public:
	__fastcall virtual TTbReportGroup(Classes::TComponent* AOwner);
	__fastcall virtual ~TTbReportGroup(void);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
__published:
	__property int Indice = {read=FIndice, write=SetIndice, nodefault};
	__property TTbReport* Reporte = {read=FReporte, write=SetReporte};
	__property bool SaltaDeHoja = {read=SaltaHoja, write=SaltaHoja, default=0};
	__property AnsiString TextoEncabezado = {read=Encabezado, write=Encabezado};
	__property Db::TField* CampoClaveDeAgrupacion = {read=ClaveAgrupacion, write=ClaveAgrupacion};
	__property bool Totaliza = {read=FTotalizaGrupo, write=FTotalizaGrupo, default=0};
	__property AnsiString FormatoTotal = {read=FTotalFormato, write=FTotalFormato};
	__property AnsiString Titulo = {read=FTitulo, write=FTitulo};
	__property TTbEndGroupEvent OnEndGroupQuery = {read=GetEndGroupEvent, write=SetEndGroupEvent};
	__property TTbAboutBoxProperty* About = {read=FAbout, write=FAbout};
};

#pragma pack(pop)

class DELPHICLASS TTbExcel;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TTbExcel : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	OleVariant FExcel;
	OleVariant FWorksheet;
	Windows::TRect Selection;
	TTbAboutBoxProperty* FAbout;
	
public:
	bool Conectado;
	__fastcall virtual TTbExcel(Classes::TComponent* AOwner);
	__fastcall virtual ~TTbExcel(void);
	bool __fastcall Connect(void);
	void __fastcall Disconnect(void);
	void __fastcall StartExport(void);
	void __fastcall EndExport(void);
	bool __fastcall IsReady(void);
	void __fastcall Select(int Col1, int Row1, int Col2, int Row2);
	void __fastcall Align(Byte Horizontal);
	void __fastcall SetCell(int Col, int Row, AnsiString Value);
	void __fastcall SetStr(int Col, int Row, AnsiString Value);
	void __fastcall SetDate(int Col, int Row, System::TDateTime Value);
	void __fastcall SetInt(int Col, int Row, int Value);
	void __fastcall SetFloat(int Col, int Row, double Value);
	void __fastcall ColWidth(int Col1, int Col2, int Width);
	void __fastcall FormatCells(AnsiString FFormat, int Col, int Row1, int Row2);
	void __fastcall FmtNum(int Col, int Row1, int Row2);
	void __fastcall FmtMoney(int Col, int Row1, int Row2);
	AnsiString __fastcall Request(const AnsiString Item);
	void __fastcall Wait(void);
	
__published:
	__property TTbAboutBoxProperty* About = {read=FAbout, write=FAbout};
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
#define TbPrintVersion "v2.52"
static const Word WM_TASKICON = 0x40a;
extern PACKAGE void __fastcall Register(void);

}	/* namespace Tbprint */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Tbprint;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// TbPrint
