//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <ShellApi.h>
#pragma hdrstop

#include "Unit1.h"
#include "URLScan.hpp"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // Uncomment this line to test working with Unicode
  // RVStyle1->TextStyles->Items[0]->Unicode = true;
  rve->Clear();
  rve->AddNLATag("This demo shows how to implement URL scanning",0,0,0);
  rve->AddNLATag("Click the button, and URLs (like this - \"www.richedit.com/\") will be highlighted.",0,0,0);
  rve->AddNLATag("Ctrl+click URL to launch browser or e-mail client",0,0,0);  
  rve->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnOpenClick(TObject *Sender)
{
  if (! od->Execute())
    return;
  Screen->Cursor = crHourGlass;
  rve->Clear();
  rve->DeleteUnusedStyles(true,true,true);
  bool r = false;
  switch (od->FilterIndex)
  {
   case 1:
     r = rve->LoadText(od->FileName,0,0,false);
     break;
   case 2:
     r = rve->LoadRTF(od->FileName);
     break;
  }
  rve->Format();
  Screen->Cursor = crDefault;
  if (!r)
    Application->MessageBox("Error loading file", "Error", MB_OK | MB_ICONSTOP);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnScanClick(TObject *Sender)
{
  Screen->Cursor = crHourGlass;
  // Moving caret to the beginning
  rve->SetSelectionBounds(0, rve->GetOffsBeforeItem(0), 0, rve->GetOffsBeforeItem(0));
  // Clearing undo/redo buffers
  rve->ClearUndo();
  // removing old hypertext links
  bool r = ClearHypertext(rve->RVData, URLScanEvent, true);
  // scanning for URLs
  r = ScanURLs(rve->RVData, URLScanEvent, true) || r;
  if (r)
    rve->Format();
  Screen->Cursor = crDefault;
  rve->SetFocus();
}
//---------------------------------------------------------------------------
// Callback procedure
// This procedure should return index of style for converting source style to
void __fastcall TForm1::URLScanEvent(int OldStyleNo, int& NewStyleNo,
                                     bool ToHypertext)
{
  // Constructing desired style
  TFontInfo* Style = new TFontInfo(NULL);
  Style->Assign(RVStyle1->TextStyles->Items[OldStyleNo]);
  Style->Jump = ToHypertext;
  if (ToHypertext)
  {
    // Hypertext links will be blue and underlined
    Style->Style << fsUnderline;
    Style->Color = clBlue;
    Style->JumpCursor = crJump;
  }
  else
  {
    // Plain text will be black and not underlined
    Style->Style >> fsUnderline;
    Style->Color = clWindowText;
  }
  // May be such style already exists?
  NewStyleNo = RVStyle1->TextStyles->FindSuchStyle(OldStyleNo,Style,RVAllFontInfoProperties);
  if (NewStyleNo==-1)
  {
    // Not exists, adding...
    RVStyle1->TextStyles->Add()->Assign(Style);
    NewStyleNo = RVStyle1->TextStyles->Count-1;
    RVStyle1->TextStyles->Items[NewStyleNo]->Standard = false;
  }
  delete Style;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::rveJump(TObject *Sender, int id)
{
  TCustomRVFormattedData* RVData;
  int ItemNo;
  rve->GetJumpPointLocation(id, RVData, ItemNo);
  AnsiString url = (char*)(RVData->GetItemTag(ItemNo));
  ShellExecute(0, "open", url.c_str(), NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::rveKeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
  if (Key==VK_SPACE || Key==VK_RETURN)
  {
    // url detection
    if (CheckBox1->Checked)
      DetectURL(rve, URLScanEvent, true);
    // closing url if necessary
    TerminateHyperlink(rve, URLScanEvent);
  }
}
//---------------------------------------------------------------------------