//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RVStyle"
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichViewEdit1->Clear();
  RichViewEdit1->AddNL("M",1,0);
  RichViewEdit1->Add("=||m",0);
  RichViewEdit1->Add("i,j",3);
  RichViewEdit1->Add("||",0);
  // Note: rvoTagsArePChars in Options
  RichViewEdit1->AddTag("n",2, (int)StrNew("m")); // double scripts are only as
                                         // an example here. They are too imperfect -
                                         // they assume that upperscript text is narrower
                                         // (or at least not very wider)
                                         // than superscript
  RichViewEdit1->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RVStyle1DrawStyleText(TRVStyle *Sender,
    const AnsiString s, TCanvas *Canvas, int StyleNo, int SpaceBefore, int Left,
    int Top, int Width, int Height, TRVTextDrawStates DrawState,
    bool &DoDefault)
{
  switch (StyleNo)
  {
    case 1: // dot
    {
      // displaying small circle in the right top corner of item
      // and allowing default drawing of item text
      if (DrawState.Contains(rvtsItemEnd) && s.Length()>0)
      {
        Canvas->Pen->Color = Sender->TextStyles->Items[1]->Color;
        Canvas->Ellipse(Left+Width-2,Top-2,Left+Width+2,Top+2);
      }
      break;
    }
    case 2: // double scripts
    {
        // displaying tag string as superscript
        // and allowing default drawing of item text (subscript)
        if (DrawState.Contains(rvtsItemStart) && s.Length()>0)
        {
          char* uppertext =
            (char*)(((TCustomRVFormattedData*)(Sender->RVData))->GetItemTag(Sender->ItemNo));
          if (uppertext)
            Canvas->TextOut(Left,Top-Height+5, uppertext);
        }
    }
  }
}
//---------------------------------------------------------------------------