/*******************************************************}
{                                                       }
{       RichView                                        }
{       AutoComplete demo
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************/

//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "RVGetText.hpp"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma link "RVGetText"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
#if __BORLANDC__>0x0550
  PopupMenu1->AutoHotkeys = maManual;
#endif
  RichViewEdit1->Clear();
  RichViewEdit1->AddNL("Type a word and press Ctrl+Space for suggestions",0,0);
  RichViewEdit1->Format();
}
//---------------------------------------------------------------------------
void TForm1::AddPopupMenuItem(AnsiString s)
{
  TMenuItem*mi = new TMenuItem(PopupMenu1);
  mi->Caption = s;
  mi->OnClick = AutoCompletePopupMenuClick;
  PopupMenu1->Items->Add(mi);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::AutoCompletePopupMenuClick(TObject* Sender)
{
  RichViewEdit1->SelectCurrentWord();
  RichViewEdit1->InsertText(((TMenuItem*)Sender)->Caption, false);
}
void __fastcall TForm1::RichViewEdit1KeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
  if (Key==VK_SPACE && Shift.Contains(ssCtrl))
  {
    AnsiString s = GetCurrentWord(RichViewEdit1);
    if (s!="")
    {
      while (PopupMenu1->Items->Count>0)
      {
        TMenuItem* item = PopupMenu1->Items->Items[0];
        delete item;
      }
      AddPopupMenuItem("super"+s);
      AddPopupMenuItem("mega"+s);
      AddPopupMenuItem("ultra"+s);
      AddPopupMenuItem("grand"+s);
      TPoint pt;
      GetCaretPos(&pt);
      pt = RichViewEdit1->TopLevelEditor->ClientToScreen(pt);
      PopupMenu1->Popup(pt.x, pt.y+10);
    }
    Key = 0;
  }
}
//---------------------------------------------------------------------------
