unit pmemoreg;

{ PlusMemo version 5.0
{  Electro-Concept Mauricie, 1997-1998-1999

  Source file for registration of PlusMemo component on the palette at design time;
  Under Delphi 1 and Delphi 2, add this file to your library.
  Under Delphi 3/4/5 and CBuilder 3/4, add this file to a package of your choice }

interface
uses DsgnIntf;

{  TKeywordsProperty is a property editor for design time entry of keywords
  in a TPlusMemo
  TStartStopKeysProperty is a property editor for design time entry
  of start-stop keys in a TPlusMemo. }

type
  TKeywordsProperty = class(TStringProperty)
      public
        function GetAttributes: TPropertyAttributes; override;
        function GetValue: string; override;
        procedure Edit; override;
      end;

  TStartStopKeysProperty = class(TStringProperty)
      public
        function GetAttributes: TPropertyAttributes; override;
        function GetValue: string; override;
        procedure Edit; override;
      end;



procedure Register;

implementation

uses Classes, PlusMemo, PlusLns, PlusKeys {$IFNDEF WIN32} , PlusSup {$ENDIF};

procedure Register;
begin
  RegisterComponents('ECM', [TPlusMemo]);
  RegisterPropertyEditor(TypeInfo(TStrings), TPlusMemo, 'Lines', TPlusLinesProperty);
  RegisterPropertyEditor(TypeInfo(TKeywordList), TPlusMemo, 'Keywords', TKeywordsProperty);
  RegisterPropertyEditor(TypeInfo(TStartStopKeyList), TPlusMemo, 'StartStopKeys', TStartStopKeysProperty);
end;

function TKeywordsProperty.GetAttributes;
begin
  Result:= [paDialog, paAutoUpdate]
end;

function TKeywordsProperty.GetValue: string;
begin
  Result:= '(TKeywordList)'
end;

procedure TKeywordsProperty.Edit;
var MyMemo: TPlusMemo;
begin
  MyMemo:= GetComponent(0) as TPlusMemo;
  if EditKeywordList(MyMemo.Keywords) then
    begin
    MyMemo.ReApplyKeywords;
    Modified
    end
end;

function TStartStopKeysProperty.GetAttributes;
begin
  Result:= [paDialog, paAutoUpdate]
end;

function TStartStopKeysProperty.GetValue: string;
begin
  Result:= '(TStartStopKeyList)'
end;

procedure TStartStopKeysProperty.Edit;
var MyMemo: TPlusMemo;
begin
  MyMemo:= GetComponent(0) as TPlusMemo;
  if EditStartStopList(MyMemo.StartStopKeys) then
    begin
    MyMemo.ReApplyKeywords;
    Modified
    end
end;
end.
