// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Plusmemo.pas' rev: 4.00

#ifndef PlusmemoHPP
#define PlusmemoHPP

#pragma delphiheader begin
#pragma option push -w-
#include <Dialogs.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <Menus.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Plusmemo
{
//-- type declarations -------------------------------------------------------
typedef int PlusCardinal;

typedef Graphics::TFontStyle TExtFontStyle;

typedef Set<Graphics::TFontStyle, fsBold, fsStrikeOut>  TExtFontStyles;

typedef Shortint TPlusFontStyle;

typedef Set<TPlusFontStyle, 0, 5>  TPlusFontStyles;

#pragma option push -b-
enum TMouseScrollType { msNoScroll, msUp, msDown, msLeft, msRight };
#pragma option pop

#pragma pack(push, 4)
struct DynInfoRec
{
	int DynOffset;
	Byte DynStyle;
	Shortint Level;
	Graphics::TColor Backgnd;
	Graphics::TColor Foregnd;
	short Context;
	Controls::TCursor Cursor;
	short KeyIndex[16];
	union
	{
		struct 
		{
			Byte StartKlen;
			Byte StopKLen;
			
		};
		struct 
		{
			Word Klen;
			
		};
		
	};
} ;
#pragma pack(pop)

typedef DynInfoRec *pDynInfoRec;

typedef DynInfoRec DynInfoArray[38347922];

typedef DynInfoRec *pDynArray;

#pragma pack(push, 4)
struct LineInfo
{
	int Start;
	int Stop;
	int LineWidth;
	int TotalWidth;
	int TotalColumns;
	int Spaces;
	int JustifyStart;
	TExtFontStyles StartAttrib;
	int StartDynNb;
} ;
#pragma pack(pop)

typedef LineInfo *pLineInfo;

#pragma pack(push, 4)
struct ParInfo
{
	char *Text;
	int Length;
	Graphics::TColor Foregnd;
	Graphics::TColor Backgnd;
	int StartLine;
	int StartOffset;
	DynInfoRec *StartDynAttrib;
	LineInfo FirstLine;
	int NbLines;
	void *LinesBuf;
	int DynCount;
	DynInfoRec *DynBuffer;
	int DynBufLen;
	bool Formatted;
	bool StartStopDone;
	bool KeywordsDone;
} ;
#pragma pack(pop)

typedef ParInfo *pParInfo;

class DELPHICLASS TLinesList;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TLinesList : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	int __fastcall GetCount(void);
	void __fastcall SetCount(int NewCount);
	LineInfo __fastcall GetItem(int i);
	void __fastcall SetItem(int i, const LineInfo &Item);
	pLineInfo __fastcall GetLinesPointer(int i);
	
public:
	ParInfo *LLPar;
	int __fastcall Add(const LineInfo &Item);
	__property int Count = {read=GetCount, write=SetCount, nodefault};
	__property LineInfo Items[int i] = {read=GetItem, write=SetItem/*, default*/};
	__property pLineInfo LinePointers[int i] = {read=GetLinesPointer};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TLinesList(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TLinesList(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TDynArray;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TDynArray : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
protected:
	short fElementSize;
	short fElementSpace;
	void *fList;
	int fCount;
	int fCapacity;
	void __fastcall SetCapacity(int cap);
	void __fastcall SetCount(int NewCount);
	void * __fastcall getPointer(int i);
	
public:
	__fastcall virtual ~TDynArray(void);
	__property int Capacity = {read=fCapacity, write=SetCapacity, nodefault};
	__property int Count = {read=fCount, write=SetCount, nodefault};
	__property void * Pointers[int i] = {read=getPointer};
	__property short ElementSpace = {read=fElementSpace, nodefault};
	int __fastcall Add(const void *Item);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TDynArray(void) : Classes::TPersistent() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TDynArray2;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TDynArray2 : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	short fElementSize;
	short fElementSpace;
	Classes::TList* fList;
	int fCount;
	int fCapacity;
	short fElementsPerBuffer;
	void __fastcall SetCapacity(int cap);
	void __fastcall SetCount(int NewCount);
	void * __fastcall GetPointer(int i);
	
public:
	__fastcall TDynArray2(void);
	__fastcall virtual ~TDynArray2(void);
	__property int Capacity = {read=fCapacity, write=SetCapacity, nodefault};
	__property int Count = {read=fCount, write=SetCount, nodefault};
	__property void * Pointers[int i] = {read=GetPointer};
	__property short ElementSpace = {read=fElementSpace, nodefault};
	int __fastcall Add(const void *Item);
};

#pragma pack(pop)

class DELPHICLASS TParagraphsList;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TParagraphsList : public TDynArray2 
{
	typedef TDynArray2 inherited;
	
private:
	ParInfo __fastcall GetItem(int i);
	void __fastcall SetItem(int i, const ParInfo &Item);
	pParInfo __fastcall GetParPointers(int i);
	
public:
	__fastcall TParagraphsList(void);
	__property ParInfo Items[int i] = {read=GetItem, write=SetItem/*, default*/};
	__property pParInfo ParPointers[int i] = {read=GetParPointers};
public:
	#pragma option push -w-inl
	/* TDynArray2.Destroy */ inline __fastcall virtual ~TParagraphsList(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TPlusMemoStrings;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPlusMemoStrings : public Classes::TStrings 
{
	typedef Classes::TStrings inherited;
	
private:
	HIDESBASE void __fastcall ReadData(Classes::TReader* Reader);
	HIDESBASE void __fastcall WriteData(Classes::TWriter* Writer);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	virtual void __fastcall SetUpdateState(bool StringsUpdating);
	virtual void __fastcall SetTextStr(const AnsiString Value);
	virtual AnsiString __fastcall GetTextStr(void);
	
public:
	Classes::TComponent* Memo;
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall Clear(void);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
public:
	#pragma option push -w-inl
	/* TStrings.Destroy */ inline __fastcall virtual ~TPlusMemoStrings(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TPlusMemoStrings(void) : Classes::TStrings() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TPlusParaStrings;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPlusParaStrings : public TPlusMemoStrings 
{
	typedef TPlusMemoStrings inherited;
	
protected:
	virtual AnsiString __fastcall Get(int Index);
	virtual int __fastcall GetCount(void);
	virtual void __fastcall Put(int Index, const AnsiString s);
	
public:
	virtual int __fastcall Add(const AnsiString s);
	virtual void __fastcall Delete(int Index);
	virtual void __fastcall Insert(int Index, const AnsiString s);
public:
	#pragma option push -w-inl
	/* TStrings.Destroy */ inline __fastcall virtual ~TPlusParaStrings(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TPlusParaStrings(void) : TPlusMemoStrings() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TPlusLinesStrings;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPlusLinesStrings : public TPlusMemoStrings 
{
	typedef TPlusMemoStrings inherited;
	
protected:
	TLinesList* fLinesStrings;
	virtual AnsiString __fastcall Get(int Index);
	virtual int __fastcall GetCount(void);
	virtual void __fastcall Put(int Index, const AnsiString s);
	
public:
	__fastcall virtual ~TPlusLinesStrings(void);
	virtual int __fastcall Add(const AnsiString s);
	virtual void __fastcall Delete(int Index);
	virtual void __fastcall Insert(int Index, const AnsiString s);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TPlusLinesStrings(void) : TPlusMemoStrings() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TPlusNavigator;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPlusNavigator : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int __fastcall GetOffset(void);
	int __fastcall GetDynNb(void);
	void __fastcall SetPos(int p);
	int __fastcall GetParNb(void);
	int __fastcall GetLineNb(void);
	void __fastcall SetLineNb(int l);
	int __fastcall GetColNb(void);
	void __fastcall SetColNb(int c);
	int __fastcall GetParLine(void);
	pParInfo __fastcall GetPar(void);
	char __fastcall GetText(void);
	DynInfoRec __fastcall GetDynInfo(void);
	pDynInfoRec __fastcall GetpDynInfo(void);
	Graphics::TFontStyles __fastcall GetStyle(void);
	TLinesList* __fastcall GetNavLines(void);
	
public:
	Classes::TComponent* fPMemo;
	int fPos;
	ParInfo *fPar;
	int fParNb;
	int fOffset;
	int fDynNb;
	int fParLine;
	TLinesList* fNavLines;
	__fastcall TPlusNavigator(Classes::TComponent* APlusMemo);
	__fastcall virtual ~TPlusNavigator(void);
	void __fastcall AddDyn(const DynInfoRec &dyn);
	void __fastcall Assign(TPlusNavigator* Source);
	bool __fastcall BackToDyn(int Min);
	bool __fastcall ForwardToDyn(int Max);
	void __fastcall GetTextBuf(char * Buffer, int Len);
	void __fastcall Invalidate(void);
	void __fastcall RemoveDyn(void);
	void __fastcall RightOfDyn(void);
	__property int Pos = {read=fPos, write=SetPos, nodefault};
	__property int ParNumber = {read=GetParNb, nodefault};
	__property int LineNumber = {read=GetLineNb, write=SetLineNb, nodefault};
	__property int Col = {read=GetColNb, write=SetColNb, nodefault};
	__property int ParOffset = {read=GetOffset, nodefault};
	__property int ParLine = {read=GetParLine, nodefault};
	__property char Text = {read=GetText, nodefault};
	__property Graphics::TFontStyles Style = {read=GetStyle, nodefault};
	__property int DynNb = {read=GetDynNb, nodefault};
	__property pParInfo Par = {read=GetPar};
	__property DynInfoRec DynAttr = {read=GetDynInfo};
	__property pDynInfoRec pDynAttr = {read=GetpDynInfo};
	__property TLinesList* NavLines = {read=GetNavLines};
};

#pragma pack(pop)

class DELPHICLASS TPlusHighlighter;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPlusHighlighter : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
protected:
	virtual void __fastcall ApplyKeywordsList(TPlusNavigator* Start, TPlusNavigator* Stop, int BaseIndex
		);
	virtual bool __fastcall FindStart(TPlusNavigator* Start, TPlusNavigator* Stop, int BaseIndex);
	virtual bool __fastcall FindStop(TPlusNavigator* Start, TPlusNavigator* Stop, int BaseIndex);
	
public:
	Classes::TList* MemoList;
	__fastcall virtual TPlusHighlighter(Classes::TComponent* AOwner);
	__fastcall virtual ~TPlusHighlighter(void);
};

#pragma pack(pop)

#pragma option push -b-
enum TWordOption { woMatchCase, woWholeWordsOnly, woContextOnly };
#pragma option pop

typedef Set<TWordOption, woMatchCase, woContextOnly>  TWordOptions;

#pragma pack(push, 1)
struct TKeywordInfo
{
	TWordOptions Options;
	TExtFontStyles Style;
	short ContextNumber;
	Controls::TCursor Cursor;
	Graphics::TColor Backgnd;
	Graphics::TColor Foregnd;
} ;
#pragma pack(pop)

typedef TKeywordInfo *pKeyInfo;

#pragma pack(push, 4)
struct TKeyInfoLen
{
	TKeywordInfo BasicPart;
	int KeyLen;
} ;
#pragma pack(pop)

typedef TKeyInfoLen *pKeyInfoLen;

class DELPHICLASS TKeywordList;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TKeywordList : public Classes::TStringList 
{
	typedef Classes::TStringList inherited;
	
protected:
	Classes::TList* keylist;
	int fLongestKeyword;
	bool fResetKeywords;
	bool fSomeUpperCase;
	void __fastcall setKeyInfo(int i, const TKeywordInfo &wi);
	TKeywordInfo __fastcall getKeyInfo(int i);
	void __fastcall UpdateKeyList(System::TObject* Sender);
	virtual void __fastcall Changed(void);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	
public:
	HIDESBASE void __fastcall ReadData(Classes::TReader* Reader);
	HIDESBASE void __fastcall WriteData(Classes::TWriter* Writer);
	__fastcall virtual ~TKeywordList(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall Delete(int i);
	virtual void __fastcall Clear(void);
	int __fastcall AddKeyWord(const AnsiString KeyWord, TWordOptions Options, TExtFontStyles Style, short 
		ContextNumber, Controls::TCursor Cursor, Graphics::TColor Backgnd, Graphics::TColor Foregnd);
	__property TKeywordInfo KeyInfos[int i] = {read=getKeyInfo, write=setKeyInfo};
	__property bool ResetKeywords = {read=fResetKeywords, write=fResetKeywords, nodefault};
	__property bool SomeUpperCase = {read=fSomeUpperCase, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TKeywordList(void) : Classes::TStringList() { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 1)
struct StartStopInfo
{
	TKeywordInfo Attributes;
	char *StartKey;
	char *StopKey;
	short StartLen;
	short StopLen;
	bool ParStop;
	short Previous;
	bool StartRightCheck;
	bool StartLeftCheck;
	bool StopRightCheck;
	bool StopLeftCheck;
} ;
#pragma pack(pop)

typedef StartStopInfo *pStartStopInfo;

class DELPHICLASS TStartStopKeyList;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TStartStopKeyList : public TDynArray 
{
	typedef TDynArray inherited;
	
protected:
	short fLongestStartKey;
	short fLongestStopKey;
	bool fDelChecked;
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	
public:
	void __fastcall ReadData(Classes::TReader* Reader);
	void __fastcall WriteData(Classes::TWriter* Writer);
	__fastcall TStartStopKeyList(void);
	__fastcall virtual ~TStartStopKeyList(void);
	__property short LongestStartKey = {read=fLongestStartKey, nodefault};
	__property bool DelChecked = {read=fDelChecked, write=fDelChecked, nodefault};
	void __fastcall Clear(void);
	int __fastcall AddStartStopKey(const AnsiString StartKey, const AnsiString StopKey, TWordOptions Options
		, TExtFontStyles Style, short ContextNumber, Controls::TCursor Cursor, Graphics::TColor Backgnd, Graphics::TColor 
		Foregnd, bool EndAtPar);
};

#pragma pack(pop)

typedef Controls::TWndMethod *pWndMethod;

#pragma option push -b-
enum TUpdateMode { umImmediate, umOnNeed, umBackground };
#pragma option pop

#pragma option push -b-
enum TPlusMemoOption { pmoKeepColumnPos, pmoPutExtraSpaces, pmoWrapCaret, pmoInsertKeyActive, pmoWideOverwriteCaret, 
	pmoLargeWordSelect, pmoAutoScrollBars, pmoNoDragnDrop, pmoAutoIndent, pmoBackIndent, pmoWindowsSelColors, 
	pmoFullLineSelect, pmoDiscardTrailingSpaces, pmoNoFineScroll };
#pragma option pop

typedef Set<TPlusMemoOption, pmoKeepColumnPos, pmoNoFineScroll>  TPlusMemoOptions;

#pragma option push -b-
enum TPlusLineBreak { pbCRLF, pbLFCR, pbCR, pbLF };
#pragma option pop

typedef Set<char, 0, 255>  TSetOfChar;

#pragma pack(push, 4)
struct TUndoRecord
{
	int UndoStart;
	int UndoStop;
	char *UndoText;
} ;
#pragma pack(pop)

typedef void __fastcall (__closure *TParseEvent)(System::TObject* Sender, int StartOffset, int StopOffset
	);

typedef void __fastcall (__closure *TContextEvent)(System::TObject* Sender, short Context, int StartOffset
	, int StopOffset);

class DELPHICLASS TPlusMemo;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPlusMemo : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
protected:
	int fTextLen;
	int fLineCount;
	TParagraphsList* fParagraphs;
	Classes::TStrings* fPars;
	Classes::TStrings* fLines;
	int fSelLen;
	TPlusNavigator* fcp;
	TPlusNavigator* fDisplayTop;
	int fLeftMargin;
	int fRightMargin;
	int fDisplayLeft;
	int fTabStops;
	bool fAutoLineHeight;
	bool fModified;
	bool fReadOnly;
	bool fWantTabs;
	bool fWordWrap;
	bool fHScrollBar;
	bool fVScrollBar;
	bool fHideSelection;
	bool fShowEndParSelected;
	bool fEnableHotKeys;
	bool fPassOver;
	bool fDisplayOnly;
	Classes::TAlignment fAlignment;
	bool fJustified;
	Graphics::TFont* fAltFont;
	Graphics::TColor fHTColor;
	Graphics::TColor fHBColor;
	Forms::TFormBorderStyle fBorderStyle;
	int fCaretWidth;
	int fCompleted;
	TKeywordList* fKeywords;
	TStartStopKeyList* fStartStopKeys;
	bool fApplyKeyWords;
	bool fApplyStartStopKeys;
	TUpdateMode fUpdateMode;
	bool fStripStrayCtrlCodes;
	TSetOfChar fDelimiters;
	Graphics::TPen* fEndOfTextPen;
	bool fOverWrite;
	TPlusMemoOptions fOptions;
	int fUndoLevel;
	int fUndoMaxLevel;
	Classes::TList* fUndoList;
	int fUndoMaxSpace;
	char fNull;
	TPlusHighlighter* fHighlighter;
	int fRTFLeading;
	TPlusLineBreak fLineBreak;
	int fTopOrigin;
	bool fStaticFormat;
	int fCharSet;
	int fMouseWheelFact;
	Graphics::TPicture* fBackground;
	Classes::TNotifyEvent fOnChange;
	Classes::TNotifyEvent fOnAttrChange;
	Classes::TNotifyEvent fOnMove;
	Classes::TNotifyEvent fOnProgress;
	Classes::TNotifyEvent fOnVScroll;
	TParseEvent fOnParse;
	TContextEvent fOnContext;
	int fDisplayLines;
	int fWideCaret;
	int fLastPosWidth;
	Classes::TList* fNavigators;
	int fMaxLineWidth;
	int fMaxLineNumber;
	TPlusNavigator* fSelStart;
	TPlusNavigator* fSelStop;
	TPlusNavigator* ftmpnav1;
	TPlusNavigator* ftmpnav2;
	TPlusNavigator* fkeynav1;
	TPlusNavigator* fkeynav2;
	TPlusNavigator* fssnav1;
	TPlusNavigator* fssnav2;
	TPlusNavigator* fformnav1;
	TPlusNavigator* fformnav2;
	TPlusNavigator* fpnav1;
	TPlusNavigator* fpnav2;
	TPlusNavigator* fMouseNav;
	int fMouseDownPos;
	int fMouseWheelAcc;
	bool fDragging;
	bool fDraggingOutside;
	bool fMouseDown;
	bool fDblClick;
	bool fMouseInContext;
	bool fMouseInSel;
	TMouseScrollType fMouseScroll;
	int fScrollRate;
	Controls::TCursor fCursor;
	TExtFontStyles fsStyle;
	int fspos;
	int fCaretX;
	int fCaretY;
	bool fNoCheckFormat;
	bool fNoFormat;
	bool fInSetScroll;
	bool fNoCompleteFormat;
	int fSpaceWidth;
	int fVScrollfact;
	int fHScrollfact;
	bool fAutoCaretWidth;
	HBITMAP fLineBmp;
	int fLineBmpWidth;
	bool fReceivedKeyUp;
	bool fNoPaint;
	Graphics::TCanvas* fCanvas;
	int fW;
	int fLastProgress;
	int fRunningSpaceWidth;
	int fSpaceKern;
	int fExtraCols;
	int fXCaretRunningPos;
	int fUndoTotalSize;
	bool fUndoSkip;
	bool fNoClearRedo;
	bool fInUndo;
	bool fUndoBreak;
	unsigned fSavedDragCursor;
	int fModStartLine;
	int fModStartPar;
	int fModStopPar;
	int fModLinesOffset;
	int fLastStartStopParsed;
	int fUpdateStartPar;
	int fUpdateStopPar;
	bool fUpdating;
	int fLockedCount;
	DynInfoRec fOldFinalDyn;
	bool fVScrollChange;
	char *fUpText;
	int fUpParNb;
	int fUpOffset;
	int fUpLength;
	Classes::TList* fMsgList;
	MESSAGE void __fastcall WMGetDlgCode(Messages::TWMNoParams &Message);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMFontChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMCtl3Dchanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMEraseBkgnd(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMVSCROLL(Messages::TWMScroll &m);
	HIDESBASE MESSAGE void __fastcall WMHSCROLL(Messages::TWMScroll &m);
	HIDESBASE MESSAGE void __fastcall WMMouseWheel(Messages::TMessage &m);
	MESSAGE void __fastcall PMUpdateBkg(Messages::TMessage &m);
	void __fastcall SetupLogFontStyle(tagLOGFONTA &lf, TExtFontStyles style);
	void __fastcall setHScrollParams(void);
	void __fastcall setVScrollParams(void);
	void __fastcall BackgroundChange(System::TObject* Sender);
	int __fastcall GetParCount(void);
	int __fastcall GetPar(int Pos);
	void __fastcall setSelLength(int l);
	AnsiString __fastcall getSelText(void);
	void __fastcall setSelText(const AnsiString s);
	void __fastcall SetSelAttrib(char a);
	TExtFontStyles __fastcall getCurrentStyle(void);
	char __fastcall getChar(int i);
	AnsiString __fastcall getLines(int i);
	void __fastcall setLines(Classes::TStrings* Value);
	AnsiString __fastcall getParagraphs(int i);
	char * __fastcall getLinesBuf(int i);
	char * __fastcall getParsBuf(int i);
	void __fastcall setParsBuf(int i, char * parg);
	int __fastcall getParsOffset(int i);
	void __fastcall setLeftMargin(int lm);
	void __fastcall setRightMargin(int rm);
	void __fastcall setBorderStyle(Forms::TBorderStyle b);
	void __fastcall setTabStops(int t);
	void __fastcall setWordWrap(bool ww);
	void __fastcall setHTColor(Graphics::TColor c);
	void __fastcall setHBColor(Graphics::TColor c);
	void __fastcall setHideSelection(bool h);
	void __fastcall setfAltFont(Graphics::TFont* f);
	bool __fastcall getCanRedo(void);
	bool __fastcall getCanUndo(void);
	void __fastcall setSelPar(int par);
	int __fastcall getSelPar(void);
	void __fastcall setSelStart(int ss);
	void __fastcall setSelLine(int line);
	int __fastcall getSelLine(void);
	void __fastcall setSelCol(int col);
	int __fastcall getSelCol(void);
	int __fastcall getSelStart(void);
	int __fastcall getUndoCount(void);
	void __fastcall setParagraphs(int i, const AnsiString par);
	void __fastcall setScrollBars(Stdctrls::TScrollStyle s);
	AnsiString __fastcall getVersion(void);
	void __fastcall setVersion(const AnsiString v);
	void __fastcall setCaretWidth(int w);
	void __fastcall setAlignment(Classes::TAlignment al);
	void __fastcall setJustified(bool j);
	int __fastcall getTopLine(void);
	void __fastcall setTopLine(int tl);
	void __fastcall setDisplayLeft(int dl);
	Stdctrls::TScrollStyle __fastcall getScrollBars(void);
	void __fastcall setDisplayOnly(bool d);
	void __fastcall setLineHeight(int lh);
	int __fastcall getLineHeight(void);
	void __fastcall setUpdateMode(TUpdateMode um);
	void __fastcall setDelimiters(const TSetOfChar &d);
	void __fastcall setApplyKeywords(bool apply);
	void __fastcall setApplyStartStopKeys(bool apply);
	void __fastcall setEndOfTextMark(Graphics::TPen* p);
	AnsiString __fastcall getSeparators(void);
	void __fastcall setSeparators(const AnsiString s);
	void __fastcall setOptions(TPlusMemoOptions opt);
	void __fastcall setOverwrite(bool ovr);
	TUndoRecord __fastcall getUndoList(int i);
	void __fastcall setUndoMaxLevel(int uml);
	void __fastcall setUndoMaxSpace(int ums);
	void __fastcall setHighlighter(TPlusHighlighter* aHighlighter);
	AnsiString __fastcall getCurrentWord(void);
	Graphics::TColor __fastcall getParBackgnd(int i);
	Graphics::TColor __fastcall getParForegnd(int i);
	void __fastcall setParBackgnd(int i, Graphics::TColor c);
	void __fastcall setParForegnd(int i, Graphics::TColor c);
	void __fastcall setTopOrigin(int top);
	void __fastcall setStaticFormat(bool ssf);
	void __fastcall setBackground(Graphics::TPicture* pic);
	virtual void __fastcall CreateHandle(void);
	virtual void __fastcall DestroyWindowHandle(void);
	virtual void __fastcall CreateParams(Controls::TCreateParams &p);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyPress(char &Key);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, 
		int Y);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	DYNAMIC void __fastcall DblClick(void);
	virtual void __fastcall Loaded(void);
	virtual void __fastcall WndProc(Messages::TMessage &Message);
	void __fastcall Reformat(void);
	void __fastcall FormatNow(int StartPar, int StopPar, bool Unconditional);
	void __fastcall ParseStartStopNow(int ToReach);
	virtual void __fastcall ReformatPar(HDC DC, bool InitDC, int Width, pParInfo Par, int frmParNb, int 
		&Line, int &LastLineChanged, bool CompleteReformat, unsigned &OldFontH);
	TExtFontStyles __fastcall AttrToExtFontStyles(TExtFontStyles StaticAttrib, Word DynAttrib);
	virtual void __fastcall Change(void);
	void __fastcall ETPenChange(System::TObject* Sender);
	void __fastcall InvalidateLines(int start, int stop, bool erase);
	void __fastcall RemoveUndo(int i);
	void __fastcall UpdateCaret(bool Recreate);
	void __fastcall PlaceCaret(void);
	void __fastcall RefreshDisplay(void);
	virtual int __fastcall ColPos(pParInfo Par, int ParNb, int LineNb, int ColNb);
	virtual int __fastcall ColNb(pParInfo Par, int ParNb, int LineNb, int X, bool NoTabRounding);
	virtual int __fastcall LinePos(int lineFromTop);
	virtual int __fastcall LineNb(int Y);
	virtual void __fastcall SetDynStyleP(TPlusNavigator* Start, TPlusNavigator* Stop, const DynInfoRec 
		&dinfo, bool AddDInfo, bool ExtendModFields);
	virtual void __fastcall ApplyKeywordsList(TPlusNavigator* Start, TPlusNavigator* Stop);
	virtual void __fastcall ApplyStartStopKeyList(TPlusNavigator* Start, TPlusNavigator* Stop);
	void __fastcall ExtendMods(int Startpar, int Startline, int Stoppar);
	void __fastcall CheckIntegrity(void);
	int __fastcall GetCaretWidth(void);
	
public:
	int fLineHeight;
	int fLineBase;
	Messages::TMessage NotifyMsg;
	__property Classes::TList* MsgList = {read=fMsgList};
	char * __fastcall GetUpText(pParInfo Par, int ParNb, int Start, int Len);
	__fastcall virtual TPlusMemo(Classes::TComponent* AOwner);
	__fastcall virtual ~TPlusMemo(void);
	virtual void __fastcall SetBounds(int ALeft, int ATop, int AWidth, int AHeight);
	void __fastcall Clear(void);
	void __fastcall ClearSelection(void);
	void __fastcall CopyToClipboard(void);
	void __fastcall CutToClipboard(void);
	HIDESBASE int __fastcall GetTextBuf(char * Buffer, int BufSize);
	HIDESBASE int __fastcall GetTextLen(void);
	int __fastcall GetSelTextBuf(char * Buffer, int BufSize);
	void __fastcall PasteFromClipboard(void);
	void __fastcall SelectAll(void);
	virtual void __fastcall SetSelTextBuf(char * t);
	HIDESBASE void __fastcall SetTextBuf(char * t);
	__property bool Modified = {read=fModified, write=fModified, nodefault};
	__property int SelStart = {read=getSelStart, write=setSelStart, nodefault};
	__property int SelLength = {read=fSelLen, write=setSelLength, nodefault};
	__property AnsiString SelText = {read=getSelText, write=setSelText};
	void __fastcall ClearStyle(int Pos);
	void __fastcall ClearStyleRange(int FromRange, int ToRange);
	void __fastcall ClearUndo(void);
	void __fastcall DrawLine(int Line, Graphics::TCanvas* Canvas, const Windows::TPoint &Pos);
	void __fastcall DrawLines(int StartLine, int StopLine, Graphics::TCanvas* Canvas, const Windows::TPoint 
		&Pos, float VertSpacing);
	AnsiString __fastcall DynText(int Start, int Stop);
	bool __fastcall FindTxt(const AnsiString Text, bool GoForward, bool MatchCase, bool WholeWordsOnly)
		;
	void __fastcall FormatText(Graphics::TCanvas* Canvas, int Width);
	AnsiString __fastcall GetTextPart(int Start, int Stop);
	char * __fastcall GetTextPartBuf(int Start, int Stop);
	virtual void __fastcall LoadFromNativeStream(Classes::TStream* Stream, bool Reformat);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall ReApplyKeywords(void);
	virtual void __fastcall SaveToNativeStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall SaveToRTFStream(Classes::TStream* Stream, bool DynFormat);
	void __fastcall ScrollInView(void);
	void __fastcall SetBold(void);
	void __fastcall SetItalic(void);
	void __fastcall SetUnderline(void);
	void __fastcall SetHighlight(void);
	void __fastcall SetAltFont(void);
	void __fastcall SetDynStyle(int Start, int Stop, TExtFontStyles Style, bool ContentDependant, short 
		Context, Controls::TCursor Cursor, Graphics::TColor Backgnd, Graphics::TColor Foregnd);
	void __fastcall SetDynText(int Start, int Stop, const AnsiString DText);
	void __fastcall SetTopLeft(int NewTopOrigin, int NewLeftOrigin);
	void __fastcall Redo(void);
	void __fastcall Undo(void);
	__property bool CanRedo = {read=getCanRedo, nodefault};
	__property bool CanUndo = {read=getCanUndo, nodefault};
	__property int CaretX = {read=fCaretX, nodefault};
	__property int CaretY = {read=fCaretY, nodefault};
	__property int CharCount = {read=fTextLen, nodefault};
	__property char Chars[int i] = {read=getChar};
	__property int CharSet = {read=fCharSet, write=fCharSet, nodefault};
	__property AnsiString CurrentWord = {read=getCurrentWord};
	__property TSetOfChar Delimiters = {read=fDelimiters, write=setDelimiters};
	__property int FirstVisibleLine = {read=getTopLine, write=setTopLine, nodefault};
	__property int FormatCompleted = {read=fCompleted, nodefault};
	__property int LeftOrigin = {read=fDisplayLeft, write=setDisplayLeft, nodefault};
	__property int LineCount = {read=fLineCount, nodefault};
	__property AnsiString LinesArray[int i] = {read=getLines};
	__property char * LinesBuf[int i] = {read=getLinesBuf};
	__property int ParagraphCount = {read=GetParCount, nodefault};
	__property Classes::TStrings* Paragraphs = {read=fPars};
	__property char * PargrphBuf[int i] = {read=getParsBuf, write=setParsBuf};
	__property int PargrphNumber[int Offset] = {read=GetPar};
	__property int PargrphOffset[int i] = {read=getParsOffset};
	__property AnsiString ParsArray[int i] = {read=getParagraphs, write=setParagraphs};
	__property Graphics::TColor ParagraphsBackground[int i] = {read=getParBackgnd, write=setParBackgnd}
		;
	__property Graphics::TColor ParagraphsForeground[int i] = {read=getParForegnd, write=setParForegnd}
		;
	__property int RTFLeading = {read=fRTFLeading, write=fRTFLeading, nodefault};
	__property int SelCol = {read=getSelCol, write=setSelCol, nodefault};
	__property int SelLine = {read=getSelLine, write=setSelLine, nodefault};
	__property int SelPar = {read=getSelPar, write=setSelPar, nodefault};
	__property TExtFontStyles SelStyle = {read=getCurrentStyle, nodefault};
	__property bool StripStrayCtrlCodes = {read=fStripStrayCtrlCodes, write=fStripStrayCtrlCodes, default=1
		};
	__property int TopOrigin = {read=fTopOrigin, write=setTopOrigin, nodefault};
	__property int UndoCount = {read=getUndoCount, nodefault};
	__property int UndoLevel = {read=fUndoLevel, nodefault};
	__property TUndoRecord UndoList[int Index] = {read=getUndoList};
	__property Canvas ;
	
__published:
	__property Classes::TAlignment Alignment = {read=fAlignment, write=setAlignment, nodefault};
	__property Forms::TBorderStyle BorderStyle = {read=fBorderStyle, write=setBorderStyle, default=1};
	__property bool HideSelection = {read=fHideSelection, write=setHideSelection, default=1};
	__property Classes::TStrings* Lines = {read=fLines, write=setLines};
	__property Stdctrls::TScrollStyle ScrollBars = {read=getScrollBars, write=setScrollBars, nodefault}
		;
	__property bool WantTabs = {read=fWantTabs, write=fWantTabs, default=1};
	__property bool WordWrap = {read=fWordWrap, write=setWordWrap, default=1};
	__property Classes::TNotifyEvent OnChange = {read=fOnChange, write=fOnChange};
	__property Graphics::TFont* AltFont = {read=fAltFont, write=setfAltFont};
	__property bool ApplyKeyWords = {read=fApplyKeyWords, write=setApplyKeywords, default=1};
	__property bool ApplyStartStopKeys = {read=fApplyStartStopKeys, write=setApplyStartStopKeys, default=1
		};
	__property Graphics::TPicture* BackgroundBmp = {read=fBackground, write=setBackground};
	__property int CaretWidth = {read=fCaretWidth, write=setCaretWidth, nodefault};
	__property bool DisplayOnly = {read=fDisplayOnly, write=setDisplayOnly, nodefault};
	__property bool EnableHotKeys = {read=fEnableHotKeys, write=fEnableHotKeys, default=1};
	__property Graphics::TPen* EndOfTextMark = {read=fEndOfTextPen, write=setEndOfTextMark};
	__property Graphics::TColor HighlightBackgnd = {read=fHBColor, write=setHBColor, default=-2147483643
		};
	__property Graphics::TColor HighlightColor = {read=fHTColor, write=setHTColor, default=255};
	__property TPlusHighlighter* Highlighter = {read=fHighlighter, write=setHighlighter};
	__property bool Justified = {read=fJustified, write=setJustified, nodefault};
	__property TKeywordList* Keywords = {read=fKeywords, write=fKeywords};
	__property int LeftMargin = {read=fLeftMargin, write=setLeftMargin, default=8};
	__property TPlusLineBreak LineBreak = {read=fLineBreak, write=fLineBreak, default=0};
	__property int LineHeight = {read=getLineHeight, write=setLineHeight, nodefault};
	__property int MouseWheelFactor = {read=fMouseWheelFact, write=fMouseWheelFact, default=3};
	__property char NullReplacement = {read=fNull, write=fNull, nodefault};
	__property TPlusMemoOptions Options = {read=fOptions, write=setOptions, nodefault};
	__property bool Overwrite = {read=fOverWrite, write=setOverwrite, nodefault};
	__property bool PassOverCodes = {read=fPassOver, write=fPassOver, default=1};
	__property bool ReadOnly = {read=fReadOnly, write=fReadOnly, default=0};
	__property int RightMargin = {read=fRightMargin, write=setRightMargin, default=8};
	__property AnsiString Separators = {read=getSeparators, write=setSeparators};
	__property bool ShowEndParSelected = {read=fShowEndParSelected, write=fShowEndParSelected, default=1
		};
	__property TStartStopKeyList* StartStopKeys = {read=fStartStopKeys, write=fStartStopKeys};
	__property bool StaticFormat = {read=fStaticFormat, write=setStaticFormat, default=1};
	__property int TabStops = {read=fTabStops, write=setTabStops, default=8};
	__property int UndoMaxSpace = {read=fUndoMaxSpace, write=setUndoMaxSpace, default=65538};
	__property int UndoMaxLevel = {read=fUndoMaxLevel, write=setUndoMaxLevel, default=256};
	__property TUpdateMode UpdateMode = {read=fUpdateMode, write=setUpdateMode, default=2};
	__property AnsiString Version = {read=getVersion, write=setVersion};
	__property Classes::TNotifyEvent OnStyleChange = {read=fOnAttrChange, write=fOnAttrChange};
	__property Classes::TNotifyEvent OnSelMove = {read=fOnMove, write=fOnMove};
	__property Classes::TNotifyEvent OnVScroll = {read=fOnVScroll, write=fOnVScroll};
	__property Classes::TNotifyEvent OnProgress = {read=fOnProgress, write=fOnProgress};
	__property TParseEvent OnParse = {read=fOnParse, write=fOnParse};
	__property TContextEvent OnContext = {read=fOnContext, write=fOnContext};
	__property Align ;
	__property Color ;
	__property Ctl3D ;
	__property DragCursor ;
	__property DragMode ;
	__property Enabled ;
	__property Font ;
	__property ParentColor ;
	__property ParentCtl3D ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property PopupMenu ;
	__property ShowHint ;
	__property TabOrder ;
	__property TabStop ;
	__property Visible ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnStartDrag ;
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TPlusMemo(HWND ParentWindow) : Controls::TCustomControl(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
static const char ctrlBold = '\x2';
static const char ctrlItalic = '\x1';
static const char ctrlUnderline = '\x15';
static const char ctrlHighlight = '\x3';
static const char ctrlAltFont = '\x4';
static const char ctrlPerf = '\x0';
#define CtrlCodesSet (System::Set<char, 0, 255> () << '\x1' << '\x2' << '\x3' << '\x4' << '\x15' )
static const Shortint fsHighlight = 0x4;
static const Shortint fsAltFont = 0x5;
static const int DCodeLen = 0x38;
static const int LineInfoSpace = 0x24;
static const Word pm_UpdateBkg = 0x401;
static const Word pm_VScroll = 0x402;
static const Word pm_Context = 0x403;
static const Shortint pm_Msg = 0x40;
extern PACKAGE int ProgressInterval;
extern PACKAGE void __fastcall InvalidateNavs(Classes::TList* NavList, int startpos, int lastpar);

}	/* namespace Plusmemo */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Plusmemo;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Plusmemo
