//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "LayersReg.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TChannelEdit *ChannelEdit;
//---------------------------------------------------------------------------
__fastcall TChannelEdit::TChannelEdit(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
namespace Layersreg
{
    void __fastcall PACKAGE Register()
    {
        TComponentClass classes[3] = {__classid(TLayer),
                                      __classid(TImageLayer),
                                      __classid(TButtonLayer)};
        RegisterComponents("Layers", classes, 2);
        RegisterPropertyEditor(__typeinfo(TChannel), NULL, "", __classid(TChannelProperty));
    }
}
//---------------------------------------------------------------------------
void __fastcall TChannelEdit::SBOpenClick(TObject *Sender)
{
  if (OpenChannel->Execute()){
    Channel->LoadFromFile(OpenChannel->FileName);
    UpdateChannel();
  }
}
//---------------------------------------------------------------------------
void __fastcall TChannelEdit::SetChannel(TChannel *AChannel)
{
  FChannel = AChannel;
}
//---------------------------------------------------------------------------
void __fastcall TChannelEdit::UpdateChannel()
{
  Image->Visible = (Channel->Mode == cmAlphaChannel);
  SBColor->Visible = Image->Visible;
  SBFilter->Visible = Image->Visible;
  Button->Visible = (Channel->Mode == cmColorChannel);
  if (Channel->Mode == cmAlphaChannel) {Image->Mask = Channel; }
  else {Button->Glyph = Channel;}
  SBSave->Enabled = Channel->Active;
  SBClear->Enabled = Channel->Active;
  SBFilter->Down = (Image->Color == clNone);
  if (!SBFilter->Down) {ColorSelect->Color = Image->Color;}
}
void __fastcall TChannelEdit::SBSaveClick(TObject *Sender)
{
  if (SaveChannel->Execute())
  Channel->SaveToFile(SaveChannel->FileName);
}
//---------------------------------------------------------------------------
void __fastcall TChannelEdit::SBClearClick(TObject *Sender)
{
  Channel->Active = false;
  UpdateChannel();
}
//---------------------------------------------------------------------------
void __fastcall TChannelEdit::SBFilterClick(TObject *Sender)
{
  if (SBFilter->Down) {Image->Color = clNone;}
  else {Image->Color = ColorSelect->Color;}
}
//---------------------------------------------------------------------------
void __fastcall TChannelEdit::SBColorClick(TObject *Sender)
{
  if (ColorSelect->Execute()) {
    SBFilter->Down = false;
    Image->Color = ColorSelect->Color;
  };
}
//---------------------------------------------------------------------------
TPropertyAttributes __fastcall TChannelProperty::GetAttributes(void)
{
  TPropertyAttributes result = TClassProperty::GetAttributes();
  result << paDialog;
  result >> paSubProperties;
  return result;
}
//---------------------------------------------------------------------------
System::AnsiString __fastcall TChannelProperty::GetValue(void)
{
   TChannel *C = (TChannel*)GetOrdValue();
   if (C == NULL) return "()";
   else if (C->Active) return Format("(%d x %d)", ARRAYOFCONST(((int)C->Size.x,(int)C->Size.y)));
        else return "(None)";
}
//---------------------------------------------------------------------------
void __fastcall TChannelProperty::Edit(void)
{
  TChannelEdit* CE = new TChannelEdit(NULL);
  CE->Channel = (TChannel*)GetOrdValue();
  CE->ShowModal();
  delete CE;
}


