// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Channels.pas' rev: 4.00

#ifndef ChannelsHPP
#define ChannelsHPP

#pragma delphiheader begin
#pragma option push -w-
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Channels
{
//-- type declarations -------------------------------------------------------
#pragma pack(push, 1)
struct TRGBEntry
{
	Byte R;
	Byte G;
	Byte B;
	Byte C;
} ;
#pragma pack(pop)

typedef TRGBEntry TRGBPalette[256];

typedef TRGBEntry *PRGBPalette;

typedef Windows::TRect TRects[1001];

typedef Windows::TRect *PRects;

#pragma option push -b-
enum TAligns { aFrame, aFrameLeft, aFrameTop, aFrameRight, aFrameBottom, aCenter, aLeft, aUp, aRight, 
	aDown, aLeftUp, aLeftDown, aRightUp, aRightDown, aTile, aScale, aStretch };
#pragma option pop

typedef TAligns TChannelAlign;

typedef TAligns TImageAlign;

typedef TAligns TTextAlign;

typedef TAligns TGlyphAlign;

class DELPHICLASS TProChannel;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TProChannel : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FActive;
	Windows::TPoint FSize;
	void *FImage;
	Byte FPixelSize;
	void __fastcall SetSize(const Windows::TPoint &ASize);
	void __fastcall SetActive(bool AActive);
	virtual void __fastcall Activate(void) = 0 ;
	virtual void __fastcall Deactivate(void) = 0 ;
	Windows::TRect __fastcall GetExtents();
	
public:
	int __fastcall DataSize(void);
	void * __fastcall Seek(int APosX, int APosY);
	__fastcall TProChannel(Byte APixelSize);
	__fastcall virtual ~TProChannel(void);
	__property Windows::TRect Extents = {read=GetExtents};
	__property Windows::TPoint Size = {read=FSize, write=SetSize};
	__property bool Active = {read=FActive, write=SetActive, nodefault};
	__property Byte PixelSize = {read=FPixelSize, nodefault};
	__property void * Image = {read=FImage};
};

#pragma pack(pop)

#pragma option push -b-
enum TChannelMode { cmColorChannel, cmAlphaChannel };
#pragma option pop

class DELPHICLASS TChannel;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TChannel : public TProChannel 
{
	typedef TProChannel inherited;
	
private:
	TRGBEntry *FPalette;
	TChannelMode FMode;
	Classes::TNotifyEvent FOnChange;
	virtual void __fastcall Activate(void);
	virtual void __fastcall Deactivate(void);
	
public:
	__fastcall TChannel(TChannelMode AMode);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall LoadFromFileStream(Classes::TStream* AStream);
	void __fastcall LoadFromStream(Classes::TStream* AStream);
	void __fastcall SaveToStream(Classes::TStream* AStream);
	void __fastcall SaveToFile(const AnsiString AFileName);
	void __fastcall LoadFromResourceID(int ResID);
	void __fastcall LoadFromResourceName(const AnsiString ResName);
	void __fastcall LoadFromFile(const AnsiString AFileName);
	__property PRGBPalette Palette = {read=FPalette};
	__property TChannelMode Mode = {read=FMode, nodefault};
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
public:
	#pragma option push -w-inl
	/* TProChannel.Destroy */ inline __fastcall virtual ~TChannel(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TRGBCanvas;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRGBCanvas : public Graphics::TCanvas 
{
	typedef Graphics::TCanvas inherited;
	
private:
	HBITMAP FBitmap;
	
public:
	__fastcall TRGBCanvas(HBITMAP AChannel);
	__fastcall virtual ~TRGBCanvas(void);
};

#pragma pack(pop)

class DELPHICLASS TRGBChannel;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRGBChannel : public TProChannel 
{
	typedef TProChannel inherited;
	
private:
	HBITMAP FHandle;
	TRGBCanvas* FCanvas;
	virtual void __fastcall Activate(void);
	virtual void __fastcall Deactivate(void);
	void __fastcall AlphaChannelFrame(const Windows::TRect &AClip, const Windows::TRect &RGBArea, TChannel* 
		AAlphaChannel);
	
public:
	__fastcall virtual TRGBChannel(void);
	__property HBITMAP Handle = {read=FHandle, nodefault};
	__property TRGBCanvas* Canvas = {read=FCanvas};
	void __fastcall Luminosity(Shortint ALuminosity);
	void __fastcall LuminosityRect(const Windows::TRect &AClip, Shortint ALuminosity);
	void __fastcall WhiteAlphaChannel(const Windows::TRect &AClip, const Windows::TPoint &APos, TChannel* 
		AAlphaChannel);
	void __fastcall ColorAlphaChannel(const Windows::TRect &AClip, const Windows::TPoint &APos, Graphics::TColor 
		AColor, TChannel* AAlphaChannel, Byte AAlpha);
	void __fastcall ColorChannel(const Windows::TRect &AClip, const Windows::TPoint &APos, TChannel* AColorChannel
		, Byte AAlpha);
	void __fastcall AlphaColorChannel(const Windows::TRect &AClip, const Windows::TPoint &APos, TChannel* 
		AColorChannel, TChannel* AAlphaChannel, Byte AAlpha);
	void __fastcall AlphaChannelAlign(const Windows::TRect &AClip, const Windows::TRect &ARect, Graphics::TColor 
		AColor, TChannel* AAlphaChannel, TChannelAlign AAlign);
public:
	#pragma option push -w-inl
	/* TProChannel.Destroy */ inline __fastcall virtual ~TRGBChannel(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TClipChannel;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TClipChannel : public TRGBChannel 
{
	typedef TRGBChannel inherited;
	
private:
	_RGNDATA *FRegions;
	int FRegMem;
	Windows::TRect *FRects;
	HRGN FRegion;
	bool FDrawMode;
	
public:
	bool __fastcall Resize(const Windows::TPoint &ANewSize);
	__fastcall virtual ~TClipChannel(void);
	void __fastcall Invalidate(const Windows::TRect &ARect);
	void __fastcall InvalidateAll(void);
	bool __fastcall DrawBegin(void);
	void __fastcall DrawEnd(void);
	HIDESBASE void __fastcall Luminosity(Shortint ALuminosity);
	HIDESBASE void __fastcall WhiteAlphaChannel(const Windows::TPoint &APos, TChannel* AAlphaChannel);
	HIDESBASE void __fastcall ColorAlphaChannel(const Windows::TPoint &APos, Graphics::TColor AColor, TChannel* 
		AAlphaChannel, Byte AAlpha);
	HIDESBASE void __fastcall ColorChannel(const Windows::TPoint &APos, TChannel* AColorChannel, Byte AAlpha
		);
	HIDESBASE void __fastcall AlphaColorChannel(const Windows::TPoint &APos, TChannel* AColorChannel, TChannel* 
		AAlphaChannel, Byte AAlpha);
	HIDESBASE void __fastcall AlphaChannelAlign(const Windows::TRect &ARect, Graphics::TColor AColor, TChannel* 
		AAlphaChannel, TChannelAlign AAlign);
public:
	#pragma option push -w-inl
	/* TRGBChannel.Create */ inline __fastcall virtual TClipChannel(void) : TRGBChannel() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS EChannelError;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION EChannelError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EChannelError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EChannelError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EChannelError(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EChannelError(int Ident, const System::TVarRec * Args
		, const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EChannelError(const AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EChannelError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EChannelError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EChannelError(int Ident, const System::TVarRec * 
		Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EChannelError(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE Windows::TRect __fastcall AlignRect(const Windows::TRect &ARect, const Windows::TPoint 
	&ASize, TAligns AAlign);

}	/* namespace Channels */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Channels;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Channels
