//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "GifLZW.hpp"
#include "TIFLZW.hpp"
#include "ImageEnIO.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "ImageEnIO"
#pragma link "ImageEnProc"
#pragma link "ImageEnView"
#pragma link "VideoCap"
#pragma link "ImageEnIO"
#pragma link "ImageEnProc"
#pragma link "ImageEnView"
#pragma link "VideoCap"
#pragma link "IEOpenSaveDlg"
#pragma link "IEVect"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void TForm1::DisplayVideoSize()
{
	TRect r=ImageEnVideoView1->GetVideoSize();
	Label6->Caption=IntToStr(int(r.Right+1))+'x'+IntToStr(int(r.Bottom+1));
}
//---------------------------------------------------------------------------
// Input ON
void __fastcall TForm1::SpeedButton2Click(TObject *Sender)
{
 	ImageEnVideoView1->ShowVideo=SpeedButton2->Down;
	Button1->Enabled=!SpeedButton2->Down;
   Button2->Enabled=!SpeedButton2->Down;
 	DisplayVideoSize();
}
//---------------------------------------------------------------------------
// overlay
void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
	if( CheckBox1->Checked )
		ImageEnVideoView1->DisplayMode=dmOverlay;
   else
		ImageEnVideoView1->DisplayMode=dmPreview;
}
//---------------------------------------------------------------------------
// Freeze
void __fastcall TForm1::SpeedButton1Click(TObject *Sender)
{
	ImageEnVideoView1->Frozen=SpeedButton1->Down;
}
//---------------------------------------------------------------------------
// Color adjust
void __fastcall TForm1::Button1Click(TObject *Sender)
{
	ImageEnProc1->DoPreviews(ppeColorAdjust);
}
//---------------------------------------------------------------------------
// Effects
void __fastcall TForm1::Button2Click(TObject *Sender)
{
	ImageEnProc1->DoPreviews(ppeEffects);
}
//---------------------------------------------------------------------------
// Configure source
void __fastcall TForm1::Button5Click(TObject *Sender)
{
	if( !ImageEnVideoView1->DoConfigureSource() )
		MessageDlg("Configure Source dialog not available",mtInformation,TMsgDlgButtons() << mbOK,0);
   else
   	DisplayVideoSize();
}
//---------------------------------------------------------------------------
// Configure Format
void __fastcall TForm1::Button6Click(TObject *Sender)
{
   if( !ImageEnVideoView1->DoConfigureFormat() )
	   MessageDlg("Configure Format dialog not available",mtInformation, TMsgDlgButtons() << mbOK,0);
   else
   	DisplayVideoSize();
}
//---------------------------------------------------------------------------
// Configure display
void __fastcall TForm1::Button7Click(TObject *Sender)
{
   if( !ImageEnVideoView1->DoConfigureDisplay() )
	   MessageDlg("Configure Display dialog not available",mtInformation, TMsgDlgButtons() << mbOK,0);
   else
   	DisplayVideoSize();
}
//---------------------------------------------------------------------------
// Frames to ImageEnView1 (Activate button)
void __fastcall TForm1::SpeedButton5Click(TObject *Sender)
{
	if (SpeedButton5->Down)
		ImageEnVideoView1->OnVideoFrame=ImageEnVideoView1VideoFrame;
   else
   	ImageEnVideoView1->OnVideoFrame=0;
}
//---------------------------------------------------------------------------
// Frames to ImageEnView1 - OnVideoFrame
void __fastcall TForm1::ImageEnVideoView1VideoFrame(TObject *Sender,
      Graphics::TBitmap *Bitmap)
{
	ImageEnView1->Assign(Bitmap);
   switch( ComboBox1->ItemIndex ) {
   	case 1:
      	ImageEnProc2->ConvertToBWOrdered();
         break;
      case 2:
      	ImageEnProc2->ConvertToBWThreshold(-1);
         break;
      case 3:
      	ImageEnProc2->ConvertToGray();
         break;
	}
}
//---------------------------------------------------------------------------
// Save as...
void __fastcall TForm1::Button11Click(TObject *Sender)
{
	if( SaveImageEnDialog1->Execute() )
   	ImageEnIO1->SaveToFile(SaveImageEnDialog1->FileName);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
   DefGIF_LZWDECOMPFUNC=GIFLZWDecompress;
   DefGIF_LZWCOMPFUNC=GIFLZWCompress;
   DefTIFF_LZWDECOMPFUNC=TIFFLZWDecompress;
   DefTIFF_LZWCOMPFUNC=TIFFLZWCompress;
   ComboBox1->ItemIndex=0;
   Edit1->Text=ImageEnVideoView1->RecFileName;
   UpDown1->Position=short(ImageEnVideoView1->RecFrameRate);
   UpDown2->Max=short(ImageEnVideoView1->VideoSourceList->Count-1);
}
//---------------------------------------------------------------------------
// record
void __fastcall TForm1::SpeedButton6Click(TObject *Sender)
{
	if( SpeedButton6->Down ) {
   	ImageEnVideoView1->RecFileName=Edit1->Text;
      ImageEnVideoView1->RecFrameRate=UpDown1->Position;
		ImageEnVideoView1->StartRecord();
   } else
   	ImageEnVideoView1->StopRecord();
}
//---------------------------------------------------------------------------
// Compression
void __fastcall TForm1::Button8Click(TObject *Sender)
{
	ImageEnVideoView1->DoConfigureCompression();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ImageEnVideoView1Job(TObject *Sender, TIEJob job,
      int per)
{
	switch( job ) {
   	case iejNOTHING:
      	Label8->Caption="";
         break;
		case iejVIDEOCAP_CONNECTING:
      	Label8->Caption="Connecting...";
         break;
	}
   Application->ProcessMessages();
}
//---------------------------------------------------------------------------
// Video input
void __fastcall TForm1::UpDown2Click(TObject *Sender, TUDBtnType Button)
{
	if( ImageEnVideoView1->VideoSource!=UpDown2->Position)
		ImageEnVideoView1->VideoSource=UpDown2->Position;
}
//---------------------------------------------------------------------------

