// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ImageEnIO.pas' rev: 4.00

#ifndef ImageEnIOHPP
#define ImageEnIOHPP

#pragma delphiheader begin
#pragma option push -w-
#include <ietwain.hpp>	// Pascal unit
#include <hyieutils.hpp>	// Pascal unit
#include <hyiedefs.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <ImageEnProc.hpp>	// Pascal unit
#include <ImageEnView.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Imageenio
{
//-- type declarations -------------------------------------------------------
#pragma pack(push, 4)
struct TStreamJpegHeader
{
	char ID[5];
	int dim;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
struct PCXSHead
{
	char ID[5];
	int dim;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
struct TIFFSHead
{
	char ID[5];
	int dim;
} ;
#pragma pack(pop)

#pragma option push -b-
enum ImageEnIO__1 { ppALL, ppAUTO, ppJPEG, ppTIFF, ppGIF, ppBMP, ppPCX, ppPNG, ppTGA };
#pragma option pop

typedef Set<ImageEnIO__1, ppALL, ppTGA>  TPreviewParams;

typedef void __fastcall (*TGIFLZWCompFunc)(Classes::TStream* Stream, int Height, int Width, bool Interlaced
	, char * FData, int BitsPerPixel);

typedef void __fastcall (*TGIFLZWDecompFunc)(Classes::TStream* Stream, int Height, int Width, bool Interlaced
	, char * FData);

typedef Windows::PByte __fastcall (*TTIFFLZWDecompFunc)(Windows::PByte CompBuf, int LineSize, int &Id
	);

typedef void __fastcall (*TTIFFLZWCompFunc)(Windows::PByte indata, int inputlen, Classes::TStream* outstream
	, int &id);

#pragma option push -b-
enum TIOPreviewsParamsItems { ioppDefaultLockPreview };
#pragma option pop

typedef Set<TIOPreviewsParamsItems, ioppDefaultLockPreview, ioppDefaultLockPreview>  TIOPreviewsParams
	;

#pragma option push -b-
enum TIOTIFFCompression { ioTIFF_UNCOMPRESSED, ioTIFF_CCITT1D, ioTIFF_G3FAX1D, ioTIFF_G3FAX2D, ioTIFF_G4FAX, 
	ioTIFF_LZW, ioTIFF_OLDJPEG, ioTIFF_JPEG, ioTIFF_PACKBITS };
#pragma option pop

#pragma option push -b-
enum TIOTIFFPhotometInterpret { ioTIFF_WHITEISZERO, ioTIFF_BLACKISZERO, ioTIFF_RGB, ioTIFF_RGBPALETTE, 
	ioTIFF_TRANSPMASK, ioTIFF_CMYK, ioTIFF_YCBCR, ioTIFF_CIELAB };
#pragma option pop

#pragma option push -b-
enum TIOJPEGColorspace { ioJPEG_RGB, ioJPEG_GRAYLEV, ioJPEG_YCbCr, ioJPEG_CMYK, ioJPEG_YCbCrK };
#pragma option pop

#pragma option push -b-
enum TIOJPEGDctMethod { ioJPEG_ISLOW, ioJPEG_IFAST, ioJPEG_FLOAT };
#pragma option pop

#pragma option push -b-
enum TIOJPEGScale { ioJPEG_AUTOCALC, ioJPEG_FULLSIZE, ioJPEG_HALF, ioJPEG_QUARTER, ioJPEG_EIGHTH };
#pragma option pop

#pragma option push -b-
enum TIOBMPVersion { ioBMP_BM, ioBMP_BM3, ioBMP_BMOS2V1, ioBMP_BMOS2V2 };
#pragma option pop

#pragma option push -b-
enum TIOBMPCompression { ioBMP_UNCOMPRESSED, ioBMP_RLE };
#pragma option pop

#pragma option push -b-
enum TIOPCXCompression { ioPCX_UNCOMPRESSED, ioPCX_RLE };
#pragma option pop

#pragma option push -b-
enum TIOPNGFilter { ioPNG_FILTER_NONE, ioPNG_FILTER_SUB, ioPNG_FILTER_PAETH };
#pragma option pop

typedef int TIOFileType;

class DELPHICLASS TIOParamsVals;
class DELPHICLASS TImageEnIO;
class DELPHICLASS TIETWainParams;
#pragma pack(push, 4)
struct TIEDRect
{
	double Left;
	double Top;
	double Right;
	double Bottom;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
struct TIETWSourceCaps
{
	Hyieutils::TIEDoubleList* fXResolution;
	Hyieutils::TIEDoubleList* fYResolution;
	Hyieutils::TIEDoubleList* fXScaling;
	Hyieutils::TIEDoubleList* fYScaling;
	Hyieutils::TIEIntegerList* fPixelType;
	double fGamma;
	double fPhysicalHeight;
	double fPhysicalWidth;
	bool fFeederEnabled;
	Hyieutils::TIEIntegerList* fOrientation;
	bool fIndicators;
	TIEDRect fAcquireFrame;
	bool fBufferedTransfer;
	bool fDuplexEnabled;
	bool fAcquireFrameEnabled;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
struct TIETWainShared
{
	unsigned hDSMLib;
	Ietwain::DSMENTRYPROC DSM_Entry;
	HWND hproxy;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TIETWainParams : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TComponent* fOwner;
	bool fVisibleDialog;
	Classes::TList* fSourceListData;
	int fSelectedSource;
	bool fSourceListDataValid;
	bool fCapabilitiesValid;
	TIETWSourceCaps fCapabilities;
	AnsiString fAppVersionInfo;
	AnsiString fAppManufacturer;
	AnsiString fAppProductFamily;
	AnsiString fAppProductName;
	void __fastcall FillSourceListData(void);
	void __fastcall FillCapabilities(void);
	AnsiString __fastcall GetSourceName(int idx);
	int __fastcall GetSourceCount(void);
	Hyieutils::TIEDoubleList* __fastcall GetXResolution(void);
	Hyieutils::TIEDoubleList* __fastcall GetYResolution(void);
	Hyieutils::TIEDoubleList* __fastcall GetXScaling(void);
	Hyieutils::TIEDoubleList* __fastcall GetYScaling(void);
	Hyieutils::TIEIntegerList* __fastcall GetPixelType(void);
	double __fastcall GetGamma(void);
	double __fastcall GetPhysicalHeight(void);
	double __fastcall GetPhysicalWidth(void);
	bool __fastcall GetFeederEnabled(void);
	Hyieutils::TIEIntegerList* __fastcall GetOrientation(void);
	void __fastcall SetSelectedSource(int v);
	bool __fastcall GetIndicators(void);
	void __fastcall SetFeederEnabled(bool v);
	void __fastcall SetIndicators(bool v);
	double __fastcall GetAcquireFrame(int idx);
	void __fastcall SetAcquireFrame(int idx, double v);
	bool __fastcall GetBufferedTransfer(void);
	void __fastcall SetBufferedTransfer(bool v);
	void __fastcall SetAppVersionInfo(AnsiString v);
	void __fastcall SetAppManufacturer(AnsiString v);
	void __fastcall SetAppProductFamily(AnsiString v);
	void __fastcall SetAppProductName(AnsiString v);
	void __fastcall SetDuplexEnabled(bool v);
	bool __fastcall GetDuplexEnabled(void);
	void __fastcall SetAcquireFrameEnabled(bool v);
	bool __fastcall GetAcquireFrameEnabled(void);
	
public:
	TIETWainShared TWainShared;
	__property bool VisibleDialog = {read=fVisibleDialog, write=fVisibleDialog, nodefault};
	__property AnsiString SourceName[int idx] = {read=GetSourceName};
	__property int SourceCount = {read=GetSourceCount, nodefault};
	__property int SelectedSource = {read=fSelectedSource, write=SetSelectedSource, nodefault};
	__property Hyieutils::TIEDoubleList* XResolution = {read=GetXResolution};
	__property Hyieutils::TIEDoubleList* YResolution = {read=GetYResolution};
	__property Hyieutils::TIEDoubleList* XScaling = {read=GetXScaling};
	__property Hyieutils::TIEDoubleList* YScaling = {read=GetYScaling};
	__property Hyieutils::TIEIntegerList* PixelType = {read=GetPixelType};
	__property double Gamma = {read=GetGamma};
	__property double PhysicalHeight = {read=GetPhysicalHeight};
	__property double PhysicalWidth = {read=GetPhysicalWidth};
	__property bool FeederEnabled = {read=GetFeederEnabled, write=SetFeederEnabled, nodefault};
	__property Hyieutils::TIEIntegerList* Orientation = {read=GetOrientation};
	__property bool ProgressIndicators = {read=GetIndicators, write=SetIndicators, nodefault};
	__property double AcquireFrameLeft = {read=GetAcquireFrame, write=SetAcquireFrame, index=0};
	__property double AcquireFrameTop = {read=GetAcquireFrame, write=SetAcquireFrame, index=1};
	__property double AcquireFrameRight = {read=GetAcquireFrame, write=SetAcquireFrame, index=2};
	__property double AcquireFrameBottom = {read=GetAcquireFrame, write=SetAcquireFrame, index=3};
	__property bool BufferedTransfer = {read=GetBufferedTransfer, write=SetBufferedTransfer, nodefault}
		;
	__property bool DuplexEnabled = {read=GetDuplexEnabled, write=SetDuplexEnabled, nodefault};
	__property bool AcquireFrameEnabled = {read=GetAcquireFrameEnabled, write=SetAcquireFrameEnabled, nodefault
		};
	__property AnsiString AppVersionInfo = {read=fAppVersionInfo, write=SetAppVersionInfo};
	__property AnsiString AppManufacturer = {read=fAppManufacturer, write=SetAppManufacturer};
	__property AnsiString AppProductFamily = {read=fAppProductFamily, write=SetAppProductFamily};
	__property AnsiString AppProductName = {read=fAppProductName, write=SetAppProductName};
	__fastcall TIETWainParams(Classes::TComponent* Owner);
	__fastcall virtual ~TIETWainParams(void);
	void __fastcall SetDefaultParams(void);
	void __fastcall Assign(TIETWainParams* Source);
	bool __fastcall SelectSourceByName(const AnsiString sn);
	int __fastcall GetDefaultSource(void);
	void __fastcall Update(void);
};

#pragma pack(pop)

typedef void __fastcall (__closure *TIEIOPreviewEvent)(System::TObject* Sender, Forms::TForm* PreviewForm
	);

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TImageEnIO : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Graphics::TBitmap* fBitmap;
	Imageenview::TIEView* fImageEnView;
	Extctrls::TImage* fTImage;
	Graphics::TColor fBackground;
	Hyiedefs::TMsgLanguage fMsgLanguage;
	TIOPreviewsParams fPreviewsParams;
	TIETWainParams* fTwainParams;
	bool fStreamHeaders;
	Graphics::TFont* fPreviewFont;
	TIEIOPreviewEvent fOnIOPreview;
	void __fastcall SetAttachedBitmap(Graphics::TBitmap* atBitmap);
	void __fastcall SetAttachedImageEn(Imageenview::TIEView* atImageEn);
	Graphics::TColor __fastcall GetReBackground(void);
	void __fastcall SetReBackground(Graphics::TColor v);
	void __fastcall Clear(void);
	void __fastcall SetPreviewFont(Graphics::TFont* f);
	void __fastcall SetTImage(Extctrls::TImage* v);
	void __fastcall SetIOPreviewParams(TIOPreviewsParams v);
	TIOPreviewsParams __fastcall GetIOPreviewParams(void);
	
protected:
	TIOParamsVals* fParams;
	bool fAborting;
	Hyiedefs::TIEProgressEvent fOnProgress;
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	void __fastcall OnBitmapChange(System::TObject* Sender, bool destroying);
	
public:
	__fastcall virtual TImageEnIO(Classes::TComponent* Owner);
	__fastcall virtual ~TImageEnIO(void);
	__property Graphics::TBitmap* AttachedBitmap = {read=fBitmap, write=SetAttachedBitmap};
	void __fastcall Update(void);
	bool __fastcall DoPreviews(TPreviewParams pp);
	__property Graphics::TBitmap* Bitmap = {read=fBitmap, write=fBitmap};
	__property TIOParamsVals* Params = {read=fParams};
	void __fastcall AssignParams(System::TObject* Source);
	void __fastcall SaveToFileJpeg(const AnsiString nf);
	void __fastcall LoadFromFileJpeg(const AnsiString nf);
	void __fastcall SaveToStreamJpeg(Classes::TStream* Stream);
	void __fastcall LoadFromStreamJpeg(Classes::TStream* Stream);
	int __fastcall LoadFromFileGif(const AnsiString nf);
	void __fastcall SaveToFileGif(const AnsiString nf);
	int __fastcall InsertToFileGif(const AnsiString nf);
	int __fastcall LoadFromStreamGif(Classes::TStream* Stream);
	void __fastcall SaveToStreamGif(Classes::TStream* Stream);
	void __fastcall SaveToStreamPCX(Classes::TStream* Stream);
	void __fastcall LoadFromStreamPCX(Classes::TStream* Stream);
	void __fastcall SaveToFilePCX(const AnsiString nf);
	void __fastcall LoadFromFilePCX(const AnsiString nf);
	int __fastcall LoadFromStreamTIFF(Classes::TStream* Stream);
	void __fastcall SaveToStreamTIFF(Classes::TStream* Stream);
	int __fastcall LoadFromFileTIFF(const AnsiString nf);
	void __fastcall SaveToFileTIFF(const AnsiString nf);
	int __fastcall InsertToFileTIFF(const AnsiString nf);
	void __fastcall SaveToStreamBMP(Classes::TStream* Stream);
	void __fastcall LoadFromStreamBMP(Classes::TStream* Stream);
	void __fastcall SaveToFileBMP(const AnsiString nf);
	void __fastcall LoadFromFileBMP(const AnsiString nf);
	void __fastcall LoadFromFileICO(const AnsiString nf);
	void __fastcall LoadFromStreamICO(Classes::TStream* Stream);
	void __fastcall LoadFromFileCUR(const AnsiString nf);
	void __fastcall LoadFromStreamCUR(Classes::TStream* Stream);
	void __fastcall LoadFromFilePNG(const AnsiString nf);
	void __fastcall LoadFromStreamPNG(Classes::TStream* Stream);
	void __fastcall SaveToFilePNG(const AnsiString nf);
	void __fastcall SaveToStreamPNG(Classes::TStream* Stream);
	void __fastcall LoadFromFileTGA(const AnsiString nf);
	void __fastcall LoadFromStreamTGA(Classes::TStream* Stream);
	void __fastcall SaveToFileTGA(const AnsiString nf);
	void __fastcall SaveToStreamTGA(Classes::TStream* Stream);
	void __fastcall ImportMetafile(const AnsiString nf, int Width, int Height);
	void __fastcall LoadFromFilePXM(const AnsiString nf);
	void __fastcall LoadFromStreamPXM(Classes::TStream* Stream);
	void __fastcall SaveToFilePXM(const AnsiString nf);
	void __fastcall SaveToStreamPXM(Classes::TStream* Stream);
	DYNAMIC void __fastcall LoadFromFile(const AnsiString nf);
	DYNAMIC void __fastcall SaveToFile(const AnsiString nf);
	DYNAMIC void __fastcall LoadFromFileFormat(const AnsiString nf, int FileFormat);
	__property bool Aborting = {read=fAborting, write=fAborting, nodefault};
	DYNAMIC void __fastcall ParamsFromFile(const AnsiString nf);
	DYNAMIC void __fastcall ParamsFromFileFormat(const AnsiString nf, int format);
	DYNAMIC void __fastcall ParamsFromStream(Classes::TStream* Stream);
	DYNAMIC void __fastcall ParamsFromStreamFormat(Classes::TStream* Stream, int format);
	DYNAMIC void __fastcall LoadFromStream(Classes::TStream* Stream);
	DYNAMIC void __fastcall LoadFromStreamFormat(Classes::TStream* Stream, int FileFormat);
	DYNAMIC void __fastcall SaveToStream(Classes::TStream* Stream, int FileType);
	bool __fastcall Acquire(void);
	bool __fastcall SelectAcquireSource(void);
	__property TIETWainParams* TWainParams = {read=fTwainParams};
	
__published:
	__property Imageenview::TIEView* AttachedImageEn = {read=fImageEnView, write=SetAttachedImageEn};
	__property Graphics::TColor Background = {read=GetReBackground, write=SetReBackground, default=0};
	__property Hyiedefs::TIEProgressEvent OnProgress = {read=fOnProgress, write=fOnProgress};
	__property Hyiedefs::TMsgLanguage MsgLanguage = {read=fMsgLanguage, write=fMsgLanguage, default=0};
		
	__property TIOPreviewsParams PreviewsParams = {read=GetIOPreviewParams, write=SetIOPreviewParams, default=0
		};
	__property bool StreamHeaders = {read=fStreamHeaders, write=fStreamHeaders, default=0};
	__property Graphics::TFont* PreviewFont = {read=fPreviewFont, write=SetPreviewFont};
	__property Extctrls::TImage* AttachedTImage = {read=fTImage, write=SetTImage};
	__property TIEIOPreviewEvent OnIOPreview = {read=fOnIOPreview, write=fOnIOPreview};
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TIOParamsVals : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TImageEnIO* fImageEnIO;
	int fBitsPerSample;
	int fSamplesPerPixel;
	int fWidth;
	int fHeight;
	int fDpiX;
	int fDpiY;
	int fFileType;
	TIOTIFFCompression fTIFF_Compression;
	int fTIFF_ImageIndex;
	TIOTIFFPhotometInterpret fTIFF_PhotometInterpret;
	int fTIFF_PlanarConf;
	int fTIFF_XPos;
	int fTIFF_YPos;
	AnsiString fTIFF_DocumentName;
	AnsiString fTIFF_ImageDescription;
	AnsiString fTIFF_PageName;
	int fTIFF_PageNumber;
	int fTIFF_PageCount;
	TTIFFLZWDecompFunc fTIFF_LZWDecompFunc;
	TTIFFLZWCompFunc fTIFF_LZWCompFunc;
	AnsiString fGIF_Version;
	int fGIF_ImageIndex;
	int fGIF_XPos;
	int fGIF_YPos;
	int fGIF_DelayTime;
	bool fGIF_FlagTranspColor;
	Hyiedefs::TRGB fGIF_TranspColor;
	bool fGIF_Interlaced;
	int fGIF_WinWidth;
	int fGIF_WinHeight;
	Hyiedefs::TRGB fGIF_Background;
	int fGIF_Ratio;
	TGIFLZWDecompFunc fGIF_LZWDecompFunc;
	TGIFLZWCompFunc fGIF_LZWCompFunc;
	TIOJPEGColorspace fJPEG_ColorSpace;
	int fJPEG_Quality;
	TIOJPEGDctMethod fJPEG_DCTMethod;
	bool fJPEG_OptimalHuffman;
	int fJPEG_Smooth;
	bool fJPEG_Progressive;
	TIOJPEGScale fJPEG_Scale;
	Hyieutils::TIEMarkerList* fJPEG_MarkerList;
	int fPCX_Version;
	TIOPCXCompression fPCX_Compression;
	TIOBMPVersion fBMP_Version;
	TIOBMPCompression fBMP_Compression;
	int fICO_ImageIndex;
	Hyiedefs::TRGB fICO_Background;
	int fCUR_ImageIndex;
	int fCUR_XHotSpot;
	int fCUR_YHotSpot;
	Hyiedefs::TRGB fCUR_Background;
	bool fPNG_Interlaced;
	Hyiedefs::TRGB fPNG_Background;
	TIOPNGFilter fPNG_Filter;
	int fPNG_Compression;
	int fTGA_XPos;
	int fTGA_YPos;
	bool fTGA_Compressed;
	AnsiString fTGA_Descriptor;
	AnsiString fTGA_Author;
	System::TDateTime fTGA_Date;
	AnsiString fTGA_ImageName;
	Hyiedefs::TRGB fTGA_Background;
	double fTGA_AspectRatio;
	double fTGA_Gamma;
	bool fTGA_GrayLevel;
	Hyieutils::TIEIPTCInfoList* fIPTC_Info;
	Classes::TStringList* fPXM_Comments;
	AnsiString __fastcall GetFileTypeStr();
	
public:
	AnsiString fFileName;
	Hyiedefs::TRGB *fColorMap;
	int fColorMapCount;
	int fGIF_ImageCount;
	int fTIFF_ImageCount;
	__property AnsiString FileName = {read=fFileName};
	__property AnsiString FileTypeStr = {read=GetFileTypeStr};
	__property int FileType = {read=fFileType, write=fFileType, nodefault};
	__property int BitsPerSample = {read=fBitsPerSample, write=fBitsPerSample, nodefault};
	__property int SamplesPerPixel = {read=fSamplesPerPixel, write=fSamplesPerPixel, nodefault};
	__property int Width = {read=fWidth, write=fWidth, nodefault};
	__property int Height = {read=fHeight, write=fHeight, nodefault};
	__property int DpiX = {read=fDpiX, write=fDpiX, nodefault};
	__property int DpiY = {read=fDpiY, write=fDpiY, nodefault};
	__property Hyiedefs::pRGBROW ColorMap = {read=fColorMap};
	__property int ColorMapCount = {read=fColorMapCount, nodefault};
	__property Hyieutils::TIEIPTCInfoList* IPTC_Info = {read=fIPTC_Info};
	__property TIOTIFFCompression TIFF_Compression = {read=fTIFF_Compression, write=fTIFF_Compression, 
		nodefault};
	__property int TIFF_ImageIndex = {read=fTIFF_ImageIndex, write=fTIFF_ImageIndex, nodefault};
	__property int TIFF_ImageCount = {read=fTIFF_ImageCount, nodefault};
	__property TIOTIFFPhotometInterpret TIFF_PhotometInterpret = {read=fTIFF_PhotometInterpret, write=fTIFF_PhotometInterpret
		, nodefault};
	__property int TIFF_PlanarConf = {read=fTIFF_PlanarConf, write=fTIFF_PlanarConf, nodefault};
	__property int TIFF_XPos = {read=fTIFF_XPos, write=fTIFF_XPos, nodefault};
	__property int TIFF_YPos = {read=fTIFF_YPos, write=fTIFF_YPos, nodefault};
	__property AnsiString TIFF_DocumentName = {read=fTIFF_DocumentName, write=fTIFF_DocumentName};
	__property AnsiString TIFF_ImageDescription = {read=fTIFF_ImageDescription, write=fTIFF_ImageDescription
		};
	__property AnsiString TIFF_PageName = {read=fTIFF_PageName, write=fTIFF_PageName};
	__property int TIFF_PageNumber = {read=fTIFF_PageNumber, write=fTIFF_PageNumber, nodefault};
	__property int TIFF_PageCount = {read=fTIFF_PageCount, write=fTIFF_PageCount, nodefault};
	__property TTIFFLZWDecompFunc TIFF_LZWDecompFunc = {read=fTIFF_LZWDecompFunc, write=fTIFF_LZWDecompFunc
		};
	__property TTIFFLZWCompFunc TIFF_LZWCompFunc = {read=fTIFF_LZWCompFunc, write=fTIFF_LZWCompFunc};
	__property AnsiString GIF_Version = {read=fGIF_Version, write=fGIF_Version};
	__property int GIF_ImageIndex = {read=fGIF_ImageIndex, write=fGIF_ImageIndex, nodefault};
	__property int GIF_ImageCount = {read=fGIF_ImageCount, nodefault};
	__property int GIF_XPos = {read=fGIF_XPos, write=fGIF_XPos, nodefault};
	__property int GIF_YPos = {read=fGIF_YPos, write=fGIF_YPos, nodefault};
	__property int GIF_DelayTime = {read=fGIF_DelayTime, write=fGIF_DelayTime, nodefault};
	__property bool GIF_FlagTranspColor = {read=fGIF_FlagTranspColor, write=fGIF_FlagTranspColor, nodefault
		};
	__property Hyiedefs::TRGB GIF_TranspColor = {read=fGIF_TranspColor, write=fGIF_TranspColor};
	__property bool GIF_Interlaced = {read=fGIF_Interlaced, write=fGIF_Interlaced, nodefault};
	__property int GIF_WinWidth = {read=fGIF_WinWidth, write=fGIF_WinWidth, nodefault};
	__property int GIF_WinHeight = {read=fGIF_WinHeight, write=fGIF_WinHeight, nodefault};
	__property Hyiedefs::TRGB GIF_Background = {read=fGIF_Background, write=fGIF_Background};
	__property int GIF_Ratio = {read=fGIF_Ratio, write=fGIF_Ratio, nodefault};
	__property TGIFLZWDecompFunc GIF_LZWDecompFunc = {read=fGIF_LZWDecompFunc, write=fGIF_LZWDecompFunc
		};
	__property TGIFLZWCompFunc GIF_LZWCompFunc = {read=fGIF_LZWCompFunc, write=fGIF_LZWCompFunc};
	__property TIOJPEGColorspace JPEG_ColorSpace = {read=fJPEG_ColorSpace, write=fJPEG_ColorSpace, nodefault
		};
	__property int JPEG_Quality = {read=fJPEG_Quality, write=fJPEG_Quality, nodefault};
	__property TIOJPEGDctMethod JPEG_DCTMethod = {read=fJPEG_DCTMethod, write=fJPEG_DCTMethod, nodefault
		};
	__property bool JPEG_OptimalHuffman = {read=fJPEG_OptimalHuffman, write=fJPEG_OptimalHuffman, nodefault
		};
	__property int JPEG_Smooth = {read=fJPEG_Smooth, write=fJPEG_Smooth, nodefault};
	__property bool JPEG_Progressive = {read=fJPEG_Progressive, write=fJPEG_Progressive, nodefault};
	__property TIOJPEGScale JPEG_Scale = {read=fJPEG_Scale, write=fJPEG_Scale, nodefault};
	__property Hyieutils::TIEMarkerList* JPEG_MarkerList = {read=fJPEG_MarkerList};
	__property int PCX_Version = {read=fPCX_Version, write=fPCX_Version, nodefault};
	__property TIOPCXCompression PCX_Compression = {read=fPCX_Compression, write=fPCX_Compression, nodefault
		};
	__property TIOBMPVersion BMP_Version = {read=fBMP_Version, write=fBMP_Version, nodefault};
	__property TIOBMPCompression BMP_Compression = {read=fBMP_Compression, write=fBMP_Compression, nodefault
		};
	__property int ICO_ImageIndex = {read=fICO_ImageIndex, write=fICO_ImageIndex, nodefault};
	__property Hyiedefs::TRGB ICO_Background = {read=fICO_Background, write=fICO_Background};
	__property int CUR_ImageIndex = {read=fCUR_ImageIndex, write=fCUR_ImageIndex, nodefault};
	__property int CUR_XHotSpot = {read=fCUR_XHotSpot, write=fCUR_XHotSpot, nodefault};
	__property int CUR_YHotSpot = {read=fCUR_YHotSpot, write=fCUR_YHotSpot, nodefault};
	__property Hyiedefs::TRGB CUR_Background = {read=fCUR_Background, write=fCUR_Background};
	__property bool PNG_Interlaced = {read=fPNG_Interlaced, write=fPNG_Interlaced, nodefault};
	__property Hyiedefs::TRGB PNG_Background = {read=fPNG_Background, write=fPNG_Background};
	__property TIOPNGFilter PNG_Filter = {read=fPNG_Filter, write=fPNG_Filter, nodefault};
	__property int PNG_Compression = {read=fPNG_Compression, write=fPNG_Compression, nodefault};
	__property int TGA_XPos = {read=fTGA_XPos, write=fTGA_XPos, nodefault};
	__property int TGA_YPos = {read=fTGA_YPos, write=fTGA_YPos, nodefault};
	__property bool TGA_Compressed = {read=fTGA_Compressed, write=fTGA_Compressed, nodefault};
	__property AnsiString TGA_Descriptor = {read=fTGA_Descriptor, write=fTGA_Descriptor};
	__property AnsiString TGA_Author = {read=fTGA_Author, write=fTGA_Author};
	__property System::TDateTime TGA_Date = {read=fTGA_Date, write=fTGA_Date};
	__property AnsiString TGA_ImageName = {read=fTGA_ImageName, write=fTGA_ImageName};
	__property Hyiedefs::TRGB TGA_Background = {read=fTGA_Background, write=fTGA_Background};
	__property double TGA_AspectRatio = {read=fTGA_AspectRatio, write=fTGA_AspectRatio};
	__property double TGA_Gamma = {read=fTGA_Gamma, write=fTGA_Gamma};
	__property bool TGA_GrayLevel = {read=fTGA_GrayLevel, write=fTGA_GrayLevel, nodefault};
	__property Classes::TStringList* PXM_Comments = {read=fPXM_Comments};
	__fastcall TIOParamsVals(TImageEnIO* IEIO);
	__fastcall virtual ~TIOParamsVals(void);
	void __fastcall SetDefaultParams(void);
	void __fastcall Assign(TIOParamsVals* Source);
	void __fastcall SaveToFile(const AnsiString FileName);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall LoadFromFile(const AnsiString FileName);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
};

#pragma pack(pop)

typedef TIETWainShared *PIETWainShared;

typedef void __fastcall (*TIEReadImageStream)(Classes::TStream* Stream, Graphics::TBitmap* Bitmap, TIOParamsVals* 
	&IOParams, Hyiedefs::TProgressRec &Progress, bool Preview);

typedef void __fastcall (*TIEWriteImageStream)(Classes::TStream* Stream, Graphics::TBitmap* Bitmap, 
	TIOParamsVals* &IOParams, Hyiedefs::TProgressRec &Progress);

typedef bool __fastcall (*TIETryImageStream)(Classes::TStream* Stream);

#pragma pack(push, 4)
struct TIEFileFormatInfo
{
	int FileType;
	System::SmallString<80>  FullName;
	System::SmallString<80>  Extensions;
	TIEReadImageStream ReadFunction;
	TIEWriteImageStream WriteFunction;
	TIETryImageStream TryFunction;
} ;
#pragma pack(pop)

typedef TIEFileFormatInfo *PIEFileFormatInfo;

//-- var, const, procedure ---------------------------------------------------
static const Shortint ioUnknown = 0x0;
static const Shortint ioTIFF = 0x1;
static const Shortint ioGIF = 0x2;
static const Shortint ioJPEG = 0x3;
static const Shortint ioPCX = 0x4;
static const Shortint ioBMP = 0x5;
static const Shortint ioICO = 0x6;
static const Shortint ioCUR = 0x7;
static const Shortint ioPNG = 0x8;
static const Shortint ioWMF = 0x9;
static const Shortint ioEMF = 0xa;
static const Shortint ioTGA = 0xb;
static const Shortint ioPXM = 0xc;
static const Word ioUSER = 0x2710;
static const Byte JPEG_APP0 = 0xe0;
static const Byte JPEG_APP1 = 0xe1;
static const Byte JPEG_APP2 = 0xe2;
static const Byte JPEG_APP3 = 0xe3;
static const Byte JPEG_APP4 = 0xe4;
static const Byte JPEG_APP5 = 0xe5;
static const Byte JPEG_APP6 = 0xe6;
static const Byte JPEG_APP7 = 0xe7;
static const Byte JPEG_APP8 = 0xe8;
static const Byte JPEG_APP9 = 0xe9;
static const Byte JPEG_APP10 = 0xea;
static const Byte JPEG_APP11 = 0xeb;
static const Byte JPEG_APP12 = 0xec;
static const Byte JPEG_APP13 = 0xed;
static const Byte JPEG_APP14 = 0xee;
static const Byte JPEG_APP15 = 0xef;
static const Byte JPEG_COM = 0xfe;
extern PACKAGE TGIFLZWDecompFunc DefGIF_LZWDECOMPFUNC;
extern PACKAGE TGIFLZWCompFunc DefGIF_LZWCOMPFUNC;
extern PACKAGE TTIFFLZWDecompFunc DefTIFF_LZWDECOMPFUNC;
extern PACKAGE TTIFFLZWCompFunc DefTIFF_LZWCOMPFUNC;
extern PACKAGE Classes::TList* iegFileFormats;
extern PACKAGE int __fastcall DeleteGifIm(const AnsiString nf, int idx);
extern PACKAGE int __fastcall DeleteTIFFIm(const AnsiString nf, int idx);
extern PACKAGE int __fastcall EnumGifIm(const AnsiString nf);
extern PACKAGE int __fastcall EnumTIFFIm(const AnsiString nf);
extern PACKAGE bool __fastcall CheckAniGif(const AnsiString nf);
extern PACKAGE int __fastcall FindFileFormat(const AnsiString nf, bool VerifyExtension);
extern PACKAGE int __fastcall FindStreamFormat(Classes::TStream* fs);
extern PACKAGE PIEFileFormatInfo __fastcall IEFileFormatGetInfo(int FileType);
extern PACKAGE int __fastcall IEFileFormatGetExtCount(int FileType);
extern PACKAGE AnsiString __fastcall IEFileFormatGetExt(int FileType, int idx);
extern PACKAGE PIEFileFormatInfo __fastcall IEFileFormatGetInfo2(AnsiString Extension);
extern PACKAGE void __fastcall IEFileFormatAdd(const TIEFileFormatInfo &FileFormatInfo);
extern PACKAGE void __fastcall IEFileFormatRemove(int FileType);

}	/* namespace Imageenio */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Imageenio;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ImageEnIO
