//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "GifLZW.hpp"
#include "TIFLZW.hpp"
#include "ImageEnIO.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "IEVect"
#pragma link "ImageEnIO"
#pragma link "ImageEnProc"
#pragma link "ImageEnView"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
   DefGIF_LZWDECOMPFUNC=GIFLZWDecompress;
   DefGIF_LZWCOMPFUNC=GIFLZWCompress;
   DefTIFF_LZWDECOMPFUNC=TIFFLZWDecompress;
   DefTIFF_LZWCOMPFUNC=TIFFLZWCompress;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
	ctrlch=false;
	ComboBox3->ItemIndex=1;
   ComboBox4->ItemIndex=0;
   ComboBox5->ItemIndex=0;
	ComboBox6->ItemIndex=0;
   ComboBox7->ItemIndex=0;
   ComboBox4Change(this);
   ComboBox2->ItemIndex=4;
   ComboBox2Change(this);
   //
   ImageEnVect1->SelColor1=clWhite;
   ImageEnVect1->SelColor2=clRed;
   ImageEnVect1->MeasureTrack=true;
   //
   ImageEnProc1->ImageResize(526,543);
   //
   ImageEnView1->Assign( ImageEnVect1->ObjBitmap[-1] );
   ImageEnView1->Fit();
}
//---------------------------------------------------------------------------
// Object properties (controls change)
void __fastcall TForm1::ComboBox4Change(TObject *Sender)
{
	const TBrushStyle BS[8]={bsSolid,bsClear,bsBDiagonal,bsFDiagonal,bsCross,bsDiagCross,bsHorizontal,bsVertical};
	const TPenStyle PS[7]={psSolid, psDash, psDot, psDashDot, psDashDotDot, psClear, psInsideFrame};
	const TIEShape SH[3]={iesNONE,iesINARROW,iesOUTARROW};
   const TAlignment TA[3]={taLeftJustify, taRightJustify, taCenter};
	if(ctrlch) return;
	int obj=-1;	// -1 is next object (new object to insert)
   for(int q=-1; q<ImageEnVect1->SelObjectsCount;q++) {
      if(q>=0)
         obj=ImageEnVect1->SelObjects[q];
      ImageEnVect1->SetObjFont(obj,FontDialog1->Font);
      ImageEnVect1->ObjPenColor[obj]=Panel3->Color;
      ImageEnVect1->ObjBrushColor[obj]=Panel4->Color;
      ImageEnVect1->ObjBrushStyle[obj]=BS[ ComboBox3->ItemIndex ];
      ImageEnVect1->ObjPenStyle[obj]=PS[ ComboBox4->ItemIndex ];
      ImageEnVect1->ObjPenWidth[obj]=StrToIntDef(Edit2->Text,1);
      ImageEnVect1->ObjBeginShape[obj]=SH[ ComboBox5->ItemIndex ];
      ImageEnVect1->ObjEndShape[obj]=SH[ ComboBox6->ItemIndex ];
      ImageEnVect1->ObjFontAngle[obj]=StrToIntDef(Edit6->Text,0);
      ImageEnVect1->ObjTextAlign[obj]=TA[ ComboBox7->ItemIndex ];
   }
}
//---------------------------------------------------------------------------
// Measures unit / Scale / Digits / Precision
void __fastcall TForm1::ComboBox2Change(TObject *Sender)
{
   ImageEnVect1->MUnit=TIEUnits( ComboBox2->ItemIndex );
   ImageEnVect1->ScaleFactor=StrToIntDef(Edit1->Text,1);
   ImageEnVect1->FloatDigits=StrToIntDef(Edit3->Text,2);
   ImageEnVect1->FloatPrecision=StrToIntDef(Edit4->Text,15);
}
//---------------------------------------------------------------------------
// File->Exit
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
// File->New
void __fastcall TForm1::NewClick(TObject *Sender)
{
	ImageEnProc1->Clear();
	ImageEnVect1->RemoveAllObjects();
}
//---------------------------------------------------------------------------
// Speedbuttons click (Zoom,Selection,Measures,Objects)
void __fastcall TForm1::SpeedButton1Click(TObject *Sender)
{
   // SET MouseInteract and MouseInteractVt
   // Zoom
   if (Sender==SpeedButton1 && SpeedButton1->Down) ImageEnVect1->MouseInteract=ImageEnVect1->MouseInteract << miZoom;
   if (Sender==SpeedButton4 && SpeedButton4->Down) ImageEnVect1->MouseInteract=ImageEnVect1->MouseInteract << miSelectZoom;
   if (Sender==SpeedButton8 && SpeedButton8->Down) ImageEnVect1->MouseInteract=ImageEnVect1->MouseInteract << miScroll;
   // Selection
   if (Sender==SpeedButton13 && SpeedButton13->Down) ImageEnVect1->MouseInteractVt=ImageEnVect1->MouseInteractVt << miObjectSelect;
   if (Sender==SpeedButton7 && SpeedButton7->Down) ImageEnVect1->MouseInteract=ImageEnVect1->MouseInteract << miSelect;
   if (Sender==SpeedButton11 && SpeedButton11->Down) ImageEnVect1->MouseInteract=ImageEnVect1->MouseInteract << miSelectPolygon;
   if (Sender==SpeedButton12 && SpeedButton12->Down) ImageEnVect1->MouseInteract=ImageEnVect1->MouseInteract << miSelectCircle;
   // Measures
   if (Sender==SpeedButton2 && SpeedButton2->Down) ImageEnVect1->MouseInteractVt=ImageEnVect1->MouseInteractVt << miArea;
   if (Sender==SpeedButton3 && SpeedButton3->Down) ImageEnVect1->MouseInteractVt=ImageEnVect1->MouseInteractVt << miLineLen;
   // Insert objects
   if (Sender==SpeedButton5 && SpeedButton5->Down) ImageEnVect1->MouseInteractVt=ImageEnVect1->MouseInteractVt << miPutLine;
   if (Sender==SpeedButton6 && SpeedButton6->Down) ImageEnVect1->MouseInteractVt=ImageEnVect1->MouseInteractVt << miPutBox;
   if (Sender==SpeedButton9 && SpeedButton9->Down) ImageEnVect1->MouseInteractVt=ImageEnVect1->MouseInteractVt << miPutEllipse;
   if (Sender==SpeedButton10 && SpeedButton10->Down) ImageEnVect1->MouseInteractVt=ImageEnVect1->MouseInteractVt << miPutBitmap;
   if (Sender==SpeedButton14 && SpeedButton14->Down) ImageEnVect1->MouseInteractVt=ImageEnVect1->MouseInteractVt << miPutText;
   // SET Buttons
   SpeedButton1->Down= ImageEnVect1->MouseInteract.Contains(miZoom);
   SpeedButton4->Down= ImageEnVect1->MouseInteract.Contains(miSelectZoom);
   SpeedButton8->Down= ImageEnVect1->MouseInteract.Contains(miScroll);
   SpeedButton13->Down= ImageEnVect1->MouseInteractVt.Contains(miObjectSelect);
   SpeedButton7->Down= ImageEnVect1->MouseInteract.Contains(miSelect);
   SpeedButton11->Down= ImageEnVect1->MouseInteract.Contains(miSelectPolygon);
   SpeedButton12->Down= ImageEnVect1->MouseInteract.Contains(miSelectCircle);
   SpeedButton2->Down= ImageEnVect1->MouseInteractVt.Contains(miArea);
   SpeedButton3->Down= ImageEnVect1->MouseInteractVt.Contains(miLineLen);
   SpeedButton5->Down= ImageEnVect1->MouseInteractVt.Contains(miPutLine);
   SpeedButton6->Down= ImageEnVect1->MouseInteractVt.Contains(miPutBox);
   SpeedButton9->Down= ImageEnVect1->MouseInteractVt.Contains(miPutEllipse);
   SpeedButton10->Down= ImageEnVect1->MouseInteractVt.Contains(miPutBitmap);
   SpeedButton14->Down= ImageEnVect1->MouseInteractVt.Contains(miPutText);
   // Cancell selection
   if ( !ImageEnVect1->MouseInteract.Contains(miSelect) && !ImageEnVect1->MouseInteract.Contains(miSelectPolygon)
      && !ImageEnVect1->MouseInteract.Contains(miSelectCircle) )
      ImageEnVect1->DeSelect();
}
//---------------------------------------------------------------------------
// Pen color
void __fastcall TForm1::Panel3Click(TObject *Sender)
{
	ColorDialog1->Color=Panel3->Color;
   if(ColorDialog1->Execute())
   	Panel3->Color=ColorDialog1->Color;
	ComboBox4Change(this);
}
//---------------------------------------------------------------------------
// Brush color
void __fastcall TForm1::Panel4Click(TObject *Sender)
{
	ColorDialog1->Color=Panel4->Color;
   if(ColorDialog1->Execute())
   	Panel4->Color=ColorDialog1->Color;
	ComboBox4Change(this);
}
//---------------------------------------------------------------------------
// Object (or multi-object) selection
void __fastcall TForm1::ImageEnVect1SelectObject(TObject *Sender)
{
	// load properties to "Object properties"
   ctrlch=true;
	int obj=-1;	// -1 is next object (new object to insert)
   for(int q=-1; q<ImageEnVect1->SelObjectsCount;q++) {
      if(q>=0)
         obj=ImageEnVect1->SelObjects[q];
      Panel3->Color=ImageEnVect1->ObjPenColor[obj];
      Panel4->Color=ImageEnVect1->ObjBrushColor[obj];
      Edit2->Text=IntToStr( ImageEnVect1->ObjPenWidth[obj] );
      ComboBox3->ItemIndex=int( ImageEnVect1->ObjBrushStyle[obj] );
      ComboBox4->ItemIndex=int( ImageEnVect1->ObjPenStyle[obj] );
      ComboBox5->ItemIndex=int( ImageEnVect1->ObjBeginShape[obj] );
      ComboBox6->ItemIndex=int( ImageEnVect1->ObjEndShape[obj] );
      FontDialog1->Font->Name=ImageEnVect1->ObjFontName[obj];
      FontDialog1->Font->Height=ImageEnVect1->ObjFontHeight[obj];
      FontDialog1->Font->Style=ImageEnVect1->ObjFontStyles[obj];
      Edit6->Text=FloatToStr(ImageEnVect1->ObjFontAngle[obj]);
      ComboBox7->ItemIndex=int( ImageEnVect1->ObjTextAlign[obj] );
 	}
   ctrlch=false;
}
//---------------------------------------------------------------------------
// File->Open
void __fastcall TForm1::Open1Click(TObject *Sender)
{
	OpenDialog1->Filter="ImageEn Objects|*.IEV";
   OpenDialog1->DefaultExt='IEV';
	if(OpenDialog1->Execute())
   	ImageEnVect1->LoadFromFileIEV( OpenDialog1->FileName );
}
//---------------------------------------------------------------------------
// File->SaveAs
void __fastcall TForm1::Saveas1Click(TObject *Sender)
{
	if(SaveDialog1->Execute())
   	ImageEnVect1->SaveToFileIEV( SaveDialog1->FileName );
}
//---------------------------------------------------------------------------
// File->Import->DXF
void __fastcall TForm1::DXF1Click(TObject *Sender)
{
	OpenDialog1->Filter="AutoCAD DXF|*.DXF";
   OpenDialog1->DefaultExt="DXF";
	if(OpenDialog1->Execute())
   	ImageEnVect1->ImportDXF( OpenDialog1->FileName );
}
//---------------------------------------------------------------------------
// properties- zoom
void __fastcall TForm1::ComboBox1Change(TObject *Sender)
{
	if(ComboBox1->Text=="Fit")
   	ImageEnVect1->Fit();
   else
		ImageEnVect1->Zoom=StrToIntDef( ComboBox1->Text,100 );
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ImageEnVect1ViewChange(TObject *Sender, int Change)
{
	if(Change==0)
		ComboBox1->Text=IntToStr(ImageEnVect1->Zoom);
}
//---------------------------------------------------------------------------
// Tools->OpenBackgroundImage
void __fastcall TForm1::Openbackgroundimage1Click(TObject *Sender)
{
	OpenDialog1->Filter="All (JPG;PNG;BMP;PCX;GIF;TIF;ICO;CUR)|*.jpg;*.png;*.bmp;*.pcx;*.gif;*.tif;*.wmf;*.emf;*.ico;*.cur";
   OpenDialog1->DefaultExt="JPG";
	if(OpenDialog1->Execute()) {
   	ImageEnIO1->AttachedImageEn=ImageEnVect1;
   	ImageEnIO1->LoadFromFile( OpenDialog1->FileName );
      ImageEnIO1->AttachedImageEn=NULL;
   }
}
//---------------------------------------------------------------------------
// Tools->AdjustColor
void __fastcall TForm1::Adjustcolor1Click(TObject *Sender)
{
	ImageEnProc1->DoPreviews(ppeColorAdjust);
}
//---------------------------------------------------------------------------
// Tools->Effetcs
void __fastcall TForm1::Effects1Click(TObject *Sender)
{
	ImageEnProc1->DoPreviews(ppeEffects);
}
//---------------------------------------------------------------------------
// Set image
void __fastcall TForm1::Button1Click(TObject *Sender)
{
	Graphics::TBitmap* tmpBitmap;
	OpenDialog1->Filter="All (JPG;PNG;BMP;PCX;GIF;TIF;ICO;CUR)|*.jpg;*.png;*.bmp;*.pcx;*.gif;*.tif;*.wmf;*.emf;*.ico;*.cur";
   OpenDialog1->DefaultExt="JPG";
	if(OpenDialog1->Execute()) {
   	tmpBitmap=new Graphics::TBitmap;
   	ImageEnIO1->AttachedBitmap=tmpBitmap;
   	ImageEnIO1->LoadFromFile( OpenDialog1->FileName );
      ImageEnVect1->ObjBitmap[-1]=tmpBitmap;
      ImageEnIO1->AttachedBitmap=NULL;
      delete tmpBitmap;
	   ImageEnView1->Assign( ImageEnVect1->ObjBitmap[-1] );
	   ImageEnView1->Fit();
   }
}
//---------------------------------------------------------------------------
// Adjust image
void __fastcall TForm1::Button2Click(TObject *Sender)
{
	// find first iekBITMAP object
   for(int q=0; q<ImageEnVect1->SelObjectsCount;q++)
      if(ImageEnVect1->ObjKind[ ImageEnVect1->SelObjects[q] ]==iekBITMAP) {
         ImageEnProc2->AttachedBitmap=ImageEnVect1->ObjBitmap[ ImageEnVect1->SelObjects[q] ];
         ImageEnProc2->DoPreviews(TPreviewEffects() << peAll);
         ImageEnVect1->Update();
         break;
      }
}
//---------------------------------------------------------------------------
// Edit->Undo
void __fastcall TForm1::Undo1Click(TObject *Sender)
{
	ImageEnProc1->Undo();
}
//---------------------------------------------------------------------------
// Edit->Copy
void __fastcall TForm1::Copy1Click(TObject *Sender)
{
	ImageEnProc1->SelCopyToClip();
}
//---------------------------------------------------------------------------
// Edit->Cut
void __fastcall TForm1::Cut1Click(TObject *Sender)
{
	ImageEnProc1->SelCutToClip();
}
//---------------------------------------------------------------------------
// Edit->Paste
void __fastcall TForm1::Paste1Click(TObject *Sender)
{
	ImageEnProc1->PasteFromClipboard();
}
//---------------------------------------------------------------------------
// Edit->PasteInRect
void __fastcall TForm1::Pasteinrect1Click(TObject *Sender)
{
	ImageEnProc1->SelPasteFromClipStretch();
}
//---------------------------------------------------------------------------
// Delete object
void __fastcall TForm1::Deleteobject1Click(TObject *Sender)
{
	while(ImageEnVect1->SelObjectsCount>0)
   	ImageEnVect1->RemoveObject( ImageEnVect1->SelObjects[0] );
}
//---------------------------------------------------------------------------
// Set Font
void __fastcall TForm1::Button3Click(TObject *Sender)
{
	if(FontDialog1->Execute())
		ComboBox4Change(this);
}
//---------------------------------------------------------------------------
// Stretch
void __fastcall TForm1::Button4Click(TObject *Sender)
{
	FontDialog1->Font->Height=0;
	ComboBox4Change(this);
}
//---------------------------------------------------------------------------

