//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "GifLZW.hpp"
#include "TIFLZW.hpp"
#include "ImageEnIO.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "DBImageEn"
#pragma link "IEOpenSaveDlg"
#pragma link "ImageEnIO"
#pragma link "ImageEnProc"
#pragma link "ImageEnView"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
   DefGIF_LZWDECOMPFUNC=GIFLZWDecompress;
   DefGIF_LZWCOMPFUNC=GIFLZWCompress;
   DefTIFF_LZWDECOMPFUNC=TIFFLZWDecompress;
   DefTIFF_LZWCOMPFUNC=TIFFLZWCompress;
}
//---------------------------------------------------------------------------
// Import...
void __fastcall TForm1::Button2Click(TObject *Sender)
{
	if( OpenImageEnDialog1->Execute() )
   	ImageEnIO1->LoadFromFile(OpenImageEnDialog1->FileName);
}
//---------------------------------------------------------------------------
// Effects...
void __fastcall TForm1::Button3Click(TObject *Sender)
{
	ImageEnProc1->DoPreviews(ppeEffects);
}
//---------------------------------------------------------------------------
// Color adjust...
void __fastcall TForm1::Button7Click(TObject *Sender)
{
	ImageEnProc1->DoPreviews(ppeColorAdjust);	
}
//---------------------------------------------------------------------------
// Append
void __fastcall TForm1::NewClick(TObject *Sender)
{
	Table1->Append();
   ImageEnDBView1->DataFieldImageFormat=ifJpeg;
   ComboBox1->ItemIndex=1;
}
//---------------------------------------------------------------------------
// Post
void __fastcall TForm1::Button1Click(TObject *Sender)
{
	if( Table1->State!=dsBrowse )
		Table1->Post();
}
//---------------------------------------------------------------------------
// Del/Cancel
void __fastcall TForm1::DelClick(TObject *Sender)
{
	if (Table1->State==dsEdit || Table1->State==dsInsert)
   	Table1->Cancel();
   else
	   Table1->Delete();
}
//---------------------------------------------------------------------------
// Modify
void __fastcall TForm1::Button4Click(TObject *Sender)
{
	Table1->Edit();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
	Table1->DatabaseName=ExtractFilePath(Application->ExeName);
   Table1->Open();
}
//---------------------------------------------------------------------------
// change combobox - store format
void __fastcall TForm1::ComboBox1Change(TObject *Sender)
{
	switch( ComboBox1->ItemIndex) {
      case 0: // BMP
			ImageEnDBView1->DataFieldImageFormat=ifBitmap;
         break;
   	case 1:	// JPEG
			ImageEnDBView1->DataFieldImageFormat=ifJpeg;
         break;
      case 2: // GIF
			ImageEnDBView1->DataFieldImageFormat=ifGif;
         break;
      case 3: // PCX
      	ImageEnDBView1->DataFieldImageFormat=ifPCX;
         break;
      case 4: // TIFF
      	ImageEnDBView1->DataFieldImageFormat=ifTIFF;
         break;
      case 5: // PNG
      	ImageEnDBView1->DataFieldImageFormat=ifPNG;
         break;
      case 6: // UNKNOW
      	ImageEnDBView1->DataFieldImageFormat=ifUnknown;
         break;
   }
}
//---------------------------------------------------------------------------
// update combobox - store format
void __fastcall TForm1::Table1AfterScroll(TDataSet *DataSet)
{
	ComboBox1->ItemIndex=int(ImageEnDBView1->LoadedFieldImageFormat());	
}
//---------------------------------------------------------------------------
// Copy
void __fastcall TForm1::Button5Click(TObject *Sender)
{
	ImageEnProc1->SelCopyToClip();
}
//---------------------------------------------------------------------------
// Paste
void __fastcall TForm1::Button6Click(TObject *Sender)
{
	ImageEnProc1->PasteFromClipboard();
}
//---------------------------------------------------------------------------
// Store parameters
void __fastcall TForm1::Button8Click(TObject *Sender)
{
	ImageEnDBView1->DoIOPreview();
}
//---------------------------------------------------------------------------

