//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "GifLZW.hpp"
#include "TIFLZW.hpp"
#include "ImageEnIO.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "IEOpenSaveDlg"
#pragma link "IEMIO"
#pragma link "IEMView"
#pragma link "ImageEnView"
#pragma link "IEOpenSaveDlg"
#pragma link "ImageEnProc"
#pragma link "ImageEnIO"
#pragma link "IEMIO"
#pragma link "IEMView"
#pragma link "IEOpenSaveDlg"
#pragma link "ImageEnIO"
#pragma link "ImageEnProc"
#pragma link "ImageEnView"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
   DefGIF_LZWDECOMPFUNC=GIFLZWDecompress;
   DefGIF_LZWCOMPFUNC=GIFLZWCompress;
   DefTIFF_LZWDECOMPFUNC=TIFFLZWDecompress;
   DefTIFF_LZWCOMPFUNC=TIFFLZWCompress;
}
//---------------------------------------------------------------------------
// File->Exit
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
// File->Open
void __fastcall TForm1::Open1Click(TObject *Sender)
{
	if(OpenImageEnDialog1->Execute())
   	ImageEnMIO1->LoadFromFile(OpenImageEnDialog1->FileName);
}
//---------------------------------------------------------------------------
// Edit->Copy to clipboard
void __fastcall TForm1::Copy1Click(TObject *Sender)
{
	ImageEnProc1->CopyToClipboard();
}
//---------------------------------------------------------------------------
// Edit->Paste from clipboard
void __fastcall TForm1::Paste1Click(TObject *Sender)
{
	ImageEnProc1->PasteFromClipboard();
}
//---------------------------------------------------------------------------
// Edit->Insert blank bitmap
void __fastcall TForm1::Insert1Click(TObject *Sender)
{
   int idx=ImageEnMView1->SelectedImage;
   if(idx<0) idx=0;
   ImageEnMView1->InsertImage( idx );
	Graphics::TBitmap* tempbmp = new Graphics::TBitmap;
   tempbmp->Width=ImageEnMView1->ThumbWidth;
   tempbmp->Height=ImageEnMView1->ThumbHeight;
   tempbmp->PixelFormat=pf24bit;
   ImageEnMView1->SetImage(idx,tempbmp);
   delete tempbmp;
}
//---------------------------------------------------------------------------
// Edit->Append blank bitmap
void __fastcall TForm1::Append1Click(TObject *Sender)
{
   int idx=ImageEnMView1->AppendImage();
	Graphics::TBitmap* tempbmp = new Graphics::TBitmap;
   tempbmp->Width=ImageEnMView1->ThumbWidth;
   tempbmp->Height=ImageEnMView1->ThumbHeight;
   tempbmp->PixelFormat=pf24bit;
   ImageEnMView1->SetImage(idx,tempbmp);
   delete tempbmp;
}
//---------------------------------------------------------------------------
// Edit->Delete image
void __fastcall TForm1::Delete1Click(TObject *Sender)
{
	if(ImageEnMView1->SelectedImage>=0)
		ImageEnMView1->DeleteImage( ImageEnMView1->SelectedImage );
}
//---------------------------------------------------------------------------
// File->Import image
void __fastcall TForm1::Importimage1Click(TObject *Sender)
{
	if( OpenImageEnDialog2->Execute() )
   	ImageEnIO1->LoadFromFile( OpenImageEnDialog2->FileName );
}
//---------------------------------------------------------------------------
// Tools->Effects...
void __fastcall TForm1::Effects1Click(TObject *Sender)
{
	ImageEnProc1->DoPreviews(ppeEffects);
}
//---------------------------------------------------------------------------
// Tools->Color adjust...
void __fastcall TForm1::Coloradjust1Click(TObject *Sender)
{
	ImageEnProc1->DoPreviews(ppeColorAdjust);
}
//---------------------------------------------------------------------------
// File->SelectTWainSource
void __fastcall TForm1::SelectTWainsource1Click(TObject *Sender)
{
	ImageEnMIO1->SelectAcquireSource();
}
//---------------------------------------------------------------------------
// File->Acquire
void __fastcall TForm1::AcquireTWain1Click(TObject *Sender)
{
	ImageEnMIO1->Acquire();
}
//---------------------------------------------------------------------------
// Edit->Clear
void __fastcall TForm1::Clear1Click(TObject *Sender)
{
	if( Application->MessageBox("Are you sure?", NULL, MB_OKCANCEL) == IDOK)
		ImageEnMView1->Clear();
}
//---------------------------------------------------------------------------
// Grid columns
void __fastcall TForm1::Edit2Change(TObject *Sender)
{
	ImageEnMView1->GridWidth=StrToIntDef(Edit2->Text,0);
}
//---------------------------------------------------------------------------
// Auto
void __fastcall TForm1::CheckBox3Click(TObject *Sender)
{
	if( CheckBox3->Checked) {
   	Edit2->Enabled=false;
      ImageEnMView1->GridWidth=-1;
   } else {
   	Edit2->Enabled=true;
      ImageEnMView1->GridWidth=StrToIntDef(Edit2->Text,0);
   }
}
//---------------------------------------------------------------------------
// Play
void __fastcall TForm1::SpeedButton2Click(TObject *Sender)
{
	ImageEnMView1->Playing=SpeedButton2->Down;
}
//---------------------------------------------------------------------------
// Load as thumbnail
void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
	ImageEnMView1->StoreType= CheckBox1->Checked? ietThumb : ietNormal;
}
//---------------------------------------------------------------------------
// Show selection
void __fastcall TForm1::CheckBox2Click(TObject *Sender)
{
	ImageEnMView1->VisibleSelection=CheckBox2->Checked;
}
//---------------------------------------------------------------------------

