// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'DBFilterGrid.pas' rev: 3.00

#ifndef DBFilterGridHPP
#define DBFilterGridHPP
#include <Buttons.hpp>
#include <DBTables.hpp>
#include <Db.hpp>
#include <DBCtrls.hpp>
#include <Grids.hpp>
#include <StdCtrls.hpp>
#include <Dialogs.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Dbfiltergrid
{
//-- type declarations -------------------------------------------------------
enum TFilterColumnIndex { fciLeftArg, fciOperator, fciRightArg, fciBoolOperator };

typedef System::AnsiString TFilterColumnNames[4];

enum TFilterOperatorIndex { foiLess, foiLessOrEqual, foiEqual, foiLargerOrEqual, foiLarger, foiNotEqual, 
	foiStartingWith, foiContaining, foiLike, foiIsNull, foiIsNotNull };

typedef Set<TFilterOperatorIndex, foiLess, foiIsNotNull>  TFilterOperatorIndexes;

typedef System::AnsiString TFilterOperatorNames[11];

enum TFilterBoolIndex { fbiFalse, fbiTrue };

typedef System::AnsiString TFilterBoolNames[2];

class DELPHICLASS TDBFilterGridComboBox;
class PASCALIMPLEMENTATION TDBFilterGridComboBox : public Stdctrls::TCustomComboBox 
{
	typedef Stdctrls::TCustomComboBox inherited;
	
private:
	HIDESBASE void __fastcall SetText(void);
	void __fastcall AppendRow(void);
	void __fastcall Select(void);
	
protected:
	DYNAMIC void __fastcall Click(void);
	HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &Message);
	DYNAMIC void __fastcall DropDown(void);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	
public:
	int Col;
	int Row;
	HIDESBASE void __fastcall Show(void);
	bool __fastcall ShowPositioned(const Grids::TGridCoord &GridCoord);
	HIDESBASE void __fastcall Hide(void);
public:
	/* TCustomComboBox.Create */ __fastcall virtual TDBFilterGridComboBox(Classes::TComponent* AOwner) : 
		Stdctrls::TCustomComboBox(AOwner) { }
	/* TCustomComboBox.Destroy */ __fastcall virtual ~TDBFilterGridComboBox(void) { }
	
public:
	/* TWinControl.CreateParented */ __fastcall TDBFilterGridComboBox(HWND ParentWindow) : Stdctrls::TCustomComboBox(
		ParentWindow) { }
	
};

class DELPHICLASS TDBFilterGridSpeedButton;
class PASCALIMPLEMENTATION TDBFilterGridSpeedButton : public Buttons::TSpeedButton 
{
	typedef Buttons::TSpeedButton inherited;
	
protected:
	HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &Message);
	
public:
	int Row;
	DYNAMIC void __fastcall Click(void);
public:
	/* TSpeedButton.Create */ __fastcall virtual TDBFilterGridSpeedButton(Classes::TComponent* AOwner) : 
		Buttons::TSpeedButton(AOwner) { }
	/* TSpeedButton.Destroy */ __fastcall virtual ~TDBFilterGridSpeedButton(void) { }
	
};

enum TFilterKind { fkSimple, fkSQL };

enum TFilterGridOption { fgoCaseSensitive, fgoCaseSensitiveContaining, fgoCorrect, fgoCorrectTranslateWildcards, 
	fgoExceptions, fgoNonTableValueList, fgoStrictOperators };

typedef Set<TFilterGridOption, fgoCaseSensitive, fgoStrictOperators>  TFilterGridOptions;

class DELPHICLASS TDBFilterGrid;
class PASCALIMPLEMENTATION TDBFilterGrid : public Grids::TStringGrid 
{
	typedef Grids::TStringGrid inherited;
	
private:
	Dbctrls::TFieldDataLink* FDataLink;
	TFilterKind FFilterKind;
	int FFilterMaxDropDownCount;
	TFilterOperatorIndex FDefaultOperator;
	TDBFilterGridComboBox* ComboBox;
	bool FocusMe;
	bool SkipMouseMove;
	Dbtables::TQuery* ValueQuery;
	Graphics::TBitmap* DeleteRowBitmap;
	TDBFilterGridSpeedButton* DeleteRowButton;
	System::AnsiString FWildcards;
	System::AnsiString FTargetWildcards;
	TFilterGridOptions FFilterGridOptions;
	void __fastcall SetFilterKind(const TFilterKind Value);
	void __fastcall SetDataSource(const Db::TDataSource* Value);
	Db::TDataSource* __fastcall GetDataSource(void);
	Grids::TGridCoord __fastcall CurrentComboCell();
	void __fastcall SetFilterMaxDropDownCount(const int Value);
	System::AnsiString __fastcall GetFilterExpression();
	bool __fastcall QuotedType(const System::AnsiString FieldName);
	TFilterOperatorIndex __fastcall OperatorNameToIndex(const System::AnsiString OpName);
	TFilterOperatorIndex __fastcall OperatorNameToIndexStrict(const System::AnsiString OpName, const System::AnsiString 
		FieldName);
	System::AnsiString __fastcall OperatorIndexTOSQLOperator(const TFilterOperatorIndex Index);
	
protected:
	void __fastcall ActiveChange(System::TObject* Sender);
	bool __fastcall UnexistinqOrEmptyRow(const int ARow);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall SetParent(Controls::TWinControl* AParent);
	bool __fastcall ValidCellCoordinates(const Grids::TGridCoord &GC);
	
public:
	System::AnsiString FilterColumnNames[4];
	System::AnsiString FilterOperatorNames[11];
	System::AnsiString FilterBoolNames[2];
	__fastcall virtual TDBFilterGrid(Classes::TComponent* AOwner);
	__fastcall virtual ~TDBFilterGrid(void);
	void __fastcall Clear(void);
	bool __fastcall DeleteOrClearRow(const int Row);
	__property System::AnsiString FilterExpression = {read=GetFilterExpression};
	
__published:
	__property Db::TDataSource* DataSource = {read=GetDataSource, write=SetDataSource};
	__property TFilterKind FilterKind = {read=FFilterKind, write=SetFilterKind, nodefault};
	__property int FilterMaxDropDownCount = {read=FFilterMaxDropDownCount, write=SetFilterMaxDropDownCount
		, nodefault};
	__property TFilterOperatorIndex DefaultOperator = {read=FDefaultOperator, write=FDefaultOperator, nodefault
		};
	__property System::AnsiString Wildcards = {read=FWildcards, write=FWildcards};
	__property System::AnsiString TargetWildcards = {read=FTargetWildcards, write=FTargetWildcards};
	__property TFilterGridOptions FilterGridOptions = {read=FFilterGridOptions, write=FFilterGridOptions
		, nodefault};
public:
	/* TWinControl.CreateParented */ __fastcall TDBFilterGrid(HWND ParentWindow) : Grids::TStringGrid(ParentWindow
		) { }
	
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE TFilterOperatorIndexes AllFilterOperatorIndexes;
extern PACKAGE TFilterOperatorIndexes SimpleFilterOperatorIndexes;
extern PACKAGE TFilterOperatorIndexes UnquotedFilterOperatorIndexes;
extern PACKAGE System::AnsiString fcnSerbian[4];
extern PACKAGE System::AnsiString fcnEnglish[4];
extern PACKAGE System::AnsiString fonSerbian[11];
extern PACKAGE System::AnsiString fonEnglish[11];
extern PACKAGE System::AnsiString fonComputer[11];
extern PACKAGE System::AnsiString fbnSerbian[2];
extern PACKAGE System::AnsiString fbnEnglish[2];
extern PACKAGE System::AnsiString fbnComputer[2];
extern PACKAGE void __fastcall Register(void);

}	/* namespace Dbfiltergrid */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Dbfiltergrid;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// DBFilterGrid
