unit BDEForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBFieldComboBox, DBLocateEdit, ComCtrls,
  Grids, DBGrids, ExtCtrls,
  DBGridTitleSort, DBSortComboBox, Mask, DBFilterGrid, DBTables,
  Db, DBCtrls;

type
  TfrmBDE = class(TForm)
    dsCustomer: TDataSource;
    PageControl1: TPageControl;
    tsLocate: TTabSheet;
    StatusBar1: TStatusBar;
    PageControl2: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Panel1: TPanel;
    Panel2: TPanel;
    dblSVCustimerNumber: TDBLocateEdit;
    Label1: TLabel;
    Label5: TLabel;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    Panel3: TPanel;
    Label3: TLabel;
    cmbChooseField: TDBFieldComboBox;
    Label4: TLabel;
    dblField: TDBLocateEdit;
    Panel4: TPanel;
    Label2: TLabel;
    dblCustomerIncremental: TDBLocateEdit;
    DBGrid3: TDBGrid;
    DBNavigator3: TDBNavigator;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    TabSheet7: TTabSheet;
    Label7: TLabel;
    dblCustomerEnter: TDBLocateEdit;
    PageControl3: TPageControl;
    TabSheet8: TTabSheet;
    Panel5: TPanel;
    TabSheet9: TTabSheet;
    Panel6: TPanel;
    DBNavigator4: TDBNavigator;
    dbgTitleClick: TDBGrid;
    DBGridTitleSort1: TDBGridTitleSort;
    Panel7: TPanel;
    Label8: TLabel;
    cmbChooseSortField: TDBSortComboBox;
    DBGrid5: TDBGrid;
    DBNavigator5: TDBNavigator;
    TabSheet10: TTabSheet;
    Panel8: TPanel;
    Label9: TLabel;
    Label10: TLabel;
    DBSortComboBox2: TDBSortComboBox;
    dbgSortSynchronize1: TDBGrid;
    DBNavigator6: TDBNavigator;
    Splitter1: TSplitter;
    dbgSortSynchronize2: TDBGrid;
    TabSheet11: TTabSheet;
    Panel9: TPanel;
    Label11: TLabel;
    Label12: TLabel;
    DBSortComboBox3: TDBSortComboBox;
    DBSortComboBox4: TDBSortComboBox;
    GroupBox1: TGroupBox;
    Splitter2: TSplitter;
    GroupBox2: TGroupBox;
    dsSales: TDataSource;
    DBNavigator7: TDBNavigator;
    DBNavigator8: TDBNavigator;
    dbgSortSlave: TDBGrid;
    Label6: TLabel;
    Label13: TLabel;
    dblSVCustomer: TDBLocateEdit;
    dblSVContactFirst: TDBLocateEdit;
    dblSVContactLast: TDBLocateEdit;
    Panel10: TPanel;
    PageControl4: TPageControl;
    TabSheet12: TTabSheet;
    Panel11: TPanel;
    Label14: TLabel;
    Label15: TLabel;
    DBSortComboBox5: TDBSortComboBox;
    DBLocateEdit6: TDBLocateEdit;
    dbgSortLocate: TDBGrid;
    DBNavigator9: TDBNavigator;
    TabSheet13: TTabSheet;
    gbMaster: TGroupBox;
    gbSlave: TGroupBox;
    Splitter3: TSplitter;
    pnlMaster: TPanel;
    Label16: TLabel;
    Label17: TLabel;
    DBSortComboBox6: TDBSortComboBox;
    DBLocateEdit7: TDBLocateEdit;
    pnlSlave: TPanel;
    Label18: TLabel;
    Label19: TLabel;
    DBSortComboBox7: TDBSortComboBox;
    DBLocateEdit8: TDBLocateEdit;
    DBNavigator10: TDBNavigator;
    DBNavigator11: TDBNavigator;
    dbgSortLocateMaster: TDBGrid;
    dbgSortLocateSlave: TDBGrid;
    Panel14: TPanel;
    PageControl5: TPageControl;
    TabSheet14: TTabSheet;
    TabSheet15: TTabSheet;
    Panel15: TPanel;
    Panel16: TPanel;
    Panel17: TPanel;
    btnFilter: TButton;
    memSimpleFilter: TMemo;
    dbgSimpleFiltered: TDBGrid;
    DBNavigator12: TDBNavigator;
    Splitter4: TSplitter;
    dbfSimple: TDBFilterGrid;
    btnClear: TButton;
    Panel18: TPanel;
    Panel19: TPanel;
    Panel20: TPanel;
    btnRunQuery: TButton;
    memSQLFilter: TMemo;
    DBNavigator13: TDBNavigator;
    DBGrid4: TDBGrid;
    Splitter5: TSplitter;
    dsFilter: TDataSource;
    chkCaseSensitive: TCheckBox;
    Panel21: TPanel;
    dbfSQL: TDBFilterGrid;
    Panel22: TPanel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    DB: TDatabase;
    tCustomer: TTable;
    tSales: TTable;
    qFilter: TQuery;
    dbgSortMaster: TDBGrid;
    procedure FormShow(Sender: TObject);
    procedure dbgTitleClickTitleClick(Column: TColumn);
    procedure btnFilterClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure chkCaseSensitiveClick(Sender: TObject);
    procedure btnRunQueryClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmBDE: TfrmBDE;

implementation

{$R *.DFM}

procedure TfrmBDE.FormShow(Sender: TObject);
begin
  ShowMessage('Before proceeding be sure IBLocal alias is set-up and InterBase is running.');
  DB.Connected := true;
  tCustomer.Open;
  tSales.Open;
  // We intentionally don't set AutoRegister to arForm.
  DBGridTitleSort1.RegisterGrids([
    dbgTitleClick,dbgSortSynchronize1,dbgSortSynchronize2,
    dbgSortMaster,dbgSortSlave,
    dbgSortLocate,dbgSortLocateMaster,dbgSortLocateSlave
  ]);
end;

procedure TfrmBDE.dbgTitleClickTitleClick(Column: TColumn);
begin
  DBGridTitleSort1.Execute(Column)
end;

procedure TfrmBDE.btnFilterClick(Sender: TObject);
var
  Tmp: string;
begin
  Tmp := dbfSimple.FilterExpression;
  memSimpleFilter.Lines.Text := Tmp;
  with dbgSimpleFiltered.DataSource.DataSet do
  begin
    Filter := Tmp;
    Filtered := true
  end
end;

procedure TfrmBDE.btnClearClick(Sender: TObject);
begin
  dbfSimple.Clear;
  memSimpleFilter.Clear;
  dbgSimpleFiltered.DataSource.DataSet.Filtered := false
end;

procedure TfrmBDE.chkCaseSensitiveClick(Sender: TObject);
begin
  if (Sender as TCheckBox).Checked then
    dbfSQL.FilterGridOptions := dbfSQL.FilterGridOptions + [fgoCaseSensitive]
  else
    dbfSQL.FilterGridOptions := dbfSQL.FilterGridOptions - [fgoCaseSensitive]
end;

procedure TfrmBDE.btnRunQueryClick(Sender: TObject);
var
  Select,Where: string;
begin
  Select := 'SELECT * FROM Customer';
  Where := dbfSQL.FilterExpression;
  if not (Where = '') then
    Select := Select + ' WHERE ' + Where;
  memSQLFilter.Lines.Text := Select;
  qFilter.SQL.Text := Select;
  qFilter.Open
end;

end.
