// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'AdvGrid.pas' rev: 4.00

#ifndef AdvGridHPP
#define AdvGridHPP

#pragma delphiheader begin
#pragma option push -w-
#include <Mask.hpp>	// Pascal unit
#include <asgdd.hpp>	// Pascal unit
#include <ImgList.hpp>	// Pascal unit
#include <ActiveX.hpp>	// Pascal unit
#include <WinSpool.hpp>	// Pascal unit
#include <ComObj.hpp>	// Pascal unit
#include <ShellAPI.hpp>	// Pascal unit
#include <OleCtnrs.hpp>	// Pascal unit
#include <Registry.hpp>	// Pascal unit
#include <Commctrl.hpp>	// Pascal unit
#include <RichEdit.hpp>	// Pascal unit
#include <asgcombo.hpp>	// Pascal unit
#include <AdvObj.hpp>	// Pascal unit
#include <ComCtrls.hpp>	// Pascal unit
#include <ASGEdit.hpp>	// Pascal unit
#include <asgspin.hpp>	// Pascal unit
#include <IniFiles.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <AdvUtil.hpp>	// Pascal unit
#include <Buttons.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Printers.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Clipbrd.hpp>	// Pascal unit
#include <Grids.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Advgrid
{
//-- type declarations -------------------------------------------------------
typedef bool TBoolArray[257];

typedef bool *PBoolArray;

typedef short TWidthArray[257];

class DELPHICLASS EAdvGridError;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION EAdvGridError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EAdvGridError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EAdvGridError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EAdvGridError(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EAdvGridError(int Ident, const System::TVarRec * Args
		, const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EAdvGridError(const AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EAdvGridError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EAdvGridError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EAdvGridError(int Ident, const System::TVarRec * 
		Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EAdvGridError(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TEditorType { edNormal, edSpinEdit, edComboEdit, edComboList, edEditBtn, edCheckBox, edDateEdit, 
	edDateEditUpDown, edTimeEdit, edButton, edDataCheckBox, edNumeric, edPositiveNumeric, edFloat, edCapital, 
	edMixedCase, edPassword, edUnitEditBtn, edLowerCase, edUpperCase, edFloatSpinEdit, edTimeSpinEdit, 
	edDateSpinEdit, edNumericEditBtn, edFloatEditBtn, edCustom, edRichEdit };
#pragma option pop

typedef void __fastcall (__closure *TGetEditorTypeEvent)(System::TObject* Sender, int ACol, int ARow
	, TEditorType &AEditor);

typedef void __fastcall (__closure *TEllipsClickEvent)(System::TObject* Sender, int ACol, int ARow, 
	AnsiString &S);

typedef void __fastcall (__closure *TButtonClickEvent)(System::TObject* Sender, int ACol, int ARow);
	

typedef void __fastcall (__closure *TCheckBoxClickEvent)(System::TObject* Sender, int ACol, int ARow
	, bool State);

typedef void __fastcall (__closure *TRadioClickEvent)(System::TObject* Sender, int ACol, int ARow, int 
	AIdx);

typedef void __fastcall (__closure *TComboChangeEvent)(System::TObject* Sender, int ACol, int ARow, 
	int AItemIndex, AnsiString ASelection);

typedef void __fastcall (__closure *TComboObjectChangeEvent)(System::TObject* Sender, int ACol, int 
	ARow, int AItemIndex, AnsiString ASelection, System::TObject* AObject);

typedef void __fastcall (__closure *TSpinClickEvent)(System::TObject* Sender, int ACol, int ARow, int 
	AValue, bool UpDown);

typedef void __fastcall (__closure *TFloatSpinClickEvent)(System::TObject* Sender, int ACol, int ARow
	, double AValue, bool UpDown);

typedef void __fastcall (__closure *TDateTimeSpinClickEvent)(System::TObject* Sender, int ACol, int 
	ARow, System::TDateTime AValue, bool UpDown);

#pragma option push -b-
enum TScrollHintType { shNone, shVertical, shHorizontal, shBoth };
#pragma option pop

#pragma option push -b-
enum TSortStyle { ssAutomatic, ssAlphabetic, ssNumeric, ssDate, ssAlphaNoCase, ssAlphaCase, ssShortDateEU, 
	ssShortDateUS, ssCustom, ssFinancial, ssAnsiAlphaCase, ssAnsiAlphaNoCase, ssRaw, ssHTML, ssImages }
	;
#pragma option pop

#pragma option push -b-
enum TPrintPosition { ppNone, ppTopLeft, ppTopRight, ppTopCenter, ppBottomLeft, ppBottomRight, ppBottomCenter 
	};
#pragma option pop

#pragma option push -b-
enum TPrintBorders { pbNoborder, pbSingle, pbDouble, pbVertical, pbHorizontal, pbAround, pbAroundVertical, 
	pbAroundHorizontal, pbCustom };
#pragma option pop

#pragma option push -b-
enum TCellBorder { cbTop, cbLeft, cbRight, cbBottom };
#pragma option pop

typedef Set<TCellBorder, cbTop, cbBottom>  TCellBorders;

#pragma option push -b-
enum TPrintMethod { prPreview, prPrint, prCalcPrint, prCalcPreview };
#pragma option pop

#pragma option push -b-
enum TSortDirection { sdAscending, sdDescending };
#pragma option pop

#pragma option push -b-
enum TAdvanceDirection { adLeftRight, adTopBottom };
#pragma option pop

#pragma option push -b-
enum TIntelliPan { ipVertical, ipHorizontal, ipBoth, ipNone };
#pragma option pop

#pragma option push -b-
enum TInsertPosition { pInsertBefore, pInsertAfter };
#pragma option pop

#pragma option push -b-
enum TScrollType { ssNormal, ssFlat, ssEncarta };
#pragma option pop

#pragma option push -b-
enum TVAlignment { vtaCenter, vtaTop, vtaBottom };
#pragma option pop

#pragma option push -b-
enum TGridLook { glStandard, glSoft };
#pragma option pop

typedef void __fastcall (__closure *TCanInsertRowEvent)(System::TObject* Sender, int ARow, bool &CanInsert
	);

typedef void __fastcall (__closure *TAutoInsertRowEvent)(System::TObject* Sender, int ARow);

typedef void __fastcall (__closure *TCanAddRowEvent)(System::TObject* Sender, bool &CanAdd);

typedef void __fastcall (__closure *TAutoAddRowEvent)(System::TObject* Sender, int ARow);

typedef void __fastcall (__closure *TCanDeleteRowEvent)(System::TObject* Sender, int ARow, bool &CanDelete
	);

typedef void __fastcall (__closure *TAutoDeleteRowEvent)(System::TObject* Sender, int ARow);

typedef void __fastcall (__closure *TAutoInsertColEvent)(System::TObject* Sender, int ACol);

typedef void __fastcall (__closure *TGridProgressEvent)(System::TObject* Sender, short progress);

typedef void __fastcall (__closure *TClipboardEvent)(System::TObject* Sender, bool &Allow);

typedef void __fastcall (__closure *TClickSortEvent)(System::TObject* Sender, int ACol);

typedef void __fastcall (__closure *TCanSortEvent)(System::TObject* Sender, int ACol, bool &DoSort);
	

typedef void __fastcall (__closure *TNodeClickEvent)(System::TObject* Sender, int ARow, int ARowreal
	);

typedef void __fastcall (__closure *TCustomCompareEvent)(System::TObject* Sender, AnsiString str1, AnsiString 
	str2, int &Res);

typedef void __fastcall (__closure *TRawCompareEvent)(System::TObject* Sender, int Col, int Row1, int 
	Row2, int &Res);

typedef void __fastcall (__closure *TGridFormatEvent)(System::TObject* Sender, int ACol, TSortStyle 
	&AStyle, AnsiString &aPrefix, AnsiString &aSuffix);

typedef void __fastcall (__closure *TGridColorEvent)(System::TObject* Sender, int ARow, int ACol, Grids::TGridDrawState 
	AState, Graphics::TBrush* ABrush, Graphics::TFont* AFont);

typedef void __fastcall (__closure *TGridBorderEvent)(System::TObject* Sender, int ARow, int ACol, Graphics::TPen* 
	APen, TCellBorders &Borders);

typedef void __fastcall (__closure *TGridAlignEvent)(System::TObject* Sender, int ARow, int ACol, Classes::TAlignment 
	&AAlignment);

typedef void __fastcall (__closure *TGridHintEvent)(System::TObject* Sender, int ARow, int ACol, AnsiString 
	&hintstr);

typedef void __fastcall (__closure *TOleDragDropEvent)(System::TObject* Sender, int ARow, int ACol, 
	AnsiString data, bool &Allow);

typedef void __fastcall (__closure *TOleDragOverEvent)(System::TObject* Sender, int ARow, int ACol, 
	bool &Allow);

typedef void __fastcall (__closure *TOleDragStartEvent)(System::TObject* Sender, int ARow, int ACol)
	;

typedef void __fastcall (__closure *TOleDragStopEvent)(System::TObject* Sender, int OLEEffect);

typedef void __fastcall (__closure *TOleDropColEvent)(System::TObject* Sender, int ARow, int ACol, int 
	DropCol);

typedef void __fastcall (__closure *TOleDroppedEvent)(System::TObject* Sender, const Grids::TGridRect 
	&ARect);

typedef void __fastcall (__closure *TRowChangingEvent)(System::TObject* Sender, int OldRow, int NewRow
	, bool &Allow);

typedef void __fastcall (__closure *TColChangingEvent)(System::TObject* Sender, int OldCol, int NewCol
	, bool &Allow);

typedef void __fastcall (__closure *TCellChangingEvent)(System::TObject* Sender, int OldRow, int OldCol
	, int NewRow, int NewCol, bool &Allow);

typedef void __fastcall (__closure *TScrollHintEvent)(System::TObject* Sender, int ARow, AnsiString 
	&hintstr);

typedef void __fastcall (__closure *TGridPrintPageEvent)(System::TObject* Sender, Graphics::TCanvas* 
	Canvas, int PageNr, int PageXSize, int PageYSize);

typedef void __fastcall (__closure *TGridPrintStartEvent)(System::TObject* Sender, int NrOfPages, int 
	&FromPage, int &ToPage);

typedef void __fastcall (__closure *TGridPrintPageDoneEvent)(System::TObject* Sender, Graphics::TCanvas* 
	Canvas, int LastRow, int LastRowOffset, int LastPage, int PageXSize, int PageYSize);

typedef void __fastcall (__closure *TGridPrintNewPageEvent)(System::TObject* Sender, int ARow, bool 
	&NewPage);

typedef void __fastcall (__closure *TGridPrintColumnWidthEvent)(System::TObject* Sender, int ACol, int 
	&Width);

typedef void __fastcall (__closure *TGridPrintRowHeightEvent)(System::TObject* Sender, int ARow, int 
	&Height);

typedef void __fastcall (__closure *TOnResizeEvent)(System::TObject* Sender);

typedef void __fastcall (__closure *TColumnSizeEvent)(System::TObject* Sender, int ACol, bool &Allow
	);

typedef void __fastcall (__closure *TRowSizeEvent)(System::TObject* Sender, int ARow, bool &Allow);

typedef void __fastcall (__closure *TEndColumnSizeEvent)(System::TObject* Sender, int ACol);

typedef void __fastcall (__closure *TEndRowSizeEvent)(System::TObject* Sender, int ARow);

typedef void __fastcall (__closure *TClickCellEvent)(System::TObject* Sender, int ARow, int ACol);

typedef void __fastcall (__closure *TDblClickCellEvent)(System::TObject* Sender, int ARow, int ACol)
	;

typedef void __fastcall (__closure *TCanEditCellEvent)(System::TObject* Sender, int ARow, int ACol, 
	bool &CanEdit);

typedef void __fastcall (__closure *TIsFixedCellEvent)(System::TObject* Sender, int ARow, int ACol, 
	bool &IsFixed);

typedef void __fastcall (__closure *TIsPasswordCellEvent)(System::TObject* Sender, int ARow, int ACol
	, bool &IsPassword);

typedef void __fastcall (__closure *TAnchorClickEvent)(System::TObject* Sender, int ARow, int ACol, 
	AnsiString Anchor, bool &AutoHandle);

typedef void __fastcall (__closure *TAnchorEvent)(System::TObject* Sender, int ARow, int ACol, AnsiString 
	Anchor);

typedef void __fastcall (__closure *TCellValidateEvent)(System::TObject* Sender, int Col, int Row, AnsiString 
	&Value, bool &Valid);

typedef void __fastcall (__closure *TCellsChangedEvent)(System::TObject* Sender, const Windows::TRect 
	&R);

typedef void __fastcall (__closure *TGetCheckEvent)(System::TObject* Sender, int ACol, int ARow, AnsiString 
	&Value);

typedef void __fastcall (__closure *TDoFitToPageEvent)(System::TObject* Sender, double &ScaleFactor, 
	bool &Allow);

#pragma option push -b-
enum TFindParameters { fnMatchCase, fnMatchFull, fnMatchRegular, fnDirectionLeftRight, fnMatchStart, 
	fnFindInCurrentRow, fnFindInCurrentCol, fnIncludeFixed, fnAutoGoto, fnIgnoreHTMLTags, fnBackward };
	
#pragma option pop

#pragma option push -b-
enum TCellHAlign { haLeft, haRight, haCenter, haBeforeText, haAfterText, haFull };
#pragma option pop

#pragma option push -b-
enum TCellVAlign { vaTop, vaBottom, vaCenter, vaUnderText, vaAboveText, vaFull };
#pragma option pop

#pragma option push -b-
enum TCellType { ctBitmap, ctIcon, ctNone, ctImageList, ctCheckBox, ctDataCheckBox, ctRotated, ctDataImage, 
	ctNode, ctRadio, ctEmpty, ctImages, ctPicture, ctFilePicture, ctValue, ctProgress, ctComment, ctButton 
	};
#pragma option pop

#pragma option push -b-
enum TFitToPage { fpNever, fpGrow, fpShrink, fpAlways, fpCustom };
#pragma option pop

typedef Set<TFindParameters, fnMatchCase, fnBackward>  TFindParams;

#pragma option push -b-
enum TStretchMode { noStretch, Stretch, StretchWithAspectRatio, Shrink, ShrinkWithAspectRatio };
#pragma option pop

#pragma option push -b-
enum TSortBlankPosition { blFirst, blLast };
#pragma option pop

class DELPHICLASS TCellGraphic;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCellGraphic : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TCellType CellType;
	Graphics::TBitmap* CellBitmap;
	Graphics::TIcon* CellIcon;
	TCellVAlign CellVAlign;
	TCellHAlign CellHAlign;
	int CellIndex;
	bool CellTransparent;
	bool CellCreated;
	bool CellBoolean;
	int CellAngle;
	double CellValue;
	System::TObject* CellObject;
	int CellData;
	Graphics::TColor CellColor;
	short CellErrFrom;
	short CellErrLen;
	__fastcall TCellGraphic(void);
	__fastcall virtual ~TCellGraphic(void);
	void __fastcall SetBitmap(Graphics::TBitmap* ABmp, bool transparent, TCellHAlign hal, TCellVAlign val
		);
	void __fastcall SetPicture(Graphics::TPicture* APicture, bool transparent, TStretchMode StretchMode
		, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetFilePicture(Advobj::TFilePicture* apicture, bool transparent, TStretchMode stretchmode
		, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetImageIdx(int idx, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetDataImage(int idx, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetMultiImage(int Col, int Row, int dir, TCellHAlign hal, TCellVAlign val, Advobj::TImageChangeEvent 
		Notifier);
	void __fastcall SetIcon(Graphics::TIcon* aicon, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetCheckBox(bool Value, bool Data, bool Flat, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetAngle(short aAngle);
	void __fastcall SetButton(int bw, int bh, AnsiString caption, TCellHAlign hal, TCellVAlign val);
	Windows::TPoint __fastcall GetPictureSize(int cw, int rh, bool hastext);
};

#pragma pack(pop)

class DELPHICLASS TBands;
class DELPHICLASS TAdvStringGrid;
class DELPHICLASS TGridDropTarget;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridDropTarget : public Asgdd::TASGDropTarget 
{
	typedef Asgdd::TASGDropTarget inherited;
	
private:
	TAdvStringGrid* FGrid;
	
public:
	__fastcall TGridDropTarget(TAdvStringGrid* aGrid);
	virtual void __fastcall DropText(const Windows::TPoint &pt, AnsiString s);
	virtual void __fastcall DropCol(const Windows::TPoint &pt, int Col);
	virtual void __fastcall DropRTF(const Windows::TPoint &pt, AnsiString s);
	virtual void __fastcall DropFiles(const Windows::TPoint &pt, Classes::TStrings* files);
	virtual void __fastcall DragMouseMove(const Windows::TPoint &pt, bool &Allow, Asgdd::TDropFormats DropFormats
		);
	virtual void __fastcall DragMouseLeave(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TGridDropTarget(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TBackGround;
#pragma option push -b-
enum TBackGroundDisplay { bdTile, bdFixed };
#pragma option pop

#pragma option push -b-
enum TBackGroundCells { bcNormal, bcFixed };
#pragma option pop

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TBackGround : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TAdvStringGrid* FGrid;
	int FTop;
	int FLeft;
	TBackGroundDisplay FDisplay;
	TBackGroundCells FBackgroundCells;
	void __fastcall SetBitmap(Graphics::TBitmap* Value);
	void __fastcall SetTop(int Value);
	void __fastcall SetLeft(int Value);
	void __fastcall SetDisplay(TBackGroundDisplay Value);
	void __fastcall SetBackGroundCells(const TBackGroundCells Value);
	Graphics::TBitmap* FBitmap;
	
public:
	__fastcall TBackGround(TAdvStringGrid* aGrid);
	__fastcall virtual ~TBackGround(void);
	
__published:
	__property int Top = {read=FTop, write=SetTop, nodefault};
	__property int Left = {read=FLeft, write=SetLeft, nodefault};
	__property TBackGroundDisplay Display = {read=FDisplay, write=SetDisplay, nodefault};
	__property Graphics::TBitmap* Bitmap = {read=FBitmap, write=SetBitmap};
	__property TBackGroundCells Cells = {read=FBackgroundCells, write=SetBackGroundCells, nodefault};
};

#pragma pack(pop)

class DELPHICLASS TPrintSettings;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPrintSettings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TPrintPosition FTime;
	TPrintPosition FDate;
	TPrintPosition FPageNr;
	AnsiString FPageNumSep;
	AnsiString FDateFormat;
	TPrintPosition FTitle;
	Graphics::TFont* FFont;
	Graphics::TFont* FHeaderFont;
	Graphics::TFont* FFooterFont;
	TPrintBorders FBorders;
	Graphics::TPenStyle FBorderStyle;
	AnsiString FTitleText;
	Classes::TStringList* FTitleLines;
	bool FCentered;
	bool FRepeatFixedRows;
	bool FRepeatFixedCols;
	int FFooterSize;
	int FHeaderSize;
	int FLeftSize;
	int FRightSize;
	int FColumnSpacing;
	int FRowSpacing;
	int FTitleSpacing;
	Printers::TPrinterOrientation FOrientation;
	AnsiString FPagePrefix;
	AnsiString FPageSuffix;
	int FFixedHeight;
	bool FUseFixedHeight;
	int FFixedWidth;
	bool FUseFixedWidth;
	TFitToPage FFitToPage;
	bool FNoAutoSize;
	bool FPrintGraphics;
	AnsiString FJobName;
	void __fastcall SetPrintFont(Graphics::TFont* Value);
	void __fastcall SetPrintHeaderFont(Graphics::TFont* Value);
	void __fastcall SetPrintFooterFont(Graphics::TFont* Value);
	void __fastcall SetTitleLines(Classes::TStringList* Value);
	
public:
	__fastcall TPrintSettings(void);
	__fastcall virtual ~TPrintSettings(void);
	
__published:
	__property int FooterSize = {read=FFooterSize, write=FFooterSize, nodefault};
	__property int HeaderSize = {read=FHeaderSize, write=FHeaderSize, nodefault};
	__property TPrintPosition Time = {read=FTime, write=FTime, nodefault};
	__property TPrintPosition Date = {read=FDate, write=FDate, nodefault};
	__property AnsiString DateFormat = {read=FDateFormat, write=FDateFormat};
	__property TPrintPosition PageNr = {read=FPageNr, write=FPageNr, nodefault};
	__property TPrintPosition Title = {read=FTitle, write=FTitle, nodefault};
	__property AnsiString TitleText = {read=FTitleText, write=FTitleText};
	__property Classes::TStringList* TitleLines = {read=FTitleLines, write=SetTitleLines};
	__property Graphics::TFont* Font = {read=FFont, write=SetPrintFont};
	__property Graphics::TFont* HeaderFont = {read=FHeaderFont, write=SetPrintHeaderFont};
	__property Graphics::TFont* FooterFont = {read=FFooterFont, write=SetPrintFooterFont};
	__property TPrintBorders Borders = {read=FBorders, write=FBorders, nodefault};
	__property Graphics::TPenStyle BorderStyle = {read=FBorderStyle, write=FBorderStyle, nodefault};
	__property bool Centered = {read=FCentered, write=FCentered, nodefault};
	__property bool RepeatFixedRows = {read=FRepeatFixedRows, write=FRepeatFixedRows, nodefault};
	__property bool RepeatFixedCols = {read=FRepeatFixedCols, write=FRepeatFixedCols, nodefault};
	__property int LeftSize = {read=FLeftSize, write=FLeftSize, nodefault};
	__property int RightSize = {read=FRightSize, write=FRightSize, nodefault};
	__property int ColumnSpacing = {read=FColumnSpacing, write=FColumnSpacing, nodefault};
	__property int RowSpacing = {read=FRowSpacing, write=FRowSpacing, nodefault};
	__property int TitleSpacing = {read=FTitleSpacing, write=FTitleSpacing, nodefault};
	__property Printers::TPrinterOrientation Orientation = {read=FOrientation, write=FOrientation, nodefault
		};
	__property AnsiString PagePrefix = {read=FPagePrefix, write=FPagePrefix, stored=true};
	__property AnsiString PageSuffix = {read=FPageSuffix, write=FPageSuffix};
	__property int FixedWidth = {read=FFixedWidth, write=FFixedWidth, nodefault};
	__property int FixedHeight = {read=FFixedHeight, write=FFixedHeight, nodefault};
	__property bool UseFixedHeight = {read=FUseFixedHeight, write=FUseFixedHeight, nodefault};
	__property bool UseFixedWidth = {read=FUseFixedWidth, write=FUseFixedWidth, nodefault};
	__property TFitToPage FitToPage = {read=FFitToPage, write=FFitToPage, nodefault};
	__property AnsiString JobName = {read=FJobName, write=FJobName};
	__property AnsiString PageNumSep = {read=FPageNumSep, write=FPageNumSep};
	__property bool NoAutoSize = {read=FNoAutoSize, write=FNoAutoSize, nodefault};
	__property bool PrintGraphics = {read=FPrintGraphics, write=FPrintGraphics, nodefault};
};

#pragma pack(pop)

class DELPHICLASS THTMLSettings;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION THTMLSettings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FSaveColor;
	bool FSaveFonts;
	AnsiString FFooterFile;
	AnsiString FHeaderFile;
	int FBorderSize;
	int FCellSpacing;
	int FCellPadding;
	AnsiString FTableStyle;
	AnsiString FPrefixTag;
	AnsiString FSuffixTag;
	int FWidth;
	Advobj::TIntList* FColWidths;
	
public:
	__fastcall THTMLSettings(void);
	__fastcall virtual ~THTMLSettings(void);
	__property Advobj::TIntList* ColWidths = {read=FColWidths};
	
__published:
	__property int BorderSize = {read=FBorderSize, write=FBorderSize, default=1};
	__property int CellSpacing = {read=FCellSpacing, write=FCellSpacing, default=0};
	__property int CellPadding = {read=FCellPadding, write=FCellPadding, default=0};
	__property bool SaveColor = {read=FSaveColor, write=FSaveColor, default=1};
	__property bool SaveFonts = {read=FSaveFonts, write=FSaveFonts, default=1};
	__property AnsiString FooterFile = {read=FFooterFile, write=FFooterFile};
	__property AnsiString HeaderFile = {read=FHeaderFile, write=FHeaderFile};
	__property AnsiString TableStyle = {read=FTableStyle, write=FTableStyle};
	__property AnsiString PrefixTag = {read=FPrefixTag, write=FPrefixTag};
	__property AnsiString SuffixTag = {read=FSuffixTag, write=FSuffixTag};
	__property int Width = {read=FWidth, write=FWidth, nodefault};
};

#pragma pack(pop)

class DELPHICLASS TNavigation;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TNavigation : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FAllowInsertRow;
	bool FAllowDeleteRow;
	bool FAdvanceOnEnter;
	bool FAdvanceInsert;
	bool FAutoGotoWhenSorted;
	bool FAutoGotoIncremental;
	bool FAutoComboDropSize;
	bool FAllowClipboardShortcuts;
	bool FAllowRTFClipboard;
	bool FAllowSmartClipboard;
	bool FAllowClipboardAlways;
	bool FAllowClipboardColGrow;
	bool FAllowClipboardRowGrow;
	bool FCopyHTMLTagsToClipboard;
	TAdvanceDirection FAdvanceDirection;
	bool FAdvanceAuto;
	bool FCursorWalkEditor;
	bool FMoveRowOnSort;
	bool FImproveMaskSel;
	bool FAlwaysEdit;
	TInsertPosition FInsertPosition;
	bool FLineFeedOnEnter;
	void __fastcall SetAutoGoto(bool aValue);
	
public:
	__fastcall TNavigation(void);
	__fastcall virtual ~TNavigation(void);
	
__published:
	__property bool AllowInsertRow = {read=FAllowInsertRow, write=FAllowInsertRow, nodefault};
	__property bool AllowDeleteRow = {read=FAllowDeleteRow, write=FAllowDeleteRow, nodefault};
	__property bool AdvanceOnEnter = {read=FAdvanceOnEnter, write=FAdvanceOnEnter, nodefault};
	__property bool AdvanceInsert = {read=FAdvanceInsert, write=FAdvanceInsert, nodefault};
	__property bool AutoGotoWhenSorted = {read=FAutoGotoWhenSorted, write=SetAutoGoto, nodefault};
	__property bool AutoGotoIncremental = {read=FAutoGotoIncremental, write=FAutoGotoIncremental, nodefault
		};
	__property bool AutoComboDropSize = {read=FAutoComboDropSize, write=FAutoComboDropSize, nodefault};
		
	__property TAdvanceDirection AdvanceDirection = {read=FAdvanceDirection, write=FAdvanceDirection, nodefault
		};
	__property bool AllowClipboardShortCuts = {read=FAllowClipboardShortcuts, write=FAllowClipboardShortcuts
		, nodefault};
	__property bool AllowSmartClipboard = {read=FAllowSmartClipboard, write=FAllowSmartClipboard, nodefault
		};
	__property bool AllowRTFClipboard = {read=FAllowRTFClipboard, write=FAllowRTFClipboard, nodefault};
		
	__property bool AllowClipboardAlways = {read=FAllowClipboardAlways, write=FAllowClipboardAlways, nodefault
		};
	__property bool AllowClipboardRowGrow = {read=FAllowClipboardRowGrow, write=FAllowClipboardRowGrow, 
		nodefault};
	__property bool AllowClipboardColGrow = {read=FAllowClipboardColGrow, write=FAllowClipboardColGrow, 
		nodefault};
	__property bool AdvanceAuto = {read=FAdvanceAuto, write=FAdvanceAuto, nodefault};
	__property TInsertPosition InsertPosition = {read=FInsertPosition, write=FInsertPosition, nodefault
		};
	__property bool CursorWalkEditor = {read=FCursorWalkEditor, write=FCursorWalkEditor, nodefault};
	__property bool MoveRowOnSort = {read=FMoveRowOnSort, write=FMoveRowOnSort, nodefault};
	__property bool ImproveMaskSel = {read=FImproveMaskSel, write=FImproveMaskSel, nodefault};
	__property bool AlwaysEdit = {read=FAlwaysEdit, write=FAlwaysEdit, nodefault};
	__property bool CopyHTMLTagsToClipboard = {read=FCopyHTMLTagsToClipboard, write=FCopyHTMLTagsToClipboard
		, nodefault};
	__property bool LineFeedOnEnter = {read=FLineFeedOnEnter, write=FLineFeedOnEnter, nodefault};
};

#pragma pack(pop)

class DELPHICLASS TColumnSize;
#pragma option push -b-
enum TColumnSizeLocation { clRegistry, clIniFile };
#pragma option pop

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TColumnSize : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FSave;
	AnsiString FKey;
	AnsiString FSection;
	bool FStretch;
	bool FSynchWithGrid;
	TColumnSizeLocation FLocation;
	Classes::TComponent* Owner;
	void __fastcall SetStretch(bool Value);
	
public:
	__fastcall TColumnSize(Classes::TComponent* AOwner);
	__fastcall virtual ~TColumnSize(void);
	
__published:
	__property bool Save = {read=FSave, write=FSave, nodefault};
	__property AnsiString Key = {read=FKey, write=FKey};
	__property AnsiString Section = {read=FSection, write=FSection};
	__property bool Stretch = {read=FStretch, write=SetStretch, nodefault};
	__property bool SynchWithGrid = {read=FSynchWithGrid, write=FSynchWithGrid, nodefault};
	__property TColumnSizeLocation Location = {read=FLocation, write=FLocation, nodefault};
};

#pragma pack(pop)

class DELPHICLASS TCellNode;
#pragma option push -b-
enum TNodeType { cnFlat, cn3D, cnGlyph };
#pragma option pop

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCellNode : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Graphics::TColor FColor;
	TNodeType FNodeType;
	Graphics::TColor FNodeColor;
	Graphics::TBitmap* FExpandGlyph;
	Graphics::TBitmap* FContractGlyph;
	TAdvStringGrid* FOwner;
	void __fastcall SetExpandGlyph(Graphics::TBitmap* Value);
	void __fastcall SetContractGlyph(Graphics::TBitmap* Value);
	void __fastcall SetNodeType(TNodeType Value);
	
public:
	__fastcall TCellNode(TAdvStringGrid* AOwner);
	__fastcall virtual ~TCellNode(void);
	
__published:
	__property Graphics::TColor Color = {read=FColor, write=FColor, nodefault};
	__property TNodeType NodeType = {read=FNodeType, write=SetNodeType, nodefault};
	__property Graphics::TColor NodeColor = {read=FNodeColor, write=FNodeColor, nodefault};
	__property Graphics::TBitmap* ExpandGlyph = {read=FExpandGlyph, write=SetExpandGlyph};
	__property Graphics::TBitmap* ContractGlyph = {read=FContractGlyph, write=SetContractGlyph};
};

#pragma pack(pop)

class DELPHICLASS TSizeWhileTyping;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TSizeWhileTyping : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FHeight;
	bool FWidth;
	
public:
	__fastcall TSizeWhileTyping(void);
	__fastcall virtual ~TSizeWhileTyping(void);
	
__published:
	__property bool Height = {read=FHeight, write=FHeight, nodefault};
	__property bool Width = {read=FWidth, write=FWidth, nodefault};
};

#pragma pack(pop)

class DELPHICLASS TMouseActions;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TMouseActions : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FColSelect;
	bool FRowSelect;
	bool FAllSelect;
	bool FDirectEdit;
	bool FDirectComboDrop;
	bool FDisjunctRowSelect;
	bool FAllColumnSize;
	bool FAllRowSize;
	bool FCaretPositioning;
	
public:
	__fastcall TMouseActions(void);
	__fastcall virtual ~TMouseActions(void);
	
__published:
	__property bool AllSelect = {read=FAllSelect, write=FAllSelect, nodefault};
	__property bool ColSelect = {read=FColSelect, write=FColSelect, nodefault};
	__property bool RowSelect = {read=FRowSelect, write=FRowSelect, nodefault};
	__property bool DirectEdit = {read=FDirectEdit, write=FDirectEdit, nodefault};
	__property bool DirectComboDrop = {read=FDirectComboDrop, write=FDirectComboDrop, nodefault};
	__property bool DisjunctRowSelect = {read=FDisjunctRowSelect, write=FDisjunctRowSelect, nodefault};
		
	__property bool AllColumnSize = {read=FAllColumnSize, write=FAllColumnSize, nodefault};
	__property bool AllRowSize = {read=FAllRowSize, write=FAllRowSize, nodefault};
	__property bool CaretPositioning = {read=FCaretPositioning, write=FCaretPositioning, nodefault};
};

#pragma pack(pop)

class DELPHICLASS TAdvRichEdit;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TAdvRichEdit : public Comctrls::TRichEdit 
{
	typedef Comctrls::TRichEdit inherited;
	
private:
	TAdvStringGrid* FGrid;
	int FReqHeight;
	int FReqWidth;
	bool FLocked;
	void __fastcall SelFormat(int offset);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall CNNotify(Messages::TWMNotify &Msg);
	
protected:
	void __fastcall Lock(void);
	void __fastcall Unlock(void);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	
public:
	__fastcall virtual TAdvRichEdit(Classes::TComponent* AOwner);
	void __fastcall SelSubscript(void);
	void __fastcall SelSuperscript(void);
	void __fastcall SelNormal(void);
	
__published:
	__property int ReqWidth = {read=FReqWidth, nodefault};
	__property int ReqHeight = {read=FReqHeight, nodefault};
public:
	#pragma option push -w-inl
	/* TCustomRichEdit.Destroy */ inline __fastcall virtual ~TAdvRichEdit(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TAdvRichEdit(HWND ParentWindow) : Comctrls::TRichEdit(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TMouseSelectMode { msNormal, msColumn, msRow, msAll, msURL };
#pragma option pop

class DELPHICLASS TEditLink;
typedef void __fastcall (__closure *TGetEditorPropEvent)(System::TObject* Sender, int ACol, int ARow
	, TEditLink* AEditLink);

class DELPHICLASS TGridCombo;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridCombo : public Asgcombo::TASGComboBox 
{
	typedef Asgcombo::TASGComboBox inherited;
	
private:
	bool Forced;
	bool WorkMode;
	int ItemIdx;
	bool ItemChange;
	MESSAGE void __fastcall CMWantSpecialKey(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	
protected:
	DYNAMIC void __fastcall KeyPress(char &Key);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoExit(void);
	virtual void __fastcall WndProc(Messages::TMessage &Message);
	
public:
	TAdvStringGrid* FGrid;
	void __fastcall DoChange(void);
	__fastcall virtual TGridCombo(Classes::TComponent* AOwner);
	void __fastcall SizeDropDownWidth(void);
public:
	#pragma option push -w-inl
	/* TCustomComboBox.Destroy */ inline __fastcall virtual ~TGridCombo(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridCombo(HWND ParentWindow) : Asgcombo::TASGComboBox(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TGridSpin;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridSpin : public Asgspin::TAsgSpinEdit 
{
	typedef Asgspin::TAsgSpinEdit inherited;
	
private:
	HIDESBASE MESSAGE void __fastcall CMWantSpecialKey(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	
protected:
	void __fastcall DoClick(bool UpDown);
	virtual void __fastcall UpClick(System::TObject* Sender);
	virtual void __fastcall DownClick(System::TObject* Sender);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall Keypress(char &Key);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	TAdvStringGrid* FGrid;
	__fastcall virtual TGridSpin(Classes::TComponent* AOwner);
public:
	#pragma option push -w-inl
	/* TAsgSpinEdit.Destroy */ inline __fastcall virtual ~TGridSpin(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridSpin(HWND ParentWindow) : Asgspin::TAsgSpinEdit(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TGridCheckBox;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridCheckBox : public Stdctrls::TCheckBox 
{
	typedef Stdctrls::TCheckBox inherited;
	
private:
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &Msg);
	
protected:
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	TAdvStringGrid* FGrid;
	__fastcall virtual TGridCheckBox(Classes::TComponent* AOwner);
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridCheckBox(HWND ParentWindow) : Stdctrls::TCheckBox(
		ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~TGridCheckBox(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TGridEditBtn;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridEditBtn : public Asgedit::TAsgEditBtn 
{
	typedef Asgedit::TAsgEditBtn inherited;
	
private:
	TAdvStringGrid* FGrid;
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	MESSAGE void __fastcall CMWantSpecialKey(Messages::TWMKey &Msg);
	
protected:
	void __fastcall ExtClick(System::TObject* Sender);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall Keypress(char &Key);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	__fastcall virtual TGridEditBtn(Classes::TComponent* AOwner);
public:
	#pragma option push -w-inl
	/* TAsgEditBtn.Destroy */ inline __fastcall virtual ~TGridEditBtn(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridEditBtn(HWND ParentWindow) : Asgedit::TAsgEditBtn(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TGridUnitEditBtn;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridUnitEditBtn : public Asgedit::TAsgUnitEditBtn 
{
	typedef Asgedit::TAsgUnitEditBtn inherited;
	
private:
	TAdvStringGrid* FGrid;
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	MESSAGE void __fastcall CMWantSpecialKey(Messages::TWMKey &Msg);
	
protected:
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	__fastcall virtual TGridUnitEditBtn(Classes::TComponent* AOwner);
public:
	#pragma option push -w-inl
	/* TAsgUnitEditBtn.Destroy */ inline __fastcall virtual ~TGridUnitEditBtn(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridUnitEditBtn(HWND ParentWindow) : Asgedit::TAsgUnitEditBtn(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TGridDatePicker;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridDatePicker : public Comctrls::TDateTimePicker 
{
	typedef Comctrls::TDateTimePicker inherited;
	
private:
	bool FOldDropped;
	HIDESBASE MESSAGE void __fastcall CNNotify(Messages::TWMNotify &Message);
	HIDESBASE MESSAGE void __fastcall WMNCPaint(Messages::TMessage &Message);
	
protected:
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	TAdvStringGrid* FGrid;
	__fastcall virtual TGridDatePicker(Classes::TComponent* AOwner);
public:
	#pragma option push -w-inl
	/* TCommonCalendar.Destroy */ inline __fastcall virtual ~TGridDatePicker(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridDatePicker(HWND ParentWindow) : Comctrls::TDateTimePicker(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TGridButton;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridButton : public Stdctrls::TButton 
{
	typedef Stdctrls::TButton inherited;
	
private:
	TAdvStringGrid* FGrid;
	
protected:
	HIDESBASE MESSAGE void __fastcall WMLButtonUp(Messages::TWMMouse &Msg);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	__fastcall virtual TGridButton(Classes::TComponent* AOwner);
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridButton(HWND ParentWindow) : Stdctrls::TButton(
		ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~TGridButton(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TFilter;
class DELPHICLASS TFilterData;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TFilter : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TAdvStringGrid* FOwner;
	HIDESBASE TFilterData* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TFilterData* Value);
	
public:
	__fastcall TFilter(TAdvStringGrid* AOwner);
	HIDESBASE TFilterData* __fastcall Add(void);
	HIDESBASE TFilterData* __fastcall Insert(int index);
	__property TFilterData* Items[int Index] = {read=GetItem, write=SetItem};
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TFilter(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TAdvInplaceEdit;
#pragma option push -b-
enum TClipOperation { coCut, coCopy };
#pragma option pop

class DELPHICLASS THTMLHintWindow;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION THTMLHintWindow : public Controls::THintWindow 
{
	typedef Controls::THintWindow inherited;
	
private:
	int FTextHeight;
	int FTextWidth;
	HIDESBASE MESSAGE void __fastcall CMTextChanged(Messages::TMessage &Message);
	
protected:
	virtual void __fastcall Paint(void);
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	
public:
	virtual void __fastcall ActivateHint(const Windows::TRect &Rect, const AnsiString AHint);
	virtual Windows::TRect __fastcall CalcHintRect(int MaxWidth, const AnsiString AHint, void * AData);
		
public:
	#pragma option push -w-inl
	/* THintWindow.Create */ inline __fastcall virtual THTMLHintWindow(Classes::TComponent* AOwner) : Controls::THintWindow(
		AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCustomControl.Destroy */ inline __fastcall virtual ~THTMLHintWindow(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall THTMLHintWindow(HWND ParentWindow) : Controls::THintWindow(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TGridChangeNotifier;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TAdvStringGrid : public Grids::TStringGrid 
{
	typedef Grids::TStringGrid inherited;
	
private:
	AnsiString cla;
	int FMoveColInd;
	int FMoveRowInd;
	int FSortColumn;
	int FGroupColumn;
	AnsiString FGroupCaption;
	int FGroupWidth;
	bool FSortShow;
	bool FSortIndexShow;
	bool FSortFull;
	bool FSortSingleColumn;
	bool FSortIgnoreBlanks;
	TSortBlankPosition FSortBlankPos;
	bool FSortAutoFormat;
	TSortDirection FSortDirection;
	bool FAutoSize;
	bool FAutoNumAlign;
	bool FEnhTextSize;
	bool FOemConvert;
	bool FLookup;
	bool FLookupCaseSensitive;
	bool FDeselectState;
	bool FSelectionClick;
	bool FMouseDown;
	bool FLookupHistory;
	bool FEnhRowColMove;
	bool FSizeWithForm;
	bool FMultilinecells;
	bool FSortFixedCols;
	bool FSortNormalCellsOnly;
	TGridColorEvent FOnGetCellColor;
	TGridColorEvent FOnGetCellPrintColor;
	TGridBorderEvent FOnGetCellBorder;
	TGridBorderEvent FOnGetCellPrintBorder;
	TGridAlignEvent FOnGetAlignment;
	TGridFormatEvent FOnGetFormat;
	TGetCheckEvent FOnGetCheckTrue;
	TGetCheckEvent FOnGetCheckFalse;
	TGridHintEvent FOnGridHint;
	TRowChangingEvent FOnRowChanging;
	TColChangingEvent FOnColChanging;
	TCellChangingEvent FOnCellChanging;
	Forms::TShowHintEvent FOnShowHint;
	TCanAddRowEvent FOnCanAddRow;
	TAutoAddRowEvent FOnAutoAddRow;
	TCanInsertRowEvent FOnCanInsertRow;
	TAutoInsertRowEvent FOnAutoInsertRow;
	TAutoInsertColEvent FOnAutoInsertCol;
	TCanDeleteRowEvent FOnCanDeleteRow;
	TAutoDeleteRowEvent FOnAutoDeleteRow;
	TOleDragDropEvent FOnOleDrop;
	TOleDragDropEvent FOnOleDrag;
	TOleDragOverEvent FOnOleDragOver;
	TOleDragStartEvent FOnOleDragStart;
	TOleDragStopEvent FOnOleDragStop;
	TOleDropColEvent FOnOleDropCol;
	TOleDroppedEvent FOnOleDropped;
	TGridDropTarget* FGridDropTarget;
	TClickSortEvent FOnClickSort;
	TCanSortEvent FOnCanSort;
	TNodeClickEvent FOnExpandNode;
	TNodeClickEvent FOnContractNode;
	TCustomCompareEvent FCustomCompare;
	TRawCompareEvent FRawCompare;
	TClipboardEvent FOnClipboardPaste;
	TClipboardEvent FOnClipboardCut;
	TClipboardEvent FOnClipboardCopy;
	TOnResizeEvent FOnResize;
	TGridPrintStartEvent FOnPrintStart;
	TGridPrintPageEvent FOnPrintPage;
	TGridPrintNewPageEvent FOnPrintNewPage;
	TGridPrintPageDoneEvent FOnPrintPageDone;
	TGridPrintColumnWidthEvent FOnPrintSetColumnWidth;
	TGridPrintRowHeightEvent FOnPrintSetRowHeight;
	TDoFitToPageEvent FDoFitToPage;
	TClickCellEvent FOnClickCell;
	TClickCellEvent FOnRightClickCell;
	TDblClickCellEvent FOnDblClickCell;
	TCanEditCellEvent FOnCanEditCell;
	TIsFixedCellEvent FOnIsFixedCell;
	TIsPasswordCellEvent FOnIsPasswordCell;
	TAnchorClickEvent FOnAnchorClick;
	TAnchorEvent FOnAnchorEnter;
	TAnchorEvent FOnAnchorExit;
	TCellValidateEvent FOnCellValidate;
	TCellsChangedEvent FOnCellsChanged;
	TGridProgressEvent FOnFileProgress;
	Classes::TNotifyEvent FOnRichEditSelectionChange;
	Graphics::TColor FHintColor;
	bool FHintShowCells;
	bool FHintShowLargeText;
	bool FHintShowSizing;
	Windows::TPoint FLastHintPos;
	Graphics::TBitmap* FSortUpGlyph;
	Graphics::TBitmap* FSortDownGlyph;
	Graphics::TBitmap* FRowIndicator;
	Advobj::TSortIndexList* FSortIndexes;
	TBackGround* FBackGround;
	bool FOleDropTarget;
	bool FOleDropSource;
	bool FOleInsertRows;
	bool FOleRemoveRows;
	bool FOleEntireRows;
	bool FOleDropRTF;
	bool FOleDropTargetAssigned;
	bool FOleAcceptFiles;
	bool FOleAcceptText;
	Grids::TGridRect FDropSelection;
	Advobj::TArrowWindow* ArwU;
	Advobj::TArrowWindow* ArwD;
	Advobj::TArrowWindow* ArwL;
	Advobj::TArrowWindow* ArwR;
	TColumnSizeEvent FOnColumnSize;
	TRowSizeEvent FOnRowSize;
	TColumnSizeEvent FOnColumnMove;
	TRowSizeEvent FOnRowMove;
	TEndColumnSizeEvent FOnEndColumnSize;
	TEndRowSizeEvent FOnEndRowSize;
	TPrintSettings* FPrintSettings;
	bool FFastPrint;
	THTMLSettings* FHTMLSettings;
	TBands* FBands;
	TNavigation* FNavigation;
	TColumnSize* FColumnSize;
	bool FScrollProportional;
	TCellNode* FCellNode;
	TSizeWhileTyping* FSizeWhileTyping;
	TMouseActions* FMouseActions;
	bool FVisibleCol[257];
	short FAllColWidths[257];
	int FUpdateCount;
	int FNumNodes;
	int FNumHidden;
	Graphics::TColor FSelectionColor;
	Graphics::TColor FSelectionTextColor;
	bool FSelectionRectangle;
	bool FSelectionRTFKeep;
	TVAlignment FVAlignment;
	unsigned FVAlign;
	bool FURLShow;
	bool FURLFull;
	Graphics::TColor FURLColor;
	bool FURLEdit;
	Controls::TImageList* FGridImages;
	TIntelliPan FIntelliPan;
	bool FIntelliZoom;
	TScrollType FScrollType;
	Graphics::TColor FScrollColor;
	int FScrollWidth;
	bool FScrollSynch;
	TScrollHintType FScrollHints;
	bool FIsFlat;
	TAdvRichEdit* FRichEdit;
	TAdvRichEdit* FInplaceRichEdit;
	bool FFixedAsButtons;
	bool FFixedCellPushed;
	Windows::TRect FPushedFixedCell;
	Windows::TPoint FPushedCellButton;
	bool FShowSelection;
	bool FHideFocusRect;
	Graphics::TFont* FFixedFont;
	bool FFixedRowAlways;
	bool FFixedColAlways;
	Classes::TStringList* FColumnHeaders;
	Classes::TStringList* FRowHeaders;
	Classes::TStringList* FLookupItems;
	Classes::TList* FRowSelect;
	int FFixedFooters;
	int FFixedRightCols;
	char FDelimiter;
	char FPasswordChar;
	bool FJavaCSV;
	AnsiString FCheckTrue;
	AnsiString FCheckFalse;
	bool FEnableGraphics;
	bool FEnableHTML;
	bool FEnableWheel;
	bool FFlat;
	bool FFlatCheckBox;
	bool FSaveFixedCells;
	bool FSaveHiddenCells;
	bool FWordWrap;
	bool FModified;
	bool FEditDisable;
	bool FEditChange;
	bool FExcelStyleDecimalSeparator;
	bool FHovering;
	AnsiString FFloatFormat;
	AnsiString FOldCellText;
	char FStartEditChar;
	int FOldCol;
	int FOldRow;
	bool FOldModifiedValue;
	int FOldCursor;
	bool FBlockFocus;
	bool FDblClk;
	Grids::TGridRect FOldSelection;
	Grids::TGridRect FMoveSelection;
	bool FEntered;
	bool FEditing;
	bool FValidating;
	bool FFindBusy;
	int FComboIdx;
	int SortDir;
	int SortRow;
	Windows::TPoint SearchCell;
	bool ResizeAssigned;
	Grids::TGridRect FPrintRect;
	TFindParams FFindParams;
	AnsiString CellCache;
	AnsiString SearchCache;
	AnsiString SearchInc;
	AnsiString FAnchor;
	int ZoomFactor;
	bool ColchgFlg;
	bool ColMoveFlg;
	bool ColSizeFlg;
	bool ColSized;
	bool Rowsized;
	int Colclicked;
	int Rowclicked;
	int Colclickedsize;
	int Rowclickedsize;
	int Movecell;
	int MoveOfsX;
	int MoveOfsY;
	int Clickposx;
	int Clickposy;
	int Clickposdx;
	int Clickposdy;
	bool Invokedchange;
	bool InvokedFocusChange;
	unsigned wheelmsg;
	int wheelscrl;
	bool wheelpan;
	Windows::TPoint wheelpanpos;
	unsigned wheeltimer;
	HICON prevcurs;
	TMouseSelectMode FMouseSelectMode;
	int FMouseSelectStart;
	bool FPrinterdriverfix;
	Windows::TRect PrevRect;
	double Fontscalefactor;
	int FPrintPageWidth;
	Windows::TRect FPrintPageRect;
	int FPrintColStart;
	int FPrintColEnd;
	int FPrintPageFrom;
	int FPrintPageTo;
	int FPrintPageNum;
	bool FExcelClipboardFormat;
	int FGridTimerID;
	bool FGridBlink;
	int FMaxEditLength;
	TGridLook FLook;
	int MaxWidths[257];
	int Indents[257];
	TGetEditorTypeEvent FOnGetEditorType;
	TGetEditorPropEvent FOnGetEditorProp;
	TEllipsClickEvent FOnEllipsClick;
	TButtonClickEvent FOnButtonClick;
	TCheckBoxClickEvent FOnCheckBoxClick;
	TCheckBoxClickEvent FOnCheckBoxMouseUp;
	TRadioClickEvent FOnRadioClick;
	TRadioClickEvent FOnRadioMouseUp;
	TComboChangeEvent FOnComboChange;
	TComboObjectChangeEvent FOnComboObjectChange;
	TSpinClickEvent FOnSpinClick;
	TFloatSpinClickEvent FOnFloatSpinClick;
	TDateTimeSpinClickEvent FontimeSpinClick;
	TDateTimeSpinClickEvent FOnDateSpinClick;
	TEditLink* FEditLink;
	TGridCombo* EditCombo;
	TGridSpin* EditSpin;
	TGridCheckBox* EditCheck;
	TGridEditBtn* EditBtn;
	TGridUnitEditBtn* UnitEditBtn;
	TGridDatePicker* EditDate;
	TScrollHintEvent FOnScrollHint;
	TGridButton* GridButton;
	Advobj::TPopupButton* MoveButton;
	TEditorType EditControl;
	Classes::TCollection* FGriditems;
	TFilter* FFilter;
	bool FFilterActive;
	int FFilterFixedRows;
	Classes::TList* FNotifierList;
	bool FActiveCellShow;
	Graphics::TFont* FActiveCellFont;
	Windows::TPoint FXYOffset;
	int FOldSize;
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMSetCursor(Messages::TWMSetCursor &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonUp(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall WMRButtonDown(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonDblClk(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TWMSize &Msg);
	HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &Msg);
	HIDESBASE MESSAGE void __fastcall WMEraseBkGnd(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMTimer(Messages::TWMTimer &Msg);
	HIDESBASE MESSAGE void __fastcall WMVScroll(Messages::TWMScroll &WMScroll);
	HIDESBASE MESSAGE void __fastcall WMHScroll(Messages::TWMScroll &WMScroll);
	HIDESBASE MESSAGE void __fastcall CMCursorChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMHintShow(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall CMDialogChar(Messages::TWMKey &Msg);
	void __fastcall RestoreCache(void);
	void __fastcall HideEditControl(int ACol, int ARow);
	void __fastcall ShowEditControl(int ACol, int ARow);
	bool __fastcall IsFixed(int ACol, int ARow);
	bool __fastcall IsEditable(int ACol, int ARow);
	bool __fastcall IsPassword(int ACol, int ARow);
	void __fastcall HandleRadioClick(int ACol, int ARow, int Xpos, int Ypos);
	bool __fastcall HasStaticEdit(int ACol, int ARow);
	void __fastcall AdvanceEdit(int ACol, int ARow, bool advance, bool show, bool frwrd);
	TAdvInplaceEdit* __fastcall GetInplaceEditor(void);
	bool __fastcall ToggleCheck(int ACol, int ARow, bool fromedit);
	void __fastcall SetAutoSizeP(bool AAutoSize);
	void __fastcall SetFlat(const bool AValue);
	void __fastcall SetFlatCheckBox(const bool AValue);
	void __fastcall SetShowSelection(bool AValue);
	void __fastcall SetSortShow(const bool AValue);
	void __fastcall SetSortIndexShow(const bool AValue);
	void __fastcall SetSortColumn(int ASortColumn);
	void __fastcall SetMaxEditLength(const int AValue);
	void __fastcall SetGroupColumn(int AGroupColumn);
	void __fastcall QuickSortRows(int Col, int Left, int Right);
	void __fastcall QuickSortRowsIndexed(int Col, int Left, int Right);
	void __fastcall SetVAlignment(TVAlignment AVAlignment);
	int __fastcall BuildPages(Graphics::TCanvas* Canvas, TPrintMethod PrintMethod, int MaxPages);
	int __fastcall Compare(int Col, int ARow1, int ARow2);
	int __fastcall CompareLine(int Col, int ARow1, int ARow2);
	int __fastcall CompareLineIndexed(int Colidx, int ARow1, int ARow2);
	bool __fastcall MatchCell(int Col, int Row);
	void __fastcall ShowHintProc(AnsiString &HintStr, bool &CanShow, Forms::THintInfo &HintInfo);
	void __fastcall DrawSortIndicator(Graphics::TCanvas* Canvas, int Col, int x, int y);
	void __fastcall GridResize(System::TObject* Sender);
	bool __fastcall FreeCellGraphic(int ACol, int ARow);
	bool __fastcall RemoveCellGraphic(int ACol, int ARow, TCellType CellType);
	TCellGraphic* __fastcall CreateCellGraphic(int ACol, int ARow);
	Advobj::TIntList* __fastcall GetCellImages(int ACol, int ARow);
	int __fastcall GetCellImageIdx(int ACol, int ARow);
	void __fastcall SetInts(int ACol, int ARow, const int Value);
	int __fastcall GetInts(int ACol, int ARow);
	void __fastcall SetFloats(int ACol, int ARow, const double Value);
	double __fastcall GetFloats(int ACol, int ARow);
	void __fastcall SetDates(int ACol, int ARow, const System::TDateTime Value);
	System::TDateTime __fastcall GetDates(int ACol, int ARow);
	void __fastcall SetTimes(int ACol, int ARow, const System::TDateTime Value);
	System::TDateTime __fastcall GetTimes(int ACol, int ARow);
	bool __fastcall GetRowSelect(int ARow);
	void __fastcall SetRowSelect(int ARow, bool Value);
	int __fastcall GetRowSelectCount(void);
	Windows::TRect __fastcall ButtonRect(int ACol, int ARow);
	void __fastcall SelectToRowSelect(bool IsShift);
	void __fastcall SetFixedFont(Graphics::TFont* Value);
	void __fastcall FixedFontChanged(System::TObject* Sender);
	void __fastcall MultiImageChanged(System::TObject* Sender, int ACol, int ARow);
	void __fastcall RichSelChange(System::TObject* Sender);
	void __fastcall SetColumnHeaders(Classes::TStringList* Value);
	void __fastcall ColHeaderChanged(System::TObject* Sender);
	void __fastcall SetRowHeaders(Classes::TStringList* Value);
	void __fastcall RowHeaderChanged(System::TObject* Sender);
	int __fastcall GetPrintColWidth(int ACol);
	int __fastcall GetPrintColOffset(int ACol);
	void __fastcall SetLookupItems(Classes::TStringList* Value);
	int __fastcall PasteFunc(int ACol, int ARow);
	void __fastcall CopyFunc(const Grids::TGridRect &gd);
	void __fastcall CopyRTFFunc(int ACol, int ARow);
	void __fastcall SetPreviewPage(int Value);
	Graphics::TBitmap* __fastcall GetUpGlyph(void);
	void __fastcall SetUpGlyph(Graphics::TBitmap* Value);
	Graphics::TBitmap* __fastcall GetDownGlyph(void);
	void __fastcall SetDownGlyph(Graphics::TBitmap* Value);
	Graphics::TBitmap* __fastcall GetRowIndicator(void);
	void __fastcall SetRowIndicator(Graphics::TBitmap* Value);
	void __fastcall SetBackground(TBackGround* Value);
	void __fastcall RTFPaint(int ACol, int ARow, Graphics::TCanvas* Canvas, const Windows::TRect &ARect
		);
	void __fastcall FlatInit(void);
	void __fastcall FlatDone(void);
	void __fastcall FlatUpdate(void);
	void __fastcall FlatSetScrollProp(int index, int newValue, BOOL fRedraw);
	void __fastcall FlatSetScrollInfo(int code, tagSCROLLINFO &scrollinfo, BOOL fRedraw);
	void __fastcall FlatShowScrollBar(int code, BOOL show);
	void __fastcall UpdateVScrollBar(void);
	void __fastcall UpdateHScrollBar(void);
	void __fastcall UpdateType(void);
	void __fastcall UpdateColor(void);
	void __fastcall UpdateWidth(void);
	void __fastcall SetScrollType(const TScrollType Value);
	void __fastcall SetScrollColor(const Graphics::TColor Value);
	void __fastcall SetScrollWidth(const int Value);
	void __fastcall SetScrollProportional(bool Value);
	void __fastcall SetActiveCellShow(const bool Value);
	void __fastcall SetActiveCellFont(const Graphics::TFont* Value);
	void __fastcall SetXYOffset(const Windows::TPoint &Value);
	bool __fastcall GetLockFlag(void);
	void __fastcall SetLockFlag(bool AValue);
	bool __fastcall InSizeZone(int x, int y);
	int __fastcall RemapCol(int ACol);
	int __fastcall RemapColInv(int ACol);
	int __fastcall RemapRow(int ARow);
	int __fastcall RemapRowInv(int ARow);
	void __fastcall SetVisibleCol(int i, bool AValue);
	bool __fastcall GetVisibleCol(int i);
	int __fastcall MaxLinesInGrid(void);
	int __fastcall MaxLinesInRow(int ARow);
	int __fastcall MaxCharsInCol(int ACol);
	void __fastcall SizeToLines(const int ARow, const int Lines, const int Padding);
	void __fastcall SizeToWidth(const int ACol, bool inconly);
	tagSIZE __fastcall GetCellTextSize(int ACol, int ARow);
	Classes::TAlignment __fastcall GetCellAlignment(int ACol, int ARow);
	void __fastcall DrawIntelliFocusPoint(void);
	void __fastcall EraseIntelliFocusPoint(void);
	void __fastcall SetImages(Controls::TImageList* Value);
	void __fastcall SetURLShow(bool Value);
	void __fastcall SetURLColor(Graphics::TColor Value);
	void __fastcall SetURLFull(bool Value);
	void __fastcall SetLook(TGridLook Value);
	void __fastcall CalcTextPos(Windows::TRect &aRect, int aAngle, AnsiString aTxt, Classes::TAlignment 
		tal);
	void __fastcall SetFixedFooters(int Value);
	void __fastcall SetFixedRightCols(int Value);
	void __fastcall SetFixedColWidth(int Value);
	void __fastcall SetRowCountEx(int Value);
	int __fastcall GetRowCountEx(void);
	void __fastcall SetFixedRowsEx(int Value);
	int __fastcall GetFixedRowsEx(void);
	void __fastcall SetColCountEx(int Value);
	int __fastcall GetColCountEx(void);
	void __fastcall SetFixedColsEx(int Value);
	int __fastcall GetFixedColsEx(void);
	void __fastcall SetHovering(bool Value);
	int __fastcall GetFixedColWidth(void);
	void __fastcall SetFixedRowHeight(int Value);
	int __fastcall GetFixedRowHeight(void);
	void __fastcall SetWordWrap(bool Value);
	void __fastcall SetSelectionColor(Graphics::TColor AColor);
	void __fastcall SetSelectionTextColor(Graphics::TColor AColor);
	void __fastcall SetSelectionRectangle(bool aValue);
	void __fastcall SetFilterActive(const bool Value);
	void __fastcall ApplyFilter(void);
	Controls::TCursor __fastcall GetCursorEx(void);
	void __fastcall SetCursorEx(const Controls::TCursor Value);
	AnsiString __fastcall GetCellsEx(int i, int j);
	void __fastcall SetCellsEx(int i, int j, AnsiString Value);
	System::TObject* __fastcall GetObjectsEx(int i, int j);
	void __fastcall SetObjectsEx(int i, int j, System::TObject* aObject);
	Graphics::TColor __fastcall GetColors(int i, int j);
	void __fastcall SetColors(int i, int j, Graphics::TColor AColor);
	AnsiString __fastcall GetStrippedCell(int i, int j);
	AnsiString __fastcall GetCurrentCell();
	void __fastcall SetCurrentCell(const AnsiString AValue);
	Classes::TStrings* __fastcall HiddenRow(int j);
	int __fastcall PasteText(int ACol, int ARow, char * p);
	void __fastcall InputFromCSV(AnsiString FileName, bool insertmode);
	void __fastcall OutputToCSV(AnsiString FileName, bool appendmode);
	void __fastcall OutputToHTML(AnsiString FileName, bool appendmode);
	void __fastcall LoadXLS(AnsiString filename, AnsiString sheetname);
	void __fastcall SaveXLS(AnsiString filename, AnsiString sheetname);
	Comctrls::TDateTimePicker* __fastcall GeTDateTimePicker(void);
	void __fastcall SetArrowColor(Graphics::TColor Value);
	Graphics::TColor __fastcall GetArrowColor(void);
	Windows::TPoint __fastcall PasteSize(char * p);
	void __fastcall SetOleDropTarget(bool AValue);
	void __fastcall SetOleDropRTF(bool AValue);
	
protected:
	Windows::TPoint FClipTopLeft;
	TClipOperation FClipLastOp;
	THTMLHintWindow* FScrollHintWnd;
	bool FScrollHintShow;
	virtual TCellType __fastcall GetCellType(int ACol, int ARow);
	virtual TCellGraphic* __fastcall GetCellGraphic(int ACol, int ARow);
	virtual Windows::TPoint __fastcall GetCellGraphicSize(int ACol, int ARow);
	virtual void __fastcall DrawCell(int ACol, int ARow, const Windows::TRect &ARect, Grids::TGridDrawState 
		AState);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	virtual Grids::TInplaceEdit* __fastcall CreateEditor(void);
	virtual bool __fastcall CanEditShow(void);
	DYNAMIC void __fastcall SetEditText(int ACol, int ARow, const AnsiString Value);
	DYNAMIC AnsiString __fastcall GetEditText(int ACol, int ARow);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	DYNAMIC void __fastcall ColumnMoved(int FromIndex, int ToIndex);
	DYNAMIC void __fastcall RowMoved(int FromIndex, int ToIndex);
	DYNAMIC void __fastcall KeyPress(char &Key);
	virtual void __fastcall DestroyWnd(void);
	virtual void __fastcall CreateWnd(void);
	virtual void __fastcall Loaded(void);
	virtual bool __fastcall SelectCell(int ACol, int ARow);
	virtual void __fastcall WndProc(Messages::TMessage &Message);
	DYNAMIC void __fastcall SizeChanged(int OldColCount, int OldRowCount);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation AOperation
		);
	virtual void __fastcall CalcSizingState(int X, int Y, Grids::TGridState &State, int &Index, int &SizingPos
		, int &SizingOfs, Grids::TGridDrawInfo &FixedInfo);
	virtual void __fastcall EditProgress(AnsiString Value, const Windows::TPoint &pt, int SelPos);
	DYNAMIC void __fastcall Click(void);
	DYNAMIC void __fastcall DoEnter(void);
	DYNAMIC void __fastcall DoExit(void);
	virtual void __fastcall Paint(void);
	DYNAMIC void __fastcall ColWidthsChanged(void);
	DYNAMIC void __fastcall RowHeightsChanged(void);
	void __fastcall InvalidateGridRect(const Grids::TGridRect &r);
	DYNAMIC void __fastcall TopLeftChanged(void);
	virtual AnsiString __fastcall EllipsClick(AnsiString s);
	virtual bool __fastcall MatchFilter(int ARow);
	virtual void __fastcall PasteNotify(const Windows::TPoint &orig, const Grids::TGridRect &gr, TClipOperation 
		LastOp);
	virtual AnsiString __fastcall CalcCell(int ACol, int ARow);
	virtual AnsiString __fastcall SaveCell(int ACol, int ARow);
	virtual void __fastcall UpdateCell(int ACol, int ARow);
	virtual void __fastcall InitValidate(int ACol, int ARow);
	virtual void __fastcall CellsChanged(const Windows::TRect &R);
	virtual void __fastcall CellsLoaded(void);
	virtual void __fastcall GetCellColor(int ACol, int ARow, Grids::TGridDrawState AState, Graphics::TBrush* 
		ABrush, Graphics::TFont* AFont);
	virtual void __fastcall GetCellPrintColor(int ACol, int ARow, Grids::TGridDrawState AState, Graphics::TBrush* 
		ABrush, Graphics::TFont* AFont);
	virtual void __fastcall GetCellBorder(int ACol, int ARow, Graphics::TPen* APen, TCellBorders &Borders
		);
	virtual void __fastcall GetCellPrintBorder(int ACol, int ARow, Graphics::TPen* APen, TCellBorders &
		borders);
	virtual void __fastcall GetCellAlign(int ACol, int ARow, Classes::TAlignment &AAlignment);
	virtual void __fastcall GetColFormat(int ACol, TSortStyle &AStyle, AnsiString &aPrefix, AnsiString 
		&aSuffix);
	virtual void __fastcall GetCellEditor(int ACol, int ARow, TEditorType &AEditor);
	virtual void __fastcall GetCellFixed(int ACol, int ARow, bool &IsFixed);
	virtual void __fastcall GetCellReadOnly(int ACol, int ARow, bool &IsReadOnly);
	virtual void __fastcall GetCellPassword(int ACol, int ARow, bool &IsPassword);
	virtual AnsiString __fastcall GetCheckTrue(int ACol, int ARow);
	virtual AnsiString __fastcall GetCheckFalse(int ACol, int ARow);
	int __fastcall GetSaveStartCol(void);
	int __fastcall GetSaveStartRow(void);
	int __fastcall GetSaveEndCol(void);
	int __fastcall GetSaveEndRow(void);
	int __fastcall GetSaveRowCount(void);
	int __fastcall GetSaveColCount(void);
	
public:
	bool LButFlg;
	int Compares;
	int Swaps;
	unsigned SortTime;
	Classes::TStringList* Sortlist;
	int PrevSizeX;
	int PrevSizeY;
	bool EditMode;
	void __fastcall RegisterNotifier(TGridChangeNotifier* ANotifier);
	void __fastcall UnRegisterNotifier(TGridChangeNotifier* ANotifier);
	void __fastcall ClearComboString(void);
	void __fastcall AddComboString(const AnsiString s);
	void __fastcall AddComboStringObject(const AnsiString s, System::TObject* AObject);
	bool __fastcall RemoveComboString(const AnsiString s);
	bool __fastcall SetComboSelectionString(const AnsiString s);
	void __fastcall SetComboSelection(int idx);
	int __fastcall GetComboCount(void);
	__fastcall virtual TAdvStringGrid(Classes::TComponent* AOwner);
	__fastcall virtual ~TAdvStringGrid(void);
	virtual void __fastcall Invalidate(void);
	virtual int __fastcall GetVersionNr(void);
	virtual AnsiString __fastcall GetVersionString();
	virtual bool __fastcall ValidateCell(const AnsiString NewValue);
	virtual void __fastcall RemoveRowsEx(int RowIndex, int RCount);
	virtual void __fastcall RemoveRows(int RowIndex, int RCount);
	virtual void __fastcall InsertRows(int RowIndex, int RCount);
	virtual void __fastcall RemoveCols(int ColIndex, int CCount);
	virtual void __fastcall InsertCols(int ColIndex, int CCount);
	void __fastcall AddColumn(void);
	void __fastcall AddRow(void);
	void __fastcall RemoveSelectedRows(void);
	void __fastcall MergeCols(int ColIndex1, int ColIndex2);
	void __fastcall SwapColumns(int ACol1, int ACol2);
	void __fastcall HideColumn(int Colindex);
	void __fastcall UnHideColumn(int Colindex);
	void __fastcall HideColumns(int fromCol, int toCol);
	void __fastcall UnHideColumns(int fromCol, int toCol);
	void __fastcall UnHideColumnsAll(void);
	bool __fastcall IsHiddenColumn(int Colindex);
	int __fastcall NumHiddenColumns(void);
	void __fastcall RepaintRect(const Windows::TRect &r);
	void __fastcall RepaintCell(int c, int r);
	void __fastcall RepaintRow(int ARow);
	void __fastcall RepaintCol(int ACol);
	void __fastcall GroupCalc(int Colindex, int method);
	void __fastcall GroupSum(int Colindex);
	void __fastcall GroupAvg(int Colindex);
	void __fastcall GroupMin(int Colindex);
	void __fastcall GroupMax(int Colindex);
	void __fastcall GroupCount(int ColIndex);
	void __fastcall Group(int Colindex);
	void __fastcall UnGroup(void);
	void __fastcall HideRow(int Rowindex);
	void __fastcall HideRows(int fromRow, int toRow);
	void __fastcall HideRowsEx(int fromRow, int toRow);
	void __fastcall UnHideRow(int Rowindex);
	void __fastcall UnHideRows(int fromRow, int toRow);
	void __fastcall UnHideRowsAll(void);
	void __fastcall HideSelectedRows(void);
	bool __fastcall IsHiddenRow(int Rowindex);
	int __fastcall NumHiddenRows(void);
	int __fastcall RealRowIndex(int ARow);
	int __fastcall RealColIndex(int ACol);
	int __fastcall DisplRowIndex(int ARow);
	int __fastcall DisplColIndex(int ACol);
	int __fastcall GetRealCol(void);
	int __fastcall GetRealRow(void);
	void __fastcall ScreenToCell(const Windows::TPoint &pt, int &ACol, int &ARow);
	void __fastcall HideSelection(void);
	void __fastcall UnHideSelection(void);
	void __fastcall ScrollInView(int ColIndex, int RowIndex);
	HIDESBASE void __fastcall MoveRow(int FromIndex, int ToIndex);
	HIDESBASE void __fastcall MoveColumn(int FromIndex, int ToIndex);
	void __fastcall SwapRows(int ARow1, int ARow2);
	virtual void __fastcall SortSwapRows(int ARow1, int ARow2);
	virtual void __fastcall ClearRect(int ACol1, int ARow1, int ACol2, int ARow2);
	void __fastcall Clear(void);
	void __fastcall ClearRows(int RowIndex, int RCount);
	void __fastcall ClearCols(int ColIndex, int CCount);
	void __fastcall ClearNormalCells(void);
	void __fastcall ClearSelection(void);
	void __fastcall ClearRowSelect(void);
	void __fastcall SelectRows(int RowIndex, int RCount);
	void __fastcall SelectCols(int ColIndex, int CCount);
	void __fastcall SelectRange(int FromCol, int ToCol, int FromRow, int ToRow);
	bool __fastcall IsCell(AnsiString SubStr, int &ACol, int &ARow);
	void __fastcall SaveToFile(AnsiString FileName);
	void __fastcall SaveToHTML(AnsiString FileName);
	void __fastcall AppendToHTML(AnsiString FileName);
	void __fastcall SaveToXML(AnsiString FileName, AnsiString ListDescr, AnsiString RecordDescr, Classes::TStrings* 
		FieldDescr);
	void __fastcall SaveToASCII(AnsiString FileName);
	void __fastcall SaveToCSV(AnsiString FileName);
	void __fastcall AppendToCSV(AnsiString FileName);
	void __fastcall SaveToFixed(AnsiString FileName, Advobj::TIntList* positions);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall LoadFromFile(AnsiString FileName);
	void __fastcall LoadFromCSV(AnsiString FileName);
	void __fastcall LoadFromFixed(AnsiString FileName, Advobj::TIntList* positions);
	void __fastcall InsertFromCSV(AnsiString FileName);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall SaveColSizes(void);
	void __fastcall LoadColSizes(void);
	void __fastcall SavePrintSettings(AnsiString Key, AnsiString Section);
	void __fastcall LoadPrintSettings(AnsiString Key, AnsiString Section);
	void __fastcall CutToClipboard(void);
	void __fastcall CutSelectionToClipboard(void);
	void __fastcall CopyToClipBoard(void);
	void __fastcall CopySelectionToClipboard(void);
	void __fastcall PasteFromClipboard(void);
	void __fastcall PasteSelectionFromClipboard(void);
	void __fastcall ShowColumnHeaders(void);
	void __fastcall ClearColumnHeaders(void);
	void __fastcall ShowRowHeaders(void);
	void __fastcall ClearRowHeaders(void);
	void __fastcall HideCellEdit(void);
	void __fastcall ShowCellEdit(void);
	void __fastcall RandomFill(bool DoFixed, int Rnd);
	void __fastcall TextFill(bool DoFixed, AnsiString Txt);
	void __fastcall Zoom(int x);
	void __fastcall SaveToXLS(AnsiString Filename);
	void __fastcall SaveToXLSSheet(AnsiString Filename, AnsiString SheetName);
	void __fastcall LoadFromXLS(AnsiString Filename);
	void __fastcall LoadFromXLSSheet(AnsiString Filename, AnsiString SheetName);
	void __fastcall SaveToDOC(AnsiString Filename);
	void __fastcall RichToCell(int Col, int Row, Comctrls::TRichEdit* Richeditor);
	void __fastcall CellToRich(int Col, int Row, Comctrls::TRichEdit* Richeditor);
	void __fastcall AutoSizeCells(const bool DoFixedCells, const int PaddingX, const int PaddingY);
	void __fastcall AutoSizeColumns(const bool DoFixedCols, const int Padding);
	void __fastcall AutoSizeCol(const int ACol);
	void __fastcall AutoSizeRows(const bool DoFixedRows, const int Padding);
	void __fastcall AutoSizeRow(const int ARow);
	void __fastcall StretchRightColumn(void);
	void __fastcall AutoNumberCol(const int ACol);
	void __fastcall AutoNumberRow(const int ARow);
	bool __fastcall IsSelected(int ACol, int ARow);
	AnsiString __fastcall SelectedText();
	void __fastcall ShowInplaceEdit(void);
	void __fastcall HideInplaceEdit(void);
	void __fastcall DoneInplaceEdit(Word Key, Classes::TShiftState Shift);
	void __fastcall QSort(void);
	void __fastcall QSortIndexed(void);
	void __fastcall QSortGroup(void);
	void __fastcall Print(void);
	void __fastcall PrintRect(const Grids::TGridRect &Gridrect);
	void __fastcall PrintPreview(Graphics::TCanvas* Canvas, const Windows::TRect &Displayrect);
	void __fastcall PrintPreviewRect(Graphics::TCanvas* Canvas, const Windows::TRect &displayrect, const 
		Grids::TGridRect &Gridrect);
	void __fastcall PrintDraw(Graphics::TCanvas* Canvas, const Windows::TRect &DrawRect);
	void __fastcall PrintDrawRect(Graphics::TCanvas* Canvas, const Windows::TRect &DrawRect, const Grids::TGridRect 
		&Gridrect);
	void __fastcall SortByColumn(int Col);
	void __fastcall QuickSort(int Col, int Left, int Right);
	void __fastcall QuickSortIndexed(int Left, int Right);
	bool __fastcall SortLine(int Col, int ARow1, int ARow2);
	int __fastcall Search(AnsiString s);
	Windows::TPoint __fastcall Find(const Windows::TPoint &StartCell, AnsiString s, TFindParams FindParams
		);
	Windows::TPoint __fastcall FindFirst(AnsiString s, TFindParams FindParams);
	Windows::TPoint __fastcall FindNext();
	int __fastcall MapFontHeight(int pointsize);
	int __fastcall MapFontSize(int Height);
	Graphics::TBitmap* __fastcall CreateBitmap(int ACol, int ARow, bool transparent, TCellHAlign hal, TCellVAlign 
		val);
	void __fastcall AddBitmap(int ACol, int ARow, Graphics::TBitmap* ABmp, bool transparent, TCellHAlign 
		hal, TCellVAlign val);
	void __fastcall RemoveBitmap(int ACol, int ARow);
	Graphics::TBitmap* __fastcall GetBitmap(int ACol, int ARow);
	Graphics::TPicture* __fastcall CreatePicture(int ACol, int ARow, bool transparent, TStretchMode stretchmode
		, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall AddPicture(int ACol, int ARow, Graphics::TPicture* apicture, bool transparent, TStretchMode 
		stretchmode, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall RemovePicture(int ACol, int ARow);
	Graphics::TPicture* __fastcall GetPicture(int ACol, int ARow);
	Advobj::TFilePicture* __fastcall CreateFilePicture(int ACol, int ARow, bool transparent, TStretchMode 
		stretchmode, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall AddFilePicture(int ACol, int ARow, Advobj::TFilePicture* afilepicture, bool transparent
		, TStretchMode stretchmode, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall RemoveFilePicture(int ACol, int ARow);
	Advobj::TFilePicture* __fastcall GetFilePicture(int ACol, int ARow);
	void __fastcall AddNode(int ARow, int Span);
	void __fastcall RemoveNode(int ARow);
	bool __fastcall IsNode(int ARow);
	bool __fastcall GetNodeState(int ARow);
	void __fastcall SetNodeState(int ARow, bool Value);
	void __fastcall ExpandNode(int ARow);
	void __fastcall ContractNode(int ARow);
	void __fastcall ExpandAll(void);
	void __fastcall ContractAll(void);
	void __fastcall AddRadio(int ACol, int ARow, int DirRadio, int IdxRadio, Classes::TStrings* sl);
	void __fastcall RemoveRadio(int ACol, int ARow);
	bool __fastcall IsRadio(int ACol, int ARow);
	bool __fastcall GetRadioIdx(int ACol, int ARow, int &IdxRadio);
	bool __fastcall SetRadioIdx(int ACol, int ARow, int IdxRadio);
	void __fastcall AddImageIdx(int ACol, int ARow, int Aidx, TCellHAlign hal, TCellVAlign val);
	void __fastcall RemoveImageIdx(int ACol, int ARow);
	bool __fastcall GetImageIdx(int ACol, int ARow, int &idx);
	void __fastcall AddMultiImage(int ACol, int ARow, int Dir, TCellHAlign hal, TCellVAlign val);
	void __fastcall RemoveMultiImage(int ACol, int ARow);
	void __fastcall AddDataImage(int ACol, int ARow, int Aidx, TCellHAlign hal, TCellVAlign val);
	void __fastcall RemoveDataImage(int ACol, int ARow);
	void __fastcall AddRotated(int ACol, int ARow, short aAngle, AnsiString s);
	void __fastcall RemoveRotated(int ACol, int ARow);
	bool __fastcall IsRotated(int ACol, int ARow, int &aAngle);
	Graphics::TIcon* __fastcall CreateIcon(int ACol, int ARow, TCellHAlign hal, TCellVAlign val);
	void __fastcall AddIcon(int ACol, int ARow, Graphics::TIcon* aicon, TCellHAlign hal, TCellVAlign val
		);
	void __fastcall RemoveIcon(int ACol, int ARow);
	void __fastcall AddButton(int ACol, int ARow, int bw, int bh, AnsiString caption, TCellHAlign hal, 
		TCellVAlign val);
	void __fastcall PushButton(int ACol, int ARow, bool push);
	void __fastcall RemoveButton(int ACol, int ARow);
	bool __fastcall HasButton(int ACol, int ARow);
	void __fastcall AddCheckBox(int ACol, int ARow, bool State, bool Data);
	void __fastcall RemoveCheckBox(int ACol, int ARow);
	bool __fastcall HasCheckBox(int ACol, int ARow);
	bool __fastcall HasDataCheckBox(int ACol, int ARow);
	bool __fastcall GetCheckBoxState(int ACol, int ARow, bool &state);
	bool __fastcall SetCheckBoxState(int ACol, int ARow, bool state);
	bool __fastcall ToggleCheckBox(int ACol, int ARow);
	void __fastcall AddProgress(int ACol, int ARow, Graphics::TColor FGColor, Graphics::TColor BKColor)
		;
	void __fastcall AddProgressEx(int ACol, int ARow, Graphics::TColor FGColor, Graphics::TColor FGTextColor
		, Graphics::TColor BKColor, Graphics::TColor BKTextColor);
	void __fastcall RemoveProgress(int ACol, int ARow);
	void __fastcall AddComment(int ACol, int ARow, AnsiString comment);
	void __fastcall RemoveComment(int ACol, int ARow);
	void __fastcall AddMarker(int ACol, int ARow, int ErrPos, int ErrLen);
	void __fastcall RemoveMarker(int ACol, int ARow);
	void __fastcall GetMarker(int ACol, int ARow, int &ErrPos, int &ErrLen);
	bool __fastcall IsComment(int ACol, int ARow, AnsiString &comment);
	double __fastcall ColumnSum(int ACol, int fromRow, int toRow);
	double __fastcall ColumnAvg(int ACol, int fromRow, int toRow);
	double __fastcall ColumnMin(int ACol, int fromRow, int toRow);
	double __fastcall ColumnMax(int ACol, int fromRow, int toRow);
	double __fastcall RowSum(int ARow, int fromCol, int toCol);
	double __fastcall RowAvg(int ARow, int fromCol, int toCol);
	double __fastcall RowMin(int ARow, int fromCol, int toCol);
	double __fastcall RowMax(int ARow, int fromCol, int toCol);
	void __fastcall BeginUpdate(void);
	void __fastcall EndUpdate(void);
	void __fastcall ResetUpdate(void);
	__property bool LockUpdate = {read=GetLockFlag, write=SetLockFlag, nodefault};
	__property TCellType CellTypes[int ACol][int ARow] = {read=GetCellType};
	__property TCellGraphic* CellGraphics[int ACol][int ARow] = {read=GetCellGraphic};
	__property Windows::TPoint CellGraphicSize[int ACol][int ARow] = {read=GetCellGraphicSize};
	__property Advobj::TIntList* CellImages[int ACol][int ARow] = {read=GetCellImages};
	__property int Ints[int ACol][int ARow] = {read=GetInts, write=SetInts};
	__property double Floats[int ACol][int ARow] = {read=GetFloats, write=SetFloats};
	__property System::TDateTime Dates[int ACol][int ARow] = {read=GetDates, write=SetDates};
	__property System::TDateTime Times[int ACol][int ARow] = {read=GetTimes, write=SetTimes};
	__property char Delimiter = {read=FDelimiter, write=FDelimiter, nodefault};
	__property char PasswordChar = {read=FPasswordChar, write=FPasswordChar, nodefault};
	__property bool JavaCSV = {read=FJavaCSV, write=FJavaCSV, nodefault};
	__property bool FastPrint = {read=FFastPrint, write=FFastPrint, nodefault};
	__property AnsiString CheckTrue = {read=FCheckTrue, write=FCheckTrue};
	__property AnsiString CheckFalse = {read=FCheckFalse, write=FCheckFalse};
	__property bool SaveFixedCells = {read=FSaveFixedCells, write=FSaveFixedCells, nodefault};
	__property bool SaveHiddenCells = {read=FSaveHiddenCells, write=FSaveHiddenCells, nodefault};
	__property Advobj::TSortIndexList* SortIndexes = {read=FSortIndexes};
	__property AnsiString OriginalCellValue = {read=CellCache};
	__property Comctrls::TDateTimePicker* DateTimePicker = {read=GeTDateTimePicker};
	__property TGridCombo* Combobox = {read=EditCombo};
	__property TGridSpin* SpinEdit = {read=EditSpin};
	__property TGridEditBtn* BtnEdit = {read=EditBtn};
	__property TGridUnitEditBtn* BtnUnitEdit = {read=UnitEditBtn};
	__property TAdvRichEdit* RichEdit = {read=FRichEdit};
	__property TAdvRichEdit* InplaceRichEdit = {read=FInplaceRichEdit};
	__property TAdvInplaceEdit* NormalEdit = {read=GetInplaceEditor};
	__property bool PrinterDriverFix = {read=FPrinterdriverfix, write=FPrinterdriverfix, nodefault};
	__property bool RowSelect[int ARow] = {read=GetRowSelect, write=SetRowSelect};
	__property int RowSelectCount = {read=GetRowSelectCount, nodefault};
	__property bool NodeState[int ARow] = {read=GetNodeState, write=SetNodeState};
	__property bool FindBusy = {read=FFindBusy, nodefault};
	__property Windows::TRect PrintPageRect = {read=FPrintPageRect};
	__property int PrintPageWidth = {read=FPrintPageWidth, nodefault};
	__property int PrintColWidth[int ACol] = {read=GetPrintColWidth};
	__property int PrintColOffset[int ACol] = {read=GetPrintColOffset};
	__property int PrintColStart = {read=FPrintColStart, nodefault};
	__property int PrintColEnd = {read=FPrintColEnd, nodefault};
	__property int PrintNrOfPages = {read=FPrintPageNum, nodefault};
	__property bool ExcelClipboardFormat = {read=FExcelClipboardFormat, write=FExcelClipboardFormat, nodefault
		};
	__property int PreviewPage = {read=FPrintPageFrom, write=SetPreviewPage, nodefault};
	__property AnsiString AllCells[int i][int j] = {read=GetCellsEx, write=SetCellsEx};
	__property System::TObject* AllObjects[int i][int j] = {read=GetObjectsEx, write=SetObjectsEx};
	__property Graphics::TColor Colors[int i][int j] = {read=GetColors, write=SetColors};
	__property AnsiString StrippedCells[int i][int j] = {read=GetStrippedCell};
	__property AnsiString CurrentCell = {read=GetCurrentCell, write=SetCurrentCell};
	__property Graphics::TColor ArrowColor = {read=GetArrowColor, write=SetArrowColor, nodefault};
	__property int GroupColumn = {read=FGroupColumn, write=SetGroupColumn, nodefault};
	__property int RealRow = {read=GetRealRow, nodefault};
	__property int RealCol = {read=GetRealCol, nodefault};
	__property int SaveStartCol = {read=GetSaveStartCol, nodefault};
	__property int SaveStartRow = {read=GetSaveStartRow, nodefault};
	__property int SaveEndCol = {read=GetSaveEndCol, nodefault};
	__property int SaveEndRow = {read=GetSaveEndRow, nodefault};
	__property int SaveColCount = {read=GetSaveColCount, nodefault};
	__property int SaveRowCount = {read=GetSaveRowCount, nodefault};
	__property int VersionNr = {read=GetVersionNr, nodefault};
	__property AnsiString VersionString = {read=GetVersionString};
	__property TEditLink* EditLink = {read=FEditLink, write=FEditLink};
	__property Windows::TPoint XYOffset = {read=FXYOffset, write=SetXYOffset};
	
__published:
	__property bool ActiveCellShow = {read=FActiveCellShow, write=SetActiveCellShow, nodefault};
	__property Graphics::TFont* ActiveCellFont = {read=FActiveCellFont, write=SetActiveCellFont};
	__property TBands* Bands = {read=FBands, write=FBands};
	__property bool AutoNumAlign = {read=FAutoNumAlign, write=FAutoNumAlign, nodefault};
	__property bool AutoSize = {read=FAutoSize, write=SetAutoSizeP, nodefault};
	__property TVAlignment VAlignment = {read=FVAlignment, write=SetVAlignment, nodefault};
	__property bool EnhTextSize = {read=FEnhTextSize, write=FEnhTextSize, nodefault};
	__property bool EnhRowColMove = {read=FEnhRowColMove, write=FEnhRowColMove, nodefault};
	__property bool SortFixedCols = {read=FSortFixedCols, write=FSortFixedCols, nodefault};
	__property bool SortNormalCellsOnly = {read=FSortNormalCellsOnly, write=FSortNormalCellsOnly, nodefault
		};
	__property bool SizeWithForm = {read=FSizeWithForm, write=FSizeWithForm, nodefault};
	__property bool Multilinecells = {read=FMultilinecells, write=FMultilinecells, nodefault};
	__property TGridColorEvent OnGetCellColor = {read=FOnGetCellColor, write=FOnGetCellColor};
	__property TGridColorEvent OnGetCellPrintColor = {read=FOnGetCellPrintColor, write=FOnGetCellPrintColor
		};
	__property TGridBorderEvent OnGetCellPrintBorder = {read=FOnGetCellPrintBorder, write=FOnGetCellPrintBorder
		};
	__property TGridBorderEvent OnGetCellBorder = {read=FOnGetCellBorder, write=FOnGetCellBorder};
	__property TGridAlignEvent OnGetAlignment = {read=FOnGetAlignment, write=FOnGetAlignment};
	__property TGridFormatEvent OnGetFormat = {read=FOnGetFormat, write=FOnGetFormat};
	__property TGetCheckEvent OnGetCheckTrue = {read=FOnGetCheckTrue, write=FOnGetCheckTrue};
	__property TGetCheckEvent OnGetCheckFalse = {read=FOnGetCheckFalse, write=FOnGetCheckFalse};
	__property TGridHintEvent OnGridHint = {read=FOnGridHint, write=FOnGridHint};
	__property TRowChangingEvent OnRowChanging = {read=FOnRowChanging, write=FOnRowChanging};
	__property TColChangingEvent OnColChanging = {read=FOnColChanging, write=FOnColChanging};
	__property TCellChangingEvent OnCellChanging = {read=FOnCellChanging, write=FOnCellChanging};
	__property TGridPrintPageEvent OnPrintPage = {read=FOnPrintPage, write=FOnPrintPage};
	__property TGridPrintPageDoneEvent OnPrintPageDone = {read=FOnPrintPageDone, write=FOnPrintPageDone
		};
	__property TGridPrintStartEvent OnPrintStart = {read=FOnPrintStart, write=FOnPrintStart};
	__property TDoFitToPageEvent OnFitToPage = {read=FDoFitToPage, write=FDoFitToPage};
	__property TGridPrintNewPageEvent OnPrintNewPage = {read=FOnPrintNewPage, write=FOnPrintNewPage};
	__property TGridPrintColumnWidthEvent OnPrintSetColumnWidth = {read=FOnPrintSetColumnWidth, write=FOnPrintSetColumnWidth
		};
	__property TGridPrintRowHeightEvent OnPrintSetRowHeight = {read=FOnPrintSetRowHeight, write=FOnPrintSetRowHeight
		};
	__property TCanAddRowEvent OnCanAddRow = {read=FOnCanAddRow, write=FOnCanAddRow};
	__property TAutoAddRowEvent OnAutoAddRow = {read=FOnAutoAddRow, write=FOnAutoAddRow};
	__property TCanInsertRowEvent OnCanInsertRow = {read=FOnCanInsertRow, write=FOnCanInsertRow};
	__property TAutoInsertRowEvent OnAutoInsertRow = {read=FOnAutoInsertRow, write=FOnAutoInsertRow};
	__property TAutoInsertColEvent OnAutoInsertCol = {read=FOnAutoInsertCol, write=FOnAutoInsertCol};
	__property TCanDeleteRowEvent OnCanDeleteRow = {read=FOnCanDeleteRow, write=FOnCanDeleteRow};
	__property TAutoDeleteRowEvent OnAutoDeleteRow = {read=FOnAutoDeleteRow, write=FOnAutoDeleteRow};
	__property TClickSortEvent OnClickSort = {read=FOnClickSort, write=FOnClickSort};
	__property TCanSortEvent OnCanSort = {read=FOnCanSort, write=FOnCanSort};
	__property TNodeClickEvent OnExpandNode = {read=FOnExpandNode, write=FOnExpandNode};
	__property TNodeClickEvent OnContractNode = {read=FOnContractNode, write=FOnContractNode};
	__property TCustomCompareEvent OnCustomCompare = {read=FCustomCompare, write=FCustomCompare};
	__property TRawCompareEvent OnRawCompare = {read=FRawCompare, write=FRawCompare};
	__property TClickCellEvent OnClickCell = {read=FOnClickCell, write=FOnClickCell};
	__property TClickCellEvent OnRightClickCell = {read=FOnRightClickCell, write=FOnRightClickCell};
	__property TDblClickCellEvent OnDblClickCell = {read=FOnDblClickCell, write=FOnDblClickCell};
	__property TCanEditCellEvent OnCanEditCell = {read=FOnCanEditCell, write=FOnCanEditCell};
	__property TIsFixedCellEvent OnIsFixedCell = {read=FOnIsFixedCell, write=FOnIsFixedCell};
	__property TIsPasswordCellEvent OnIsPasswordCell = {read=FOnIsPasswordCell, write=FOnIsPasswordCell
		};
	__property TAnchorClickEvent OnAnchorClick = {read=FOnAnchorClick, write=FOnAnchorClick};
	__property TAnchorEvent OnAnchorEnter = {read=FOnAnchorEnter, write=FOnAnchorEnter};
	__property TAnchorEvent OnAnchorExit = {read=FOnAnchorExit, write=FOnAnchorExit};
	__property TClipboardEvent OnClipboardPaste = {read=FOnClipboardPaste, write=FOnClipboardPaste};
	__property TClipboardEvent OnClipboardCopy = {read=FOnClipboardCopy, write=FOnClipboardCopy};
	__property TClipboardEvent OnClipboardCut = {read=FOnClipboardCut, write=FOnClipboardCut};
	__property TCellValidateEvent OnCellValidate = {read=FOnCellValidate, write=FOnCellValidate};
	__property TCellsChangedEvent OnCellsChanged = {read=FOnCellsChanged, write=FOnCellsChanged};
	__property TGridProgressEvent OnFileProgress = {read=FOnFileProgress, write=FOnFileProgress};
	__property TSortDirection SortDirection = {read=FSortDirection, write=FSortDirection, nodefault};
	__property TGetEditorTypeEvent OnGetEditorType = {read=FOnGetEditorType, write=FOnGetEditorType};
	__property TGetEditorPropEvent OnGetEditorProp = {read=FOnGetEditorProp, write=FOnGetEditorProp};
	__property TEllipsClickEvent OnEllipsClick = {read=FOnEllipsClick, write=FOnEllipsClick};
	__property TButtonClickEvent OnButtonClick = {read=FOnButtonClick, write=FOnButtonClick};
	__property TCheckBoxClickEvent OnCheckBoxClick = {read=FOnCheckBoxClick, write=FOnCheckBoxClick};
	__property TCheckBoxClickEvent OnCheckBoxMouseUp = {read=FOnCheckBoxMouseUp, write=FOnCheckBoxMouseUp
		};
	__property TRadioClickEvent OnRadioClick = {read=FOnRadioClick, write=FOnRadioClick};
	__property TRadioClickEvent OnRadioMouseUp = {read=FOnRadioMouseUp, write=FOnRadioMouseUp};
	__property TComboChangeEvent OnComboChange = {read=FOnComboChange, write=FOnComboChange};
	__property TComboObjectChangeEvent OnComboObjectChange = {read=FOnComboObjectChange, write=FOnComboObjectChange
		};
	__property TSpinClickEvent OnSpinClick = {read=FOnSpinClick, write=FOnSpinClick};
	__property TFloatSpinClickEvent OnFloatSpinClick = {read=FOnFloatSpinClick, write=FOnFloatSpinClick
		};
	__property TDateTimeSpinClickEvent OnTimeSpinClick = {read=FontimeSpinClick, write=FontimeSpinClick
		};
	__property TDateTimeSpinClickEvent OnDateSpinClick = {read=FOnDateSpinClick, write=FOnDateSpinClick
		};
	__property Classes::TNotifyEvent OnRichEditSelectionChange = {read=FOnRichEditSelectionChange, write=
		FOnRichEditSelectionChange};
	__property TOleDragDropEvent OnOleDrop = {read=FOnOleDrop, write=FOnOleDrop};
	__property TOleDroppedEvent OnOleDropped = {read=FOnOleDropped, write=FOnOleDropped};
	__property TOleDragDropEvent OnOleDrag = {read=FOnOleDrag, write=FOnOleDrag};
	__property TOleDragOverEvent OnOleDragOver = {read=FOnOleDragOver, write=FOnOleDragOver};
	__property TOleDragStartEvent OnOleDragStart = {read=FOnOleDragStart, write=FOnOleDragStart};
	__property TOleDragStopEvent OnOleDragStop = {read=FOnOleDragStop, write=FOnOleDragStop};
	__property TOleDropColEvent OnOleDropCol = {read=FOnOleDropCol, write=FOnOleDropCol};
	__property bool SortFull = {read=FSortFull, write=FSortFull, nodefault};
	__property bool SortAutoFormat = {read=FSortAutoFormat, write=FSortAutoFormat, nodefault};
	__property bool SortShow = {read=FSortShow, write=SetSortShow, nodefault};
	__property bool SortSingleColumn = {read=FSortSingleColumn, write=FSortSingleColumn, default=0};
	__property bool SortIgnoreBlanks = {read=FSortIgnoreBlanks, write=FSortIgnoreBlanks, default=0};
	__property TSortBlankPosition SortBlankPosition = {read=FSortBlankPos, write=FSortBlankPos, default=0
		};
	__property bool SortIndexShow = {read=FSortIndexShow, write=SetSortIndexShow, nodefault};
	__property bool EnableGraphics = {read=FEnableGraphics, write=FEnableGraphics, nodefault};
	__property bool EnableHTML = {read=FEnableHTML, write=FEnableHTML, nodefault};
	__property bool EnableWheel = {read=FEnableWheel, write=FEnableWheel, nodefault};
	__property bool ExcelStyleDecimalSeparator = {read=FExcelStyleDecimalSeparator, write=FExcelStyleDecimalSeparator
		, default=0};
	__property bool Flat = {read=FFlat, write=SetFlat, nodefault};
	__property bool FlatCheckBox = {read=FFlatCheckBox, write=SetFlatCheckBox, nodefault};
	__property TGridLook Look = {read=FLook, write=SetLook, nodefault};
	__property int SortColumn = {read=FSortColumn, write=SetSortColumn, nodefault};
	__property Graphics::TColor HintColor = {read=FHintColor, write=FHintColor, nodefault};
	__property Graphics::TColor SelectionColor = {read=FSelectionColor, write=SetSelectionColor, nodefault
		};
	__property Graphics::TColor SelectionTextColor = {read=FSelectionTextColor, write=SetSelectionTextColor
		, nodefault};
	__property bool SelectionRectangle = {read=FSelectionRectangle, write=SetSelectionRectangle, nodefault
		};
	__property bool SelectionRTFKeep = {read=FSelectionRTFKeep, write=FSelectionRTFKeep, nodefault};
	__property bool HintShowCells = {read=FHintShowCells, write=FHintShowCells, nodefault};
	__property bool HintShowLargeText = {read=FHintShowLargeText, write=FHintShowLargeText, nodefault};
		
	__property bool HintShowSizing = {read=FHintShowSizing, write=FHintShowSizing, nodefault};
	__property TScrollHintEvent OnScrollHint = {read=FOnScrollHint, write=FOnScrollHint};
	__property TColumnSizeEvent OnColumnSize = {read=FOnColumnSize, write=FOnColumnSize};
	__property TColumnSizeEvent OnColumnMove = {read=FOnColumnMove, write=FOnColumnMove};
	__property TRowSizeEvent OnRowSize = {read=FOnRowSize, write=FOnRowSize};
	__property TRowSizeEvent OnRowMove = {read=FOnRowMove, write=FOnRowMove};
	__property TEndColumnSizeEvent OnEndColumnSize = {read=FOnEndColumnSize, write=FOnEndColumnSize};
	__property TEndRowSizeEvent OnEndRowSize = {read=FOnEndRowSize, write=FOnEndRowSize};
	__property bool OleAcceptFiles = {read=FOleAcceptFiles, write=FOleAcceptFiles, default=0};
	__property bool OleAcceptText = {read=FOleAcceptText, write=FOleAcceptText, default=0};
	__property bool OleDropTarget = {read=FOleDropTarget, write=SetOleDropTarget, default=0};
	__property bool OleDropSource = {read=FOleDropSource, write=FOleDropSource, default=0};
	__property bool OleEntireRows = {read=FOleEntireRows, write=FOleEntireRows, default=0};
	__property bool OleInsertRows = {read=FOleInsertRows, write=FOleInsertRows, default=0};
	__property bool OleRemoveRows = {read=FOleRemoveRows, write=FOleRemoveRows, default=0};
	__property bool OleDropRTF = {read=FOleDropRTF, write=SetOleDropRTF, default=0};
	__property TPrintSettings* PrintSettings = {read=FPrintSettings, write=FPrintSettings};
	__property THTMLSettings* HTMLSettings = {read=FHTMLSettings, write=FHTMLSettings};
	__property TNavigation* Navigation = {read=FNavigation, write=FNavigation};
	__property TColumnSize* ColumnSize = {read=FColumnSize, write=FColumnSize};
	__property TCellNode* CellNode = {read=FCellNode, write=FCellNode};
	__property TSizeWhileTyping* SizeWhileTyping = {read=FSizeWhileTyping, write=FSizeWhileTyping};
	__property int MaxEditLength = {read=FMaxEditLength, write=SetMaxEditLength, nodefault};
	__property TMouseActions* MouseActions = {read=FMouseActions, write=FMouseActions};
	__property Controls::TImageList* GridImages = {read=FGridImages, write=SetImages};
	__property TIntelliPan IntelliPan = {read=FIntelliPan, write=FIntelliPan, nodefault};
	__property bool IntelliZoom = {read=FIntelliZoom, write=FIntelliZoom, default=1};
	__property Graphics::TColor URLColor = {read=FURLColor, write=SetURLColor, nodefault};
	__property bool URLShow = {read=FURLShow, write=SetURLShow, nodefault};
	__property bool URLFull = {read=FURLFull, write=SetURLFull, nodefault};
	__property bool URLEdit = {read=FURLEdit, write=FURLEdit, nodefault};
	__property TScrollType ScrollType = {read=FScrollType, write=SetScrollType, nodefault};
	__property Graphics::TColor ScrollColor = {read=FScrollColor, write=SetScrollColor, nodefault};
	__property int ScrollWidth = {read=FScrollWidth, write=SetScrollWidth, nodefault};
	__property bool ScrollSynch = {read=FScrollSynch, write=FScrollSynch, nodefault};
	__property bool ScrollProportional = {read=FScrollProportional, write=SetScrollProportional, nodefault
		};
	__property TScrollHintType ScrollHints = {read=FScrollHints, write=FScrollHints, nodefault};
	__property bool OemConvert = {read=FOemConvert, write=FOemConvert, nodefault};
	__property int FixedFooters = {read=FFixedFooters, write=SetFixedFooters, nodefault};
	__property int FixedRightCols = {read=FFixedRightCols, write=SetFixedRightCols, nodefault};
	__property int FixedColWidth = {read=GetFixedColWidth, write=SetFixedColWidth, nodefault};
	__property int FixedRowHeight = {read=GetFixedRowHeight, write=SetFixedRowHeight, nodefault};
	__property bool FixedRowAlways = {read=FFixedRowAlways, write=FFixedRowAlways, default=0};
	__property bool FixedColAlways = {read=FFixedColAlways, write=FFixedColAlways, default=0};
	__property Graphics::TFont* FixedFont = {read=FFixedFont, write=SetFixedFont};
	__property int RowCount = {read=GetRowCountEx, write=SetRowCountEx, nodefault};
	__property int FixedRows = {read=GetFixedRowsEx, write=SetFixedRowsEx, nodefault};
	__property int ColCount = {read=GetColCountEx, write=SetColCountEx, nodefault};
	__property int FixedCols = {read=GetFixedColsEx, write=SetFixedColsEx, nodefault};
	__property bool FixedAsButtons = {read=FFixedAsButtons, write=FFixedAsButtons, nodefault};
	__property AnsiString FloatFormat = {read=FFloatFormat, write=FFloatFormat};
	__property bool WordWrap = {read=FWordWrap, write=SetWordWrap, nodefault};
	__property Classes::TStringList* ColumnHeaders = {read=FColumnHeaders, write=SetColumnHeaders};
	__property Classes::TStringList* RowHeaders = {read=FRowHeaders, write=SetRowHeaders};
	__property Classes::TStringList* LookupItems = {read=FLookupItems, write=SetLookupItems};
	__property bool Lookup = {read=FLookup, write=FLookup, nodefault};
	__property bool LookupCaseSensitive = {read=FLookupCaseSensitive, write=FLookupCaseSensitive, nodefault
		};
	__property bool LookupHistory = {read=FLookupHistory, write=FLookupHistory, nodefault};
	__property bool ShowSelection = {read=FShowSelection, write=SetShowSelection, default=1};
	__property bool HideFocusRect = {read=FHideFocusRect, write=FHideFocusRect, default=0};
	__property Graphics::TBitmap* SortUpGlyph = {read=GetUpGlyph, write=SetUpGlyph};
	__property Graphics::TBitmap* SortDownGlyph = {read=GetDownGlyph, write=SetDownGlyph};
	__property Graphics::TBitmap* RowIndicator = {read=GetRowIndicator, write=SetRowIndicator};
	__property TBackGround* BackGround = {read=FBackGround, write=SetBackground};
	__property bool Hovering = {read=FHovering, write=SetHovering, default=0};
	__property TFilter* Filter = {read=FFilter, write=FFilter};
	__property bool FilterActive = {read=FFilterActive, write=SetFilterActive, default=0};
	__property Controls::TCursor Cursor = {read=GetCursorEx, write=SetCursorEx, nodefault};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TAdvStringGrid(HWND ParentWindow) : Grids::TStringGrid(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TBands : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FPrint;
	bool FActive;
	int fTotalLength;
	int fSecondaryLength;
	int fPrimaryLength;
	Graphics::TColor fSecondaryColor;
	Graphics::TColor fPrimaryColor;
	TAdvStringGrid* FOwner;
	void __fastcall SetActive(const bool Value);
	void __fastcall SetPrimaryColor(const Graphics::TColor Value);
	void __fastcall SetPrimaryLength(const int Value);
	void __fastcall SetSecondaryColor(const Graphics::TColor Value);
	void __fastcall SetSecondaryLength(const int Value);
	
public:
	__fastcall TBands(TAdvStringGrid* AOwner);
	
__published:
	__property bool Active = {read=FActive, write=SetActive, nodefault};
	__property Graphics::TColor PrimaryColor = {read=fPrimaryColor, write=SetPrimaryColor, nodefault};
	__property int PrimaryLength = {read=fPrimaryLength, write=SetPrimaryLength, nodefault};
	__property Graphics::TColor SecondaryColor = {read=fSecondaryColor, write=SetSecondaryColor, nodefault
		};
	__property int SecondaryLength = {read=fSecondaryLength, write=SetSecondaryLength, nodefault};
	__property bool Print = {read=FPrint, write=FPrint, nodefault};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TBands(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TEditStyle { esInplace, esPopup };
#pragma option pop

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TEditLink : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TAdvStringGrid* FOwner;
	bool FWantKeyLeftRight;
	bool FWantKeyUpDown;
	bool FWantKeyHomeEnd;
	bool FWantKeyPriorNext;
	bool FWantKeyReturn;
	bool FWantKeyEscape;
	TEditStyle FEditStyle;
	Forms::TForm* FPopupForm;
	int FPopupWidth;
	int FPopupHeight;
	bool FForcedExit;
	Windows::TPoint FEditCell;
	int FTag;
	
public:
	__fastcall virtual TEditLink(Classes::TComponent* AOwner);
	__fastcall virtual ~TEditLink(void);
	virtual void __fastcall EditKeyDown(System::TObject* Sender, Word &Key, Classes::TShiftState Shift)
		;
	void __fastcall EditExit(System::TObject* Sender);
	void __fastcall FormExit(System::TObject* Sender);
	Controls::TWinControl* __fastcall GetParent(void);
	virtual Controls::TWinControl* __fastcall GetEditControl(void);
	AnsiString __fastcall GetCellValue();
	void __fastcall SetCellValue(AnsiString s);
	virtual void __fastcall CreateEditor(Controls::TWinControl* AParent);
	virtual void __fastcall DestroyEditor(void);
	void __fastcall HideEditor(void);
	virtual void __fastcall SetFocus(bool Value);
	virtual void __fastcall SetRect(const Windows::TRect &r);
	virtual void __fastcall SetVisible(bool Value);
	virtual void __fastcall SetProperties(void);
	virtual AnsiString __fastcall GetEditorValue();
	virtual void __fastcall SetEditorValue(AnsiString s);
	__property TAdvStringGrid* Grid = {read=FOwner};
	__property Windows::TPoint EditCell = {read=FEditCell};
	
__published:
	__property TEditStyle EditStyle = {read=FEditStyle, write=FEditStyle, nodefault};
	__property int PopupWidth = {read=FPopupWidth, write=FPopupWidth, nodefault};
	__property int PopupHeight = {read=FPopupHeight, write=FPopupHeight, nodefault};
	__property bool WantKeyLeftRight = {read=FWantKeyLeftRight, write=FWantKeyLeftRight, nodefault};
	__property bool WantKeyUpDown = {read=FWantKeyUpDown, write=FWantKeyUpDown, nodefault};
	__property bool WantKeyHomeEnd = {read=FWantKeyHomeEnd, write=FWantKeyHomeEnd, nodefault};
	__property bool WantKeyPriorNext = {read=FWantKeyPriorNext, write=FWantKeyPriorNext, nodefault};
	__property bool WantKeyReturn = {read=FWantKeyReturn, write=FWantKeyReturn, nodefault};
	__property bool WantKeyEscape = {read=FWantKeyEscape, write=FWantKeyEscape, nodefault};
	__property int Tag = {read=FTag, write=FTag, nodefault};
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TAdvInplaceEdit : public Grids::TInplaceEdit 
{
	typedef Grids::TInplaceEdit inherited;
	
private:
	short FLengthLimit;
	bool FValign;
	bool FWordWrap;
	bool GotKey;
	bool Workmode;
	TAdvStringGrid* FGrid;
	void __fastcall SetVAlign(bool Value);
	void __fastcall SetWordWrap(bool Value);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMKeyUp(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonDblClk(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMPaste(Messages::TMessage &Msg);
	MESSAGE void __fastcall WMCopy(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall WMCut(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall CMWantSpecialKey(Messages::TWMKey &Msg);
	
protected:
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	virtual void __fastcall CreateWnd(void);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyPress(char &Key);
	virtual void __fastcall UpdateContents(void);
	
public:
	void __fastcall DoChange(void);
	
__published:
	__property bool VAlign = {read=FValign, write=SetVAlign, nodefault};
	__property bool WordWrap = {read=FWordWrap, write=SetWordWrap, nodefault};
	__property short LengthLimit = {read=FLengthLimit, write=FLengthLimit, nodefault};
public:
	#pragma option push -w-inl
	/* TInplaceEdit.Create */ inline __fastcall virtual TAdvInplaceEdit(Classes::TComponent* AOwner) : 
		Grids::TInplaceEdit(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TAdvInplaceEdit(HWND ParentWindow) : Grids::TInplaceEdit(
		ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~TAdvInplaceEdit(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TFilterData : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	short FColumn;
	AnsiString FCondition;
	bool FCaseSensitive;
	
public:
	__fastcall virtual TFilterData(Classes::TCollection* ACollection);
	
__published:
	__property short Column = {read=FColumn, write=FColumn, nodefault};
	__property AnsiString Condition = {read=FCondition, write=FCondition};
	__property bool CaseSensitive = {read=FCaseSensitive, write=FCaseSensitive, default=1};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TFilterData(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TGridItem;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridItem : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	int FIdx;
	Classes::TStrings* FItems;
	void __fastcall SetIdx(const int Value);
	void __fastcall SetItems(const Classes::TStrings* Value);
	
public:
	__fastcall virtual TGridItem(Classes::TCollection* Collection);
	__fastcall virtual ~TGridItem(void);
	
__published:
	__property int Idx = {read=FIdx, write=SetIdx, nodefault};
	__property Classes::TStrings* Items = {read=FItems, write=SetItems};
};

#pragma pack(pop)

class DELPHICLASS TGridDropSource;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridDropSource : public Asgdd::TASGDropSource 
{
	typedef Asgdd::TASGDropSource inherited;
	
private:
	TAdvStringGrid* FGrid;
	int FLastEffect;
	
public:
	__fastcall TGridDropSource(TAdvStringGrid* aGrid);
	virtual void __fastcall CurrentEffect(int dwEffect);
	virtual void __fastcall QueryDrag(void);
	
__published:
	__property int LastEffect = {read=FLastEffect, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TGridDropSource(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TGridChangeNotifier : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
protected:
	virtual void __fastcall CellsChanged(const Windows::TRect &R);
public:
	#pragma option push -w-inl
	/* TComponent.Create */ inline __fastcall virtual TGridChangeNotifier(Classes::TComponent* AOwner) : 
		Classes::TComponent(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TGridChangeNotifier(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
static const Word MAXCOLUMNS = 0x100;
static const Shortint CHECKBOXSIZE = 0xf;
static const Word RTF_TWIPS = 0x5a0;

}	/* namespace Advgrid */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Advgrid;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// AdvGrid
