// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'DbpIndex.pas' rev: 4.00

#ifndef DbpIndexHPP
#define DbpIndexHPP

#pragma delphiheader begin
#pragma option push -w-
#include <Windows.hpp>	// Pascal unit
#include <TypInfo.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Dbpindex
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TFieldCompareOption { fcoEqual, fcoMore, fcoLess };
#pragma option pop

#pragma option push -b-
enum TDPSeekOption { dsoFirstEQ, dsoLastEQ, dsoAfterEQ, dsoAfter, dsoBeforeEQ, dsoBefore };
#pragma option pop

#pragma option push -b-
enum TDPGotoOption { dgoFirst, dgoLast, dgoNone };
#pragma option pop

struct TIndexFieldDef;
typedef TIndexFieldDef *PIndexFieldDef;

#pragma pack(push, 4)
struct TIndexFieldDef
{
	Variant Value;
	Db::TField* Field;
	bool CaseInsensitive;
	bool Descending;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
struct TIndexRecord
{
	AnsiString FieldNames;
	AnsiString CaseInsFields;
	AnsiString DescFields;
	Db::TIndexOptions Options;
} ;
#pragma pack(pop)

typedef int __fastcall (__closure *TCompareFunction)(const AnsiString S1, const AnsiString S2, const 
	bool CaseInsensitive);

class DELPHICLASS TDPIndexDefs;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TDPIndexDefs : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Db::TDataSet* FDataSet;
	Classes::TList* FIndexFields;
	TDPSeekOption FSeekOption;
	int FFoundRecNo;
	int FIndexHighBound;
	int FLocaleID;
	TCompareFunction FCompareObject;
	bool __fastcall FindFieldName(const AnsiString FieldName, const AnsiString FieldNames, const bool DefaultValue
		);
	bool __fastcall SimpleMethod(int &i, int &j);
	TFieldCompareOption __fastcall CheckIndexFields(void);
	bool __fastcall IndexFind(const TDPGotoOption Default);
	TIndexFieldDef __fastcall GetItem(int Index);
	int __fastcall GetCount(void);
	void __fastcall SetLocaleID(int Value);
	int __fastcall DPAnsiCompare(const AnsiString S1, const AnsiString S2, const bool CaseInsensitive);
		
	int __fastcall DPCompare(const AnsiString S1, const AnsiString S2, const bool CaseInsensitive);
	
protected:
	virtual Db::TDataSet* __fastcall GetDataSet(void) = 0 ;
	virtual void __fastcall DoAfterDataSetChanged(void);
	virtual void __fastcall DoAfterIndexChanged(void);
	virtual TIndexRecord __fastcall GetIndexRecord(void) = 0 ;
	TFieldCompareOption __fastcall CheckIndexField(const Variant &FieldValue, const Variant &SearchValue
		, const TIndexFieldDef &IndexField);
	bool __fastcall Seek(const Variant &KeyValues, const TDPSeekOption SeekOption, const TDPGotoOption 
		Default);
	__property Db::TDataSet* DataSet = {read=FDataSet};
	__property int LocaleID = {read=FLocaleID, write=SetLocaleID, default=1024};
	
public:
	__fastcall TDPIndexDefs(void);
	__fastcall virtual ~TDPIndexDefs(void);
	virtual bool __fastcall IsUpdateIndex(void);
	virtual bool __fastcall IsUpdateDataSet(void);
	void __fastcall UpdateDataSet(void);
	void __fastcall UpdateIndex(void);
	__property int Count = {read=GetCount, nodefault};
	__property TIndexFieldDef Items[int Index] = {read=GetItem};
};

#pragma pack(pop)

class DELPHICLASS TBaseDataSetIndex;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TBaseDataSetIndex : public TDPIndexDefs 
{
	typedef TDPIndexDefs inherited;
	
private:
	bool FDefaultIndex;
	TIndexRecord FIndexRecord;
	bool __fastcall IsOptionsStored(void);
	bool __fastcall IsCaseInsFieldsStored(void);
	bool __fastcall IsDescFieldsStored(void);
	bool __fastcall IsFieldNamesStored(void);
	void __fastcall SetDefaultIndex(bool Value);
	void __fastcall SetFieldNames(AnsiString Value);
	void __fastcall SetOptions(Db::TIndexOptions Value);
	void __fastcall SetCaseInsFields(AnsiString Value);
	void __fastcall SetDescFields(AnsiString Value);
	Db::TIndexOptions __fastcall GetOptions(void);
	AnsiString __fastcall GetCaseInsFields(void);
	AnsiString __fastcall GetDescFields(void);
	AnsiString __fastcall GetFieldNames(void);
	void __fastcall UpdateIndexDef(void);
	
protected:
	virtual TIndexRecord __fastcall GetIndexRecord(void);
	virtual Db::TIndexOptions __fastcall InternalGetOptions(void);
	virtual AnsiString __fastcall InternalGetCaseInsFields(void);
	virtual AnsiString __fastcall InternalGetDescFields(void);
	virtual AnsiString __fastcall InternalGetFieldNames(void);
	
public:
	__fastcall TBaseDataSetIndex(void);
	
__published:
	__property bool DefaultIndex = {read=FDefaultIndex, write=SetDefaultIndex, default=1};
	__property Db::TIndexOptions Options = {read=GetOptions, write=SetOptions, stored=IsOptionsStored, 
		nodefault};
	__property AnsiString CaseInsFields = {read=GetCaseInsFields, write=SetCaseInsFields, stored=IsCaseInsFieldsStored
		};
	__property AnsiString DescFields = {read=GetDescFields, write=SetDescFields, stored=IsDescFieldsStored
		};
	__property AnsiString FieldNames = {read=GetFieldNames, write=SetFieldNames, stored=IsFieldNamesStored
		};
public:
	#pragma option push -w-inl
	/* TDPIndexDefs.Destroy */ inline __fastcall virtual ~TBaseDataSetIndex(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TQueryIndex;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TQueryIndex : public TBaseDataSetIndex 
{
	typedef TBaseDataSetIndex inherited;
	
private:
	AnsiString FFieldNames;
	AnsiString FDescFields;
	bool FDefaultIndexDef;
	Classes::TStrings* FSQL;
	void __fastcall UpdateTypeInfo(void);
	void __fastcall SetSQLProperty(void);
	
protected:
	virtual Db::TIndexOptions __fastcall InternalGetOptions(void);
	virtual AnsiString __fastcall InternalGetCaseInsFields(void);
	virtual AnsiString __fastcall InternalGetDescFields(void);
	virtual AnsiString __fastcall InternalGetFieldNames(void);
	virtual void __fastcall DoAfterDataSetChanged(void);
	virtual TIndexRecord __fastcall GetIndexRecord(void);
	virtual Classes::TStrings* __fastcall GetSQLStrings(void);
	
public:
	virtual bool __fastcall IsUpdateIndex(void);
public:
	#pragma option push -w-inl
	/* TBaseDataSetIndex.Create */ inline __fastcall TQueryIndex(void) : TBaseDataSetIndex() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TDPIndexDefs.Destroy */ inline __fastcall virtual ~TQueryIndex(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TDataSetIndex;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TDataSetIndex : public TQueryIndex 
{
	typedef TQueryIndex inherited;
	
private:
	Db::TIndexDef* FIndexDef;
	bool FDefaultIndexDef;
	Db::TIndexDefs* FIndexDefs;
	Typinfo::TPropInfo *FIndexNamePropInfo;
	Typinfo::TPropInfo *FIndexFieldNamesPropInfo;
	AnsiString FIndexName;
	AnsiString FIndexFieldNames;
	Db::TIndexOptions __fastcall GetDefaultOptions(void);
	AnsiString __fastcall GetDefaultCaseInsFields(void);
	AnsiString __fastcall GetDefaultDescFields(void);
	Db::TIndexDef* __fastcall GetDefaultIndexDef(void);
	AnsiString __fastcall GetDefaultIndexFieldNames(void);
	HIDESBASE void __fastcall UpdateTypeInfo(void);
	Db::TIndexDef* __fastcall GetIndexDef(void);
	bool __fastcall IsTableIndex(void);
	
protected:
	virtual void __fastcall DoAfterDataSetChanged(void);
	virtual void __fastcall DoAfterIndexChanged(void);
	virtual TIndexRecord __fastcall GetIndexRecord(void);
	virtual Db::TIndexOptions __fastcall InternalGetOptions(void);
	virtual AnsiString __fastcall InternalGetCaseInsFields(void);
	virtual AnsiString __fastcall InternalGetDescFields(void);
	virtual AnsiString __fastcall InternalGetFieldNames(void);
	virtual AnsiString __fastcall GetIndexFieldNames(void);
	virtual AnsiString __fastcall GetIndexName(void);
	virtual Db::TIndexDefs* __fastcall GetIndexDefs(void);
	__property Db::TIndexDef* IndexDef = {read=GetDefaultIndexDef};
	
public:
	virtual bool __fastcall IsUpdateIndex(void);
	virtual bool __fastcall IsUpdateDataSet(void);
public:
	#pragma option push -w-inl
	/* TBaseDataSetIndex.Create */ inline __fastcall TDataSetIndex(void) : TQueryIndex() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TDPIndexDefs.Destroy */ inline __fastcall virtual ~TDataSetIndex(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
static const Word DEFAULT_LOCALEID = 0x400;
static const Shortint DEFAULT_LOCALEID_ASCII = 0xffffffff;
extern PACKAGE bool __fastcall CaseSensitiveDependent(const Db::TFieldType DataType);

}	/* namespace Dbpindex */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Dbpindex;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// DbpIndex
