{$I dbpOptions.Inc}
unit DbpClientSet;

interface

uses
  Classes, Db, dbclient, DbpSet;

type
  TDPClientFindIndex=class(TDPFindIndex)
  private
    function TableFindKey(const KeyValues:Variant; const ExactFind:Boolean):Boolean;
  protected
  {$IFNDEF V4_MORE}
    function GetIndexDefs:TIndexDefs; override;
  {$ENDIF}
    function FindKey(const KeyValues:Variant):Boolean; override;
    procedure FindNearest(const KeyValues:Variant); override;
  end;

  TDPClientFindPanel=class(TDBFindPanel)
  protected
    function CreateFindIndex:TDPFindIndex; override;
  end;

  TDPClientFindDialog=class(TDBFindDialog)
  protected
    function CreatePanelFieldsSet:TPanelFieldsSet; override;
  end;

procedure Register;

implementation
{$IFDEF V6_MORE} uses Variants; {$ENDIF}

type
  TDPClientFindComponent=class(TDBFindComponent)
  protected
    function CreateFindIndex:TDPFindIndex; override;
  end;

procedure Register;
begin
  {$IFNDEF VER90}
     RegisterComponents('DP Addition', [TDPClientFindPanel]);
     RegisterComponents('DP Addition', [TDPClientFindDialog]);
  {$ENDIF}
end;

{ TDPClientFindIndex }

{$IFNDEF V4_MORE}
function TDPClientFindIndex.GetIndexDefs:TIndexDefs;
begin
  if (DataSet is {$IFDEF V6_MORE} TCustomClientDataSet {$ELSE} TClientDataSet {$ENDIF} ) then
   {$IFDEF V6_MORE}
     result:=TCustomClientDataSet(DataSet).IndexDefs
   {$ELSE}
     result:=TClientDataSet(DataSet).IndexDefs
   {$ENDIF}
  else result:= inherited GetIndexDefs;
end;
{$ENDIF}

function TDPClientFindIndex.FindKey(const KeyValues:Variant):Boolean;
begin
  if DataSet is {$IFDEF V6_MORE} TCustomClientDataSet {$ELSE} TClientDataSet {$ENDIF} then result:=TableFindKey(KeyValues,true)
  else result:=inherited FindKey(KeyValues);
end;

procedure TDPClientFindIndex.FindNearest(const KeyValues:Variant);
begin
  if DataSet is {$IFDEF V6_MORE} TCustomClientDataSet {$ELSE} TClientDataSet {$ENDIF} then TableFindKey(KeyValues,false)
  else inherited FindNearest(KeyValues);
end;

function TDPClientFindIndex.TableFindKey(const KeyValues:Variant; const ExactFind:Boolean):Boolean;
var
  i,HighBound:Integer;
begin
  HighBound:=VarArrayHighBound(KeyValues,1);
  {$IFDEF V6_MORE}
     TCustomClientDataSet(DataSet).SetKey;
  {$ELSE}
     TClientDataSet(DataSet).SetKey;
  {$ENDIF}
  for i:=0 to Count-1 do
  begin
    if i<=HighBound then Items[i].Field.Value:=KeyValues[i]
    else Items[i].Field.Value:=null;
  end;
  if ExactFind then
  {$IFDEF V6_MORE}
    result:=TCustomClientDataSet(DataSet).GotoKey
  {$ELSE}
    result:=TClientDataSet(DataSet).GotoKey
  {$ENDIF}
  else
  begin
  {$IFDEF V6_MORE}
    TCustomClientDataSet(DataSet).GotoNearest;
  {$ELSE}
    TClientDataSet(DataSet).GotoNearest;
  {$ENDIF}
    result:=true;
  end;
end;

{ TDPClientFindPanel }

function TDPClientFindPanel.CreateFindIndex:TDPFindIndex;
begin
  result:=TDPClientFindIndex.Create(Self);
end;

{ TDPClientFindComponent }

function TDPClientFindComponent.CreateFindIndex:TDPFindIndex;
begin
  result:=TDPClientFindIndex.Create(Self);
end;

{ TDPClientFindDialog }

function TDPClientFindDialog.CreatePanelFieldsSet:TPanelFieldsSet;
begin
  result:=TDPClientFindComponent.Create(Self);
end;

end.
