//---------------------------------------------------------------------------
#ifndef VideoH
#define VideoH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
//---------------------------------------------------------------------------
typedef void __fastcall (__closure *TOnFrameEvent)(LPBYTE VideoBuffer, DWORD BufferSize);
//---------------------------------------------------------------------------
class PACKAGE TVideo : public TWinControl
{
private:
        TStringList *FInstDrvList;
        int FInstDrvCount;
        int FDriverIndex;
        bool FhasVideoSourceDlg;
        bool FhasVideoFormatDlg;
        bool FhasVideoDisplayDlg;
        int FVideoWidth;
        int FVideoHeight;
        int FFrameRate;
        bool FAutoSize;
        bool FEnable;
        bool FUseOverlay;
        HWND VidHWND;
        bool Initialized;
        TNotifyEvent FOnResize;
        void __fastcall SetInstalledDrivers(TStringList *InstDrvList);
        TStringList * __fastcall GetInstalledDrivers();
        void __fastcall SetDriverCount(int Count);
        void __fastcall SetDriverIndex(int Index);
        void __fastcall SetAutoSize(bool AutoSize);
        void __fastcall SetEnable(bool pEnable);
        void __fastcall SetUseOverlay(bool pUseOverlay);
        void __fastcall SetFrameRate(int FrameRate);
        bool __fastcall StartVideo();
        void __fastcall UpdateWindowSize();
        // events
        void __fastcall SetOnFrame(TOnFrameEvent OnFrameEvent);
        TOnFrameEvent __fastcall GetOnFrame();
protected:
public:
        __fastcall TVideo(TComponent* Owner);
        __fastcall ~TVideo();
        bool __fastcall hasVideoSourceDlg();
        bool __fastcall hasVideoFormatDlg();
        bool __fastcall hasVideoDisplayDlg();
        int __fastcall GetVideoWidth();
        int __fastcall GetVideoHeight();
        void __fastcall ExecuteSourceDlg();
        void __fastcall ExecuteFormatDlg();
        void __fastcall ExecuteDisplayDlg();
        void __fastcall SaveFrameToFile(AnsiString Filename);
__published:
        // properties
        __property TStringList *InstalledDrivers = {read = GetInstalledDrivers, write = SetInstalledDrivers};
        __property int DrvCount = {read = FInstDrvCount, write = SetDriverCount};
        __property int DrvIndex = {read = FDriverIndex, write = SetDriverIndex};
        __property bool AutoSize = {read = FAutoSize, write = SetAutoSize};
        __property bool Enabled = {read = FEnable, write = SetEnable};
        __property bool UseOverlay = {read = FUseOverlay, write = SetUseOverlay};
        __property int FrameRate = {read = FFrameRate, write = SetFrameRate};
        // inherited properties
        __property Align;
        __property Anchors;
        // events - inherited
        __property OnResize;
        __property OnClick;
        __property OnDblClick;
        __property OnMouseDown;
        __property OnMouseMove;
        __property OnMouseUp;
        __property OnDragDrop;
        __property OnEndDrag;
        __property OnDragOver;
        // events - custom
        __property TOnFrameEvent OnFrame = {read = GetOnFrame, write = SetOnFrame};
};
//---------------------------------------------------------------------------
#endif
