#ifndef PropItemsBox_IIH
#define PropItemsBox_IIH

#include <Classes.hpp>
#include <vector>

typedef struct
{
	AnsiString sProp;
	AnsiString sValor;

} TRegPropiedad;

typedef std::vector<TRegPropiedad> CVectorPropiedades;

class TPropItemsBox_II : TPersistent
{
public:
	CVectorPropiedades FVecProp;

	__fastcall TPropItemsBox_II() : TPersistent() {}

	// Lee las propiedades de un stream
	//
	void __fastcall ReadData( TReader *Reader )
    {
		// Inicializa el vector de propiedades
		//
    	FVecProp.clear();

		// Empezamos una lista de propiedades
		//
    	Reader->ReadListBegin();

		// Mientras haya propiedades que leer...
		//
        while( !Reader->EndOfList() )
        {
        	TRegPropiedad stReg;

			// Estar almacenado primero el nombre de la propiedad y luego su valor
			//
    		stReg.sProp= Reader->ReadString();
    		stReg.sValor= Reader->ReadString();

			// Actualizamos el vector de propiedades
			//
            FVecProp.push_back( stReg );
        }

		// Leemos la marca de fin de lista
		//
    	Reader->ReadListEnd();
    }

	void __fastcall WriteData( TWriter *Writer )
    {
		// Escribiremos una lista de propiedades
		//
    	Writer->WriteListBegin();

		// Escribimos primero el nombre de la propiedad y luego su valor
		//
        for( unsigned i=0; i< FVecProp.size(); i++ )
		{
    		Writer->WriteString( FVecProp[i].sProp );
    		Writer->WriteString( FVecProp[i].sValor );
        }

		// Fin de la lista
		//
    	Writer->WriteListEnd();
    }

	void __fastcall DefineProperties(TFiler* Filer)
    {
		// Especificamos que metodos llamar para serializar el componente
		//
		// Esto sera mejorable teniendo en cuenta el ancestor, pero as
		// creo que ya me sirve
		//
    	Filer->DefineProperty( "RegProp", ReadData, WriteData, true );
    }
};

#endif
