#ifndef PropItemsBox_II_PropertyEditorH
#define PropItemsBox_II_PropertyEditorH

#include <dsgnintf.hpp>
#include "EditorPropBoxII_dlg.cpp"
#include "propitemsbox_ii.h"

class PACKAGE TPropItemsBox_II_PropertyEditor : public TPropertyEditor
{
public:
	virtual System::AnsiString __fastcall GetValue()
	{
		// Texto que aparecer en el Inspector de Objetos
		//
    	return "(TPropItemsBox_II)";
    }

	virtual TPropertyAttributes __fastcall GetAttributes(void)
	{
		// Indicamos al inspector de objectos que la propiedad en cuestin
		// ser modificada por un dilogo
		//
		return  (TPropertyEditor::GetAttributes() << paDialog ) >> paSubProperties;
	}

    bool __fastcall EditTPropItemsBox_II( TPropItemsBox_II *pNuevo )
	{
		bool result = false;

		// Creamos el dilogo para editar la propiedad
		//
		TEditorPropBoxII_dlg *EEditor= new TEditorPropBoxII_dlg(Application);

		// Copia los valores que tuviese la propiedad al grid para editarlos
		//
    	for( unsigned i=0; i< pNuevo->FVecProp.size(); i++ )
    	{
        	EEditor->StringGrid1->Cells[0][i+1]= pNuevo->FVecProp[i].sProp;
        	EEditor->StringGrid1->Cells[1][i+1]= pNuevo->FVecProp[i].sValor;
    	}

		// Guardar la seleccin?
		//
		if( EEditor->ShowModal() == IDOK )
		{
			result = true;

			// Borramos el vector de propiedades
			//
        	pNuevo->FVecProp.clear();

			// Copiamos las nuevas propiedades introducidas en el StringGrid al vector
			//
        	for( int i=1; i< EEditor->StringGrid1->RowCount; i++ )
        	{
				// En el momento que una celda de propiedades del StringGrid est
				// vaca, no seguimos copiandp propiedades
				//
            	if( EEditor->StringGrid1->Cells[0][i]=="" )
                {
                	break;
                }

                TRegPropiedad stReg;

                stReg.sProp = EEditor->StringGrid1->Cells[0][i];
                stReg.sValor= EEditor->StringGrid1->Cells[1][i];

				// Aadimos otra nueva propiedad
				//
        		pNuevo->FVecProp.push_back( stReg );
        	}
		}

		// Eliminamos el dilogo
		//
		delete EEditor;

		return result;
	}

	virtual void __fastcall Edit(void)
	{
		// Creamos una variable temporal para la edicin de la propiedad
		//
		TPropItemsBox_II *pNuevo= new TPropItemsBox_II;

		// Cogemos el contenido actual de la propiedad editada
		//
		TPropItemsBox_II *pProp= (TPropItemsBox_II *) GetOrdValue();

		// Copiamos el valor al temporal
		//
        pNuevo->FVecProp= pProp->FVecProp;

		// Lo editamos en nuestro dilogo
		//
		if( EditTPropItemsBox_II(pNuevo) )
		{
			// Si ha cambiado, lo copiamos y notificamos al inspector
			//
        	SetOrdValue( (long) pNuevo );
		}

		// Borramos el temporal
		//
		delete pNuevo;
	}
};

#endif