#ifndef InspBox_IIH
#define InspBox_IIH

#include <StdCtrls.hpp>
#include "propitemsbox_ii.h"

class TEditProp_II;

//---------------------------------------------------------------------------
class PACKAGE TInspBox_II : public TCustomListBox
{
private:
	TEditProp_II *Edit;
	TPropItemsBox_II *FProps;

	TColor m_PropColor;
	TColor m_EditColor;
	TColor m_SelColor;
	TColor m_GridColor;

	int mid;

protected:
	void __fastcall CreateWnd();
	void __fastcall CreateParams( TCreateParams &Params );

    void __fastcall CNDrawItem( TWMDrawItem &Message );
    void __fastcall WMKeyDown( TWMKey &Message );
    void __fastcall WMSetFocus( TWMSetFocus &Message );
    void __fastcall WMLButtonDown( TWMMouse &Message );
    void __fastcall WMLButtonUp( TWMMouse &Message );
    void __fastcall WMMouseMove( TWMMouse &Message );
    void __fastcall WMSize( TWMSize &Message );

    BEGIN_MESSAGE_MAP
        MESSAGE_HANDLER(CN_DRAWITEM, TWMDrawItem , CNDrawItem )
        MESSAGE_HANDLER(WM_KEYDOWN, TWMKey , WMKeyDown )
        MESSAGE_HANDLER(WM_SETFOCUS, TWMSetFocus , WMSetFocus )
        MESSAGE_HANDLER(WM_LBUTTONDOWN, TWMMouse , WMLButtonDown )
        MESSAGE_HANDLER(WM_LBUTTONUP, TWMMouse , WMLButtonUp )
		MESSAGE_HANDLER(WM_MOUSEMOVE, TWMMouse, WMMouseMove )
        MESSAGE_HANDLER(WM_SIZE, TWMSize , WMSize )
    END_MESSAGE_MAP(TCustomListBox)

public:
    __fastcall TInspBox_II(TComponent* Owner);
    __fastcall ~TInspBox_II();

	void SetProp( unsigned i, AnsiString sProp )
	{
		if( i < FProps->FVecProp.size() )
		{
			FProps->FVecProp[i].sValor= sProp;
		}
	}

    void __fastcall SetProps( TPropItemsBox_II *value )
    {
    	FProps->FVecProp= value->FVecProp;
		Perform(LB_SETCOUNT, (short) FProps->FVecProp.size(), 0);
    }

__published:
	__property TPropItemsBox_II* Props = {read= FProps, write=SetProps};

    __property Align;
    __property BorderStyle;
    __property Color;
    __property Enabled;
    __property Font;
    __property ItemHeight;
    __property PopupMenu;
    __property TabOrder;
    __property TabStop;
    __property Visible;
    __property TColor PropColor= { read= m_PropColor, write= m_PropColor };
    __property TColor EditColor= { read= m_EditColor, write= m_EditColor };
    __property TColor SelColor= { read= m_SelColor, write= m_SelColor };
    __property TColor GridColor= { read= m_GridColor, write= m_GridColor };
};
//---------------------------------------------------------------------------

class TEditProp_II : public TCustomEdit
{
public:
	__fastcall TEditProp_II(TComponent* Owner) : TCustomEdit(Owner)
	{
		Width= 0;
	}

protected:
	void __fastcall WMKeyDown( TWMKey &Message );

	BEGIN_MESSAGE_MAP
		MESSAGE_HANDLER(WM_KEYDOWN, TWMKey , WMKeyDown )
	END_MESSAGE_MAP(TCustomEdit)

__published:
        __property Visible;
        __property ReadOnly;
        __property Parent;
        __property BorderStyle;
        __property Color;
};

#endif
