//
// Jorge Fernandez
// cascoscuro@retemail.es
//
// Version 2.0

#include <vcl.h>
#pragma hdrstop

#include "InspBox_II.h"
#include "PropItemsBox_II_PropertyEditor.h"

#pragma package(smart_init)
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TInspBox_II *)
{
	new TInspBox_II(NULL);
}

//---------------------------------------------------------------------------

__fastcall TInspBox_II::TInspBox_II(TComponent* Owner) : TCustomListBox(Owner)
{
	ControlStyle << csOpaque;

	// Colores por defecto
	//
	Color= clBtnFace;
	PropColor= clNavy;
	EditColor= clWhite;
	SelColor= clBlack;
	GridColor= clGray;

	// Inicializamos nuestro editor "privado"
	//
	Edit= new TEditProp_II(this);

	Edit->Parent= this;
	Edit->Visible = true;
	Edit->BorderStyle= bsNone;

	// Creamos el componente con las propiedades
	//
	FProps = new TPropItemsBox_II;

	// Usando un doble buffer, rebajaremos el efecto de flickering
	//
	DoubleBuffered= true;
}

__fastcall TInspBox_II::~TInspBox_II()
{
	// Liberamos los objetos creados a mano
	//
	delete Edit;
	delete FProps;
}

void __fastcall TInspBox_II::CreateWnd()
{
	TCustomListBox::CreateWnd();

	// Coordenada X de la linea divisoria entre propiedades y sus valores
	//
	mid= ClientWidth / 2;

	// Informamos al listbox 'virtual' del n de elementos que contiene
	//
	Perform(LB_SETCOUNT, (short) FProps->FVecProp.size(), 0);

	// Si tiene algun elemento...
	//
    if( !FProps->FVecProp.empty() )
    {
		// Inicialmente estar seleccionada la primera propiedad
		//
    	ItemIndex= 0;
		Edit->Text= FProps->FVecProp[0].sValor;

		// Si estamos en modo diseo no podemos pasarle el foco al Edit
		//
        if( !ComponentState.Contains(csDesigning) )
        {
        	Edit->SetFocus();
        }
    }
}

void __fastcall TInspBox_II::CreateParams( TCreateParams &Params )
{
     TCustomListBox::CreateParams(Params);

	 // Una lista virtual no puede tener ciertos estilos...
	 //
     Params.Style &= ~(	LBS_SORT | LBS_HASSTRINGS | LBS_OWNERDRAWVARIABLE | WS_HSCROLL );

	 // ... y debe tener otros obligatoriamente
	 //
     Params.Style |= LBS_OWNERDRAWFIXED | LBS_NODATA;
}

void __fastcall TInspBox_II::CNDrawItem( TWMDrawItem &Message )
{
	DRAWITEMSTRUCT *p= Message.DrawItemStruct;

    int Index= p->itemID;
    TRect Rect= p->rcItem;
    bool bSelected= (p->itemState & 0xF) & ODS_SELECTED;

	// Si no hay nada seleccionado, no hay nada que pintar
	//
	if( Index < 0 )
    {
    	return;
    }

    // Inicializamos el objeto canvas
    //
    Canvas->Handle= p->hDC;
	Canvas->Pen->Width= 1;
	Canvas->Brush= Brush;
	Canvas->Font= Font;

    Edit->Color= EditColor;

    // Color de fondo del Item
    //
    Canvas->FillRect(Rect);

	// Rectngulo para el texto de la propiedad
	//
	TRect rProp= Rect;
	rProp.right= rProp.left + mid - 2;

	// Escribimos la propiedad
	//
	AnsiString sProp= Props->FVecProp[Index].sProp;
	Canvas->TextRect( rProp, rProp.left+10, rProp.top+1, sProp );

	// Linea vertical divisoria entre la propiedad y su valor
	// en color gris
	//
	Canvas->Pen->Color= GridColor;
	Canvas->MoveTo( mid, Rect.top );
	Canvas->LineTo( mid, Rect.bottom );

	// Linea vertical divisoria entre la propiedad y su valor
	// en colo blanco (para simular relieve)
	//
	Canvas->Pen->Color= EditColor;
	Canvas->MoveTo( mid + 1, Rect.top );
	Canvas->LineTo( mid + 1, Rect.bottom );

	// Valor que toma la propiedad (si toma alguno)
	//
	TRegPropiedad *pProp= (TRegPropiedad *) &Props->FVecProp[Index];
	AnsiString sVal= pProp ? pProp->sValor : AnsiString("");

	// Vemos si es el item que est seleccionado
	//
	if( bSelected )
	{
		// Linea horizontal superior
		//
		Canvas->Pen->Color= SelColor;
		Canvas->MoveTo( Rect.left, Rect.top );
		Canvas->LineTo( Rect.right, Rect.top );

		// Linea vertical izquierda
		//
		Canvas->MoveTo( Rect.left, Rect.top );
		Canvas->LineTo( Rect.left, Rect.bottom-1 );

		// Linea horizontal inferior (simula relieve)
		//
		Canvas->Pen->Color= EditColor;
		Canvas->MoveTo( Rect.left, Rect.bottom-1 );
		Canvas->LineTo( Rect.right, Rect.bottom-1 );

		// Rectngulo blanco para simular margen del TEdit
		//
		TRect rMargen= TRect( mid+2, Rect.top+1, mid+4, Rect.bottom-1 );

		Canvas->Brush->Color= EditColor;
		Canvas->FillRect(rMargen);

		// Copiamos al TEdit el valor de la propiedad para
		// su visualizacin / edicin
		//
		Edit->Text= sVal;

		// Inicialmente el texto estar seleccionado
		//
		Edit->SelStart= 0;
		Edit->SelLength= -1;

        // Ajustamos el tamao del TEdit a su zona del ListBox
		//
		Edit->SetBounds( mid+4 , Rect.top+1, Rect.right - mid , Rect.bottom - Rect.top - 1 );

		// En el futuro existirn propiedades de slo lectura, combobox, etc...
		// !pProp->bEnabled
        //
		Edit->ReadOnly= false;
	}
	else
	{
		// Rectngulo para el texto del valor de la propiedad
		//
		TRect rVal= Rect;
		rVal.left+= mid + 2;

		// Un color similar al utilizado por el Inspector
		//
		Canvas->Font->Color= PropColor;
		Canvas->TextRect( rVal, rVal.left+2, rVal.top+1, sVal );

		// Lineas horizontales que separan los items
		//
		for( int i= Rect.left; i<= Rect.right; i+=2 )
		{
			Canvas->Pixels[i][Rect.bottom-1]= GridColor;
		}
	}

    Canvas->Handle= 0;
}

void __fastcall TInspBox_II::WMKeyDown( TWMKey &Message )
{
	switch( Message.CharCode )
	{
	case VK_RETURN:
	case VK_UP:
	case VK_DOWN:
	case VK_PRIOR:
	case VK_NEXT:
		// Realizamos la accin por defecto para estas teclas
		//
		DefaultHandler( (void *) &Message );

		// Asignamos el foco al TEdit de la propiedad actual
		//
		if( ItemIndex >= 0 )
		{
			Edit->SetFocus();
		}
		break;

	default:
		if( ItemIndex >= 0 )
		{
			Edit->SetFocus();

			// Enviamos cualquier otra tecla al TEdit
			//
			SendMessage( Edit->Handle, WM_KEYDOWN, Message.CharCode, 0 );
		}
		break;
	}
}

void __fastcall TInspBox_II::WMSetFocus( TWMSetFocus &Message )
{
	// Si hay un item seleccionado, actualizamos el contenido
	// de su propiedad con el texto del TEdit
	//
	if( ItemIndex >= 0 )
	{
		SetProp( ItemIndex, Edit->Text );
	}

	// Llamamos a la accin por defecto
	//
	DefaultHandler( (void *) &Message );
}

void __fastcall TInspBox_II::WMLButtonDown( TWMMouse &Message )
{
	// Distancia del click actual a la linea separadora
	//
    int dist= abs(Message.XPos - mid);

	if( ItemIndex < 0 )
	{
		return;
	}

	// Si estamos a una distancia cortita, la reposicionaremos
	//
	if( dist <= 3 )
    {
    	MouseCapture= true;
    }
    else
    {
		DefaultHandler( (void *) &Message );

    	// Activamos el foco de la propiedad recien seleccionada
        //
		Edit->SetFocus();
    }
}

void __fastcall TInspBox_II::WMMouseMove( TWMMouse &Message )
{
    int dist= abs(Message.XPos - mid);

    if( MouseCapture )
    {
		// Estamos reposicionando la linea divisoria
		//
    	mid= Message.XPos;

		// Obligamos a que ambos campos tengan un tamao mnimo
		//
        mid= mid < 25 ? 25 : mid;
        mid= mid > ClientWidth - 25 ? ClientWidth - 25 : mid;

		// Repintamos todo el tinglao
		//
        Invalidate();
    }
	else if( dist <= 3 )
    {
		// Cambiamos el cursor para que el usuario sepa que puede reposicionar
		// la linea divisoria entre propiedades y sus valores
		//
    	Cursor= crHSplit;
    }
    else
    {
    	Cursor= crDefault;
    }
}

void __fastcall TInspBox_II::WMLButtonUp( TWMMouse &Message )
{
	MouseCapture= false;
}

void __fastcall TInspBox_II::WMSize( TWMSize &Message )
{
    // Guardamos la propiedad que estuviese editndose
    //
    if( ItemIndex >= 0 )
    {
		SetProp( ItemIndex, Edit->Text );
    }

	// Si hacemos que el tamao de la ventana sea menor que la
	// posicin de la linea divisoria, reposicionamos sta a la mitad
	//
    if( Message.Width < mid && Message.Width/2 > 25 )
    {
		mid= Message.Width/2;
    }

    // Si no estamos minimizando la ventana (posible?)
    // repintamos todo el componente
    //
    if( Message.SizeType != SIZE_MINIMIZED )
    {
		Invalidate();
    }

    DefaultHandler( (void *) &Message );
}

void __fastcall TEditProp_II::WMKeyDown( TWMKey &Message )
{
	TInspBox_II *pII= (TInspBox_II *) Parent;
	TRegPropiedad *p= (TRegPropiedad *) &pII->Props->FVecProp[pII->ItemIndex];

	switch( Message.CharCode )
	{
	case VK_RETURN:
	case VK_UP:
	case VK_DOWN:
	case VK_PRIOR:
	case VK_NEXT:
		// Estos eventos los gestionar el listbox
		//
		pII->SetFocus();
		SendMessage( pII->Handle, WM_KEYDOWN, Message.CharCode, 0 );
		break;

	case VK_ESCAPE:
		// Restauramos el texto seleccionado anteriormente
		//
		Text= p->sValor;
		SelStart= 0;
		SelLength= -1;
		break;

	default:
		DefaultHandler( (void *) &Message );
		break;
   	}
}

//---------------------------------------------------------------------------
namespace Inspbox_ii
{
	void __fastcall PACKAGE Register()
	{
		TComponentClass classes[1] = {__classid(TInspBox_II)};
		RegisterComponents( "Samples", classes, 0 );

		RegisterPropertyEditor(
			__typeinfo( TPropItemsBox_II ),
			NULL,
			"",
			__classid( TPropItemsBox_II_PropertyEditor )
		);
	}
}
//---------------------------------------------------------------------------
