//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "sort.h"
#include "graph.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
// Class MyGraphNode simply extends GraphNode adding an action (a message box)
// to it . This is the point where you should place your own class, deriving it
// from GraphNode and adding the necessary fields and methods. 
class MyGraphNode : public GraphNode {
  public:
    virtual void __fastcall doAction() { ShowMessage(name); }; // virtual method overriden
};

TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
// Sample usage of Graph and GraphNode definitions
int i;
Graph *MyGraph = new Graph;
MyGraphNode *NodeArray[10];

// Create array of GraphNodes
for (i=0;i<10;++i)
  NodeArray[i] = new MyGraphNode;

// Initialize names of GraphNodes
NodeArray[0]->name = "A1";
NodeArray[1]->name = "A2";
NodeArray[2]->name = "A3";
NodeArray[3]->name = "A4";

// Set dependencies of GraphNodes
NodeArray[0]->Add(NodeArray[1]);
NodeArray[1]->Add(NodeArray[0]);
NodeArray[1]->Add(NodeArray[2]);
NodeArray[2]->Add(NodeArray[1]);
NodeArray[2]->Add(NodeArray[0]);
NodeArray[0]->Add(NodeArray[2]);
NodeArray[3]->Add(NodeArray[0]);

// Add all GraphNodes to Graph
MyGraph->Add(NodeArray[0]);
MyGraph->Add(NodeArray[1]);
MyGraph->Add(NodeArray[2]);
MyGraph->Add(NodeArray[3]);

// Topological sort
if (MyGraph->topSort()) {
  ShowMessage("Graph has circular dependencies");
}

// Free array of GraphNodes
for (i=0;i<10;++i)
  delete NodeArray[i];
}
//---------------------------------------------------------------------------

