//---------------------------------------------------------------------------
#ifndef graphH
#define graphH
//---------------------------------------------------------------------------
// Classes GraphNode and Graph
// Eduardo T Ochiai - 27/03/2000
//
// These two classes implement a directed graph
//
class GraphNode : public TObject {
  private:
    int count;      // count is the number of GraphNodes that this GraphNode depends on 
    int tempCount;  //  temporary count for TopSort
    int visited;    // Has this GraphNode been visited yet ?
    TList *depList; // Dependency list -> list of GraphNodes that depend on this one
  public:
    ShortString name;
    virtual __fastcall GraphNode() { depList = new TList; visited=0; }
    virtual __fastcall ~GraphNode() { delete depList; }
    GraphNode* __fastcall First() { return (depList->Count>0? (GraphNode *)depList->Items[0]: NULL ); }
    GraphNode* __fastcall Last() { return (depList->Count>0? (GraphNode *)depList->Items[depList->Count-1]: NULL ); }
    GraphNode* __fastcall ItemAt(int n) { return (depList->Count>0? (GraphNode *)depList->Items[n]: NULL ); }
    int __fastcall Add(GraphNode *aItem) { return depList->Add(aItem); }
    void __fastcall Delete(int n) { depList->Delete(n); }
    int __fastcall Count() { return depList->Count; }
    int __fastcall getCount() { return count; }
    void __fastcall setCount(aCount) { count=aCount; }
    void __fastcall incCount() { count++; }
    void __fastcall decCount() { count--; }        
    int __fastcall getTempCount() { return tempCount; }
    void __fastcall setTempCount(aCount) { tempCount=aCount; }
    void __fastcall incTempCount() { tempCount++; }
    void __fastcall decTempCount() { tempCount--; }
    int __fastcall getVisited() { return visited; }
    void __fastcall setVisited(aFlag) { visited=aFlag; }
    virtual void __fastcall doAction() { }
};

class Graph : public TObject {
  private:
    TList *nodeList; // Node list
    TList *ZL;       // Zero list
    int   maxIter;   // numnber of iterations if graph is circular - NOT used for now
  public:
    virtual __fastcall Graph() { nodeList = new TList; ZL = new TList; maxIter=1; }
    virtual __fastcall ~Graph() { delete nodeList; delete ZL; }
    GraphNode* __fastcall First() { return (nodeList->Count>0? (GraphNode *)nodeList->Items[0]: NULL ); }
    GraphNode* __fastcall Last() { return (nodeList->Count>0? (GraphNode *)nodeList->Items[nodeList->Count-1]: NULL ); }
    GraphNode* __fastcall ItemAt(int n) { return (nodeList->Count>0? (GraphNode *)nodeList->Items[n]: NULL ); }
    GraphNode* __fastcall getZL();
    void __fastcall putZL(GraphNode *aItem);
    int __fastcall Add(GraphNode *aItem) { return nodeList->Add(aItem); };
    void __fastcall Delete(int n) {nodeList->Delete(n); } ;
    int __fastcall Count() { return nodeList->Count; }
    void __fastcall initCount();
    void __fastcall makeCount();
    int __fastcall getMaxIter(int n) { return maxIter; };
    void __fastcall setMaxIter(int n) { maxIter=n; };
    int __fastcall topSort();
};
#endif
