//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "graph.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

void __fastcall Graph::initCount()
{
 int i,j;
 GraphNode *current; 

 for (j=0;j<=Count()-1;++j) {
   ItemAt(j)->setCount(0);
   ItemAt(j)->setTempCount(0);
   ItemAt(j)->setVisited(0);   
 }

 // Initialize counts of all nodes in graph
 for (j=0;j<=Count()-1;++j) {
   for (i=0;i<=ItemAt(j)->Count()-1;++i) {
     current=ItemAt(j)->ItemAt(i);
     current->incCount();
   }
 }
}

void __fastcall Graph::makeCount()
{
 int i;

 for (i=0;i<=Count()-1;++i) {
   // New count is equal to the difference between :
   // the number of nodes on which this node depends less
   // the number of nodes that depend on this node 
   ItemAt(i)->setTempCount((ItemAt(i)->getTempCount()-ItemAt(i)->Count())>=0 ?
                           (ItemAt(i)->getTempCount()-ItemAt(i)->Count()) :
                            0);
 }
}

GraphNode* __fastcall Graph::getZL()
{
 if (ZL->Count>0) {
   GraphNode* ret = (GraphNode *)ZL->Last();
   ZL->Delete(ZL->Count-1);

   return ret;
 }
 else
   return NULL;
}

void __fastcall Graph::putZL(GraphNode *aItem)
{
 ZL->Add(aItem); 
}

int __fastcall Graph::topSort()
{
 int i, nodesVisited, hasCircular;
 GraphNode *current;

 // Initialize counts of all nodes in graph
 initCount();
 
 // Initialize temporary counts of all nodes in graph
 for (i=0;i<=Count()-1;++i) {
   ItemAt(i)->setTempCount(ItemAt(i)->getCount());
 }
 // Construct Zero List.
 for (i=0;i<=Count()-1;++i) {
   if (ItemAt(i)->getTempCount()==0)
     putZL(ItemAt(i));
 }
 nodesVisited=0;
 hasCircular=0;
 while (nodesVisited<Count()) { // while there are nodes not visited
   while (current=getZL()) {    // get next node from zero list
     current->setVisited(1);
     current->doAction();       // perform action on node
     nodesVisited++;
     for (i=0;i<=current->Count()-1;++i) { // decrement count of nodes in depList
       current->ItemAt(i)->decTempCount();
       if (current->ItemAt(i)->getTempCount()==0) // if reached zero, add to ZL.
         putZL(current->ItemAt(i));
     }
   }
   if (nodesVisited!=Count()) { // Graph has circular dependencies
     hasCircular=1;
     // Compute new counts for the remaining nodes to resolve the circular chain
     makeCount();
     // Construct Zero List.
     for (i=0;i<=Count()-1;++i) {
       if (ItemAt(i)->getTempCount()==0 && !ItemAt(i)->getVisited())
         putZL(ItemAt(i));
     }
   }
 }

 return (hasCircular);
}
