//---------------------------------------------------------------------------
#ifndef AlphaBlenderH
#define AlphaBlenderH
//-Macro---------------------------------------------------------------------
#define Color16Bit(r,g,b) (unsigned short)((((r>>3)&0x1F)<<g_RShift)|(((g>>3)&0x3F)<<g_GShift)|((b>>3)&0x1F))
#define Color24Bit(r,g,b) (unsigned)((r<<16)|(g<<8)|b)
#define Color32Bit(r,g,b) (unsigned)((r<<16)|(g<<8)|b)
#define GetR16Bit(value) (unsigned char)(((unsigned)value>>8)&0xFF)
#define GetG16Bit(value) (unsigned char)(((unsigned)value>>3)&0xFF)
#define GetB16Bit(value) (unsigned char)(((unsigned)value<<3)&0xFF)
#define GetR15Bit(value) (unsigned char)(((unsigned)value>>7)&0xFF)
#define GetG15Bit(value) (unsigned char)(((unsigned)value>>2)&0xFF)
#define GetB15Bit(value) (unsigned char)(((unsigned)value<<3)&0xFF)
#define GetR24Bit(value) (unsigned char)(((unsigned)value>>16)&0xFF)
#define GetG24Bit(value) (unsigned char)(((unsigned)value>>8)&0xFF)
#define GetB24Bit(value) (unsigned char)(((unsigned)value)&0xFF)
#define GetR32Bit(value) (unsigned char)(((unsigned)value>>16)&0xFF)
#define GetG32Bit(value) (unsigned char)(((unsigned)value>>8)&0xFF)
#define GetB32Bit(value) (unsigned char)(((unsigned)value)&0xFF)
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Graphics.hpp>
//---------------------------------------------------------------------------
struct PixelInfo
{
  unsigned char r;
  unsigned char g;
  unsigned char b;
};
//---------------------------------------------------------------------------
class GrasomusAlphaBlend
{
public:
  bool isMMX();
  unsigned NO_OF_PIXELS;
  unsigned BYTESPERPIXEL;
  unsigned char g_RShift, g_GShift;
  __inline void AlphaBlendBasic(PixelInfo *image, PixelInfo *backgnd, unsigned *rendered_image, unsigned char src_coef, unsigned char ShiftCount);
  __inline void AlphaBlendSoftwareMMX(PixelInfo *image, PixelInfo *backgnd, unsigned *rendered_image, unsigned char src_coef, unsigned char ShiftCount);
  void AlphaBlendHardwareMMX(PixelInfo *image, PixelInfo *backgnd, unsigned *rendered_image, unsigned char src_coef, unsigned char ShiftCount);
};
//---------------------------------------------------------------------------
class TAlphaBlenderForm : public TForm
{
__published:	// IDE-managed Components
        void __fastcall FormShow(TObject *Sender);
        void __fastcall FormPaint(TObject *Sender);
        void __fastcall FormHide(TObject *Sender);
private:	// User declarations
        GrasomusAlphaBlend AlphaB;
        HCURSOR oldcursor;
        HDC hDesktopDC;
        HDC hMemoryDC;
        HDC AlphaBlenderFormDC;
        HBITMAP hbm, hbmOld;
        BITMAP bm;
        unsigned *frames;
        PixelInfo *backgnd;
        PixelInfo *image;
        unsigned char ShiftCount;
        unsigned IMAGE_DIM_X, IMAGE_DIM_Y;
        unsigned NO_OF_PIXELS;
        unsigned BITSPERPIXEL;
        unsigned BYTESPERPIXEL;
        unsigned scr_x, scr_y;
        void __fastcall UpdateBackground();
public:		// User declarations
        __fastcall TAlphaBlenderForm(TComponent* Owner);
        __fastcall ~TAlphaBlenderForm();
        bool g_isMMX;
        bool Blending;
        bool Error;
        unsigned Delay;
        unsigned PauseInterval;
        unsigned short MaxOpacity;
        unsigned short MinOpacity;
        Graphics::TBitmap *Picture;
        Graphics::TBitmap *PictureMMX;
};
//---------------------------------------------------------------------------
extern PACKAGE TAlphaBlenderForm *AlphaBlenderForm;
//---------------------------------------------------------------------------
#endif
