//---------------------------------------------------------------------------
#ifndef AlphaBlendedSplashREGH
#define AlphaBlendedSplashREGH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
#include "AlphaBlender.h"
//---------------------------------------------------------------------------
#define DEFAULTDELAY 3
#define DEFAULTPAUSEINTERVAL 500
#define DEFAULTMAXOPACITY 255
#define DEFAULTMINOPACITY 0
//---------------------------------------------------------------------------
class PACKAGE TAlphaBlendedSplash : public TComponent
{
private:
        TAlphaBlenderForm *AlphaBlenderForm;
        Graphics::TBitmap *FPicture;
        Graphics::TBitmap *FPictureMMX;
        unsigned FDelay;
        unsigned FPauseInterval;
        unsigned FMaxOpacity;
        unsigned FMinOpacity;
        bool FActiveBackground;
        void __fastcall SetNULL(AnsiString Value);
        AnsiString __fastcall GetCopyright();
        AnsiString __fastcall GetVersion();
        void __fastcall SetPicture(Graphics::TBitmap *Picture);
        void __fastcall SetPictureMMX(Graphics::TBitmap *Picture);
        unsigned __fastcall GetDelay();
        void __fastcall SetDelay(unsigned Delay);
        unsigned __fastcall GetPauseInterval();
        void __fastcall SetPauseInterval(unsigned PauseInterval);
        unsigned __fastcall GetMaxOpacity();
        void __fastcall SetMaxOpacity(unsigned MaxOpacity);
        unsigned __fastcall GetMinOpacity();
        void __fastcall SetMinOpacity(unsigned MinOpacity);
protected:
public:
        __fastcall TAlphaBlendedSplash(TComponent* Owner);
        __fastcall ~TAlphaBlendedSplash();
        void __fastcall BlendIn();
        void __fastcall BlendOut();
__published:
        __property AnsiString Copyright = {read=GetCopyright, write=SetNULL};
        __property AnsiString Version = {read=GetVersion, write=SetNULL};
        __property unsigned Delay = {read=GetDelay, write=SetDelay, default=DEFAULTDELAY};
        __property unsigned PauseInterval = {read=GetPauseInterval, write=SetPauseInterval, default=DEFAULTPAUSEINTERVAL};
        __property Graphics::TBitmap * Picture = {read=FPicture, write=SetPicture};
        __property Graphics::TBitmap * PictureMMX = {read=FPictureMMX, write=SetPictureMMX};
        __property unsigned MaxOpacity = {read=GetMaxOpacity, write=SetMaxOpacity, default=DEFAULTMAXOPACITY};
        __property unsigned MinOpacity = {read=GetMinOpacity, write=SetMinOpacity, default=DEFAULTMINOPACITY};
};
//---------------------------------------------------------------------------
#endif
