unit TestZCube_SRC;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,ComObj, Grids, ExtCtrls,DateUtils,zCube_TLB;


type
  TForm1 = class(TForm)
    Grid: TStringGrid;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure GridMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
   cube : iCube;
   procedure DisplayMap;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
   i,j : integer;
   t1,t2 : TDateTime;
begin

t1 := Time;

Cube.SetTableName('CubeDemo.dbf');

Cube.AddNewDimension('ShipDate',False);
//Cube.AddNewDimension('Store',False);
Cube.AddNewDimension('Ware',False);
Cube.AddNewDimension('PaymentMethod',False);
//Cube.AddNewDimension('Client',False);
//Cube.AddNewDimension('City',False);
Cube.AddNewDimension('Country',False);
//Cube.AddNewDimension('Employer',False);
Cube.AddNewDimension('Terms',False);
Cube.AddNewMeasure('Summa');
//Cube.AddNewMeasure('Quantity');

Cube.InitDimensions;
Cube.CreateCube;
t2 := Time;
ShowMessage('Time = ' + IntToStr(MillisecondsBetween(t1,t2)) + ' Cube Length = ' + IntToStr(Cube.CubeLength));
end;

procedure TForm1.Button2Click(Sender: TObject);
var
   t1,t2,t3,t4 : TDateTime;
begin
t1 := Time;
Cube.ClearMap;
Cube.MapDimensionToColumn('Terms',maBottom);
Cube.MapDimensionToColumn('Ware',maBottom);
Cube.MapDimensionToRow('ShipDate',maBottom);
Cube.MapDimensionToRow('PaymentMethod',maBottom);
Cube.BuildMap;
t2 := Time;
Cube.HideEmptyRows;
Cube.HideEmptyColumns;
t3 := Time;
DisplayMap;
t4 := Time;
ShowMessage(' Map Time = ' + IntToStr(MillisecondsBetween(t1,t2)) +
            ' Disp Time = ' + IntToStr(MillisecondsBetween(t3,t4)) +
            ' Total Time = ' + IntToStr(MillisecondsBetween(t1,t4)) +
            ' MapSize = ' + IntToStr(Cube.ColumnCount) + 'x' + IntToStr(Cube.RowCount));

end;

procedure TForm1.Button3Click(Sender: TObject);
var
   t1,t2 : TDateTime;
begin
t1 := Time;
Cube.ClearMap;
Cube.MapDimensionToRow('Ware',maBottom);
Cube.MapDimensionToRow('Terms',maBottom);
Cube.MapDimensionToColumn('Country',maBottom);
Cube.MapDimensionToColumn('PaymentMethod',maBottom);
Cube.BuildMap;
Cube.HideEmptyRows;
Cube.HideEmptyColumns;
t2 := Time;
DisplayMap;
ShowMessage('Time = ' + IntToStr(MillisecondsBetween(t1,t2)) + ' MapSize = ' + IntToStr(Cube.ColumnCount) + 'x' + IntToStr(Cube.RowCount));
end;

procedure TForm1.DisplayMap;
var
   i,j,k : integer;
procedure ClearGrid;
var
   i,j : integer;
begin
for i := 0 to Grid.ColCount - 1 do
    for j := 0 to Grid.RowCount - 1 do
        Grid.Cells[i,j] := '';
end;
begin

ClearGrid;

Grid.ColCount := Cube.ColumnCount*Cube.MeasureCount + Cube.RowLevelCount;
Grid.RowCount := Cube.RowCount + Cube.ColumnLevelCount;

Grid.FixedCols := Cube.RowLevelCount;
if Cube.MeasureCount > 1 then
   Grid.FixedRows := Cube.ColumnLevelCount + 1
else
   Grid.FixedRows := Cube.ColumnLevelCount;


for i := 0 to Cube.ColumnCOunt - 1 do
    begin
    Grid.Cells[i*Cube.MeasureCount+Grid.FixedCols,Cube.Columns[i].Level] := Cube.Columns[i].Caption;
    if Cube.MeasureCount > 1 then
       for j := 0 to Cube.MeasureCount - 1 do
           begin
           Grid.Cells[i*Cube.MeasureCount+Grid.FixedCols+j,Grid.FixedRows-1] := Cube.Measure[j];
           end;
    end;
for i := 0 to Cube.RowCOunt - 1 do
    begin
    Grid.Cells[Cube.Rows[i].Level,i+Grid.FixedRows] := Cube.Rows[i].Caption;
    end;
for i := 0 to Cube.ColumnCount - 1 do
    begin
    for j := 0 to Cube.RowCount - 1 do
        begin
        for k := 0 to Cube.MeasureCount - 1 do
           Grid.Cells[i*Cube.MeasureCount+Grid.FixedCols+k,j+Grid.FixedRows] := FloatToStr(Cube.Cells[i,j,Cube.Measure[k]]);
        end;
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
Cube := CoCube.Create;//ICube(CreateOLEObject('zCube.Cube'));
Cube.SetAlias('CubeData','','');
end;

procedure TForm1.GridMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
   col,row : integer;
begin
Grid.MouseToCell(x,y,col,row);
if (row < Grid.FixedRows) and (col >= Grid.FixedCols) then
   begin
   col := col - Grid.FixedCols ;
   if Cube.MeasureCount > 1 then
      col := (col+1) div Cube.MeasureCount;
   if Cube.Columns[col].Collapsed then
      Cube.ExpandColumn(Cube.Columns[col].AbsoluteIndex)
   else
      Cube.CollapseColumn(Cube.Columns[col].AbsoluteIndex);
   DisplayMap;
   end;
if (row >= Grid.FixedRows) and (col < Grid.FixedCols) then
   begin
   row := row - Grid.FixedRows;
   if Cube.Rows[row].Collapsed then
      Cube.ExpandRow(Cube.Rows[row].AbsoluteIndex)
   else
      Cube.CollapseRow(Cube.Rows[row].AbsoluteIndex);
   DisplayMap;
   end;
end;

end.
