unit uagent;

interface

{ Microsoft Agent Delphi 5 Example
  By Guy Paddock

  Notes: You may use this example code any way you wish. There is no
  copyright to this code, but along that line, I do not support
  this code in any form or fashion.

  Requirements: You must have already installed & imported the Microsoft
  Agent & Lernout & Hauspie TruVoice ActiveX Controls
  This example code was written in Delphi 5, I do not know if it is
  supported by earlier versions.
}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, AgentObjects_TLB, StdCtrls;

type
  TAgentForm = class(TForm)
    AgentControl: TAgent;
    SpeakBox: TGroupBox;
    SpeakBtn: TButton;
    SayEdit: TEdit;
    SayLabel: TLabel;
    InstructLabel: TLabel;
    ActionBox: TGroupBox;
    InstructLabel2: TLabel;
    PlayLabel: TLabel;
    PlayBtn: TButton;
    PlayBox: TComboBox;
    procedure FormShow(Sender: TObject);
    procedure LoadCharacter;
    procedure DoIntro;
    procedure AgentControlHide(Sender: TObject; const CharacterID: WideString;
      Cause: Smallint);
    procedure SpeakBtnClick(Sender: TObject);
    procedure PlayBtnClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AgentForm: TAgentForm;
  Character: IAgentCtlCharacterEx;
  PlayRequest,
  LoadRequestUNC,
  LoadRequestURL: IAgentCtlRequest;
  AlreadyHid: Boolean;

implementation

{$R *.DFM}

procedure TAgentForm.FormShow(Sender: TObject);
begin
// Not quite sure why this needs to be here
AgentControl.Connected := True;
// Load the character
LoadCharacter;
end;

procedure TAgentForm.LoadCharacter;
begin
// Load the character locally
LoadRequestUNC := AgentControl.Characters.Load('Peedy', 'Peedy.acs');
if LoadRequestUNC.Status <> 0 then
        begin
	// Nag the user about getting the .acs file
	MessageDlg('You must have the Peedy character file (Peedy.acs) installed in the'+
         ' Microsoft Agent Characters directory in order to see this example.', mtError, [mbOk], 0);
        Application.Terminate;
        end
else
        begin
        // Success! We have loaded the file from the hard drive
	Character := AgentControl.Characters['Peedy'];
        // Have Peedy do his short Intro
	DoIntro;
        end;
end;

procedure TAgentForm.DoIntro;
begin
{ Show Peedy, giving False to tell Microsoft Agent that it should
 play the whole Show Animation}
Character.Show(False);
{ The PlayRequest variable is just there so that if the user clicks
 a button, Delphi can stop Peedy (Delphi requires that a Request
 object be defined when using the Character.Stop method}
PlayRequest := Character.Play('Greet');
PlayRequest := Character.Speak('Hello there, pleased to meet you. My name is Peedy.','');
PlayRequest := Character.Play('GestureDown');
PlayRequest := Character.Speak('You can read the directions below to find out how to use this Delphi 5 example.', '');
end;

procedure TAgentForm.AgentControlHide(Sender: TObject; const CharacterID: WideString;
  Cause: Smallint);
begin
// Peedy is hiding, close program
AlreadyHid := True;
Close;
end;

procedure TAgentForm.SpeakBtnClick(Sender: TObject);
begin
// Stop Peedy (See comments above)
Character.Stop(PlayRequest);
// Speak what has been typed
Character.Speak(SayEdit.Text, '');
end;

procedure TAgentForm.PlayBtnClick(Sender: TObject);
begin
// Stop Peedy (See comments above)
Character.Stop(PlayRequest);
// Make sure the animation is not left blank
if not (PlayBox.Text = '') then PlayRequest := Character.Play(PlayBox.Text)
else MessageDlg('You must select an animation first!', mtError, [mbOk], 0);
end;

{The routine below is just a something to make closing
 the program more dramatic}
procedure TAgentForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
// Make sure we didn't already hide Peedy
if AlreadyHid = False then
begin
// Stop Peedy (See comments above)
Character.Stop(PlayRequest);
// Hide Peedy
Character.Hide(False);
// This makes the program wait until Peedy has hidden
CanClose := False;
end;
end;

end.
