unit LoadMonitor_SRC;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Classes,SysUtils,ComObj, ActiveX, zCubeExplorer_TLB, StdVcl,LoadForm_SRC,Forms;

type
  TLoadMonitor = class(TAutoObject, ILoadMonitor)
    FLoadSize : LongWord;
    FStep : LongWord;
    FLoadForm : TLoadForm;
  protected
    function Get_LoadSize: Integer; safecall;
    procedure Set_LoadSize(Value: Integer); safecall;
    procedure Step; safecall;
    { Protected declarations }
  public
    procedure Initialize; override;
    destructor Destroy; override;

  end;

implementation

uses ComServ,ZCubeExplr_SRC;

function TLoadMonitor.Get_LoadSize: Integer;
begin
Result := FLoadSize;
end;

procedure TLoadMonitor.Set_LoadSize(Value: Integer);
begin
FLoadForm.ProgressBar1.Max := Value;
FStep := 0;
FLoadSize := Value;
end;

procedure TLoadMonitor.Step;
begin
FLoadForm.ProgressBar1.StepIt;
Inc(FStep);
Application.ProcessMessages;
end;

destructor TLoadMonitor.Destroy;
begin
  FLoadForm.Free;
  inherited;
end;

procedure TLoadMonitor.Initialize;
begin
  inherited;
  FLoadForm := TLoadForm.Create(Application);
  FLoadForm.Show;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TLoadMonitor, Class_LoadMonitor,
    ciMultiInstance, tmApartment);
end.
