unit ColorsForm_SRC;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TGridSettings = class(TComponent)
  private
    FFocusedCellColor: TColor;
    FRowheaderColor: TColor;
    FColumnHeaderColor: TColor;
    FSelectedCellColor: TColor;
    FCellColor: TColor;
    FPositiveCellFont: TFont;
    FRowHeaderFont: TFont;
    FZeroCellFont: TFont;
    FNegativeCellFont: TFont;
    FColumnHeaderFont: TFont;
    procedure SetCellColor(const Value: TColor);
    procedure SetColumnHeaderColor(const Value: TColor);
    procedure SetColumnHeaderFont(const Value: TFont);
    procedure SetFocusedCellColor(const Value: TColor);
    procedure SetNegativeCellFont(const Value: TFont);
    procedure SetPositiveCellFont(const Value: TFont);
    procedure SetRowheaderColor(const Value: TColor);
    procedure SetRowHeaderFont(const Value: TFont);
    procedure SetSelectedCellColor(const Value: TColor);
    procedure SetZeroCellFont(const Value: TFont);
  public
    constructor Create;
    destructor Destroy; override;
  published
    property ColumnHeaderColor : TColor read FColumnHeaderColor write SetColumnHeaderColor;
    property RowheaderColor : TColor read FRowheaderColor write SetRowheaderColor;
    property CellColor : TColor read FCellColor write SetCellColor;
    property SelectedCellColor : TColor read FSelectedCellColor write SetSelectedCellColor;
    property FocusedCellColor : TColor read FFocusedCellColor write SetFocusedCellColor;
    property ColumnHeaderFont : TFont read FColumnHeaderFont write SetColumnHeaderFont;
    property RowHeaderFont : TFont read FRowHeaderFont write SetRowHeaderFont;
    property PositiveCellFont : TFont read FPositiveCellFont write SetPositiveCellFont;
    property NegativeCellFont : TFont read FNegativeCellFont write SetNegativeCellFont;
    property ZeroCellFont : TFont read FZeroCellFont write SetZeroCellFont;
  end;

  TColorsForm = class(TForm)
    GroupBox1: TGroupBox;
    Label7: TLabel;
    ColumnsCB: TColorBox;
    Label8: TLabel;
    RowsCB: TColorBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    CellCB: TColorBox;
    SelCellCB: TColorBox;
    FCellCB: TColorBox;
    Accept: TButton;
    Cancel: TButton;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ColorsForm: TColorsForm;

implementation

{$R *.dfm}


{ TGridSettings }

constructor TGridSettings.Create;
begin
    ColumnHeaderFont := TFont.Create;
    RowHeaderFont    := TFont.Create;
    PositiveCellFont := TFont.Create;
    NegativeCellFont := TFont.Create;
    ZeroCellFont     := TFont.Create;
end;

destructor TGridSettings.Destroy;
begin
ColumnHeaderFont.Free;
RowHeaderFont.Free;
PositiveCellFont.Free;
NegativeCellFont.Free;
ZeroCellFont.Free;
inherited;

end;

procedure TGridSettings.SetCellColor(const Value: TColor);
begin
  FCellColor := Value;
end;

procedure TGridSettings.SetColumnHeaderColor(const Value: TColor);
begin
  FColumnHeaderColor := Value;
end;

procedure TGridSettings.SetColumnHeaderFont(const Value: TFont);
begin
  FColumnHeaderFont := Value;
end;

procedure TGridSettings.SetFocusedCellColor(const Value: TColor);
begin
  FFocusedCellColor := Value;
end;

procedure TGridSettings.SetNegativeCellFont(const Value: TFont);
begin
  FNegativeCellFont := Value;
end;

procedure TGridSettings.SetPositiveCellFont(const Value: TFont);
begin
  FPositiveCellFont := Value;
end;

procedure TGridSettings.SetRowheaderColor(const Value: TColor);
begin
  FRowheaderColor := Value;
end;

procedure TGridSettings.SetRowHeaderFont(const Value: TFont);
begin
  FRowHeaderFont := Value;
end;

procedure TGridSettings.SetSelectedCellColor(const Value: TColor);
begin
  FSelectedCellColor := Value;
end;

procedure TGridSettings.SetZeroCellFont(const Value: TFont);
begin
  FZeroCellFont := Value;
end;

end.
