// This sample application show you how you can simple use the BtrAPIX ActiveXControl
// to open Btrieve files directly using API calls
// No ODBC requirments
// No additional driver needed (only Btrieve MKDE Engine 6.15 or later)
// If you want to get a list of Properties and Methods then
// select on the Object combobox the BtrAPIX1 object then on drop-down the
// Procedure combo box and then you can see them all
//
// Author: Eugen Mihailescu
// Last changes: 06/06/2000
//  1999,2000 by Eugen Mihailescu
// If you are happy working with it and want to get the commercial version
// then contact me at: eugen.mihailescu@em-quicksoft.com

unit MainUnit;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  OleCtrls,
  BtrAPIXCtrl_TLB,
  Buttons,
  ExtCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    grpFieldInfo: TGroupBox;
    Label2: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    Edit2: TEdit;
    Label4: TLabel;
    Edit3: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    grpIndexInfo: TGroupBox;
    Label8: TLabel;
    ComboBox1: TComboBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    Label12: TLabel;
    Edit10: TEdit;
    Label13: TLabel;
    ComboBox2: TComboBox;
    Shape1: TShape;
    btnFirst: TSpeedButton;
    btnPrior: TSpeedButton;
    btnNext: TSpeedButton;
    btnLast: TSpeedButton;
    btnFind: TSpeedButton;
    btnPost: TSpeedButton;
    btnInsert: TSpeedButton;
    btnDelete: TSpeedButton;
    Label14: TLabel;
    Edit11: TEdit;
    Label15: TLabel;
    Edit12: TEdit;
    Button1: TButton;
    btnClose: TButton;
    Button3: TButton;
    Button4: TButton;
    BtrAPIX1: TBtrAPIX;
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnFindClick(Sender: TObject);
    procedure btnFirstClick(Sender: TObject);
    procedure btnInsertClick(Sender: TObject);
    procedure btnLastClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure btnPostClick(Sender: TObject);
    procedure btnPriorClick(Sender: TObject);
    procedure BtrAPIX1RecChanged(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    procedure CheckBoxState;
    function GetFieldDate(Offset, Length: integer): string;
    procedure UpdateFieldCtrls;
    procedure UpdateDataBuffer;
    procedure MoveCursor(Index: integer);
    procedure CreateKeyRef;
  public
    { Public declarations }
  end;

var
  Form1             : TForm1;
  RecChanged, Inserting: boolean;
  recPosition       : integer;
const
  CRLF              = #13#10;
  FldOffset         : array[0..5] of integer = (1, 11, 46, 235, 443, 639);
  FldLength         : array[0..5] of integer = (10, 35, 35, 20, 20, 8);

implementation

{$R *.DFM}

procedure TForm1.Button4Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  BtrAPIX1.AboutBox
end;

procedure TForm1.btnCloseClick(Sender: TObject);
begin
  BtrAPIX1.Active := False;
  UpdateFieldCtrls;
  CheckBoxState;
end;

procedure TForm1.btnDeleteClick(Sender: TObject);
begin
  if messagebox(0, 'Are you sure you want to delete this record?', 'Confirmation', mb_yesno or mb_iconquestion) = id_yes then
    begin
      BtrAPIX1.Delete;
      btnFirstClick(Self);
      UpdateDataBuffer;
    end
end;

procedure TForm1.btnFirstClick(Sender: TObject);
begin
  MoveCursor(0);
end;

procedure TForm1.btnInsertClick(Sender: TObject);
var
  i                 : integer;
begin
  Inserting := True;
  Edit1.Text := '';
  Edit2.Text := '';
  Edit3.Text := '';
  Edit4.Text := '';
  Edit5.Text := '';
  Edit6.Text := '';
end;

procedure TForm1.btnLastClick(Sender: TObject);
begin
  MoveCursor(-2)
end;

procedure TForm1.btnNextClick(Sender: TObject);
begin
  MoveCursor(1)
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  FileName          : string;
begin
  if Inputquery('File Name: ', 'Open File', FileName) then
    begin
      BtrAPIX1.Active := False;
      BtrAPIX1.FileName := FileName;
      BtrAPIX1.FirstOnOpen := True;
      BtrAPIX1.Active := True;
      CheckBoxState;
      CreateKeyRef;
      btnFirstClick(Self);
    end;
end;

procedure TForm1.btnPostClick(Sender: TObject);
begin
  UpdateDataBuffer
end;

procedure TForm1.btnPriorClick(Sender: TObject);
begin
  MoveCursor(-1)
end;

procedure TForm1.BtrAPIX1RecChanged(Sender: TObject);
begin
  //  messagebox(0, 'Record contents has changed.this event is triggered whenever the DataBuffer has been readen', 'Sample message when OnRecordChanged event fired', mb_ok);
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  RecChanged := True;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ComboBox2.itemindex := 0;
  RecChanged := False;
  CheckBoxState;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  BtrAPIX1.Active := False;
end;

procedure TForm1.btnFindClick(Sender: TObject);
var
  FindWhat          : string;
begin
  FindWhat := Edit1.Text;
  if Inputquery('Enter the search Text: ', 'Find What', FindWhat) then
    begin
      BtrAPIX1.KeyBuffer := FindWhat + stringofchar(#32, FldLength[0] - Length(FindWhat));
      BtrAPIX1.KeyNum := ComboBox1.itemindex;
      try
        case ComboBox2.itemindex of
          0: BtrAPIX1.Equal;
          1: BtrAPIX1.GreaterEq;
          2: BtrAPIX1.LessEq;
        end;
        UpdateFieldCtrls;
      except
        messagebox(0, PChar('Key "' + FindWhat + '" not found.'), 'Key not found', mb_ok);
      end;
    end;
end;

procedure TForm1.CheckBoxState;
var
  ActiveCtrl        : boolean;
begin
  ActiveCtrl := BtrAPIX1.Active;
  btnClose.Enabled := ActiveCtrl;
  grpFieldInfo.Enabled := ActiveCtrl;
  grpIndexInfo.Enabled := ActiveCtrl;
  btnFirst.Enabled := ActiveCtrl;
  btnNext.Enabled := ActiveCtrl;
  btnPrior.Enabled := ActiveCtrl;
  btnLast.Enabled := ActiveCtrl;
  btnFind.Enabled := ActiveCtrl;
  btnPost.Enabled := ActiveCtrl;
  btnInsert.Enabled := ActiveCtrl;
  btnDelete.Enabled := ActiveCtrl and (BtrAPIX1.RecordCount > 0);
end;

function TForm1.GetFieldDate(Offset, Length: integer): string;
var
  Buffer            : string;
begin
  if not BtrAPIX1.Active then
    result := ''
  else
    begin
      Buffer := BtrAPIX1.DataBuffer;
      result := copy(Buffer, Offset, Length);
    end
end;

procedure TForm1.UpdateFieldCtrls;
var
  i                 : integer;
begin
  if BtrAPIX1.Active then
    begin
      Edit1.Text := GetFieldDate(FldOffset[0], FldLength[0]);
      Edit2.Text := GetFieldDate(FldOffset[1], FldLength[1]);
      Edit3.Text := GetFieldDate(FldOffset[2], FldLength[2]);
      Edit4.Text := GetFieldDate(FldOffset[3], FldLength[3]);
      Edit5.Text := GetFieldDate(FldOffset[4], FldLength[4]);
      Edit6.Text := GetFieldDate(FldOffset[5], FldLength[5]);
      Edit11.Text := inttostr(recPosition);
      Edit12.Text := inttostr(BtrAPIX1.RecordCount);
    end
  else
    begin
      Edit1.Text := '';
      Edit2.Text := '';
      Edit3.Text := '';
      Edit4.Text := '';
      Edit5.Text := '';
      Edit6.Text := '';
      Edit11.Text := '0';
      Edit12.Text := '0';
    end;
  RecChanged := False;
end;

procedure TForm1.UpdateDataBuffer;
var
  Buffer            : string;
begin
  if BtrAPIX1.Active then
    begin
      Buffer := BtrAPIX1.DataBuffer;
      Buffer := copy(Buffer, 1, FldOffset[0] - 1) + Format('%-' + inttostr(FldLength[0]) + 's', [Edit1.Text]);
      Buffer := copy(Buffer, 1, FldOffset[1] - 1) + Format('%-' + inttostr(FldLength[1]) + 's', [Edit2.Text]);
      Buffer := copy(Buffer, 1, FldOffset[2] - 1) + Format('%-' + inttostr(FldLength[2]) + 's', [Edit3.Text]);
      Buffer := copy(Buffer, 1, FldOffset[3] - 1) + Format('%-' + inttostr(FldLength[3]) + 's', [Edit4.Text]);
      Buffer := copy(Buffer, 1, FldOffset[4] - 1) + Format('%-' + inttostr(FldLength[4]) + 's', [Edit5.Text]);
      Buffer := copy(Buffer, 1, FldOffset[5] - 1) + Format('%-' + inttostr(FldLength[5]) + 's', [Edit6.Text]);
      BtrAPIX1.DataBuffer := Buffer;
      if Inserting then
        BtrAPIX1.Insert
      else
        BtrAPIX1.Update;
    end;
  RecChanged := False;
  Inserting := False;
end;

procedure TForm1.MoveCursor(Index: integer);
var
  SavePosition      : integer;
begin
  SavePosition := recPosition;
  if RecChanged then
    if messagebox(0, 'Record contents changed.Post changes?', 'Confirmation', mb_iconquestion or mb_yesno) = id_yes then
      btnPostClick(Self);

  case Index of
    0:
      begin
        BtrAPIX1.First;
        recPosition := 1;
      end;
    - 2:
      begin
        BtrAPIX1.Last;
        recPosition := BtrAPIX1.RecordCount;
      end;
    - 1:
      begin
        BtrAPIX1.Prev;
        recPosition := recPosition + Index;
      end;
    1:
      begin
        BtrAPIX1.Next;
        recPosition := recPosition + Index;
      end;
  end;
  if recPosition < 1 then
    recPosition := 1
  else
    if (BtrAPIX1.Active) and (recPosition > BtrAPIX1.RecordCount) then
    recPosition := BtrAPIX1.RecordCount;
  UpdateFieldCtrls;
end;

procedure TForm1.CreateKeyRef;
var
  i                 : integer;
begin
  for i := 0 to BtrAPIX1.NumberOfKeys - 1 do
    ComboBox1.Items.add(inttostr(i));
  if ComboBox1.Items.count > 0 then
    ComboBox1.itemindex := 0;
end;
end.

