/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

/*
 * This file will flush the malloc pools before terminating.
 * I order to eliminate the C++ allocations as well, you need also
 * to change NEWMODE to NEWMODE_MALLOC in New.cpp of the MSL Runtime (CW Pro2)
 */


#include <pool_alloc.h>
extern mem_pool_obj __malloc_pool;

extern pascal void __terminate(void);

pascal void __terminate_malloc(void)
{
	__terminate();
	__pool_free_all(&__malloc_pool);
}
