/*
 * Stollen from POV and added to MacCVS by
 * Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

/*==============================================================================
Project:	POV-Ray

Version:	3

File:	VolsPaths.h

Description:
	Various volume and pathname handling routines.
------------------------------------------------------------------------------
Author:
	Eduard [esp] Schwan
------------------------------------------------------------------------------
	from Persistence of Vision(tm) Ray Tracer
	Copyright 1996 Persistence of Vision Team
------------------------------------------------------------------------------
	NOTICE: This source code file is provided so that users may experiment
	with enhancements to POV-Ray and to port the software to platforms other 
	than those supported by the POV-Ray Team.  There are strict rules under
	which you are permitted to use this file.  The rules are in the file
	named POVLEGAL.DOC which should be distributed with this file. If 
	POVLEGAL.DOC is not available or for more info please contact the POV-Ray
	Team Coordinator by leaving a message in CompuServe's Graphics Developer's
	Forum.  The latest version of POV-Ray may be found there as well.

	This program is based on the popular DKB raytracer version 2.12.
	DKBTrace was originally written by David K. Buck.
	DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
------------------------------------------------------------------------------
Change History:
	941221	[esp]	Created
==============================================================================*/

#ifndef VOLSPATHS_H
#define VOLSPATHS_H


/*==== Macintosh-specific headers ====*/
#include <Types.h>

#ifdef __cplusplus
extern "C" {
#endif

/*==== Prototypes =====*/

OSErr VRef2VolName(short theVRef, StringPtr theVolName);

OSErr VolName2VRef(StringPtr myPVolName, short * theVRefPtr);

OSErr PathNameFromDirID(const long			aDirID,
						const short			avRefNum,
						char				* aPath);

OSErr PathNameFromWD(	const short			avRefNum,
						char				* aPath);

#ifdef __cplusplus
}
#endif

#endif //  VOLSPATHS_H

