/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- March 1998
 */

/*
 * UpdateDlg.h : the cvs update dialog
 */

#if !defined(AFX_UPDATEDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_UPDATEDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"
#include "MultiString.h"

bool CompatGetUpdate(bool & toStdout, bool & noRecurs, bool & resetSticky,
					 CPStr & date, CPStr & rev,
					 bool & useMostRecent,
					 CPStr & rev1, CPStr & rev2,
					 bool & createMissDir);
	// get the update options...

extern CMString gRevNames;
extern CMString gDateNames;
	// persistent default values for the dates, tags...

#ifdef WIN32
class CUpdateMain : public CPropertyPage
{
	DECLARE_DYNCREATE(CUpdateMain)

// Construction
public:
	CUpdateMain();
	~CUpdateMain();

// Dialog Data
	//{{AFX_DATA(CUpdateMain)
	enum { IDD = IDD_UPDATE_MAIN };
	BOOL	m_delsticky;
	BOOL	m_norecurs;
	BOOL	m_stdout;
	BOOL	m_createmissdir;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CUpdateMain)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CUpdateMain)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CUpdateMerge : public CPropertyPage
{
	DECLARE_DYNCREATE(CUpdateMerge)

// Construction
public:
	CUpdateMerge(const char *rev1, const char *rev2);
	CUpdateMerge();
	~CUpdateMerge();

// Dialog Data
	//{{AFX_DATA(CUpdateMerge)
	enum { IDD = IDD_UPDATE_MERGE };
	CComboBox	m_comborevdef2;
	CComboBox	m_comborevdef;
	CString	m_rev1;
	CString	m_rev2;
	int m_merge;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CUpdateMerge)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CUpdateMerge)
	afx_msg void OnMerge();
	afx_msg void OnMerge1();
	afx_msg void OnMerge2();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CUpdateSticky : public CPropertyPage
{
	DECLARE_DYNCREATE(CUpdateSticky)

// Construction
public:
	CUpdateSticky(const char *rev, const char *date);
	CUpdateSticky();
	~CUpdateSticky();

// Dialog Data
	//{{AFX_DATA(CUpdateSticky)
	enum { IDD = IDD_UPDATE_STICKY };
	CComboBox	m_datedef;
	CComboBox	m_revdef;
	CString	m_date;
	CString	m_rev;
	BOOL	m_hasdate;
	BOOL	m_hasrev;
	BOOL	m_match;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CUpdateSticky)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CUpdateSticky)
	afx_msg void OnDate();
	afx_msg void OnRev();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};
//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
#endif /* WIN32 */

#endif // !defined(AFX_UPDATEDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
