/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- July 1998
 */

/*
 * RtagDlg.cpp : the cvs rtag dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#	include "GetPrefs.h"
#endif /* WIN32 */

#ifdef qQT
#	include "qcvsapp.h"
#endif /* qQT */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LCheckBox.h>
#	include <LEditText.h>
#	include <LPopupGroupBox.h>
#	include <LRadioButton.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "RtagDlg.h"
#include "CvsPrefs.h"
#include "UpdateDlg.h"

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#ifdef WIN32
IMPLEMENT_DYNCREATE(CRtag_CREATE, CPropertyPage)

CRtag_CREATE::CRtag_CREATE(const char * sLastModule, const char * sLastTag,
	bool hasDate, bool hasRev,
	const char * sLastDate, const char * sLastRev,
	bool noRecurs, bool overwriteExist,
	bool useMostRecent, bool lookAttic) : CPropertyPage(CRtag_CREATE::IDD)
{
	//{{AFX_DATA_INIT(CRtag_CREATE)
	m_attic = lookAttic;
	m_date = sLastDate;
	m_rev = sLastRev;
	m_hasdate = hasDate;
	m_hasrev = hasRev;
	m_norecurs = noRecurs;
	m_match = useMostRecent;
	m_modname = sLastModule;
	m_tagname = sLastTag;
	m_overwrite = overwriteExist;
	//}}AFX_DATA_INIT
}

CRtag_CREATE::CRtag_CREATE() : CPropertyPage(CRtag_CREATE::IDD)
{
	//{{AFX_DATA_INIT(CRtag_CREATE)
	m_attic = FALSE;
	m_date = _T("");
	m_rev = _T("");
	m_hasdate = FALSE;
	m_hasrev = FALSE;
	m_norecurs = FALSE;
	m_match = FALSE;
	m_modname = _T("");
	m_tagname = _T("");
	m_overwrite = FALSE;
	//}}AFX_DATA_INIT
}

CRtag_CREATE::~CRtag_CREATE()
{
}

void CRtag_CREATE::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRtag_CREATE)
	DDX_Control(pDX, IDC_COMBOREV, m_revdef);
	DDX_Control(pDX, IDC_COMBODATE, m_datedef);
	DDX_Check(pDX, IDC_ATTIC, m_attic);
	DDX_CBString(pDX, IDC_COMBODATE, m_date);
	DDX_CBString(pDX, IDC_COMBOREV, m_rev);
	DDX_Check(pDX, IDC_DATE, m_hasdate);
	DDX_Check(pDX, IDC_MATCH, m_match);
	DDX_Check(pDX, IDC_REV, m_hasrev);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Text(pDX, IDC_MODNAME, m_modname);
	DDX_Text(pDX, IDC_TAGNAME, m_tagname);
	DDX_Check(pDX, IDC_OVERWRITE, m_overwrite);
	//}}AFX_DATA_MAP
	if(m_hasrev)
		DDV_MinChars(pDX, m_rev, 1);
	if(m_hasdate)
		DDV_MinChars(pDX, m_date, 1);
	DDV_MinChars(pDX, m_modname, 1);
	DDV_MinChars(pDX, m_tagname, 1);
	if(!pDX->m_bSaveAndValidate)
	{
		OnDate();
		OnRev();
	}
	DDX_ComboMString(pDX, IDC_COMBOREV, gRevNames, m_revdef);
	DDX_ComboMString(pDX, IDC_COMBODATE, gDateNames, m_datedef);
}

BEGIN_MESSAGE_MAP(CRtag_CREATE, CPropertyPage)
	//{{AFX_MSG_MAP(CRtag_CREATE)
	ON_BN_CLICKED(IDC_DATE, OnDate)
	ON_BN_CLICKED(IDC_REV, OnRev)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CRtag_CREATE::OnDate() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_DATE);
	CWnd* wnd = GetDlgItem(IDC_COMBODATE);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CRtag_CREATE::OnRev() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_REV);
	CWnd* wnd = GetDlgItem(IDC_COMBOREV);
	wnd->EnableWindow(but->GetCheck() == 1);
}

IMPLEMENT_DYNCREATE(CRtag_DELETE, CPropertyPage)

CRtag_DELETE::CRtag_DELETE(const char * sLastModule,
	const char * sLastTag, bool noRecurs,
	bool lookAttic) : CPropertyPage(CRtag_DELETE::IDD)
{
	//{{AFX_DATA_INIT(CRtag_DELETE)
	m_attic = lookAttic;
	m_norecurs = noRecurs;
	m_modname = sLastModule;
	m_tagname = sLastTag;
	//}}AFX_DATA_INIT
}

CRtag_DELETE::CRtag_DELETE() : CPropertyPage(CRtag_DELETE::IDD)
{
	//{{AFX_DATA_INIT(CRtag_DELETE)
	m_attic = FALSE;
	m_norecurs = FALSE;
	m_modname = _T("");
	m_tagname = _T("");
	//}}AFX_DATA_INIT
}

CRtag_DELETE::~CRtag_DELETE()
{
}

void CRtag_DELETE::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRtag_DELETE)
	DDX_Check(pDX, IDC_ATTIC, m_attic);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Text(pDX, IDC_MODNAME, m_modname);
	DDX_Text(pDX, IDC_TAGNAME, m_tagname);
	//}}AFX_DATA_MAP
	DDV_MinChars(pDX, m_modname, 1);
	DDV_MinChars(pDX, m_tagname, 1);
}

BEGIN_MESSAGE_MAP(CRtag_DELETE, CPropertyPage)
	//{{AFX_MSG_MAP(CRtag_DELETE)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

IMPLEMENT_DYNCREATE(CRtag_BRANCH, CPropertyPage)

CRtag_BRANCH::CRtag_BRANCH(const char * sLastModule, const char * sLastBranch,
	bool hasDate, bool hasRev,
	const char * sLastDate, const char * sLastRev,
	bool noRecurs, bool useMostRecent, bool lookAttic) :
		CPropertyPage(CRtag_BRANCH::IDD)
{
	//{{AFX_DATA_INIT(CRtag_BRANCH)
	m_attic = lookAttic;
	m_date = sLastDate;
	m_rev = sLastRev;
	m_hasdate = hasDate;
	m_hasrev = hasRev;
	m_norecurs = noRecurs;
	m_match = useMostRecent;
	m_modname = sLastModule;
	m_branchname = sLastBranch;
	//}}AFX_DATA_INIT
}

CRtag_BRANCH::CRtag_BRANCH() : CPropertyPage(CRtag_BRANCH::IDD)
{
	//{{AFX_DATA_INIT(CRtag_BRANCH)
	m_attic = FALSE;
	m_date = _T("");
	m_rev = _T("");
	m_hasdate = FALSE;
	m_hasrev = FALSE;
	m_norecurs = FALSE;
	m_match = FALSE;
	m_modname = _T("");
	m_branchname = _T("");
	//}}AFX_DATA_INIT
}

CRtag_BRANCH::~CRtag_BRANCH()
{
}

void CRtag_BRANCH::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRtag_BRANCH)
	DDX_Control(pDX, IDC_COMBOREV, m_revdef);
	DDX_Control(pDX, IDC_COMBODATE, m_datedef);
	DDX_Check(pDX, IDC_ATTIC, m_attic);
	DDX_CBString(pDX, IDC_COMBODATE, m_date);
	DDX_CBString(pDX, IDC_COMBOREV, m_rev);
	DDX_Check(pDX, IDC_DATE, m_hasdate);
	DDX_Check(pDX, IDC_MATCH, m_match);
	DDX_Check(pDX, IDC_REV, m_hasrev);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Text(pDX, IDC_MODNAME, m_modname);
	DDX_Text(pDX, IDC_TAGNAME, m_branchname);
	//}}AFX_DATA_MAP
	if(m_hasrev)
		DDV_MinChars(pDX, m_rev, 1);
	if(m_hasdate)
		DDV_MinChars(pDX, m_date, 1);
	DDV_MinChars(pDX, m_modname, 1);
	DDV_MinChars(pDX, m_branchname, 1);
	if(!pDX->m_bSaveAndValidate)
	{
		OnDate();
		OnRev();
	}
	DDX_ComboMString(pDX, IDC_COMBOREV, gRevNames, m_revdef);
	DDX_ComboMString(pDX, IDC_COMBODATE, gDateNames, m_datedef);
}

BEGIN_MESSAGE_MAP(CRtag_BRANCH, CPropertyPage)
	//{{AFX_MSG_MAP(CRtag_BRANCH)
	ON_BN_CLICKED(IDC_DATE, OnDate)
	ON_BN_CLICKED(IDC_REV, OnRev)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CRtag_BRANCH::OnDate() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_DATE);
	CWnd* wnd = GetDlgItem(IDC_COMBODATE);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CRtag_BRANCH::OnRev() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_REV);
	CWnd* wnd = GetDlgItem(IDC_COMBOREV);
	wnd->EnableWindow(but->GetCheck() == 1);
}
#endif /* WIN32 */

#ifdef qMacCvsPP
static void DoDataExchange_RtagCreateMain(LWindow *theDialog,
	CPStr & sLastModule, CPStr & sLastTag,
	bool & hasDate, bool & hasRev,
	CPStr & sLastDate, CPStr & sLastRev,
	bool & useMostRecent, bool & lookAttic, bool putValue)
{
	LEditText *mname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_ModuleName));
	LEditText *tname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_BranchRev));
	LCheckBox *chkHasDate = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate));
	LCheckBox *chkHasRev = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckRevTag));
	LCheckBox *chkMostRecent = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_MostRecentRev));
	LCheckBox *chkLookAttic = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_InAttic));
	LEditText *editDate = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditDate));
	LEditText *editRev = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag));
	LPopupFiller *fillRev = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev1));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	LPopupFiller *fillDate = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerDate));
	
	fillRev->DoDataExchange(gRevNames, putValue);
	fillTag->DoDataExchange(gRevNames, putValue);
	fillDate->DoDataExchange(gDateNames, putValue);

	if(putValue)
	{
		mname->SetText((Ptr)(const char *)sLastModule, sLastModule.length());
		tname->SetText((Ptr)(const char *)sLastTag, sLastTag.length());
		chkHasDate->SetValue(hasDate ? Button_On : Button_Off);
		chkHasRev->SetValue(hasRev ? Button_On : Button_Off);
		chkMostRecent->SetValue(useMostRecent ? Button_On : Button_Off);
		chkLookAttic->SetValue(lookAttic ? Button_On : Button_Off);
		editDate->SetText((Ptr)(const char *)sLastDate, sLastDate.length());
		editRev->SetText((Ptr)(const char *)sLastRev, sLastRev.length());
	}
	else
	{
		hasDate = chkHasDate->GetValue() == Button_On;
		hasRev = chkHasRev->GetValue() == Button_On;
		useMostRecent = chkMostRecent->GetValue() == Button_On;
		lookAttic = chkLookAttic->GetValue() == Button_On;

		char str[255];
		Size len;
		
		mname->GetText(str, 254, &len);
		sLastModule.set(str, len);
		tname->GetText(str, 254, &len);
		sLastTag.set(str, len);
		editDate->GetText(str, 254, &len);
		sLastDate.set(str, len);
		editRev->GetText(str, 254, &len);
		sLastRev.set(str, len);
	}
}

static void DoDataExchange_RtagCreateOptions(LWindow *theDialog,
	bool & noRecurs, bool & overwriteExist, bool putValue)
{
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LCheckBox *chkOverwrite = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_OverwriteRev));
	
	if(putValue)
	{
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
		chkOverwrite->SetValue(overwriteExist ? Button_On : Button_Off);
	}
	else
	{
		noRecurs = chkNoRecurs->GetValue() == Button_On;
		overwriteExist = chkOverwrite->GetValue() == Button_On;
	}
}

static void DoDataExchange_RtagDeleteMain(LWindow *theDialog,
	CPStr & sLastModule, CPStr & sLastTag,
	bool & noRecurs, bool & lookAttic, bool putValue)
{
	LEditText *mname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_ModuleName));
	LEditText *tname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_BranchRev));
	LCheckBox *chkLookAttic = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_InAttic));
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	
	fillTag->DoDataExchange(gRevNames, putValue);

	if(putValue)
	{
		mname->SetText((Ptr)(const char *)sLastModule, sLastModule.length());
		tname->SetText((Ptr)(const char *)sLastTag, sLastTag.length());
		chkLookAttic->SetValue(lookAttic ? Button_On : Button_Off);
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
	}
	else
	{
		lookAttic = chkLookAttic->GetValue() == Button_On;
		noRecurs = chkNoRecurs->GetValue() == Button_On;

		char str[255];
		Size len;
		
		mname->GetText(str, 254, &len);
		sLastModule.set(str, len);
		tname->GetText(str, 254, &len);
		sLastTag.set(str, len);
	}
}

static void DoDataExchange_RtagBranchMain(LWindow *theDialog,
	CPStr & sLastModule, CPStr & sLastBranch,
	bool & hasDate, bool & hasRev,
	CPStr & sLastDate, CPStr & sLastRev,
	bool & useMostRecent, bool & lookAttic, bool putValue)
{
	LEditText *mname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_ModuleName));
	LEditText *tname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_BranchRev));
	LCheckBox *chkHasDate = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate));
	LCheckBox *chkHasRev = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckRevTag));
	LCheckBox *chkMostRecent = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_MostRecentRev));
	LCheckBox *chkLookAttic = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_InAttic));
	LEditText *editDate = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditDate));
	LEditText *editRev = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag));
	LPopupFiller *fillRev = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev1));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	LPopupFiller *fillDate = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerDate));
	
	fillRev->DoDataExchange(gRevNames, putValue);
	fillTag->DoDataExchange(gRevNames, putValue);
	fillDate->DoDataExchange(gDateNames, putValue);

	if(putValue)
	{
		mname->SetText((Ptr)(const char *)sLastModule, sLastModule.length());
		tname->SetText((Ptr)(const char *)sLastBranch, sLastBranch.length());
		chkHasDate->SetValue(hasDate ? Button_On : Button_Off);
		chkHasRev->SetValue(hasRev ? Button_On : Button_Off);
		chkMostRecent->SetValue(useMostRecent ? Button_On : Button_Off);
		chkLookAttic->SetValue(lookAttic ? Button_On : Button_Off);
		editDate->SetText((Ptr)(const char *)sLastDate, sLastDate.length());
		editRev->SetText((Ptr)(const char *)sLastRev, sLastRev.length());
	}
	else
	{
		hasDate = chkHasDate->GetValue() == Button_On;
		hasRev = chkHasRev->GetValue() == Button_On;
		useMostRecent = chkMostRecent->GetValue() == Button_On;
		lookAttic = chkLookAttic->GetValue() == Button_On;

		char str[255];
		Size len;
		
		mname->GetText(str, 254, &len);
		sLastModule.set(str, len);
		tname->GetText(str, 254, &len);
		sLastBranch.set(str, len);
		editDate->GetText(str, 254, &len);
		sLastDate.set(str, len);
		editRev->GetText(str, 254, &len);
		sLastRev.set(str, len);
	}
}

static void DoDataExchange_RtagBranchOptions(LWindow *theDialog,
	bool & noRecurs, bool putValue)
{
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	
	if(putValue)
	{
		chkNoRecurs->SetValue(noRecurs ? Button_On : Button_Off);
	}
	else
	{
		noRecurs = chkNoRecurs->GetValue() == Button_On;
	}
}
#endif /* qMacCvsPP */

bool CompatRtagCreate(bool & noRecurs, bool & overwriteExisting, CPStr & tagName,
					 CPStr & modName, CPStr & date, CPStr & rev,
					 bool & useMostRecent, bool & lookAttic)
{
	bool userHitOK = false;

	static CPStr sLastModule;
	static CPStr sLastTag;
	static CPStr sLastDate;
	static CPStr sLastRev;

	bool hasDate = false;
	bool hasRev = false;

	date = "";
	rev = "";
	tagName = "";
	modName = "";
	noRecurs = false;
	overwriteExisting = false;
	useMostRecent = false;
	lookAttic = false;

#ifdef WIN32
	CPropertySheet pages("Create tag settings");
	CRtag_CREATE page1(sLastModule, sLastTag, hasDate, hasRev,
		sLastDate, sLastRev, noRecurs, overwriteExisting,
		useMostRecent, lookAttic);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		lookAttic = page1.m_attic == TRUE;
		sLastDate = page1.m_date;
		sLastRev = page1.m_rev;
		hasDate = page1.m_hasdate == TRUE;
		hasRev = page1.m_hasrev == TRUE;
		noRecurs = page1.m_norecurs == TRUE;
		useMostRecent = page1.m_match == TRUE;
		sLastModule = page1.m_modname;
		sLastTag = page1.m_tagname;
		overwriteExisting = page1.m_overwrite == TRUE;

		page2.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_RtagCreate, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(3);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(2);
	DoDataExchange_RtagCreateOptions(theDialog, noRecurs, overwriteExisting, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_RtagCreateMain(theDialog, sLastModule, sLastTag,
		hasDate, hasRev, sLastDate, sLastRev,
		useMostRecent, lookAttic, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_RtagCreateMain(theDialog, sLastModule, sLastTag,
			hasDate, hasRev, sLastDate, sLastRev,
			useMostRecent, lookAttic, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_RtagCreateOptions(theDialog, noRecurs, overwriteExisting, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		if(hasDate && !sLastDate.empty())
			date = sLastDate;
		if(hasRev && !sLastRev.empty())
			rev = sLastRev;
	
		tagName = sLastTag;
		modName = sLastModule;

		gCvsPrefs.save();
	}

	return userHitOK;
}

bool CompatRtagDelete(bool & noRecurs, bool & lookAttic,
					 CPStr & tagName, CPStr & modName)
{

	bool userHitOK = false;

	static CPStr sLastModule;
	static CPStr sLastTag;

	tagName = "";
	modName = "";
	noRecurs = false;
	lookAttic = false;

#ifdef WIN32
	CPropertySheet pages("Delete tag settings");
	CRtag_DELETE page1(sLastModule, sLastTag, noRecurs, lookAttic);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		lookAttic = page1.m_attic == TRUE;
		noRecurs = page1.m_norecurs == TRUE;
		sLastModule = page1.m_modname;
		sLastTag = page1.m_tagname;

		page2.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_RtagDelete, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(2);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_RtagDeleteMain(theDialog, sLastModule, sLastTag,
		noRecurs, lookAttic, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_RtagDeleteMain(theDialog, sLastModule, sLastTag,
			noRecurs, lookAttic, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		tagName = sLastTag;
		modName = sLastModule;

		gCvsPrefs.save();
	}

	return userHitOK;
}

bool CompatRtagBranch(bool & noRecurs, CPStr & branchName,
					 CPStr & modName, CPStr & date, CPStr & rev,
					 bool & useMostRecent, bool & lookAttic)
{
	bool userHitOK = false;

	static CPStr sLastModule;
	static CPStr sLastBranch;
	static CPStr sLastDate;
	static CPStr sLastRev;

	bool hasDate = false;
	bool hasRev = false;

	date = "";
	rev = "";
	branchName = "";
	modName = "";
	noRecurs = false;
	useMostRecent = false;
	lookAttic = false;

#ifdef WIN32
	CPropertySheet pages("Create branch settings");
	CRtag_BRANCH page1(sLastModule, sLastBranch, hasDate, hasRev,
		sLastDate, sLastRev, noRecurs, useMostRecent, lookAttic);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		lookAttic = page1.m_attic == TRUE;
		sLastDate = page1.m_date;
		sLastRev = page1.m_rev;
		hasDate = page1.m_hasdate == TRUE;
		hasRev = page1.m_hasrev == TRUE;
		noRecurs = page1.m_norecurs == TRUE;
		useMostRecent = page1.m_match == TRUE;
		sLastModule = page1.m_modname;
		sLastBranch = page1.m_branchname;

		page2.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_RtagBranch, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(3);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(2);
	DoDataExchange_RtagBranchOptions(theDialog, noRecurs, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_RtagBranchMain(theDialog, sLastModule, sLastBranch,
		hasDate, hasRev, sLastDate, sLastRev,
		useMostRecent, lookAttic, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_RtagBranchMain(theDialog, sLastModule, sLastBranch,
			hasDate, hasRev, sLastDate, sLastRev,
			useMostRecent, lookAttic, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_RtagBranchOptions(theDialog, noRecurs, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		if(hasDate && !sLastDate.empty())
			date = sLastDate;
		if(hasRev && !sLastRev.empty())
			rev = sLastRev;
	
		branchName = sLastBranch;
		modName = sLastModule;

		gCvsPrefs.save();
	}

	return userHitOK;
}
