/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- August 1998
 */

/*
 * MultiString.h --- remember several unique persistents strings
 */

#ifndef MULTISTRING_H
#define MULTISTRING_H

#include <vector>
#include "Persistent.h"
#include "CPStr.h"

#ifndef NAMESPACE
#	if defined(_MSC_VER) || defined(__MWERKS__)
#		define NAMESPACE(w) w::
#	else
#		define NAMESPACE(w) ::
#	endif
#endif

template<class T>
class TMString : public CPersistent
{
public:
	TMString(unsigned int maxstr, const char *uniqueName, char * const *defaultStr = 0L);
		// defaultStr is a null terminated set of strings

	virtual ~TMString();
	
	virtual unsigned int SizeOf(void) const;
	virtual const void *GetData(void) const;
	virtual void SetData(const void *ptr, unsigned int size);
		// persistent interface
	
	void Insert(const char *newstr);
		// add a new string
	
	inline const NAMESPACE(std) vector<T> & GetList(void) const { return fAllStrs; }
	
protected:
	NAMESPACE(std) vector<T> fAllStrs;
	CStaticAllocT<char> fBuf;
	unsigned int fMaxStr;
};

typedef TMString<CStr> CMString;
typedef TMString<CPStr> CMPString;

#endif /* AUTHEN_H */
