/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- August 1998
 */

/*
 * MultiString.cpp --- remember several unique persistents strings
 */

#include "stdafx.h"

#include "MultiString.h"

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

template<class T>
TMString<T>::TMString(unsigned int maxstr, const char *uniqueName, char * const *defaultStr) :
	fMaxStr(maxstr)
{
	CPersistent::Register(this, uniqueName);

	if(defaultStr != 0L)
	{
		int i = 0;
		while(defaultStr[i] != 0L)
		{
			Insert(defaultStr[i++]);
		}
	}
}

template<class T>
TMString<T>::~TMString()
{
	CPersistent::UnRegister(this);
}

template<class T>
unsigned int TMString<T>::SizeOf(void) const
{
	NAMESPACE(std) vector<T>::const_iterator i;
	unsigned int thesize = sizeof(int);
	
	for(i = fAllStrs.begin(); i != fAllStrs.end(); ++i)
	{
		thesize += (*i).length() + 1;
	}
	return thesize;
}

template<class T>
const void *TMString<T>::GetData(void) const
{
	unsigned int thesize = SizeOf(), tmpsize;
	((TMString *)this)->fBuf.AdjustSize(thesize);
	char *tmp = ((TMString *)this)->fBuf;
	*(int *)tmp = fAllStrs.size();
	tmp += sizeof(int) / sizeof(char);
	
	NAMESPACE(std) vector<T>::const_iterator i;
	for(i = fAllStrs.begin(); i != fAllStrs.end(); ++i)
	{
		tmpsize = (*i).length() + 1;
		memcpy(tmp, (const char *)(*i), tmpsize * sizeof(char));
		tmp += tmpsize;
	}
	
	return ((TMString *)this)->fBuf;
}

template<class T>
void TMString<T>::SetData(const void *ptr, unsigned int size)
{
	const char *tmp = (char *)ptr;
	unsigned int thesize;
	fAllStrs.erase(fAllStrs.begin(), fAllStrs.end());
	thesize = *(int *)tmp;
	tmp += sizeof(int) / sizeof(char);
	for(unsigned int i = 0; i < thesize && i < fMaxStr; i++)
	{
		fAllStrs.push_back(T(tmp));
		tmp += strlen(tmp) + 1;
	}
}

template<class T>
void TMString<T>::Insert(const char *newstr)
{
	NAMESPACE(std) vector<T>::iterator i;
	for(i = fAllStrs.begin(); i != fAllStrs.end(); ++i)
	{
		if(strcmp(*i, newstr) == 0)
		{
			fAllStrs.erase(i);
			fAllStrs.insert(fAllStrs.begin(), T(newstr));
			return;
		}
	}
	fAllStrs.insert(fAllStrs.begin(), T(newstr));
	if(fAllStrs.size() > fMaxStr)
	{
		fAllStrs.erase(fAllStrs.begin() + fMaxStr, fAllStrs.end());
	}
}

template class TMString<CStr>;
template class TMString<CPStr>;
