/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- March 1998
 */

/*
 * DiffDlg.cpp : the cvs diff dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#ifdef qQT
#	include "qcvsapp.h"
#endif /* qQT */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LRadioButton.h>
#	include <LEditText.h>
#	include <LCheckBox.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "DiffDlg.h"
#include "CvsPrefs.h"
#include "UpdateDlg.h"

#ifdef WIN32
#include "GetPrefs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(CDiff_MAIN, CPropertyPage)

CDiff_MAIN::CDiff_MAIN(const char *rev1, const char *rev2) : CPropertyPage(CDiff_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CDiff_MAIN)
	m_check1 = FALSE;
	m_check2 = FALSE;
	m_str1 = rev1;
	m_str2 = rev2;
	m_diff = 0;
	m_norecurs = FALSE;
	//}}AFX_DATA_INIT
}

CDiff_MAIN::CDiff_MAIN() : CPropertyPage(CDiff_MAIN::IDD)
{
}

CDiff_MAIN::~CDiff_MAIN()
{
}

void CDiff_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDiff_MAIN)
	DDX_Control(pDX, IDC_COMBO2, m_def2);
	DDX_Control(pDX, IDC_COMBO1, m_def1);
	DDX_Check(pDX, IDC_CHECK1, m_check1);
	DDX_Check(pDX, IDC_CHECK2, m_check2);
	DDX_CBString(pDX, IDC_COMBO1, m_str1);
	DDX_CBString(pDX, IDC_COMBO2, m_str2);
	DDX_Radio(pDX, IDC_DIFF1, m_diff);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	//}}AFX_DATA_MAP
	if(m_diff == 1 || m_diff == 2)
		DDV_MinChars(pDX, m_str1, 1);
	if(m_diff == 2)
		DDV_MinChars(pDX, m_str2, 1);
	if(!pDX->m_bSaveAndValidate)
	{
		OnDiff1();
	}
	if(m_check1)
		DDX_ComboMString(pDX, IDC_COMBO1, gDateNames, m_def1);
	else
		DDX_ComboMString(pDX, IDC_COMBO1, gRevNames, m_def1);
	if(m_check2)
		DDX_ComboMString(pDX, IDC_COMBO2, gDateNames, m_def2);
	else
		DDX_ComboMString(pDX, IDC_COMBO2, gRevNames, m_def2);
}

BEGIN_MESSAGE_MAP(CDiff_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CDiff_MAIN)
	ON_BN_CLICKED(IDC_DIFF1, OnDiff1)
	ON_BN_CLICKED(IDC_DIFF2, OnDiff2)
	ON_BN_CLICKED(IDC_DIFF3, OnDiff3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDiff_MAIN message handlers

void CDiff_MAIN::OnDiff1()
{
	CButton* but = (CButton *)GetDlgItem(IDC_DIFF1);
	CButton* but1 = (CButton *)GetDlgItem(IDC_DIFF2);
	CButton* but2 = (CButton *)GetDlgItem(IDC_DIFF3);
	CWnd* wnd1 = GetDlgItem(IDC_COMBO1);
	CWnd* wnd2 = GetDlgItem(IDC_COMBO2);
	CWnd* wnd3 = GetDlgItem(IDC_CHECK1);
	CWnd* wnd4 = GetDlgItem(IDC_CHECK2);
	if(but->GetCheck() == 1)
	{
		wnd1->EnableWindow(FALSE);
		wnd2->EnableWindow(FALSE);
		wnd3->EnableWindow(FALSE);
		wnd4->EnableWindow(FALSE);
	}
	else if(but1->GetCheck() == 1)
	{
		wnd1->EnableWindow(TRUE);
		wnd2->EnableWindow(FALSE);
		wnd3->EnableWindow(TRUE);
		wnd4->EnableWindow(FALSE);
	}
	else
	{
		wnd1->EnableWindow(TRUE);
		wnd2->EnableWindow(TRUE);
		wnd3->EnableWindow(TRUE);
		wnd4->EnableWindow(TRUE);
	}
}

void CDiff_MAIN::OnDiff2() 
{
	OnDiff1();
}

void CDiff_MAIN::OnDiff3() 
{
	OnDiff1();
}
#endif /* WIN32 */

#ifdef qMacCvsPP
static void DoDataExchange_DiffMain(LWindow *theDialog, bool & noRecurs, bool & isDate1, bool & isDate2,
	CPStr & sLastRev1, CPStr & sLastRev2, bool & hasRev1, bool & hasRev2, bool putValue)
{
	LRadioGroupView *groupButtons = dynamic_cast<LRadioGroupView*>
		(theDialog->FindPaneByID(item_GroupAuthen));

	LRadioButton *chkHasRev = dynamic_cast<LRadioButton*>
		(theDialog->FindPaneByID(item_CheckRevTag1));
	LEditText *editRev = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag1));
	LRadioButton *chkHasRev2 = dynamic_cast<LRadioButton*>
		(theDialog->FindPaneByID(item_CheckRevTag2));
	LEditText *editRev2 = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag2));
	LCheckBox *chkHasDate1 = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate1));
	LCheckBox *chkHasDate2 = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate2));
	LPopupFiller *fill1 = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev1));
	LPopupFiller *fill2 = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev2));
	
	if(putValue)
	{
		chkHasDate1->SetValue(isDate1 ? Button_On : Button_Off);
		chkHasDate2->SetValue(isDate2 ? Button_On : Button_Off);
		if(hasRev1 && hasRev2)
			groupButtons->SetCurrentRadioID(item_CheckRevTag2);
		else if(hasRev1)
			groupButtons->SetCurrentRadioID(item_CheckRevTag1);
		else
			groupButtons->SetCurrentRadioID(item_MergeNone);
		editRev->SetText((Ptr)(const char *)sLastRev1, sLastRev1.length());
		editRev2->SetText((Ptr)(const char *)sLastRev2, sLastRev2.length());

		fill1->DoDataExchange(gRevNames, putValue);
		fill2->DoDataExchange(gRevNames, putValue);
	}
	else
	{
		isDate1 = chkHasDate1->GetValue() == Button_On;
		isDate2 = chkHasDate2->GetValue() == Button_On;
		PaneIDT paneID = groupButtons->GetCurrentRadioID();
		if(paneID == item_CheckRevTag2)
		{
			hasRev1 = hasRev2 = true;
		}
		else if (paneID == item_CheckRevTag1)
		{
			hasRev1 = true;
			hasRev2 = false;
		}
		else
		{
			hasRev1 = hasRev2 = false;
		}

		fill1->DoDataExchange(isDate1 ? gDateNames : gRevNames, putValue);
		fill2->DoDataExchange(isDate2 ? gDateNames : gRevNames, putValue);

		char str[255];
		Size len;
		
		editRev->GetText(str, 254, &len);
		sLastRev1.set(str, len);
		editRev2->GetText(str, 254, &len);
		sLastRev2.set(str, len);
	}
}
#endif /* qMacCvsPP */

bool CompatGetDiff(bool & noRecurs, bool & isDate1, bool & isDate2,
				   CPStr & rev1, CPStr & rev2)
{
	bool userHitOK = false;

	static CPStr sLastRev1;
	static CPStr sLastRev2;

	rev1 = "";
	rev2 = "";
	noRecurs = false;
	isDate1 = false;
	isDate2 = false;
	bool hasRev1 = false;
	bool hasRev2 = false;
	
#ifdef WIN32
	CPropertySheet pages("Diff settings");
	CDiff_MAIN page1(sLastRev1, sLastRev2);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		noRecurs = page1.m_norecurs == TRUE;

		sLastRev1 = page1.m_str1;
		sLastRev2 = page1.m_str2;
		isDate1 = page1.m_check1 == TRUE;
		isDate2 = page1.m_check2 == TRUE;
		if(page1.m_diff == 0)
		{
			hasRev1 = hasRev2 = false;
		}
		else if(page1.m_diff == 1)
		{
			hasRev1 = true;
			hasRev2 = false;
		}
		else
		{
			hasRev1 = true;
			hasRev2 = true;
		}

		page2.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Diff, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(2);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_DiffMain(theDialog, noRecurs, isDate1, isDate2, sLastRev1, sLastRev2,
		hasRev1, hasRev2, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_DiffMain(theDialog, noRecurs, isDate1, isDate2, sLastRev1, sLastRev2,
			hasRev1, hasRev2, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */

	if(userHitOK)
	{
		if(hasRev1)
			rev1 = sLastRev1;
		if(hasRev2)
			rev2 = sLastRev2;
		gCvsPrefs.save();
	}

	return userHitOK;
}
